/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.Util;
import java.beans.FeatureDescriptor;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Objects;

public class ArrayELResolver
extends ELResolver {
    private final boolean readOnly;

    public ArrayELResolver() {
        this.readOnly = false;
    }

    public ArrayELResolver(boolean bl) {
        this.readOnly = bl;
    }

    @Override
    public Class<?> getType(ELContext eLContext, Object object, Object object2) {
        Objects.requireNonNull(eLContext);
        if (object != null && object.getClass().isArray()) {
            eLContext.setPropertyResolved(object, object2);
            try {
                int n = ArrayELResolver.coerce(object2);
                ArrayELResolver.checkBounds(object, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (this.readOnly) {
                return null;
            }
            return object.getClass().getComponentType();
        }
        return null;
    }

    @Override
    public Object getValue(ELContext eLContext, Object object, Object object2) {
        Objects.requireNonNull(eLContext);
        if (object != null && object.getClass().isArray()) {
            eLContext.setPropertyResolved(object, object2);
            int n = ArrayELResolver.coerce(object2);
            if (n < 0 || n >= Array.getLength(object)) {
                return null;
            }
            return Array.get(object, n);
        }
        return null;
    }

    @Override
    public void setValue(ELContext eLContext, Object object, Object object2, Object object3) {
        Objects.requireNonNull(eLContext);
        if (object != null && object.getClass().isArray()) {
            eLContext.setPropertyResolved(object, object2);
            if (this.readOnly) {
                throw new PropertyNotWritableException(Util.message(eLContext, "resolverNotWritable", object.getClass().getName()));
            }
            int n = ArrayELResolver.coerce(object2);
            ArrayELResolver.checkBounds(object, n);
            if (object3 != null && !Util.isAssignableFrom(object3.getClass(), object.getClass().getComponentType())) {
                throw new ClassCastException(Util.message(eLContext, "objectNotAssignable", object3.getClass().getName(), object.getClass().getComponentType().getName()));
            }
            Array.set(object, n, object3);
        }
    }

    @Override
    public boolean isReadOnly(ELContext eLContext, Object object, Object object2) {
        Objects.requireNonNull(eLContext);
        if (object != null && object.getClass().isArray()) {
            eLContext.setPropertyResolved(object, object2);
            try {
                int n = ArrayELResolver.coerce(object2);
                ArrayELResolver.checkBounds(object, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.readOnly;
    }

    @Override
    @Deprecated(forRemoval=true, since="EL 5.0")
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext eLContext, Object object) {
        return null;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext eLContext, Object object) {
        if (object != null && object.getClass().isArray()) {
            return Integer.class;
        }
        return null;
    }

    private static final void checkBounds(Object object, int n) {
        if (n < 0 || n >= Array.getLength(object)) {
            throw new PropertyNotFoundException(new ArrayIndexOutOfBoundsException(n).getMessage());
        }
    }

    private static final int coerce(Object object) {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        throw new IllegalArgumentException(object != null ? object.toString() : "null");
    }
}

