/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.codec.binary;

import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.codec.binary.StringUtils;
import org.apache.tomcat.util.res.StringManager;

public abstract class BaseNCodec {
    protected static final StringManager sm = StringManager.getManager(BaseNCodec.class);
    static final int EOF = -1;
    public static final int MIME_CHUNK_SIZE = 76;
    private static final int DEFAULT_BUFFER_RESIZE_FACTOR = 2;
    private static final int DEFAULT_BUFFER_SIZE = 128;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    protected static final int MASK_8BITS = 255;
    protected static final byte PAD_DEFAULT = 61;
    static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
    protected final byte pad;
    private final int unencodedBlockSize;
    private final int encodedBlockSize;
    protected final int lineLength;
    private final int chunkSeparatorLength;

    private static int compareUnsigned(int n, int n2) {
        return Integer.compare(n + Integer.MIN_VALUE, n2 + Integer.MIN_VALUE);
    }

    private static int createPositiveCapacity(int n) {
        if (n < 0) {
            throw new OutOfMemoryError("Unable to allocate array size: " + ((long)n & 0xFFFFFFFFL));
        }
        return n > 0x7FFFFFF7 ? n : 0x7FFFFFF7;
    }

    private static byte[] resizeBuffer(Context context, int n) {
        int n2 = context.buffer.length;
        int n3 = n2 * 2;
        if (BaseNCodec.compareUnsigned(n3, n) < 0) {
            n3 = n;
        }
        if (BaseNCodec.compareUnsigned(n3, 0x7FFFFFF7) > 0) {
            n3 = BaseNCodec.createPositiveCapacity(n);
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(context.buffer, 0, byArray, 0, context.buffer.length);
        context.buffer = byArray;
        return byArray;
    }

    protected BaseNCodec(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 61);
    }

    protected BaseNCodec(int n, int n2, int n3, int n4, byte by) {
        this.unencodedBlockSize = n;
        this.encodedBlockSize = n2;
        boolean bl = n3 > 0 && n4 > 0;
        this.lineLength = bl ? n3 / n2 * n2 : 0;
        this.chunkSeparatorLength = n4;
        this.pad = by;
    }

    int available(Context context) {
        return this.hasData(context) ? context.pos - context.readPos : 0;
    }

    protected boolean containsAlphabetOrPad(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        for (byte by : byArray) {
            if (this.pad != by && !this.isInAlphabet(by)) continue;
            return true;
        }
        return false;
    }

    public byte[] decode(byte[] byArray) {
        return this.decode(byArray, 0, byArray.length);
    }

    public byte[] decode(byte[] byArray, int n, int n2) {
        if (byArray == null || n2 == 0) {
            return new byte[0];
        }
        Context context = new Context();
        this.decode(byArray, n, n2, context);
        this.decode(byArray, n, -1, context);
        byte[] byArray2 = new byte[context.pos];
        this.readResults(byArray2, 0, byArray2.length, context);
        return byArray2;
    }

    abstract void decode(byte[] var1, int var2, int var3, Context var4);

    public byte[] decode(String string) {
        return this.decode(StringUtils.getBytesUtf8(string));
    }

    public byte[] encode(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        return this.encode(byArray, 0, byArray.length);
    }

    public byte[] encode(byte[] byArray, int n, int n2) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        Context context = new Context();
        this.encode(byArray, n, n2, context);
        this.encode(byArray, n, -1, context);
        byte[] byArray2 = new byte[context.pos - context.readPos];
        this.readResults(byArray2, 0, byArray2.length, context);
        return byArray2;
    }

    abstract void encode(byte[] var1, int var2, int var3, Context var4);

    public String encodeAsString(byte[] byArray) {
        return StringUtils.newStringUtf8(this.encode(byArray));
    }

    protected byte[] ensureBufferSize(int n, Context context) {
        if (context.buffer == null) {
            context.buffer = new byte[Math.max(n, this.getDefaultBufferSize())];
            context.pos = 0;
            context.readPos = 0;
        } else if (context.pos + n - context.buffer.length > 0) {
            return BaseNCodec.resizeBuffer(context, context.pos + n);
        }
        return context.buffer;
    }

    protected int getDefaultBufferSize() {
        return 128;
    }

    public long getEncodedLength(byte[] byArray) {
        long l = (long)((byArray.length + this.unencodedBlockSize - 1) / this.unencodedBlockSize) * (long)this.encodedBlockSize;
        if (this.lineLength > 0) {
            l += (l + (long)this.lineLength - 1L) / (long)this.lineLength * (long)this.chunkSeparatorLength;
        }
        return l;
    }

    boolean hasData(Context context) {
        return context.pos > context.readPos;
    }

    protected abstract boolean isInAlphabet(byte var1);

    int readResults(byte[] byArray, int n, int n2, Context context) {
        if (this.hasData(context)) {
            int n3 = Math.min(this.available(context), n2);
            System.arraycopy(context.buffer, context.readPos, byArray, n, n3);
            context.readPos += n3;
            if (!this.hasData(context)) {
                context.readPos = 0;
                context.pos = 0;
            }
            return n3;
        }
        return context.eof ? -1 : 0;
    }

    static class Context {
        int ibitWorkArea;
        byte[] buffer;
        int pos;
        int readPos;
        boolean eof;
        int currentLinePos;
        int modulus;

        Context() {
        }

        public String toString() {
            return String.format("%s[buffer=%s, currentLinePos=%s, eof=%s, ibitWorkArea=%s, modulus=%s, pos=%s, readPos=%s]", this.getClass().getSimpleName(), HexUtils.toHexString(this.buffer), this.currentLinePos, this.eof, this.ibitWorkArea, this.modulus, this.pos, this.readPos);
        }
    }
}

