function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import React, { Component } from "react";
import PropTypes from "prop-types";
import * as types from "../../types";
import { getUiOptions, getWidget, guessType, retrieveSchema, getDefaultFormState, getMatchingOption as _getMatchingOption, deepEquals } from "../../utils";

var AnyOfField =
/*#__PURE__*/
function (_Component) {
  _inherits(AnyOfField, _Component);

  function AnyOfField(props) {
    var _this;

    _classCallCheck(this, AnyOfField);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(AnyOfField).call(this, props));

    _defineProperty(_assertThisInitialized(_this), "onOptionChange", function (option) {
      var selectedOption = parseInt(option, 10);
      var _this$props = _this.props,
          formData = _this$props.formData,
          onChange = _this$props.onChange,
          options = _this$props.options,
          registry = _this$props.registry;
      var rootSchema = registry.rootSchema;
      var newOption = retrieveSchema(options[selectedOption], rootSchema, formData); // If the new option is of type object and the current data is an object,
      // discard properties added using the old option.

      var newFormData = undefined;

      if (guessType(formData) === "object" && (newOption.type === "object" || newOption.properties)) {
        newFormData = Object.assign({}, formData);
        var optionsToDiscard = options.slice();
        optionsToDiscard.splice(selectedOption, 1); // Discard any data added using other options

        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
          for (var _iterator = optionsToDiscard[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var _option = _step.value;

            if (_option.properties) {
              for (var key in _option.properties) {
                if (newFormData.hasOwnProperty(key)) {
                  delete newFormData[key];
                }
              }
            }
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator["return"] != null) {
              _iterator["return"]();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }
      } // Call getDefaultFormState to make sure defaults are populated on change.


      onChange(getDefaultFormState(options[selectedOption], newFormData, rootSchema));

      _this.setState({
        selectedOption: parseInt(option, 10)
      });
    });

    var _this$props2 = _this.props,
        _formData = _this$props2.formData,
        _options = _this$props2.options;
    _this.state = {
      selectedOption: _this.getMatchingOption(_formData, _options)
    };
    return _this;
  }

  _createClass(AnyOfField, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      if (!deepEquals(this.props.formData, prevProps.formData) && this.props.idSchema.$id === prevProps.idSchema.$id) {
        var matchingOption = this.getMatchingOption(this.props.formData, this.props.options);

        if (!prevState || matchingOption === this.state.selectedOption) {
          return;
        }

        this.setState({
          selectedOption: matchingOption
        });
      }
    }
  }, {
    key: "getMatchingOption",
    value: function getMatchingOption(formData, options) {
      var rootSchema = this.props.registry.rootSchema;

      var option = _getMatchingOption(formData, options, rootSchema);

      if (option !== 0) {
        return option;
      } // If the form data matches none of the options, use the currently selected
      // option, assuming it's available; otherwise use the first option


      return this && this.state ? this.state.selectedOption : 0;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
          baseType = _this$props3.baseType,
          disabled = _this$props3.disabled,
          readonly = _this$props3.readonly,
          hideError = _this$props3.hideError,
          errorSchema = _this$props3.errorSchema,
          formData = _this$props3.formData,
          idPrefix = _this$props3.idPrefix,
          idSeparator = _this$props3.idSeparator,
          idSchema = _this$props3.idSchema,
          onBlur = _this$props3.onBlur,
          onChange = _this$props3.onChange,
          onFocus = _this$props3.onFocus,
          options = _this$props3.options,
          registry = _this$props3.registry,
          uiSchema = _this$props3.uiSchema,
          schema = _this$props3.schema;
      var _SchemaField = registry.fields.SchemaField;
      var widgets = registry.widgets;
      var selectedOption = this.state.selectedOption;

      var _getUiOptions = getUiOptions(uiSchema),
          _getUiOptions$widget = _getUiOptions.widget,
          widget = _getUiOptions$widget === void 0 ? "select" : _getUiOptions$widget,
          uiOptions = _objectWithoutProperties(_getUiOptions, ["widget"]);

      var Widget = getWidget({
        type: "number"
      }, widget, widgets);
      var option = options[selectedOption] || null;
      var optionSchema;

      if (option) {
        // If the subschema doesn't declare a type, infer the type from the
        // parent schema
        optionSchema = option.type ? option : Object.assign({}, option, {
          type: baseType
        });
      }

      var enumOptions = options.map(function (option, index) {
        return {
          label: option.title || "Option ".concat(index + 1),
          value: index
        };
      });
      return React.createElement("div", {
        className: "panel panel-default panel-body"
      }, React.createElement("div", {
        className: "form-group"
      }, React.createElement(Widget, _extends({
        id: "".concat(idSchema.$id).concat(schema.oneOf ? "__oneof_select" : "__anyof_select"),
        schema: {
          type: "number",
          "default": 0
        },
        onChange: this.onOptionChange,
        onBlur: onBlur,
        onFocus: onFocus,
        value: selectedOption,
        options: {
          enumOptions: enumOptions
        }
      }, uiOptions))), option !== null && React.createElement(_SchemaField, {
        schema: optionSchema,
        uiSchema: uiSchema,
        errorSchema: errorSchema,
        idSchema: idSchema,
        idPrefix: idPrefix,
        idSeparator: idSeparator,
        formData: formData,
        onChange: onChange,
        onBlur: onBlur,
        onFocus: onFocus,
        registry: registry,
        disabled: disabled,
        readonly: readonly,
        hideError: hideError
      }));
    }
  }]);

  return AnyOfField;
}(Component);

AnyOfField.defaultProps = {
  disabled: false,
  readonly: false,
  hideError: false,
  errorSchema: {},
  idSchema: {},
  uiSchema: {}
};

if (process.env.NODE_ENV !== "production") {
  AnyOfField.propTypes = {
    options: PropTypes.arrayOf(PropTypes.object).isRequired,
    baseType: PropTypes.string,
    uiSchema: PropTypes.object,
    idSchema: PropTypes.object,
    formData: PropTypes.any,
    errorSchema: PropTypes.object,
    registry: types.registry.isRequired
  };
}

export default AnyOfField;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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