"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function TextareaWidget(props) {
  var id = props.id,
      options = props.options,
      placeholder = props.placeholder,
      value = props.value,
      required = props.required,
      disabled = props.disabled,
      readonly = props.readonly,
      autofocus = props.autofocus,
      onChange = props.onChange,
      onBlur = props.onBlur,
      onFocus = props.onFocus;

  var _onChange = function _onChange(_ref) {
    var value = _ref.target.value;
    return onChange(value === "" ? options.emptyValue : value);
  };

  return _react["default"].createElement("textarea", {
    id: id,
    className: "form-control",
    value: value ? value : "",
    placeholder: placeholder,
    required: required,
    disabled: disabled,
    readOnly: readonly,
    autoFocus: autofocus,
    rows: options.rows,
    onBlur: onBlur && function (event) {
      return onBlur(id, event.target.value);
    },
    onFocus: onFocus && function (event) {
      return onFocus(id, event.target.value);
    },
    onChange: _onChange
  });
}

TextareaWidget.defaultProps = {
  autofocus: false,
  options: {}
};

if (process.env.NODE_ENV !== "production") {
  TextareaWidget.propTypes = {
    schema: _propTypes["default"].object.isRequired,
    id: _propTypes["default"].string.isRequired,
    placeholder: _propTypes["default"].string,
    options: _propTypes["default"].shape({
      rows: _propTypes["default"].number
    }),
    value: _propTypes["default"].string,
    required: _propTypes["default"].bool,
    disabled: _propTypes["default"].bool,
    readonly: _propTypes["default"].bool,
    autofocus: _propTypes["default"].bool,
    onChange: _propTypes["default"].func,
    onBlur: _propTypes["default"].func,
    onFocus: _propTypes["default"].func
  };
}

var _default = TextareaWidget;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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