"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _AddButton = _interopRequireDefault(require("../AddButton"));

var _react = _interopRequireWildcard(require("react"));

var types = _interopRequireWildcard(require("../../types"));

var _utils = require("../../utils");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function DefaultObjectFieldTemplate(props) {
  var TitleField = props.TitleField,
      DescriptionField = props.DescriptionField;
  return _react["default"].createElement("fieldset", {
    id: props.idSchema.$id
  }, (props.uiSchema["ui:title"] || props.title) && _react["default"].createElement(TitleField, {
    id: "".concat(props.idSchema.$id, "__title"),
    title: props.title || props.uiSchema["ui:title"],
    required: props.required,
    formContext: props.formContext
  }), props.description && _react["default"].createElement(DescriptionField, {
    id: "".concat(props.idSchema.$id, "__description"),
    description: props.description,
    formContext: props.formContext
  }), props.properties.map(function (prop) {
    return prop.content;
  }), (0, _utils.canExpand)(props.schema, props.uiSchema, props.formData) && _react["default"].createElement(_AddButton["default"], {
    className: "object-property-expand",
    onClick: props.onAddClick(props.schema),
    disabled: props.disabled || props.readonly
  }));
}

var ObjectField =
/*#__PURE__*/
function (_Component) {
  _inherits(ObjectField, _Component);

  function ObjectField() {
    var _getPrototypeOf2;

    var _this;

    _classCallCheck(this, ObjectField);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(ObjectField)).call.apply(_getPrototypeOf2, [this].concat(args)));

    _defineProperty(_assertThisInitialized(_this), "state", {
      wasPropertyKeyModified: false,
      additionalProperties: {}
    });

    _defineProperty(_assertThisInitialized(_this), "onPropertyChange", function (name) {
      var addedByAdditionalProperties = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      return function (value, errorSchema) {
        if (value === undefined && addedByAdditionalProperties) {
          // Don't set value = undefined for fields added by
          // additionalProperties. Doing so removes them from the
          // formData, which causes them to completely disappear
          // (including the input field for the property name). Unlike
          // fields which are "mandated" by the schema, these fields can
          // be set to undefined by clicking a "delete field" button, so
          // set empty values to the empty string.
          value = "";
        }

        var newFormData = _objectSpread({}, _this.props.formData, _defineProperty({}, name, value));

        _this.props.onChange(newFormData, errorSchema && _this.props.errorSchema && _objectSpread({}, _this.props.errorSchema, _defineProperty({}, name, errorSchema)));
      };
    });

    _defineProperty(_assertThisInitialized(_this), "onDropPropertyClick", function (key) {
      return function (event) {
        event.preventDefault();
        var _this$props = _this.props,
            onChange = _this$props.onChange,
            formData = _this$props.formData;

        var copiedFormData = _objectSpread({}, formData);

        delete copiedFormData[key];
        onChange(copiedFormData);
      };
    });

    _defineProperty(_assertThisInitialized(_this), "getAvailableKey", function (preferredKey, formData) {
      var index = 0;
      var newKey = preferredKey;

      while (formData.hasOwnProperty(newKey)) {
        newKey = "".concat(preferredKey, "-").concat(++index);
      }

      return newKey;
    });

    _defineProperty(_assertThisInitialized(_this), "onKeyChange", function (oldValue) {
      return function (value, errorSchema) {
        if (oldValue === value) {
          return;
        }

        value = _this.getAvailableKey(value, _this.props.formData);

        var newFormData = _objectSpread({}, _this.props.formData);

        var newKeys = _defineProperty({}, oldValue, value);

        var keyValues = Object.keys(newFormData).map(function (key) {
          var newKey = newKeys[key] || key;
          return _defineProperty({}, newKey, newFormData[key]);
        });
        var renamedObj = Object.assign.apply(Object, [{}].concat(_toConsumableArray(keyValues)));

        _this.setState({
          wasPropertyKeyModified: true
        });

        _this.props.onChange(renamedObj, errorSchema && _this.props.errorSchema && _objectSpread({}, _this.props.errorSchema, _defineProperty({}, value, errorSchema)));
      };
    });

    _defineProperty(_assertThisInitialized(_this), "handleAddClick", function (schema) {
      return function () {
        var type = schema.additionalProperties.type;

        var newFormData = _objectSpread({}, _this.props.formData);

        if (schema.additionalProperties.hasOwnProperty("$ref")) {
          var _this$props$registry = _this.props.registry,
              registry = _this$props$registry === void 0 ? (0, _utils.getDefaultRegistry)() : _this$props$registry;
          var refSchema = (0, _utils.retrieveSchema)({
            $ref: schema.additionalProperties["$ref"]
          }, registry.rootSchema, _this.props.formData);
          type = refSchema.type;
        }

        newFormData[_this.getAvailableKey("newKey", newFormData)] = _this.getDefaultValue(type);

        _this.props.onChange(newFormData);
      };
    });

    return _this;
  }

  _createClass(ObjectField, [{
    key: "isRequired",
    value: function isRequired(name) {
      var schema = this.props.schema;
      return Array.isArray(schema.required) && schema.required.indexOf(name) !== -1;
    }
  }, {
    key: "getDefaultValue",
    value: function getDefaultValue(type) {
      switch (type) {
        case "string":
          return "New Value";

        case "array":
          return [];

        case "boolean":
          return false;

        case "null":
          return null;

        case "number":
          return 0;

        case "object":
          return {};

        default:
          // We don't have a datatype for some reason (perhaps additionalProperties was true)
          return "New Value";
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props2 = this.props,
          uiSchema = _this$props2.uiSchema,
          formData = _this$props2.formData,
          errorSchema = _this$props2.errorSchema,
          idSchema = _this$props2.idSchema,
          name = _this$props2.name,
          required = _this$props2.required,
          disabled = _this$props2.disabled,
          readonly = _this$props2.readonly,
          hideError = _this$props2.hideError,
          idPrefix = _this$props2.idPrefix,
          idSeparator = _this$props2.idSeparator,
          onBlur = _this$props2.onBlur,
          onFocus = _this$props2.onFocus,
          _this$props2$registry = _this$props2.registry,
          registry = _this$props2$registry === void 0 ? (0, _utils.getDefaultRegistry)() : _this$props2$registry;
      var rootSchema = registry.rootSchema,
          fields = registry.fields,
          formContext = registry.formContext;
      var SchemaField = fields.SchemaField,
          TitleField = fields.TitleField,
          DescriptionField = fields.DescriptionField;
      var schema = (0, _utils.retrieveSchema)(this.props.schema, rootSchema, formData);
      var title = schema.title === undefined ? name : schema.title;
      var description = uiSchema["ui:description"] || schema.description;
      var orderedProperties;

      try {
        var properties = Object.keys(schema.properties || {});
        orderedProperties = (0, _utils.orderProperties)(properties, uiSchema["ui:order"]);
      } catch (err) {
        return _react["default"].createElement("div", null, _react["default"].createElement("p", {
          className: "config-error",
          style: {
            color: "red"
          }
        }, "Invalid ", name || "root", " object field configuration:", _react["default"].createElement("em", null, err.message), "."), _react["default"].createElement("pre", null, JSON.stringify(schema)));
      }

      var Template = uiSchema["ui:ObjectFieldTemplate"] || registry.ObjectFieldTemplate || DefaultObjectFieldTemplate;
      var templateProps = {
        title: uiSchema["ui:title"] || title,
        description: description,
        TitleField: TitleField,
        DescriptionField: DescriptionField,
        properties: orderedProperties.map(function (name) {
          var addedByAdditionalProperties = schema.properties[name].hasOwnProperty(_utils.ADDITIONAL_PROPERTY_FLAG);
          var fieldUiSchema = addedByAdditionalProperties ? uiSchema.additionalProperties : uiSchema[name];
          var hidden = fieldUiSchema && fieldUiSchema["ui:widget"] === "hidden";
          return {
            content: _react["default"].createElement(SchemaField, {
              key: name,
              name: name,
              required: _this2.isRequired(name),
              schema: schema.properties[name],
              uiSchema: fieldUiSchema,
              errorSchema: errorSchema[name],
              idSchema: idSchema[name],
              idPrefix: idPrefix,
              idSeparator: idSeparator,
              formData: (formData || {})[name],
              wasPropertyKeyModified: _this2.state.wasPropertyKeyModified,
              onKeyChange: _this2.onKeyChange(name),
              onChange: _this2.onPropertyChange(name, addedByAdditionalProperties),
              onBlur: onBlur,
              onFocus: onFocus,
              registry: registry,
              disabled: disabled,
              readonly: readonly,
              hideError: hideError,
              onDropPropertyClick: _this2.onDropPropertyClick
            }),
            name: name,
            readonly: readonly,
            disabled: disabled,
            required: required,
            hidden: hidden
          };
        }),
        readonly: readonly,
        disabled: disabled,
        required: required,
        idSchema: idSchema,
        uiSchema: uiSchema,
        schema: schema,
        formData: formData,
        formContext: formContext,
        registry: registry
      };
      return _react["default"].createElement(Template, _extends({}, templateProps, {
        onAddClick: this.handleAddClick
      }));
    }
  }]);

  return ObjectField;
}(_react.Component);

_defineProperty(ObjectField, "defaultProps", {
  uiSchema: {},
  formData: {},
  errorSchema: {},
  idSchema: {},
  required: false,
  disabled: false,
  readonly: false
});

if (process.env.NODE_ENV !== "production") {
  ObjectField.propTypes = types.fieldProps;
}

var _default = ObjectField;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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