/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.FileNotFoundException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.option.OptionsParamView;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.HeadlessBootstrap;
import org.zaproxy.zap.OsXGui;
import org.zaproxy.zap.ZapBootstrap;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnLoader;
import org.zaproxy.zap.control.AddOnRunIssuesUtils;
import org.zaproxy.zap.control.ExtensionFactory;
import org.zaproxy.zap.model.SessionUtils;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.utils.LocaleUtils;
import org.zaproxy.zap.view.LocaleDialog;
import org.zaproxy.zap.view.ProxyDialog;

public class GuiBootstrap
extends ZapBootstrap {
    private static final Logger logger = LogManager.getLogger(GuiBootstrap.class);
    private boolean lookAndFeelSet;

    public GuiBootstrap(CommandLine cmdLineArgs) {
        super(cmdLineArgs);
    }

    @Override
    public int start() {
        int rc = super.start();
        if (rc != 0) {
            return rc;
        }
        logger.info(GuiBootstrap.getStartingMessage());
        if (GraphicsEnvironment.isHeadless()) {
            String headlessMessage = Constant.messages.getString("start.gui.headless", "-help");
            logger.fatal(headlessMessage);
            System.err.println(headlessMessage);
            return 1;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiBootstrap.this.startImpl();
            }
        });
        return 0;
    }

    private void startImpl() {
        this.setX11AwtAppClassName();
        GuiBootstrap.setDefaultViewLocale(Constant.getLocale());
        this.init();
    }

    private void setX11AwtAppClassName() {
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        Class<?> toolkitClass = defaultToolkit.getClass();
        if ("sun.awt.X11.XToolkit".equals(toolkitClass.getName())) {
            try {
                Field awtAppClassName = toolkitClass.getDeclaredField("awtAppClassName");
                awtAppClassName.setAccessible(true);
                awtAppClassName.set(null, "OWASP ZAP");
            }
            catch (Exception e) {
                logger.warn("Failed to set awt app class name: " + e.getMessage());
            }
        }
    }

    private void init() {
        try {
            this.initModel();
            this.setupLookAndFeel();
        }
        catch (Exception e) {
            this.setupLookAndFeel();
            if (e instanceof FileNotFoundException) {
                JOptionPane.showMessageDialog(null, Constant.messages.getString("start.db.error"), Constant.messages.getString("start.title.error"), 0);
            }
            logger.fatal("Failed to initialise: " + e.getMessage(), (Throwable)e);
            System.err.println(e.getMessage());
            System.exit(1);
        }
        OptionsParam options = Model.getSingleton().getOptionsParam();
        OptionsParamView viewParam = options.getViewParam();
        for (FontUtils.FontType fontType : FontUtils.FontType.values()) {
            FontUtils.setDefaultFont(fontType, viewParam.getFontName(fontType), viewParam.getFontSize(fontType));
        }
        this.setupLocale(options);
        if (viewParam.isUseSystemsLocaleForFormat()) {
            Locale.setDefault(Locale.Category.FORMAT, Constant.getSystemsLocale());
        }
        View.getSingleton().showSplashScreen();
        GuiBootstrap.promptForProxyDetailsIfNeeded(options);
        Thread bootstrap = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    GuiBootstrap.this.initControlAndPostViewInit();
                }
                catch (Throwable e) {
                    if (!Constant.isDevMode()) {
                        ErrorInfo errorInfo = new ErrorInfo(Constant.messages.getString("start.gui.dialog.fatal.error.title"), Constant.messages.getString("start.gui.dialog.fatal.error.message"), null, null, e, null, null);
                        JXErrorPane errorPane = new JXErrorPane();
                        errorPane.setErrorInfo(errorInfo);
                        JXErrorPane.showDialog((Component)View.getSingleton().getSplashScreen(), (JXErrorPane)errorPane);
                    }
                    View.getSingleton().hideSplashScreen();
                    logger.fatal("Failed to initialise GUI: ", e);
                    System.exit(1);
                }
                GuiBootstrap.warnAddOnsAndExtensionsNoLongerRunnable();
                HeadlessBootstrap.checkForUpdates();
            }
        });
        bootstrap.setName("ZAP-BootstrapGUI");
        bootstrap.setDaemon(false);
        bootstrap.start();
    }

    private void initControlAndPostViewInit() throws Exception {
        Control.initSingletonWithView(this.getControlOverrides());
        final Control control = Control.getSingleton();
        final View view = View.getSingleton();
        EventQueue.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Path sessionPath;
                view.postInit();
                view.getMainFrame().setVisible(true);
                boolean createNewSession = true;
                if (GuiBootstrap.this.getArgs().isEnabled("-session") && GuiBootstrap.this.getArgs().isEnabled("-newsession")) {
                    view.showWarningDialog(Constant.messages.getString("start.gui.cmdline.invalid.session.options", "-session", "-newsession", Constant.getZapHome()));
                } else if (GuiBootstrap.this.getArgs().isEnabled("-session")) {
                    sessionPath = SessionUtils.getSessionPath(GuiBootstrap.this.getArgs().getArgument("-session"));
                    if (!Files.exists(sessionPath, new LinkOption[0])) {
                        view.showWarningDialog(Constant.messages.getString("start.gui.cmdline.session.does.not.exist", Constant.getZapHome()));
                    } else {
                        createNewSession = !control.getMenuFileControl().openSession(sessionPath.toAbsolutePath().toString());
                    }
                } else if (GuiBootstrap.this.getArgs().isEnabled("-newsession")) {
                    sessionPath = SessionUtils.getSessionPath(GuiBootstrap.this.getArgs().getArgument("-newsession"));
                    if (Files.exists(sessionPath, new LinkOption[0])) {
                        view.showWarningDialog(Constant.messages.getString("start.gui.cmdline.newsession.already.exist", Constant.getZapHome()));
                    } else {
                        createNewSession = !control.getMenuFileControl().newSession(sessionPath.toAbsolutePath().toString());
                    }
                }
                view.hideSplashScreen();
                if (createNewSession) {
                    try {
                        control.getMenuFileControl().newSession(false);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        View.getSingleton().showWarningDialog(Constant.messages.getString("menu.file.newSession.error"));
                    }
                }
            }
        });
        try {
            control.getExtensionLoader().hookCommandLineListener(this.getArgs());
            control.runCommandLine();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    view.showWarningDialog(e.getMessage());
                }
            });
        }
    }

    private static void setDefaultViewLocale(Locale locale) {
        JComponent.setDefaultLocale(locale);
    }

    private void setupLookAndFeel() {
        if (this.lookAndFeelSet) {
            return;
        }
        this.lookAndFeelSet = true;
        if (Constant.isMacOsX()) {
            OsXGui.setup();
        } else if (Constant.isWindows()) {
            UIManager.put("TitlePane.useWindowDecorations", false);
        }
        if (GuiBootstrap.setLookAndFeel(System.getProperty("swing.defaultlaf"))) {
            return;
        }
        OptionsParam options = Model.getSingleton().getOptionsParam();
        if (GuiBootstrap.setLookAndFeel(GuiBootstrap.getLookAndFeelClassname(options.getViewParam().getLookAndFeel())) || GuiBootstrap.setLookAndFeel(options.getViewParam().getLookAndFeelInfo().getClassName())) {
            return;
        }
        if (!Constant.isMacOsX() && GuiBootstrap.setLookAndFeel(GuiBootstrap.getLookAndFeelClassname("Nimbus"))) {
            return;
        }
        GuiBootstrap.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    private static String getLookAndFeelClassname(String lookAndFeelName) {
        UIManager.LookAndFeelInfo[] looks = UIManager.getInstalledLookAndFeels();
        String lookAndFeelClassname = "";
        for (UIManager.LookAndFeelInfo look : looks) {
            if (!look.getName().equals(lookAndFeelName)) continue;
            lookAndFeelClassname = look.getClassName();
            break;
        }
        return lookAndFeelClassname;
    }

    private static boolean setLookAndFeel(String lookAndFeelClassname) {
        if (StringUtils.isNotEmpty((String)lookAndFeelClassname)) {
            try {
                UIManager.setLookAndFeel(lookAndFeelClassname);
                return true;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                logger.warn("Failed to set the look and feel: " + e.getMessage());
            }
        }
        return false;
    }

    private void setupLocale(OptionsParam options) {
        String locale = options.getViewParam().getConfigLocale();
        if (locale == null || locale.length() == 0) {
            Locale userloc = GuiBootstrap.determineUsersSystemLocale();
            if (userloc == null) {
                GuiBootstrap.setDefaultViewLocale(Constant.getSystemsLocale());
                LocaleDialog dialog = new LocaleDialog(null, true);
                dialog.init(options);
                dialog.setVisible(true);
            } else {
                options.getViewParam().setLocale(userloc);
            }
            GuiBootstrap.setDefaultViewLocale(GuiBootstrap.createLocale(options.getViewParam().getLocale().split("_")));
            Constant.setLocale(Model.getSingleton().getOptionsParam().getViewParam().getLocale());
            try {
                options.getViewParam().getConfig().save();
            }
            catch (ConfigurationException e) {
                logger.warn("Failed to save locale: ", (Throwable)e);
            }
        }
    }

    private static Locale determineUsersSystemLocale() {
        String[] langArray;
        Locale userloc = null;
        Locale systloc = Constant.getSystemsLocale();
        for (String ls : LocaleUtils.getAvailableLocales()) {
            langArray = ls.split("_");
            if (langArray.length == 1 && systloc.getLanguage().equals(langArray[0])) {
                userloc = systloc;
                break;
            }
            if (langArray.length == 2 && systloc.getLanguage().equals(langArray[0]) && systloc.getCountry().equals(langArray[1])) {
                userloc = systloc;
                break;
            }
            if (langArray.length != 3 || !systloc.getLanguage().equals(langArray[0]) || !systloc.getCountry().equals(langArray[1]) || !systloc.getVariant().equals(langArray[2])) continue;
            userloc = systloc;
            break;
        }
        if (userloc == null) {
            for (String ls : LocaleUtils.getAvailableLocales()) {
                langArray = ls.split("_");
                if (!systloc.getLanguage().equals(langArray[0])) continue;
                userloc = GuiBootstrap.createLocale(langArray);
                break;
            }
        }
        return userloc;
    }

    private static Locale createLocale(String[] localeFields) {
        if (localeFields == null || localeFields.length == 0) {
            return null;
        }
        Locale.Builder localeBuilder = new Locale.Builder();
        localeBuilder.setLanguage(localeFields[0]);
        if (localeFields.length >= 2) {
            localeBuilder.setRegion(localeFields[1]);
        }
        if (localeFields.length >= 3) {
            localeBuilder.setVariant(localeFields[2]);
        }
        return localeBuilder.build();
    }

    private static void promptForProxyDetailsIfNeeded(OptionsParam options) {
        if (options.getConnectionParam().isProxyChainPrompt()) {
            ProxyDialog dialog = new ProxyDialog(null, true);
            dialog.init(options);
            dialog.setVisible(true);
        }
    }

    private static void warnAddOnsAndExtensionsNoLongerRunnable() {
        AddOnLoader addOnLoader = ExtensionFactory.getAddOnLoader();
        List<String> idsAddOnsNoLongerRunning = addOnLoader.getIdsAddOnsWithRunningIssuesSinceLastRun();
        if (idsAddOnsNoLongerRunning.isEmpty()) {
            return;
        }
        ArrayList<AddOn> addOnsNoLongerRunning = new ArrayList<AddOn>(idsAddOnsNoLongerRunning.size());
        for (String id : idsAddOnsNoLongerRunning) {
            addOnsNoLongerRunning.add(addOnLoader.getAddOnCollection().getAddOn(id));
        }
        AddOnRunIssuesUtils.showWarningMessageAddOnsNotRunnable(Constant.messages.getString("start.gui.warn.addOnsOrExtensionsNoLongerRunning"), addOnLoader.getAddOnCollection(), addOnsNoLongerRunning);
    }
}

