/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.net.URL;
import java.util.Collections;
import java.util.Map;
import javax.swing.ImageIcon;
import org.apache.commons.httpclient.URI;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordAlert;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.XMLStringUtil;

public class Alert
implements Comparable<Alert> {
    public static final int RISK_INFO = 0;
    public static final int RISK_LOW = 1;
    public static final int RISK_MEDIUM = 2;
    public static final int RISK_HIGH = 3;
    public static final int CONFIDENCE_FALSE_POSITIVE = 0;
    @Deprecated
    public static final int SUSPICIOUS = 1;
    public static final int CONFIDENCE_LOW = 1;
    @Deprecated
    public static final int WARNING = 2;
    public static final int CONFIDENCE_MEDIUM = 2;
    public static final int CONFIDENCE_HIGH = 3;
    public static final int CONFIDENCE_USER_CONFIRMED = 4;
    public static final String[] MSG_RISK = new String[]{"Informational", "Low", "Medium", "High"};
    @Deprecated
    public static final String[] MSG_RELIABILITY = new String[]{"False Positive", "Low", "Medium", "High", "Confirmed"};
    public static final String[] MSG_CONFIDENCE = new String[]{"False Positive", "Low", "Medium", "High", "Confirmed"};
    private int alertId = -1;
    private int pluginId = -1;
    private String name = "";
    private int risk = 0;
    private int confidence = 2;
    private String description = "";
    private String uri = "";
    private String param = "";
    private String attack = "";
    private String otherInfo = "";
    private String solution = "";
    private String reference = "";
    private String evidence = "";
    private int cweId = -1;
    private int wascId = -1;
    private HttpMessage message = null;
    private int sourceHistoryId = 0;
    private HistoryReference historyRef = null;
    private static final Logger logger = LogManager.getLogger(Alert.class);
    private String method = "";
    private String postData;
    private URI msgUri = null;
    private Source source = Source.UNKNOWN;
    private String alertRef = "";
    private Map<String, String> tags = Collections.emptyMap();

    public Alert(int pluginId) {
        this.pluginId = pluginId;
        if (pluginId > -1) {
            this.alertRef = Integer.toString(pluginId);
        }
    }

    public Alert(int pluginId, int risk, int confidence, String name) {
        this(pluginId);
        this.setRiskConfidence(risk, confidence);
        this.setName(name);
    }

    public Alert(RecordAlert recordAlert) {
        this(recordAlert.getPluginId(), recordAlert.getRisk(), recordAlert.getConfidence(), recordAlert.getAlert());
        HistoryReference hRef = null;
        try {
            hRef = new HistoryReference(recordAlert.getHistoryId());
        }
        catch (HttpMalformedHeaderException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.init(recordAlert, hRef);
    }

    private void init(RecordAlert recordAlert, HistoryReference ref) {
        this.alertId = recordAlert.getAlertId();
        this.source = Source.getSource(recordAlert.getSourceId());
        this.setDetail(recordAlert.getDescription(), recordAlert.getUri(), recordAlert.getParam(), recordAlert.getAttack(), recordAlert.getOtherInfo(), recordAlert.getSolution(), recordAlert.getReference(), recordAlert.getEvidence(), recordAlert.getCweId(), recordAlert.getWascId(), null);
        this.setHistoryRef(ref);
        String alertRef = recordAlert.getAlertRef();
        if (alertRef != null) {
            this.setAlertRef(alertRef);
        }
    }

    public Alert(RecordAlert recordAlert, HistoryReference ref) {
        this(recordAlert.getPluginId(), recordAlert.getRisk(), recordAlert.getConfidence(), recordAlert.getAlert());
        this.init(recordAlert, ref);
    }

    @Deprecated
    public void setRiskReliability(int risk, int confidence) {
        this.risk = risk;
        this.confidence = confidence;
    }

    public void setRiskConfidence(int risk, int confidence) {
        this.setRisk(risk);
        this.setConfidence(confidence);
    }

    public void setRisk(int risk) {
        this.risk = risk;
    }

    public void setConfidence(int confidence) {
        this.confidence = confidence;
    }

    @Deprecated
    public void setAlert(String alert) {
        this.setName(alert);
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    @Deprecated
    public void setDetail(String description, String uri, String param, String attack, String otherInfo, String solution, String reference, HttpMessage msg) {
        this.setDetail(description, uri, param, attack, otherInfo, solution, reference, "", -1, -1, msg);
    }

    public void setDetail(String description, String uri, String param, String attack, String otherInfo, String solution, String reference, String evidence, int cweId, int wascId, HttpMessage msg) {
        this.setDescription(description);
        this.setUri(uri);
        this.setParam(param);
        this.setAttack(attack);
        this.setOtherInfo(otherInfo);
        this.setSolution(solution);
        this.setReference(reference);
        this.setMessage(msg);
        this.setEvidence(evidence);
        this.setCweId(cweId);
        this.setWascId(wascId);
        if (msg != null) {
            this.setHistoryRef(msg.getHistoryRef());
        }
    }

    private void setDetail(String description, String uri, String param, String attack, String otherInfo, String solution, String reference, HistoryReference href) {
        this.setDescription(description);
        this.setUri(uri);
        this.setParam(param);
        this.setAttack(attack);
        this.setOtherInfo(otherInfo);
        this.setSolution(solution);
        this.setReference(reference);
        this.setHistoryRef(href);
    }

    public void setUri(String uri) {
        this.uri = uri == null ? "" : uri;
    }

    public void setDescription(String description) {
        this.description = description == null ? "" : description;
    }

    public void setParam(String param) {
        this.param = param == null ? "" : param;
    }

    public void setOtherInfo(String otherInfo) {
        this.otherInfo = otherInfo == null ? "" : otherInfo;
    }

    public void setSolution(String solution) {
        this.solution = solution == null ? "" : solution;
    }

    public void setReference(String reference) {
        this.reference = reference == null ? "" : reference;
    }

    public void setMessage(HttpMessage message) {
        if (message != null) {
            this.message = message;
            this.method = message.getRequestHeader().getMethod();
            this.postData = message.getRequestBody().toString();
            this.msgUri = message.getRequestHeader().getURI();
        } else {
            this.message = null;
        }
    }

    @Override
    public int compareTo(Alert alert2) {
        if (this.risk < alert2.risk) {
            return -1;
        }
        if (this.risk > alert2.risk) {
            return 1;
        }
        if (this.confidence < alert2.confidence) {
            return -1;
        }
        if (this.confidence > alert2.confidence) {
            return 1;
        }
        if (this.pluginId < alert2.pluginId) {
            return -1;
        }
        if (this.pluginId > alert2.pluginId) {
            return 1;
        }
        int result = this.compareStrings(this.alertRef, alert2.alertRef);
        if (result != 0) {
            return result;
        }
        result = this.name.compareToIgnoreCase(alert2.name);
        if (result != 0) {
            return result;
        }
        result = this.method.compareToIgnoreCase(alert2.method);
        if (result != 0) {
            return result;
        }
        result = this.uri.compareToIgnoreCase(alert2.uri);
        if (result != 0) {
            return result;
        }
        result = this.param.compareToIgnoreCase(alert2.param);
        if (result != 0) {
            return result;
        }
        result = this.otherInfo.compareToIgnoreCase(alert2.otherInfo);
        if (result != 0) {
            return result;
        }
        result = this.compareStrings(this.evidence, alert2.evidence);
        if (result != 0) {
            return result;
        }
        return this.compareStrings(this.attack, alert2.attack);
    }

    private int compareStrings(String string, String otherString) {
        if (string == null) {
            if (otherString == null) {
                return 0;
            }
            return -1;
        }
        if (otherString == null) {
            return 1;
        }
        return string.compareTo(otherString);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Alert item = (Alert)obj;
        if (this.risk != item.risk) {
            return false;
        }
        if (this.confidence != item.confidence) {
            return false;
        }
        if (this.pluginId != item.pluginId) {
            return false;
        }
        if (!this.alertRef.equals(item.alertRef)) {
            return false;
        }
        if (!this.name.equals(item.name)) {
            return false;
        }
        if (!this.method.equalsIgnoreCase(item.method)) {
            return false;
        }
        if (!this.uri.equalsIgnoreCase(item.uri)) {
            return false;
        }
        if (!this.param.equalsIgnoreCase(item.param)) {
            return false;
        }
        if (!this.otherInfo.equalsIgnoreCase(item.otherInfo)) {
            return false;
        }
        if (this.evidence == null ? item.evidence != null : !this.evidence.equals(item.evidence)) {
            return false;
        }
        return !(this.attack == null ? item.attack != null : !this.attack.equals(item.attack));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.risk;
        result = 31 * result + this.confidence;
        result = 31 * result + (this.evidence == null ? 0 : this.evidence.hashCode());
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.otherInfo.hashCode();
        result = 31 * result + this.param.hashCode();
        result = 31 * result + this.pluginId;
        result = 31 * result + this.alertRef.hashCode();
        result = 31 * result + this.method.hashCode();
        result = 31 * result + this.uri.hashCode();
        result = 31 * result + (this.attack == null ? 0 : this.attack.hashCode());
        return result;
    }

    public Alert newInstance() {
        Alert item = new Alert(this.pluginId);
        item.setRiskConfidence(this.risk, this.confidence);
        item.setName(this.name);
        item.setDetail(this.description, this.uri, this.param, this.attack, this.otherInfo, this.solution, this.reference, this.historyRef);
        item.setEvidence(this.evidence);
        item.setCweId(this.cweId);
        item.setWascId(this.wascId);
        item.setSource(this.source);
        item.setTags(this.tags);
        return item;
    }

    public String toPluginXML(String urls) {
        StringBuilder sb = new StringBuilder(150);
        sb.append("<alertitem>\r\n");
        sb.append("  <pluginid>").append(this.pluginId).append("</pluginid>\r\n");
        sb.append("  <alertRef>").append(this.alertRef).append("</alertRef>\r\n");
        sb.append("  <alert>").append(this.replaceEntity(this.name)).append("</alert>\r\n");
        sb.append("  <name>").append(this.replaceEntity(this.name)).append("</name>\r\n");
        sb.append("  <riskcode>").append(this.risk).append("</riskcode>\r\n");
        sb.append("  <confidence>").append(this.confidence).append("</confidence>\r\n");
        sb.append("  <riskdesc>").append(this.replaceEntity(MSG_RISK[this.risk] + " (" + MSG_CONFIDENCE[this.confidence] + ")")).append("</riskdesc>\r\n");
        sb.append("  <desc>").append(this.replaceEntity(this.paragraph(this.description))).append("</desc>\r\n");
        sb.append(urls);
        sb.append("  <solution>").append(this.replaceEntity(this.paragraph(this.solution))).append("</solution>\r\n");
        if (this.otherInfo != null && this.otherInfo.length() > 0) {
            sb.append("  <otherinfo>").append(this.replaceEntity(this.paragraph(this.otherInfo))).append("</otherinfo>\r\n");
        }
        sb.append("  <reference>").append(this.replaceEntity(this.paragraph(this.reference))).append("</reference>\r\n");
        if (this.cweId > 0) {
            sb.append("  <cweid>").append(this.cweId).append("</cweid>\r\n");
        }
        if (this.wascId > 0) {
            sb.append("  <wascid>").append(this.wascId).append("</wascid>\r\n");
        }
        sb.append("  <sourceid>").append(this.source.getId()).append("</sourceid>\r\n");
        sb.append("</alertitem>\r\n");
        return sb.toString();
    }

    public String replaceEntity(String text) {
        String result = null;
        if (text != null) {
            result = Alert.entityEncode(text);
        }
        return result;
    }

    private static String entityEncode(String text) {
        String result = text;
        if (result == null) {
            return result;
        }
        return StringEscapeUtils.escapeXml10((String)XMLStringUtil.escapeControlChrs(result));
    }

    public String paragraph(String text) {
        return "<p>" + text.replaceAll("\\r\\n", "</p><p>").replaceAll("\\n", "</p><p>") + "</p>";
    }

    @Deprecated
    public String getAlert() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getPluginId() {
        return this.pluginId;
    }

    public HttpMessage getMessage() {
        if (this.message != null) {
            return this.message;
        }
        if (this.historyRef != null) {
            try {
                return this.historyRef.getHttpMessage();
            }
            catch (DatabaseException | HttpMalformedHeaderException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public String getOtherInfo() {
        return this.otherInfo;
    }

    public String getParam() {
        return this.param;
    }

    public String getReference() {
        return this.reference;
    }

    @Deprecated
    public int getReliability() {
        return this.confidence;
    }

    public int getConfidence() {
        return this.confidence;
    }

    public int getRisk() {
        return this.risk;
    }

    public ImageIcon getIcon() {
        if (this.confidence == 0) {
            return DisplayUtils.getScaledIcon(Constant.OK_FLAG_IMAGE_URL);
        }
        switch (this.risk) {
            case 0: {
                return DisplayUtils.getScaledIcon(Constant.INFO_FLAG_IMAGE_URL);
            }
            case 1: {
                return DisplayUtils.getScaledIcon(Constant.LOW_FLAG_IMAGE_URL);
            }
            case 2: {
                return DisplayUtils.getScaledIcon(Constant.MED_FLAG_IMAGE_URL);
            }
            case 3: {
                return DisplayUtils.getScaledIcon(Constant.HIGH_FLAG_IMAGE_URL);
            }
        }
        return null;
    }

    @Deprecated
    public URL getIconUrl() {
        if (this.confidence == 0) {
            return Constant.OK_FLAG_IMAGE_URL;
        }
        switch (this.risk) {
            case 0: {
                return Constant.INFO_FLAG_IMAGE_URL;
            }
            case 1: {
                return Constant.LOW_FLAG_IMAGE_URL;
            }
            case 2: {
                return Constant.MED_FLAG_IMAGE_URL;
            }
            case 3: {
                return Constant.HIGH_FLAG_IMAGE_URL;
            }
        }
        return null;
    }

    public String getSolution() {
        return this.solution;
    }

    public String getUri() {
        return this.uri;
    }

    public int getAlertId() {
        return this.alertId;
    }

    public void setAlertId(int alertId) {
        this.alertId = alertId;
    }

    public String getUrlParamXML() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("  <uri>").append(this.replaceEntity(this.uri)).append("</uri>\r\n");
        sb.append("  <method>").append(this.replaceEntity(this.method)).append("</method>\r\n");
        if (this.param != null && this.param.length() > 0) {
            sb.append("  <param>").append(this.replaceEntity(this.param)).append("</param>\r\n");
        }
        if (this.attack != null && this.attack.length() > 0) {
            sb.append("  <attack>").append(this.replaceEntity(this.attack)).append("</attack>\r\n");
        }
        if (this.evidence != null && this.evidence.length() > 0) {
            sb.append("  <evidence>").append(this.replaceEntity(this.evidence)).append("</evidence>\r\n");
        }
        return sb.toString();
    }

    public int getSourceHistoryId() {
        return this.sourceHistoryId;
    }

    public void setSourceHistoryId(int sourceHistoryId) {
        this.sourceHistoryId = sourceHistoryId;
    }

    public HistoryReference getHistoryRef() {
        return this.historyRef;
    }

    public void setHistoryRef(HistoryReference historyRef) {
        this.historyRef = historyRef;
        if (historyRef != null) {
            this.message = null;
            this.method = historyRef.getMethod();
            this.msgUri = historyRef.getURI();
            this.postData = historyRef.getRequestBody();
            this.sourceHistoryId = historyRef.getHistoryId();
        }
    }

    public String getAttack() {
        return this.attack;
    }

    public void setAttack(String attack) {
        this.attack = attack == null ? "" : attack;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPostData() {
        return this.postData;
    }

    public URI getMsgUri() {
        return this.msgUri;
    }

    public String getEvidence() {
        return this.evidence;
    }

    public void setEvidence(String evidence) {
        this.evidence = evidence == null ? "" : evidence;
    }

    public int getCweId() {
        return this.cweId;
    }

    public void setCweId(int cweId) {
        this.cweId = cweId;
    }

    public int getWascId() {
        return this.wascId;
    }

    public void setWascId(int wascId) {
        this.wascId = wascId;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        if (tags != null) {
            this.tags = tags;
        }
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        if (source == null) {
            throw new IllegalArgumentException("Parameter source must not be null.");
        }
        this.source = source;
    }

    public String getAlertRef() {
        return this.alertRef;
    }

    public void setAlertRef(String alertRef) {
        if (alertRef == null) {
            throw new IllegalArgumentException("Alert reference must not be null");
        }
        if (alertRef.length() > 0) {
            if (alertRef.length() >= 256) {
                throw new IllegalArgumentException("Alert reference too big: " + alertRef.length());
            }
            if (!alertRef.startsWith(Integer.toString(this.pluginId))) {
                throw new IllegalArgumentException("Alert reference " + alertRef + " must start with the plugin id " + this.pluginId);
            }
        }
        this.alertRef = alertRef;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static boolean isValidRisk(int risk) {
        return risk >= 0 && risk <= 3;
    }

    public static boolean isValidConfidence(int confidence) {
        return confidence >= 0 && confidence <= 4;
    }

    public static class Builder {
        private int alertId = -1;
        private int pluginId;
        private String name;
        private int risk = 0;
        private int confidence = 2;
        private String description;
        private String uri;
        private String param;
        private String attack;
        private String otherInfo;
        private String solution;
        private String reference;
        private String evidence;
        private int cweId = -1;
        private int wascId = -1;
        private HttpMessage message;
        private int sourceHistoryId;
        private HistoryReference historyRef;
        private Source source = Source.UNKNOWN;
        private String alertRef;
        private Map<String, String> tags;

        protected Builder() {
        }

        public Builder setAlertId(int alertId) {
            this.alertId = alertId;
            return this;
        }

        public Builder setPluginId(int pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setRisk(int risk) {
            this.risk = risk;
            return this;
        }

        public Builder setConfidence(int confidence) {
            this.confidence = confidence;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setUri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder setParam(String param) {
            this.param = param;
            return this;
        }

        public Builder setAttack(String attack) {
            this.attack = attack;
            return this;
        }

        public Builder setOtherInfo(String otherInfo) {
            this.otherInfo = otherInfo;
            return this;
        }

        public Builder setSolution(String solution) {
            this.solution = solution;
            return this;
        }

        public Builder setReference(String reference) {
            this.reference = reference;
            return this;
        }

        public Builder setEvidence(String evidence) {
            this.evidence = evidence;
            return this;
        }

        public Builder setCweId(int cweId) {
            this.cweId = cweId;
            return this;
        }

        public Builder setWascId(int wascId) {
            this.wascId = wascId;
            return this;
        }

        public Builder setMessage(HttpMessage message) {
            this.message = message;
            return this;
        }

        public Builder setSourceHistoryId(int sourceHistoryId) {
            this.sourceHistoryId = sourceHistoryId;
            return this;
        }

        public Builder setHistoryRef(HistoryReference historyRef) {
            this.historyRef = historyRef;
            return this;
        }

        public Builder setSource(Source source) {
            this.source = source;
            return this;
        }

        public Builder setAlertRef(String alertRef) {
            this.alertRef = alertRef;
            return this;
        }

        public Builder setTags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public final Alert build() {
            String alertUri = this.uri;
            if (alertUri == null || alertUri.isEmpty()) {
                if (this.historyRef != null) {
                    alertUri = this.historyRef.getURI().toString();
                } else if (this.message != null) {
                    alertUri = this.message.getRequestHeader().getURI().toString();
                }
            }
            Alert alert = new Alert(this.pluginId);
            alert.setAlertId(this.alertId);
            alert.setName(this.name);
            alert.setRisk(this.risk);
            alert.setConfidence(this.confidence);
            alert.setDescription(this.description);
            alert.setUri(alertUri);
            alert.setParam(this.param);
            alert.setAttack(this.attack);
            alert.setOtherInfo(this.otherInfo);
            alert.setSolution(this.solution);
            alert.setReference(this.reference);
            alert.setEvidence(this.evidence);
            alert.setCweId(this.cweId);
            alert.setWascId(this.wascId);
            alert.setMessage(this.message);
            alert.setSourceHistoryId(this.sourceHistoryId);
            alert.setHistoryRef(this.historyRef);
            alert.setSource(this.source);
            if (this.alertRef != null) {
                alert.setAlertRef(this.alertRef);
            }
            alert.setTags(this.tags);
            return alert;
        }
    }

    public static enum Source {
        UNKNOWN(0, "alert.source.unknown"),
        ACTIVE(1, "alert.source.active"),
        MANUAL(2, "alert.source.manual"),
        PASSIVE(3, "alert.source.passive"),
        TOOL(4, "alert.source.tool");

        private final int id;
        private final String i18nKey;

        private Source(int id, String i18nKey) {
            this.id = id;
            this.i18nKey = i18nKey;
        }

        public int getId() {
            return this.id;
        }

        public String getI18nKey() {
            return this.i18nKey;
        }

        public static Source getSource(int id) {
            switch (id) {
                case 0: {
                    return UNKNOWN;
                }
                case 1: {
                    return ACTIVE;
                }
                case 2: {
                    return MANUAL;
                }
                case 3: {
                    return PASSIVE;
                }
                case 4: {
                    return TOOL;
                }
            }
            return UNKNOWN;
        }
    }
}

