#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 xmobar
version:              0.44.1
visibility:           public
id:                   xmobar-0.44.1-JmwKlq9AyqtC0ub4FehOIs
key:                  xmobar-0.44.1-JmwKlq9AyqtC0ub4FehOIs
license:              BSD-3-Clause
maintainer:           Jose A. Ortega Ruiz <jao@gnu.org>
author:               Andrea Rossato and Jose A. Ortega Ruiz
homepage:             https://codeberg.org/xmobar/xmobar
synopsis:             A Minimalistic Text Based Status Bar
description:
    Xmobar is a minimalistic text based status bar.

    Inspired by the Ion3 status bar, it supports similar
    features, like dynamic color management, output templates,
    and extensibility through plugins.

category:             System
abi:                  a158ef5d2713b0bd9201045c86dddd97
exposed:              True
exposed-modules:
    Xmobar Xmobar.Plugins.Monitors.Common
    Xmobar.Plugins.Monitors.Common.Run
    Xmobar.Plugins.Monitors.Common.Types Xmobar.Plugins.Monitors.Cpu

hidden-modules:
    Paths_xmobar Xmobar.Config.Types Xmobar.Config.Parse
    Xmobar.Run.Types Xmobar.Run.Timer Xmobar.Run.Template
    Xmobar.Run.Exec Xmobar.Run.Runnable Xmobar.Run.Actions
    Xmobar.Run.Parsers Xmobar.Run.Loop Xmobar.App.Config
    Xmobar.App.Main Xmobar.App.Opts Xmobar.App.Compile
    Xmobar.System.Utils Xmobar.System.StatFS Xmobar.System.Environment
    Xmobar.System.Localize Xmobar.System.Signal Xmobar.System.Kbd
    Xmobar.Text.Ansi Xmobar.Text.Loop Xmobar.Text.Pango
    Xmobar.Text.Swaybar Xmobar.Text.SwaybarClicks Xmobar.Text.Output
    Xmobar.X11.Events Xmobar.X11.Loop Xmobar.X11.Types Xmobar.X11.Text
    Xmobar.X11.Bitmap Xmobar.X11.ColorCache Xmobar.X11.Window
    Xmobar.X11.Draw Xmobar.Plugins.Command
    Xmobar.Plugins.BufferedPipeReader Xmobar.Plugins.CommandReader
    Xmobar.Plugins.Date Xmobar.Plugins.EWMH Xmobar.Plugins.HandleReader
    Xmobar.Plugins.QueueReader Xmobar.Plugins.PipeReader
    Xmobar.Plugins.MarqueePipeReader Xmobar.Plugins.StdinReader
    Xmobar.Plugins.XMonadLog Xmobar.Plugins.Kbd Xmobar.Plugins.Locks
    Xmobar.Plugins.NotmuchMail Xmobar.Plugins.Monitors
    Xmobar.Plugins.Monitors.Batt Xmobar.Plugins.Monitors.Batt.Common
    Xmobar.Plugins.Monitors.Common.Output
    Xmobar.Plugins.Monitors.Common.Parsers
    Xmobar.Plugins.Monitors.Common.Files
    Xmobar.Plugins.Monitors.CoreTemp Xmobar.Plugins.Monitors.K10Temp
    Xmobar.Plugins.Monitors.Cpu.Common Xmobar.Plugins.Monitors.CpuFreq
    Xmobar.Plugins.Monitors.Disk Xmobar.Plugins.Monitors.Disk.Common
    Xmobar.Plugins.Monitors.Load Xmobar.Plugins.Monitors.Load.Common
    Xmobar.Plugins.Monitors.Mem Xmobar.Plugins.Monitors.MultiCoreTemp
    Xmobar.Plugins.Monitors.MultiCpu Xmobar.Plugins.Monitors.Net
    Xmobar.Plugins.Monitors.Net.Common Xmobar.Plugins.Monitors.Swap
    Xmobar.Plugins.Monitors.Thermal Xmobar.Plugins.Monitors.ThermalZone
    Xmobar.Plugins.Monitors.Top Xmobar.Plugins.Monitors.Top.Common
    Xmobar.Plugins.Monitors.Uptime Xmobar.Plugins.Monitors.Bright
    Xmobar.Plugins.Monitors.CatInt Xmobar.X11.MinXft
    Xmobar.Plugins.Mail Xmobar.Plugins.MBox
    Xmobar.Plugins.Monitors.Wireless Xmobar.Plugins.Monitors.MPD
    Xmobar.Plugins.Monitors.Volume Xmobar.Plugins.Monitors.Alsa
    Xmobar.Plugins.DateZone Xmobar.Plugins.Monitors.Mpris
    Xmobar.System.DBus Xmobar.X11.XPMFile
    Xmobar.Plugins.Monitors.Weather Xmobar.Plugins.Monitors.Batt.Linux
    Xmobar.Plugins.Monitors.Cpu.Linux
    Xmobar.Plugins.Monitors.Disk.Linux
    Xmobar.Plugins.Monitors.Load.Linux
    Xmobar.Plugins.Monitors.Mem.Linux Xmobar.Plugins.Monitors.Net.Linux
    Xmobar.Plugins.Monitors.Swap.Linux
    Xmobar.Plugins.Monitors.Top.Linux
    Xmobar.Plugins.Monitors.Uptime.Linux

import-dirs:          /usr/lib/ghc-9.0.2/site-local/xmobar-0.44.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/xmobar-0.44.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.2/xmobar-0.44.1
hs-libraries:         HSxmobar-0.44.1-JmwKlq9AyqtC0ub4FehOIs
extra-libraries:      Xrandr Xrender Xpm
depends:
    X11-1.10.3-7zBAfsIL85sJKAyVO3fFRL
    X11-xft-0.3.4-Bx7HmUyuILo4NY9YdSLjq2
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT
    alsa-core-0.5.0.1-IuG6WQnGAn47tOy9J9GFFS
    alsa-mixer-0.3.0-JtZuHosXJUKH6JUSW3X2Ak
    async-2.2.4-9EoKZTgytm43s60GeTAIZR base-4.15.1.0
    bytestring-0.10.12.1 cereal-0.5.8.3-KCibhvvTsuv86wVgcPkD6
    containers-0.6.4.1 dbus-1.2.22-9MJQjLNK44KDWs0JXiHJpX
    directory-1.3.6.2
    extensible-exceptions-0.1.1.4-FO4Sw13oBkvBW8j4vnJTpA
    filepath-1.4.2.1 hinotify-0.4.1-A0yomozgVA3FJIZrNP2zYO
    http-client-tls-0.3.6.1-KvEPoRWqIbH3HwtuX8a907
    http-conduit-2.3.8-A2ewQB6Xsua8zvxieTH7DQ
    http-types-0.12.3-L4VBkj9wBbpJhmiMCXrA05
    libmpd-0.10.0.0-FOE6wFDjkeK7efCeAILh55 mtl-2.2.2
    netlink-1.1.1.0-7lToiwlODZtJ2LH0SEVk93
    old-locale-1.0.0.7-B94o3sNLYrV8oE3WO2rqHh parsec-3.1.14.0
    parsec-numbers-0.1.0-KU1MBEMrFWqCG0to3snEZN process-1.6.13.2
    regex-compat-0.95.2.1-itFB4fXPjn9OuocZGgbix stm-2.5.0.0 time-1.9.3
    timezone-olson-0.2.1-pOmM6RdLVOJfUXr6ZE0Lz
    timezone-series-0.1.13-8hy5SgZJJLXGTkGPNLHG0s transformers-0.5.6.2
    unix-2.7.2.2 utf8-string-1.0.2-Fg3PN5UX3ZfnukMwwaDpj

haddock-interfaces:
    /usr/share/doc/x86_64-linux-ghc-9.0.2/xmobar-0.44.1/html/xmobar.haddock

haddock-html:         /usr/share/doc/x86_64-linux-ghc-9.0.2/xmobar-0.44.1/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

