"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Title = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = require("@emotion/react");

var _Identity = require("../Identity");

var _Text = require("./Text");

var _excluded = ["block", "center", "fontSize", "color", "bold"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var titleStyle = function titleStyle(theme, _ref) {
  var _ref$block = _ref.block,
      block = _ref$block === void 0 ? true : _ref$block,
      _ref$center = _ref.center,
      center = _ref$center === void 0 ? true : _ref$center,
      _ref$fontSize = _ref.fontSize,
      fontSize = _ref$fontSize === void 0 ? '32px' : _ref$fontSize,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? _Identity.COLOR.GRAY : _ref$color,
      _ref$bold = _ref.bold,
      bold = _ref$bold === void 0 ? true : _ref$bold,
      props = (0, _objectWithoutProperties2["default"])(_ref, _excluded);
  return _objectSpread(_objectSpread({}, (0, _Text.textStyle)(theme, _objectSpread({
    block: block,
    bold: bold,
    center: center,
    color: color,
    fontSize: fontSize
  }, props))), {}, {
    marginBottom: '8px'
  });
};

var Title = function Title(props) {
  return (0, _react.jsx)("div", (0, _extends2["default"])({
    css: function css(theme) {
      return titleStyle(theme, props);
    }
  }, (0, _Text.filterTextProps)(props)));
};

exports.Title = Title;
//# sourceMappingURL=Title.js.map