"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Overlay = exports.OverlayBackground = exports.overlayBackgroundStyle = exports.OverlayContent = exports.OverlayWrapper = exports.overlayWrapperStyle = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = require("@emotion/react");

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react2 = _interopRequireDefault(require("react"));

var _Identity = require("../Identity");

var _motions = require("../Identity/motions");

var _mediaQueries = require("../mediaQueries");

var _util = require("../util");

var _excluded = ["onBackgroundClick", "children"];

var overlayWrapperStyle = function overlayWrapperStyle() {
  return {
    bottom: 0,
    display: 'flex',
    left: 0,
    overflowY: 'auto',
    padding: '24px',
    position: 'fixed',
    right: 0,
    top: 0,
    zIndex: 9997
  };
};

exports.overlayWrapperStyle = overlayWrapperStyle;

var OverlayWrapper = function OverlayWrapper(props) {
  return (0, _react.jsx)("div", (0, _extends2["default"])({
    css: overlayWrapperStyle
  }, props));
};

exports.OverlayWrapper = OverlayWrapper;

var OverlayContent = function OverlayContent(props) {
  return (0, _react.jsx)("div", (0, _extends2["default"])({
    css: /*#__PURE__*/(0, _react.css)((0, _defineProperty2["default"])({
      '*': {
        color: _Identity.COLOR.WHITE
      },
      alignItems: 'center',
      display: 'flex',
      flexDirection: 'column',
      justifyContent: 'space-between',
      margin: 'auto',
      maxWidth: '100%',
      overflowY: 'auto',
      position: 'relative',
      transform: 'translate3d(0, 0, 0)',
      zIndex: 9999
    }, _mediaQueries.media[_mediaQueries.QueryKeys.TABLET_DOWN], {
      width: '100%'
    }), process.env.NODE_ENV === "production" ? "" : ";label:OverlayContent;", process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */")
  }, props));
};

exports.OverlayContent = OverlayContent;

var overlayBackgroundStyle = function overlayBackgroundStyle() {
  return {
    animation: "".concat(_motions.ANIMATION.fadeIn, " ").concat(_motions.DURATION.PROACTIVE_SLOW, "ms ").concat(_motions.EASE.QUART),
    background: 'rgba(0, 0, 0, 0.88)',
    height: '100vh',
    left: 0,
    position: 'fixed',
    top: 0,
    width: '100vw',
    zIndex: 9998
  };
};

exports.overlayBackgroundStyle = overlayBackgroundStyle;

var OverlayBackground = function OverlayBackground(props) {
  return (0, _react.jsx)("div", (0, _extends2["default"])({
    css: overlayBackgroundStyle
  }, props));
};

exports.OverlayBackground = OverlayBackground;

var Overlay = function Overlay(_ref) {
  var _ref$onBackgroundClic = _ref.onBackgroundClick,
      onBackgroundClick = _ref$onBackgroundClic === void 0 ? _util.noop : _ref$onBackgroundClic,
      _ref$children = _ref.children,
      children = _ref$children === void 0 ? null : _ref$children,
      props = (0, _objectWithoutProperties2["default"])(_ref, _excluded);
  return (0, _react.jsx)(OverlayWrapper, (0, _extends2["default"])({}, props, {
    "data-uie-name": "modal"
  }), (0, _react.jsx)(OverlayContent, null, children), (0, _react.jsx)(OverlayBackground, {
    onClick: onBackgroundClick,
    "data-uie-name": "overlay-background"
  }));
};

exports.Overlay = Overlay;
//# sourceMappingURL=Overlay.js.map