"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Pagination = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = require("@emotion/react");

var _react2 = _interopRequireDefault(require("react"));

var _Identity = require("../Identity");

var _Layout = require("../Layout");

var _Text = require("../Text");

var _excluded = ["currentPage", "numberOfPages", "goPage", "previousPageComponent", "nextPageComponent"];

function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }

var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "1uohtp9",
  styles: "flex-basis:100px"
} : {
  name: "6wexnb-Pagination",
  styles: "flex-basis:100px;label:Pagination;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "jli9tm",
  styles: "align-items:flex-end;display:flex;flex-direction:row;margin:0 auto"
} : {
  name: "93bcni-Pagination",
  styles: "align-items:flex-end;display:flex;flex-direction:row;margin:0 auto;label:Pagination;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var _ref4 = process.env.NODE_ENV === "production" ? {
  name: "ffod5d",
  styles: "display:flex;flex-basis:100px;justify-content:flex-end"
} : {
  name: "338rgm-Pagination",
  styles: "display:flex;flex-basis:100px;justify-content:flex-end;label:Pagination;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var Pagination = function Pagination(_ref) {
  var _ref$currentPage = _ref.currentPage,
      currentPage = _ref$currentPage === void 0 ? 0 : _ref$currentPage,
      _ref$numberOfPages = _ref.numberOfPages,
      numberOfPages = _ref$numberOfPages === void 0 ? 1 : _ref$numberOfPages,
      goPage = _ref.goPage,
      _ref$previousPageComp = _ref.previousPageComponent,
      PreviousPageComponent = _ref$previousPageComp === void 0 ? function () {
    return '<';
  } : _ref$previousPageComp,
      _ref$nextPageComponen = _ref.nextPageComponent,
      NextPageComponent = _ref$nextPageComponen === void 0 ? function () {
    return '>';
  } : _ref$nextPageComponen,
      props = (0, _objectWithoutProperties2["default"])(_ref, _excluded);
  var isLastPage = currentPage === numberOfPages - 1;
  var isFirstPage = currentPage === 0;

  var renderPageList = function renderPageList() {
    var lastPageIndex = numberOfPages - 1;
    var spanLength = 1;
    var endLength = 1;
    var skipLength = 1;
    var normalizeCount = endLength + skipLength + spanLength;

    var dots = function dots(key) {
      return (0, _react.jsx)(_Text.Bold, {
        key: key,
        fontSize: '11px'
      }, '…');
    };

    var renderPageNumber = function renderPageNumber(pageIndex) {
      return currentPage === pageIndex ? (0, _react.jsx)(_Text.Bold, {
        fontSize: '11px',
        key: pageIndex,
        style: {
          color: _Identity.COLOR.BLUE,
          margin: '0 8px'
        },
        "data-uie-name": "status-active-page"
      }, pageIndex + 1) : (0, _react.jsx)(_Text.Link, {
        key: pageIndex,
        style: {
          margin: '0 8px'
        },
        onClick: function onClick() {
          return goPage(pageIndex);
        },
        "data-uie-name": "go-page"
      }, pageIndex + 1);
    };

    var normalizedCurrent = Math.min(Math.max(currentPage, normalizeCount), lastPageIndex - normalizeCount);
    var beforeCount = normalizedCurrent - spanLength - endLength;
    var afterCount = lastPageIndex - endLength - normalizedCurrent - spanLength;
    var pages = Array.from(Array(numberOfPages), function (nothing, index) {
      return renderPageNumber(index);
    });

    if (afterCount > skipLength) {
      pages.splice(normalizedCurrent + spanLength + 1, afterCount, dots('dots-end'));
    }

    if (beforeCount > skipLength) {
      pages.splice(endLength, beforeCount, dots('dots-start'));
    }

    return pages;
  };

  return (0, _react.jsx)(_Layout.FlexBox, (0, _extends2["default"])({
    align: "flex-end",
    "data-uie-name": "element-pagination"
  }, props), (0, _react.jsx)("div", {
    css: _ref2
  }, !isFirstPage && (0, _react.jsx)(_Text.Link, {
    block: true,
    onClick: function onClick() {
      return goPage(currentPage - 1);
    },
    "data-uie-name": "go-previous-page"
  }, (0, _react.jsx)(PreviousPageComponent, null))), (0, _react.jsx)("div", {
    css: _ref3,
    "data-uie-name": "list-pages"
  }, renderPageList()), (0, _react.jsx)("div", {
    css: _ref4
  }, !isLastPage && (0, _react.jsx)(_Text.Link, {
    block: true,
    onClick: function onClick() {
      return goPage(currentPage + 1);
    },
    "data-uie-name": "go-next-page"
  }, (0, _react.jsx)(NextPageComponent, null))));
};

exports.Pagination = Pagination;
//# sourceMappingURL=Pagination.js.map