"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MenuOpenButton = exports.menuOpenButtonStyle = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = require("@emotion/react");

var _react2 = _interopRequireDefault(require("react"));

var _mediaQueries = require("../../mediaQueries");

var _util = require("../../util");

/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */

/** @jsx jsx */
var menuOpenButtonStyle = function menuOpenButtonStyle(theme, _ref) {
  var _ref2;

  var open = _ref.open;
  return _ref2 = {
    display: 'block',
    div: {
      backgroundColor: theme.general.color,
      height: '2px',
      margin: '4px',
      transition: 'all 0.25s ease-in-out',
      width: '16px'
    },
    'div:nth-of-type(1)': {
      transform: open ? 'translateY(6px) rotate(-45deg)' : undefined
    },
    'div:nth-of-type(2)': {
      opacity: open ? 0 : undefined,
      transform: open ? 'scale(0, 1)' : undefined
    },
    'div:nth-of-type(3)': {
      transform: open ? 'translateY(-6px) rotate(45deg)' : undefined
    }
  }, (0, _defineProperty2["default"])(_ref2, _mediaQueries.media[_mediaQueries.QueryKeys.DESKTOP], {
    display: 'none'
  }), (0, _defineProperty2["default"])(_ref2, "zIndex", 2), _ref2;
};

exports.menuOpenButtonStyle = menuOpenButtonStyle;

var filterMenuOpenButtonProps = function filterMenuOpenButtonProps(props) {
  return (0, _util.filterProps)(props, ['open']);
};

var MenuOpenButton = function MenuOpenButton(props) {
  return (0, _react.jsx)("div", (0, _extends2["default"])({
    css: function css(theme) {
      return menuOpenButtonStyle(theme, props);
    }
  }, filterMenuOpenButtonProps(props)), (0, _react.jsx)("div", null), (0, _react.jsx)("div", null), (0, _react.jsx)("div", null));
};

exports.MenuOpenButton = MenuOpenButton;
//# sourceMappingURL=MenuOpenButton.js.map