"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IsTabletUp = exports.IsTabletDown = exports.IsTablet = exports.IsMobileUp = exports.IsMobileDown = exports.IsMobile = exports.IsDesktopXL = exports.IsDesktop = exports.MatchMedia = exports.useMatchMedia = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = require("@emotion/react");

var _react2 = _interopRequireWildcard(require("react"));

var _mediaQueries = require("../mediaQueries");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */

/** @jsx jsx */
var useMatchMedia = function useMatchMedia(query) {
  var matchMedia = window.matchMedia("(".concat(query, ")"));

  var _useState = (0, _react2.useState)(matchMedia.matches),
      _useState2 = (0, _slicedToArray2["default"])(_useState, 2),
      isMatching = _useState2[0],
      setIsMatching = _useState2[1];

  var updateMatching = function updateMatching() {
    return setIsMatching(matchMedia.matches);
  };

  (0, _react2.useEffect)(function () {
    matchMedia.addListener(updateMatching);
    return function () {
      return matchMedia.removeListener(updateMatching);
    };
  });
  return isMatching;
};

exports.useMatchMedia = useMatchMedia;

var MatchMedia = function MatchMedia(_ref) {
  var query = _ref.query,
      children = _ref.children,
      not = _ref.not;
  var matchQuery = useMatchMedia(_mediaQueries.QUERY[query] || query);
  var isMatching = not ? !matchQuery : matchQuery;
  return (0, _react.jsx)(_react2["default"].Fragment, null, isMatching ? children : null);
};

exports.MatchMedia = MatchMedia;

var IsDesktop = function IsDesktop(props) {
  return (0, _react.jsx)(MatchMedia, (0, _extends2["default"])({
    query: _mediaQueries.QueryKeys.DESKTOP
  }, props));
};

exports.IsDesktop = IsDesktop;

var IsDesktopXL = function IsDesktopXL(props) {
  return (0, _react.jsx)(MatchMedia, (0, _extends2["default"])({
    query: _mediaQueries.QueryKeys.DESKTOP_XL
  }, props));
};

exports.IsDesktopXL = IsDesktopXL;

var IsMobile = function IsMobile(props) {
  return (0, _react.jsx)(MatchMedia, (0, _extends2["default"])({
    query: _mediaQueries.QueryKeys.MOBILE
  }, props));
};

exports.IsMobile = IsMobile;

var IsMobileDown = function IsMobileDown(props) {
  return (0, _react.jsx)(MatchMedia, (0, _extends2["default"])({
    query: _mediaQueries.QueryKeys.MOBILE_DOWN
  }, props));
};

exports.IsMobileDown = IsMobileDown;

var IsMobileUp = function IsMobileUp(props) {
  return (0, _react.jsx)(MatchMedia, (0, _extends2["default"])({
    query: _mediaQueries.QueryKeys.MOBILE_UP
  }, props));
};

exports.IsMobileUp = IsMobileUp;

var IsTablet = function IsTablet(props) {
  return (0, _react.jsx)(MatchMedia, (0, _extends2["default"])({
    query: _mediaQueries.QueryKeys.TABLET
  }, props));
};

exports.IsTablet = IsTablet;

var IsTabletDown = function IsTabletDown(props) {
  return (0, _react.jsx)(MatchMedia, (0, _extends2["default"])({
    query: _mediaQueries.QueryKeys.TABLET_DOWN
  }, props));
};

exports.IsTabletDown = IsTabletDown;

var IsTabletUp = function IsTabletUp(props) {
  return (0, _react.jsx)(MatchMedia, (0, _extends2["default"])({
    query: _mediaQueries.QueryKeys.TABLET_UP
  }, props));
};

exports.IsTabletUp = IsTabletUp;
//# sourceMappingURL=MatchMedia.js.map