"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Avatar = exports.DEFAULT_AVATAR_SIZE = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = require("@emotion/react");

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react2 = require("react");

var _Misc = require("../Misc/");

var _util = require("../util");

var _colors = require("./colors");

var _motions = require("./motions");

/*
 * Wire
 * Copyright (C) 2019 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */

/** @jsx jsx */
var DEFAULT_AVATAR_SIZE = 28;
exports.DEFAULT_AVATAR_SIZE = DEFAULT_AVATAR_SIZE;

var avatarStyle = function avatarStyle(_ref) {
  var _ref$color = _ref.color,
      color = _ref$color === void 0 ? _colors.COLOR.WHITE : _ref$color,
      url = _ref.url,
      borderColor = _ref.borderColor,
      _ref$backgroundColor = _ref.backgroundColor,
      backgroundColor = _ref$backgroundColor === void 0 ? _colors.COLOR.GRAY : _ref$backgroundColor,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? DEFAULT_AVATAR_SIZE : _ref$size,
      isAvatarGridItem = _ref.isAvatarGridItem;
  var BORDER_SIZE_LIMIT = 32;
  var borderSize = size > BORDER_SIZE_LIMIT ? 2 : 1;
  var borderWidth = url ? 0 : borderSize;
  var fontSize = "".concat(Math.ceil(size / 2.2), "px");
  return {
    alignItems: 'center',
    backgroundColor: backgroundColor,
    borderRadius: isAvatarGridItem ? '0' : '50%',
    boxShadow: isAvatarGridItem ? 'none' : "inset 0 0 0 ".concat(borderWidth, "px ").concat(borderColor),
    color: color,
    display: 'flex',
    fontSize: fontSize,
    fontWeight: isAvatarGridItem ? 700 : 300,
    height: "".concat(size, "px"),
    justifyContent: 'center',
    minHeight: "".concat(size, "px"),
    minWidth: "".concat(size, "px"),
    overflow: 'hidden',
    width: "".concat(size, "px")
  };
};

var filteredAvatarProps = function filteredAvatarProps(props) {
  return (0, _util.filterProps)(props, ['size', 'forceInitials', 'name', 'url', 'borderColor', 'backgroundColor', 'fetchImage', 'isAvatarGridItem']);
};

var Avatar = function Avatar(props) {
  var url = props.url,
      forceInitials = props.forceInitials,
      name = props.name,
      fetchImage = props.fetchImage,
      isAvatarGridItem = props.isAvatarGridItem;

  var _useState = (0, _react2.useState)(0),
      _useState2 = (0, _slicedToArray2["default"])(_useState, 2),
      scale = _useState2[0],
      setScale = _useState2[1];

  (0, _react2.useEffect)(function () {
    if (url) {
      requestAnimationFrame(function () {
        return setScale(1);
      });
    }
  }, [url]);

  var getInitials = function getInitials() {
    var name = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
    return name.split(' ').filter(Boolean).map(function (_ref2) {
      var _ref3 = (0, _slicedToArray2["default"])(_ref2, 1),
          initial = _ref3[0];

      return initial.toUpperCase();
    }).join('').substring(0, isAvatarGridItem ? 1 : 2);
  };

  return (0, _react.jsx)(_Misc.IsInViewport, (0, _extends2["default"])({
    checkViewportOnce: true,
    onEnterViewport: fetchImage,
    disabled: !!url,
    css: avatarStyle(props),
    "data-uie-name": !forceInitials && url ? 'element-avatar-image' : 'element-avatar-initials'
  }, filteredAvatarProps(props)), forceInitials || !url ? getInitials(name) : (0, _react.jsx)("div", {
    css: /*#__PURE__*/(0, _react.css)({
      backgroundImage: url && "url(".concat(url, ")"),
      backgroundPosition: 'center',
      backgroundSize: 'cover',
      borderRadius: isAvatarGridItem ? '0' : '50%',
      minHeight: '100%',
      minWidth: '100%',
      opacity: scale,
      transform: "scale(".concat(scale, ")"),
      transition: "all ".concat(_motions.DURATION.DEFAULT, "ms ").concat(_motions.EASE.QUART),
      width: '100%'
    }, process.env.NODE_ENV === "production" ? "" : ";label:Avatar;", process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */")
  }));
};

exports.Avatar = Avatar;
//# sourceMappingURL=Avatar.js.map