"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SVGIcon = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = require("@emotion/react");

var _react2 = _interopRequireDefault(require("react"));

var _excluded = ["realWidth", "realHeight", "scale", "width", "height", "shadow", "children"];

var svgIconStyle = function svgIconStyle(theme, _ref) {
  var _ref$color = _ref.color,
      color = _ref$color === void 0 ? theme.general.color : _ref$color;
  return {
    fill: color,
    overflow: 'visible'
  };
};

var SVGIcon = function SVGIcon(_ref2) {
  var realWidth = _ref2.realWidth,
      realHeight = _ref2.realHeight,
      _ref2$scale = _ref2.scale,
      scale = _ref2$scale === void 0 ? 1 : _ref2$scale,
      _ref2$width = _ref2.width,
      width = _ref2$width === void 0 ? null : _ref2$width,
      _ref2$height = _ref2.height,
      height = _ref2$height === void 0 ? null : _ref2$height,
      shadow = _ref2.shadow,
      children = _ref2.children,
      props = (0, _objectWithoutProperties2["default"])(_ref2, _excluded);
  var newScale = scale;

  if (width || height) {
    var widthScale = width ? width / realWidth : Infinity;
    var heightScale = height ? height / realHeight : Infinity;
    newScale = Math.min(widthScale, heightScale);
  }

  var newWidth = Math.ceil(realWidth * newScale);
  var newHeight = Math.ceil(realHeight * newScale);
  var shadowId = shadow && Math.random().toString();
  return (0, _react.jsx)("svg", (0, _extends2["default"])({
    css: function css(theme) {
      return svgIconStyle(theme, props);
    },
    viewBox: "0 0 ".concat(realWidth, " ").concat(realHeight),
    width: newWidth,
    height: newHeight
  }, props), shadow && (0, _react.jsx)("defs", null, (0, _react.jsx)("filter", {
    id: shadowId,
    x: "-50%",
    y: "-50%",
    width: "200%",
    height: "200%"
  }, (0, _react.jsx)("feOffset", {
    result: "offOut",
    "in": "SourceAlpha",
    dx: "0",
    dy: "0"
  }), (0, _react.jsx)("feGaussianBlur", {
    result: "blurOut",
    "in": "offOut",
    stdDeviation: "2.5"
  }), (0, _react.jsx)("feBlend", {
    "in": "SourceGraphic",
    in2: "blurOut",
    mode: "normal"
  }))), (0, _react.jsx)("g", {
    filter: shadow && "url(#".concat(shadowId, ")")
  }, children));
};

exports.SVGIcon = SVGIcon;
//# sourceMappingURL=SVGIcon.js.map