"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterButtonProps = exports.Button = exports.buttonStyle = exports.ButtonVariant = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = require("@emotion/react");

var _Identity = require("../Identity");

var _motions = require("../Identity/motions");

var _Misc = require("../Misc");

var _Text = require("../Text");

var _util = require("../util");

var _excluded = ["variant", "backgroundColor", "block", "disabled", "noCapital", "bold", "center", "color", "fontSize", "noWrap", "textTransform", "truncate"],
    _excluded2 = ["showLoading", "children", "loadingColor"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var ButtonVariant;
exports.ButtonVariant = ButtonVariant;

(function (ButtonVariant) {
  ButtonVariant["PRIMARY"] = "primary";
  ButtonVariant["SECONDARY"] = "secondary";
  ButtonVariant["TERTIARY"] = "tertiary";
  ButtonVariant["QUATERNARY"] = "quaternary";
  ButtonVariant["SEND"] = "send";
})(ButtonVariant || (exports.ButtonVariant = ButtonVariant = {}));

var buttonStyle = function buttonStyle(theme, _ref) {
  var _ref$variant = _ref.variant,
      variant = _ref$variant === void 0 ? ButtonVariant.PRIMARY : _ref$variant,
      backgroundColor = _ref.backgroundColor,
      _ref$block = _ref.block,
      block = _ref$block === void 0 ? false : _ref$block,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled,
      _ref$noCapital = _ref.noCapital,
      noCapital = _ref$noCapital === void 0 ? false : _ref$noCapital,
      _ref$bold = _ref.bold,
      bold = _ref$bold === void 0 ? true : _ref$bold,
      _ref$center = _ref.center,
      center = _ref$center === void 0 ? true : _ref$center,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? _Identity.COLOR.WHITE : _ref$color,
      _ref$fontSize = _ref.fontSize,
      fontSize = _ref$fontSize === void 0 ? '16px' : _ref$fontSize,
      _ref$noWrap = _ref.noWrap,
      noWrap = _ref$noWrap === void 0 ? true : _ref$noWrap,
      _ref$textTransform = _ref.textTransform,
      textTransform = _ref$textTransform === void 0 ? 'none' : _ref$textTransform,
      _ref$truncate = _ref.truncate,
      truncate = _ref$truncate === void 0 ? true : _ref$truncate,
      props = (0, _objectWithoutProperties2["default"])(_ref, _excluded);
  return _objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, (0, _Text.textStyle)(theme, _objectSpread({
    block: block,
    bold: bold,
    center: center,
    disabled: disabled,
    fontSize: fontSize,
    noWrap: noWrap,
    textTransform: textTransform,
    truncate: truncate
  }, props))), {}, {
    border: 0,
    cursor: disabled ? 'default' : 'pointer',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    marginBottom: '16px',
    padding: 0,
    outline: 'none',
    textDecoration: 'none',
    touchAction: 'manipulation',
    transition: _motions.defaultTransition,
    width: block ? '100%' : 'auto',
    '&:hover, &:focus': {
      textDecoration: 'none'
    }
  }, variant !== ButtonVariant.TERTIARY && _objectSpread({
    borderRadius: variant === ButtonVariant.SEND ? '100%' : '16px',
    height: variant === ButtonVariant.SEND ? '40px' : '48px',
    lineHeight: variant === ButtonVariant.SEND ? '40px' : '48px'
  }, variant !== ButtonVariant.SEND && {
    maxWidth: '100%',
    minWidth: '125px',
    padding: '0 16px'
  })), variant === ButtonVariant.PRIMARY && _objectSpread({
    backgroundColor: backgroundColor || (disabled ? _Identity.COLOR_V2.GRAY_50 : _Identity.COLOR_V2.BLUE),
    color: disabled ? _Identity.COLOR_V2.GRAY_80 : _Identity.COLOR_V2.WHITE
  }, !disabled && {
    '&:hover, &:focus': {
      backgroundColor: _Identity.COLOR_V2.BLUE_LIGHT_600
    },
    '&:focus': {
      border: "1px solid ".concat(_Identity.COLOR_V2.BLUE_LIGHT_700)
    },
    '&:active': {
      backgroundColor: _Identity.COLOR_V2.BLUE_LIGHT_700
    }
  })), variant === ButtonVariant.SECONDARY && _objectSpread({
    backgroundColor: backgroundColor || (disabled ? _Identity.COLOR_V2.GRAY_20 : _Identity.COLOR_V2.WHITE),
    border: "1px solid ".concat(_Identity.COLOR_V2.GRAY_40),
    color: disabled ? _Identity.COLOR_V2.GRAY_60 : _Identity.COLOR_V2.BLACK
  }, !disabled && {
    '&:hover, &:focus': {
      border: "1px solid ".concat(_Identity.COLOR_V2.BLUE)
    },
    '&:focus': {
      color: _Identity.COLOR_V2.BLUE
    },
    '&:active': {
      backgroundColor: _Identity.COLOR_V2.BLUE_LIGHT_50,
      border: "1px solid ".concat(_Identity.COLOR_V2.BLUE),
      color: _Identity.COLOR_V2.BLUE
    }
  })), variant === ButtonVariant.TERTIARY && _objectSpread({
    color: disabled ? _Identity.COLOR_V2.GRAY_60 : _Identity.COLOR_V2.BLACK,
    lineHeight: '24px'
  }, !disabled && {
    '&:hover, &:focus': {
      color: _Identity.COLOR_V2.BLUE
    },
    '&:focus': {
      border: "1px solid ".concat(_Identity.COLOR_V2.BLUE_LIGHT_300)
    }
  })), variant === ButtonVariant.QUATERNARY && _objectSpread({
    backgroundColor: backgroundColor || (disabled ? _Identity.COLOR_V2.GRAY_50 : _Identity.COLOR_V2.GREEN),
    color: disabled ? _Identity.COLOR_V2.GRAY_80 : _Identity.COLOR_V2.WHITE,
    lineHeight: '24px'
  }, !disabled && {
    '&:hover, &:focus': {
      backgroundColor: _Identity.COLOR_V2.GREEN_LIGHT_600
    },
    '&:focus': {
      border: "1px solid ".concat(_Identity.COLOR_V2.GREEN_LIGHT_700)
    },
    '&:active': {
      backgroundColor: _Identity.COLOR_V2.GREEN_LIGHT_700
    }
  })), variant === ButtonVariant.SEND && _objectSpread({
    backgroundColor: backgroundColor || (disabled ? _Identity.COLOR_V2.GRAY_70 : _Identity.COLOR_V2.BLUE),
    width: '40px'
  }, !disabled && {
    '&:hover, &:focus': {
      backgroundColor: _Identity.COLOR_V2.BLUE_LIGHT_600
    },
    '&:focus': {
      border: "1px solid ".concat(_Identity.COLOR_V2.BLUE_LIGHT_800)
    },
    '&:active': {
      backgroundColor: _Identity.COLOR_V2.BLUE_LIGHT_700
    }
  }));
};

exports.buttonStyle = buttonStyle;

var Button = function Button(_ref2) {
  var showLoading = _ref2.showLoading,
      children = _ref2.children,
      _ref2$loadingColor = _ref2.loadingColor,
      loadingColor = _ref2$loadingColor === void 0 ? _Identity.COLOR.WHITE : _ref2$loadingColor,
      props = (0, _objectWithoutProperties2["default"])(_ref2, _excluded2);
  return (0, _react.jsx)("button", (0, _extends2["default"])({
    css: function css(theme) {
      return buttonStyle(theme, props);
    }
  }, filterButtonProps(props)), showLoading ? (0, _react.jsx)(_Misc.Loading, {
    size: 30,
    color: loadingColor,
    style: {
      display: 'flex',
      margin: 'auto'
    }
  }) : children);
};

exports.Button = Button;

var filterButtonProps = function filterButtonProps(props) {
  return (0, _util.filterProps)((0, _Text.filterTextProps)(props), ['backgroundColor', 'noCapital']);
};

exports.filterButtonProps = filterButtonProps;
//# sourceMappingURL=Button.js.map