"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AboutWindow = void 0;
const electron_1 = require("electron");
const url_1 = require("url");
const path = __importStar(require("path"));
const eventType_1 = require("../lib/eventType");
const locale = __importStar(require("../locale"));
const EnvironmentUtil = __importStar(require("../runtime/EnvironmentUtil"));
const config_1 = require("../settings/config");
const getLogger_1 = require("../logging/getLogger");
const WindowUtil = __importStar(require("../window/WindowUtil"));
const logger = (0, getLogger_1.getLogger)(path.basename(__filename));
let webappVersion;
const APP_PATH = path.join(electron_1.app.getAppPath(), config_1.config.electronDirectory);
const iconFileName = `logo.${EnvironmentUtil.platform.IS_WINDOWS ? 'ico' : 'png'}`;
const iconPath = path.join(APP_PATH, 'img', iconFileName);
const ABOUT_HTML = (0, url_1.pathToFileURL)(path.join(APP_PATH, 'html/about.html')).href;
const ABOUT_WINDOW_ALLOWLIST = [
    ABOUT_HTML,
    (0, url_1.pathToFileURL)(path.join(APP_PATH, 'img/logo.256.png')).href,
    (0, url_1.pathToFileURL)(path.join(APP_PATH, 'css/about.css')).href,
];
const PRELOAD_JS = path.join(APP_PATH, 'dist/preload/menu/preload-about.js');
const WINDOW_SIZE = {
    HEIGHT: 256,
    WIDTH: 304,
};
electron_1.ipcMain.once(eventType_1.EVENT_TYPE.UI.WEBAPP_VERSION, (_event, version) => {
    webappVersion = version;
});
const showWindow = () => __awaiter(void 0, void 0, void 0, function* () {
    let aboutWindow;
    if (!aboutWindow) {
        aboutWindow = new electron_1.BrowserWindow({
            alwaysOnTop: false,
            backgroundColor: '#ececec',
            fullscreen: false,
            height: WINDOW_SIZE.HEIGHT,
            icon: iconPath,
            maximizable: false,
            minimizable: false,
            resizable: false,
            show: false,
            title: config_1.config.name,
            webPreferences: {
                javascript: false,
                nodeIntegration: false,
                nodeIntegrationInWorker: false,
                preload: PRELOAD_JS,
                session: electron_1.session.fromPartition('about-window'),
                spellcheck: false,
                webviewTag: false,
            },
            width: WINDOW_SIZE.WIDTH,
        });
        aboutWindow.setMenuBarVisibility(false);
        aboutWindow.webContents.session.webRequest.onBeforeRequest(({ url }, callback) => __awaiter(void 0, void 0, void 0, function* () {
            if (ABOUT_WINDOW_ALLOWLIST.includes(url)) {
                return callback({ cancel: false });
            }
        }));
        aboutWindow.webContents.setWindowOpenHandler(details => {
            void WindowUtil.openExternal(details.url, true);
            return { action: 'deny' };
        });
        electron_1.ipcMain.on(eventType_1.EVENT_TYPE.ABOUT.LOCALE_VALUES, (event, labels) => {
            if (aboutWindow) {
                const isExpected = event.sender.id === aboutWindow.webContents.id;
                if (isExpected) {
                    const localeValues = {};
                    labels.forEach(label => (localeValues[label] = locale.getText(label)));
                    localeValues.aboutReleasesUrl = config_1.config.aboutReleasesUrl;
                    localeValues.aboutUpdatesUrl = config_1.config.aboutUpdatesUrl;
                    event.reply(eventType_1.EVENT_TYPE.ABOUT.LOCALE_RENDER, localeValues);
                }
            }
        });
        aboutWindow.webContents.on('before-input-event', (_event, input) => {
            if (input.type === 'keyDown' && input.key === 'Escape') {
                if (aboutWindow) {
                    aboutWindow.close();
                }
            }
        });
        aboutWindow.on('closed', () => (aboutWindow = undefined));
        yield aboutWindow.loadURL(ABOUT_HTML);
        if (aboutWindow) {
            aboutWindow.webContents.send(eventType_1.EVENT_TYPE.ABOUT.LOADED, {
                copyright: config_1.config.copyright,
                electronVersion: config_1.config.version,
                productName: config_1.config.name,
                webappVersion,
            });
        }
    }
    aboutWindow.show();
});
exports.AboutWindow = { showWindow };
//# sourceMappingURL=AboutWindow.js.map