"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SchemaUpdater = void 0;
const Electron = __importStar(require("electron"));
const fs = __importStar(require("fs-extra"));
const path = __importStar(require("path"));
const getLogger_1 = require("../logging/getLogger");
const SettingsType_1 = require("./SettingsType");
const app = Electron.app || require('@electron/remote').app;
const logger = (0, getLogger_1.getLogger)(path.basename(__filename));
const defaultPathV0 = path.join(app.getPath('userData'), 'init.json');
const defaultPathV1 = path.join(app.getPath('userData'), 'config/init.json');
class SchemaUpdater {
    static updateToVersion1(configFileV0 = defaultPathV0, configFileV1 = defaultPathV1) {
        const config = SchemaUpdater.SCHEMATA.VERSION_1;
        if (fs.existsSync(configFileV0)) {
            try {
                fs.moveSync(configFileV0, configFileV1, { overwrite: true });
                Object.assign(config, fs.readJSONSync(configFileV1));
            }
            catch (error) {
                logger.log(`Could not upgrade "${configFileV0}" to "${configFileV1}": ${error.message}`, error);
            }
            const getSetting = (setting) => (config.hasOwnProperty(setting) ? config[setting] : undefined);
            const hasNoConfigVersion = typeof getSetting('configVersion') === 'undefined';
            if (hasNoConfigVersion) {
                [SettingsType_1.SettingsType.FULL_SCREEN, SettingsType_1.SettingsType.WINDOW_BOUNDS].forEach(setting => {
                    if (typeof getSetting(setting) !== 'undefined') {
                        delete config[setting];
                        logger.log(`Deleted "${setting}" property from old init file.`);
                    }
                });
            }
            try {
                fs.writeJsonSync(configFileV1, config, { spaces: 2 });
            }
            catch (error) {
                logger.log(`Failed to write config to "${configFileV1}": ${error.message}`, error);
            }
        }
        return configFileV1;
    }
}
exports.SchemaUpdater = SchemaUpdater;
SchemaUpdater.SCHEMATA = {
    VERSION_1: {
        configVersion: 1,
    },
};
//# sourceMappingURL=SchemaUpdater.js.map