"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.setCertificateVerifyProc = exports.attachTo = void 0;
const certificateUtils = __importStar(require("@wireapp/certificate-check"));
const electron_1 = require("electron");
const fs = __importStar(require("fs-extra"));
const path = __importStar(require("path"));
const locale_1 = require("../locale");
const getLogger_1 = require("../logging/getLogger");
const EnvironmentUtil = __importStar(require("../runtime/EnvironmentUtil"));
const logger = (0, getLogger_1.getLogger)(path.basename(__filename));
var CertificateVerificationResult;
(function (CertificateVerificationResult) {
    CertificateVerificationResult[CertificateVerificationResult["SUCCESS"] = 0] = "SUCCESS";
    CertificateVerificationResult[CertificateVerificationResult["FAILURE"] = -2] = "FAILURE";
    CertificateVerificationResult[CertificateVerificationResult["USE_CHROMIUM_VALIDATION"] = -3] = "USE_CHROMIUM_VALIDATION";
})(CertificateVerificationResult || (CertificateVerificationResult = {}));
var CHROMIUM_ERRORS;
(function (CHROMIUM_ERRORS) {
    CHROMIUM_ERRORS[CHROMIUM_ERRORS["CERT_AUTHORITY_INVALID"] = -202] = "CERT_AUTHORITY_INVALID";
    CHROMIUM_ERRORS[CHROMIUM_ERRORS["CERT_COMMON_NAME_INVALID"] = -200] = "CERT_COMMON_NAME_INVALID";
})(CHROMIUM_ERRORS || (CHROMIUM_ERRORS = {}));
var RESPONSE;
(function (RESPONSE) {
    RESPONSE[RESPONSE["GO_BACK"] = 0] = "GO_BACK";
    RESPONSE[RESPONSE["RETRY"] = 0] = "RETRY";
    RESPONSE[RESPONSE["SAVE_CERTIFICATE"] = 1] = "SAVE_CERTIFICATE";
    RESPONSE[RESPONSE["SHOW_DETAILS"] = 1] = "SHOW_DETAILS";
})(RESPONSE || (RESPONSE = {}));
class CertificateVerifyProcManager {
    static displayCertificateDetails(hostname, certificate, options) {
        return __awaiter(this, void 0, void 0, function* () {
            const goBack = () => __awaiter(this, void 0, void 0, function* () {
                yield this.displayCertificateError(hostname, certificate, Object.assign(Object.assign({}, options), { bypassDialogLock: true }));
            });
            const textDetails = `${options.isChromiumError ? this.LOCALE.SHOW_DETAILS_TEXT_CHROMIUM : this.LOCALE.SHOW_DETAILS_TEXT_PINNING} ${hostname}`;
            const isTrustDialogSupported = EnvironmentUtil.platform.IS_MAC_OS;
            if (isTrustDialogSupported) {
                yield electron_1.dialog.showCertificateTrustDialog(this.mainWindow, {
                    certificate,
                    message: textDetails,
                });
                yield goBack();
            }
            else {
                const { response } = yield electron_1.dialog.showMessageBox(this.mainWindow, {
                    buttons: [this.LOCALE.SHOW_DETAILS_GO_BACK, this.LOCALE.SHOW_DETAILS_SAVE_CERTIFICATE],
                    cancelId: RESPONSE.GO_BACK,
                    detail: textDetails,
                    message: this.LOCALE.SHOW_DETAILS_TITLE,
                    type: 'info',
                });
                switch (response) {
                    case RESPONSE.SAVE_CERTIFICATE: {
                        const { filePath: chosenPath } = yield electron_1.dialog.showSaveDialog(this.mainWindow, {
                            defaultPath: `${hostname}.pem`,
                        });
                        if (chosenPath !== undefined) {
                            yield fs.writeFile(chosenPath, Buffer.from(certificate.data));
                        }
                        yield this.displayCertificateDetails(hostname, certificate, options);
                        break;
                    }
                    case RESPONSE.GO_BACK: {
                        yield goBack();
                        break;
                    }
                }
            }
        });
    }
    static isCertificatePinningEnabled() {
        return !this.bypassCertificatePinning;
    }
    static displayCertificateChromiumError(hostname, certificate) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.displayCertificateError(hostname, certificate, { isChromiumError: true });
        });
    }
    static displayCertificateError(hostname, certificate, options) {
        return __awaiter(this, void 0, void 0, function* () {
            const { bypassDialogLock, isChromiumError, isCheckboxChecked } = Object.assign({ bypassDialogLock: false, isCheckboxChecked: false, isChromiumError: false }, options);
            if (this.isDialogLocked && !bypassDialogLock) {
                return;
            }
            this.isDialogLocked = true;
            const { checkboxChecked, response } = yield electron_1.dialog.showMessageBox(this.mainWindow, {
                buttons: [this.LOCALE.RETRY, this.LOCALE.SHOW_DETAILS],
                cancelId: RESPONSE.RETRY,
                checkboxChecked: isChromiumError ? undefined : isCheckboxChecked,
                checkboxLabel: isChromiumError ? undefined : this.LOCALE.WARNING_BYPASS,
                defaultId: RESPONSE.RETRY,
                detail: isChromiumError ? this.LOCALE.WARNING_TEXT_CHROMIUM : this.LOCALE.WARNING_TEXT_PINNING,
                message: this.LOCALE.WARNING_TITLE,
                type: 'warning',
            });
            switch (response) {
                case RESPONSE.RETRY: {
                    if (!isChromiumError) {
                        this.bypassCertificatePinning = checkboxChecked;
                        if (this.bypassCertificatePinning) {
                            logger.log('User disabled certificate pinning');
                        }
                    }
                    setTimeout(() => (this.isDialogLocked = false), this.dialogUnlockTimeout);
                    break;
                }
                case RESPONSE.SHOW_DETAILS: {
                    yield this.displayCertificateDetails(hostname, certificate, {
                        bypassDialogLock,
                        isCheckboxChecked: checkboxChecked,
                        isChromiumError,
                    });
                    break;
                }
            }
        });
    }
}
CertificateVerifyProcManager.bypassCertificatePinning = false;
CertificateVerifyProcManager.isDialogLocked = false;
CertificateVerifyProcManager.dialogUnlockTimeout = 6000;
CertificateVerifyProcManager.LOCALE = {
    RETRY: (0, locale_1.getText)('certificateVerifyProcManagerRetry'),
    SHOW_DETAILS: (0, locale_1.getText)('certificateVerifyProcManagerShowDetails'),
    SHOW_DETAILS_GO_BACK: (0, locale_1.getText)('certificateVerifyProcManagerShowDetailsGoBack'),
    SHOW_DETAILS_SAVE_CERTIFICATE: (0, locale_1.getText)('certificateVerifyProcManagerShowDetailsSaveCertificate'),
    SHOW_DETAILS_TEXT_CHROMIUM: (0, locale_1.getText)('certificateVerifyProcManagerShowDetailsTextChromium'),
    SHOW_DETAILS_TEXT_PINNING: (0, locale_1.getText)('certificateVerifyProcManagerShowDetailsTextPinning'),
    SHOW_DETAILS_TITLE: (0, locale_1.getText)('certificateVerifyProcManagerShowDetailsTitle'),
    WARNING_BYPASS: (0, locale_1.getText)('certificateVerifyProcManagerWarningBypass'),
    WARNING_TEXT_CHROMIUM: (0, locale_1.getText)('certificateVerifyProcManagerWarningTextChromium'),
    WARNING_TEXT_PINNING: (0, locale_1.getText)('certificateVerifyProcManagerWarningTextPinning'),
    WARNING_TITLE: (0, locale_1.getText)('certificateVerifyProcManagerWarningTitle'),
};
const attachTo = (main) => {
    CertificateVerifyProcManager.mainWindow = main;
};
exports.attachTo = attachTo;
const setCertificateVerifyProc = (request, cb) => __awaiter(void 0, void 0, void 0, function* () {
    const { hostname, validatedCertificate, verificationResult, errorCode } = request;
    if (verificationResult !== 'net::OK') {
        logger.error(`Internal Chrome TLS verification failed. Hostname: ${hostname}. Verification result: ${verificationResult}. Error code: ${errorCode}`);
        const isCommonCertificateError = errorCode === CHROMIUM_ERRORS.CERT_COMMON_NAME_INVALID || errorCode === CHROMIUM_ERRORS.CERT_AUTHORITY_INVALID;
        if (isCommonCertificateError) {
            yield CertificateVerifyProcManager.displayCertificateChromiumError(hostname, validatedCertificate);
        }
        return cb(CertificateVerificationResult.FAILURE);
    }
    if (certificateUtils.hostnameShouldBePinned(hostname) && CertificateVerifyProcManager.isCertificatePinningEnabled()) {
        const pinningResults = certificateUtils.verifyPinning(hostname, validatedCertificate);
        const falsyValue = Object.values(pinningResults).some(val => val === false);
        if (falsyValue || pinningResults.errorMessage) {
            logger.error(`Certificate verification failed for "${hostname}".`);
            logger.error(`Error: "${pinningResults.errorMessage}". Displaying certificate pinning error dialog.`);
            yield CertificateVerifyProcManager.displayCertificateError(hostname, validatedCertificate);
            return cb(CertificateVerificationResult.FAILURE);
        }
    }
    return cb(CertificateVerificationResult.USE_CHROMIUM_VALIDATION);
});
exports.setCertificateVerifyProc = setCertificateVerifyProc;
//# sourceMappingURL=CertificateVerifyProcManager.js.map