/*
 * Copyright 2017 gRPC authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * Automatically generated by tools/codegen/core/gen_stats_data.py
 */

#include <grpc/support/port_platform.h>

#include "src/core/lib/debug/stats_data.h"

#include <stdint.h>

#include "src/core/lib/debug/stats.h"

namespace {
union DblUint {
  double dbl;
  uint64_t uint;
};
}  // namespace
const char* grpc_stats_counter_name[GRPC_STATS_COUNTER_COUNT] = {
    "client_calls_created",
    "server_calls_created",
    "client_channels_created",
    "client_subchannels_created",
    "server_channels_created",
    "syscall_write",
    "syscall_read",
    "tcp_read_alloc_8k",
    "tcp_read_alloc_64k",
    "http2_settings_writes",
    "http2_pings_sent",
    "http2_writes_begun",
    "http2_transport_stalls",
    "http2_stream_stalls",
    "cq_pluck_creates",
    "cq_next_creates",
    "cq_callback_creates",
};
const char* grpc_stats_counter_doc[GRPC_STATS_COUNTER_COUNT] = {
    "Number of client side calls created by this process",
    "Number of server side calls created by this process",
    "Number of client channels created",
    "Number of client subchannels created",
    "Number of server channels created",
    "Number of write syscalls (or equivalent - eg sendmsg) made by this "
    "process",
    "Number of read syscalls (or equivalent - eg recvmsg) made by this process",
    "Number of 8k allocations by the TCP subsystem for reading",
    "Number of 64k allocations by the TCP subsystem for reading",
    "Number of settings frames sent",
    "Number of HTTP2 pings sent by process",
    "Number of HTTP2 writes initiated",
    "Number of times sending was completely stalled by the transport flow "
    "control window",
    "Number of times sending was completely stalled by the stream flow control "
    "window",
    "Number of completion queues created for cq_pluck (indicates sync api "
    "usage)",
    "Number of completion queues created for cq_next (indicates cq async api "
    "usage)",
    "Number of completion queues created for cq_callback (indicates callback "
    "api usage)",
};
const char* grpc_stats_histogram_name[GRPC_STATS_HISTOGRAM_COUNT] = {
    "call_initial_size",       "tcp_write_size", "tcp_write_iov_size",
    "tcp_read_size",           "tcp_read_offer", "tcp_read_offer_iov_size",
    "http2_send_message_size",
};
const char* grpc_stats_histogram_doc[GRPC_STATS_HISTOGRAM_COUNT] = {
    "Initial size of the grpc_call arena created at call start",
    "Number of bytes offered to each syscall_write",
    "Number of byte segments offered to each syscall_write",
    "Number of bytes received by each syscall_read",
    "Number of bytes offered to each syscall_read",
    "Number of byte segments offered to each syscall_read",
    "Size of messages received by HTTP2 transport",
};
const int grpc_stats_table_0[25] = {
    0,   1,   2,   4,    7,    11,   17,   26,   40,   61,    93,    142,  216,
    329, 500, 760, 1155, 1755, 2667, 4052, 6155, 9350, 14203, 21574, 32768};
const uint8_t grpc_stats_table_1[27] = {3,  3,  4,  5,  6,  6,  7,  8,  9,
                                        10, 11, 11, 12, 13, 14, 15, 16, 16,
                                        17, 18, 19, 20, 20, 21, 22, 23, 24};
const int grpc_stats_table_2[21] = {
    0,     1,      3,      8,       19,      45,      106,
    250,   588,    1383,   3252,    7646,    17976,   42262,
    99359, 233593, 549177, 1291113, 3035402, 7136218, 16777216};
const uint8_t grpc_stats_table_3[23] = {2,  3,  3,  4,  5,  6,  7,  8,
                                        8,  9,  10, 11, 12, 12, 13, 14,
                                        15, 16, 16, 17, 18, 19, 20};
const int grpc_stats_table_4[11] = {0, 1, 2, 4, 7, 11, 17, 26, 38, 56, 80};
const uint8_t grpc_stats_table_5[9] = {3, 3, 4, 5, 6, 6, 7, 8, 9};
namespace grpc_core {
int BucketForHistogramValue_32768_24(int value) {
  if (value < 3) {
    if (value < 0) {
      return 0;
    } else {
      return value;
    }
  } else {
    if (value < 24577) {
      // first_nontrivial_code=4613937818241073152
      // last_code=4672484613396889600 [24576.000000]
      DblUint val;
      val.dbl = value;
      const int bucket =
          grpc_stats_table_1[((val.uint - 4613937818241073152ull) >> 51)];
      return bucket - (value < grpc_stats_table_0[bucket]);
    } else {
      return 23;
    }
  }
}
int BucketForHistogramValue_16777216_20(int value) {
  if (value < 2) {
    if (value < 0) {
      return 0;
    } else {
      return value;
    }
  } else {
    if (value < 8388609) {
      // first_nontrivial_code=4611686018427387904
      // last_code=4710765210229538816 [8388608.000000]
      DblUint val;
      val.dbl = value;
      const int bucket =
          grpc_stats_table_3[((val.uint - 4611686018427387904ull) >> 52)];
      return bucket - (value < grpc_stats_table_2[bucket]);
    } else {
      return 19;
    }
  }
}
int BucketForHistogramValue_80_10(int value) {
  if (value < 3) {
    if (value < 0) {
      return 0;
    } else {
      return value;
    }
  } else {
    if (value < 49) {
      // first_nontrivial_code=4613937818241073152
      // last_code=4631952216750555136 [48.000000]
      DblUint val;
      val.dbl = value;
      const int bucket =
          grpc_stats_table_5[((val.uint - 4613937818241073152ull) >> 51)];
      return bucket - (value < grpc_stats_table_4[bucket]);
    } else {
      if (value < 56) {
        return 8;
      } else {
        return 9;
      }
    }
  }
}
}  // namespace grpc_core
const int grpc_stats_histo_buckets[7] = {24, 20, 10, 20, 20, 10, 20};
const int grpc_stats_histo_start[7] = {0, 24, 44, 54, 74, 94, 104};
const int* const grpc_stats_histo_bucket_boundaries[7] = {
    grpc_stats_table_0, grpc_stats_table_2, grpc_stats_table_4,
    grpc_stats_table_2, grpc_stats_table_2, grpc_stats_table_4,
    grpc_stats_table_2};
int (*const grpc_stats_get_bucket[7])(int value) = {
    grpc_core::BucketForHistogramValue_32768_24,
    grpc_core::BucketForHistogramValue_16777216_20,
    grpc_core::BucketForHistogramValue_80_10,
    grpc_core::BucketForHistogramValue_16777216_20,
    grpc_core::BucketForHistogramValue_16777216_20,
    grpc_core::BucketForHistogramValue_80_10,
    grpc_core::BucketForHistogramValue_16777216_20};
