// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-avr.go from AT90PWM216.atdf, see http://packs.download.atmel.com/

//go:build avr && at90pwm216
// +build avr,at90pwm216

// Device information for the AT90PWM216.
package avr

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "AT90PWM216"
	ARCH   = "AVR8"
	FAMILY = "megaAVR"
)

// Interrupts
const (
	IRQ_RESET         = 0  // External Pin, Power-on Reset, Brown-out Reset, Watchdog Reset and JTAG AVR Reset
	IRQ_PSC2_CAPT     = 1  // PSC2 Capture Event
	IRQ_PSC2_EC       = 2  // PSC2 End Cycle
	IRQ_PSC1_CAPT     = 3  // PSC1 Capture Event
	IRQ_PSC1_EC       = 4  // PSC1 End Cycle
	IRQ_PSC0_CAPT     = 5  // PSC0 Capture Event
	IRQ_PSC0_EC       = 6  // PSC0 End Cycle
	IRQ_ANALOG_COMP_0 = 7  // Analog Comparator 0
	IRQ_ANALOG_COMP_1 = 8  // Analog Comparator 1
	IRQ_ANALOG_COMP_2 = 9  // Analog Comparator 2
	IRQ_INT0          = 10 // External Interrupt Request 0
	IRQ_TIMER1_CAPT   = 11 // Timer/Counter1 Capture Event
	IRQ_TIMER1_COMPA  = 12 // Timer/Counter1 Compare Match A
	IRQ_TIMER1_COMPB  = 13 // Timer/Counter Compare Match B
	IRQ_RESERVED15    = 14 //
	IRQ_TIMER1_OVF    = 15 // Timer/Counter1 Overflow
	IRQ_TIMER0_COMP_A = 16 // Timer/Counter0 Compare Match A
	IRQ_TIMER0_OVF    = 17 // Timer/Counter0 Overflow
	IRQ_ADC           = 18 // ADC Conversion Complete
	IRQ_INT1          = 19 // External Interrupt Request 1
	IRQ_SPI_STC       = 20 // SPI Serial Transfer Complete
	IRQ_USART_RX      = 21 // USART, Rx Complete
	IRQ_USART_UDRE    = 22 // USART Data Register Empty
	IRQ_USART_TX      = 23 // USART, Tx Complete
	IRQ_INT2          = 24 // External Interrupt Request 2
	IRQ_WDT           = 25 // Watchdog Timeout Interrupt
	IRQ_EE_READY      = 26 // EEPROM Ready
	IRQ_TIMER0_COMPB  = 27 // Timer Counter 0 Compare Match B
	IRQ_INT3          = 28 // External Interrupt Request 3
	IRQ_RESERVED30    = 29 //
	IRQ_RESERVED31    = 30 //
	IRQ_SPM_READY     = 31 // Store Program Memory Read
	IRQ_max           = 31 // Highest interrupt number on this device.
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export __vector_RESET
//go:interrupt
func interruptRESET() {
	callHandlers(IRQ_RESET)
}

//export __vector_PSC2_CAPT
//go:interrupt
func interruptPSC2_CAPT() {
	callHandlers(IRQ_PSC2_CAPT)
}

//export __vector_PSC2_EC
//go:interrupt
func interruptPSC2_EC() {
	callHandlers(IRQ_PSC2_EC)
}

//export __vector_PSC1_CAPT
//go:interrupt
func interruptPSC1_CAPT() {
	callHandlers(IRQ_PSC1_CAPT)
}

//export __vector_PSC1_EC
//go:interrupt
func interruptPSC1_EC() {
	callHandlers(IRQ_PSC1_EC)
}

//export __vector_PSC0_CAPT
//go:interrupt
func interruptPSC0_CAPT() {
	callHandlers(IRQ_PSC0_CAPT)
}

//export __vector_PSC0_EC
//go:interrupt
func interruptPSC0_EC() {
	callHandlers(IRQ_PSC0_EC)
}

//export __vector_ANALOG_COMP_0
//go:interrupt
func interruptANALOG_COMP_0() {
	callHandlers(IRQ_ANALOG_COMP_0)
}

//export __vector_ANALOG_COMP_1
//go:interrupt
func interruptANALOG_COMP_1() {
	callHandlers(IRQ_ANALOG_COMP_1)
}

//export __vector_ANALOG_COMP_2
//go:interrupt
func interruptANALOG_COMP_2() {
	callHandlers(IRQ_ANALOG_COMP_2)
}

//export __vector_INT0
//go:interrupt
func interruptINT0() {
	callHandlers(IRQ_INT0)
}

//export __vector_TIMER1_CAPT
//go:interrupt
func interruptTIMER1_CAPT() {
	callHandlers(IRQ_TIMER1_CAPT)
}

//export __vector_TIMER1_COMPA
//go:interrupt
func interruptTIMER1_COMPA() {
	callHandlers(IRQ_TIMER1_COMPA)
}

//export __vector_TIMER1_COMPB
//go:interrupt
func interruptTIMER1_COMPB() {
	callHandlers(IRQ_TIMER1_COMPB)
}

//export __vector_RESERVED15
//go:interrupt
func interruptRESERVED15() {
	callHandlers(IRQ_RESERVED15)
}

//export __vector_TIMER1_OVF
//go:interrupt
func interruptTIMER1_OVF() {
	callHandlers(IRQ_TIMER1_OVF)
}

//export __vector_TIMER0_COMP_A
//go:interrupt
func interruptTIMER0_COMP_A() {
	callHandlers(IRQ_TIMER0_COMP_A)
}

//export __vector_TIMER0_OVF
//go:interrupt
func interruptTIMER0_OVF() {
	callHandlers(IRQ_TIMER0_OVF)
}

//export __vector_ADC
//go:interrupt
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export __vector_INT1
//go:interrupt
func interruptINT1() {
	callHandlers(IRQ_INT1)
}

//export __vector_SPI_STC
//go:interrupt
func interruptSPI_STC() {
	callHandlers(IRQ_SPI_STC)
}

//export __vector_USART_RX
//go:interrupt
func interruptUSART_RX() {
	callHandlers(IRQ_USART_RX)
}

//export __vector_USART_UDRE
//go:interrupt
func interruptUSART_UDRE() {
	callHandlers(IRQ_USART_UDRE)
}

//export __vector_USART_TX
//go:interrupt
func interruptUSART_TX() {
	callHandlers(IRQ_USART_TX)
}

//export __vector_INT2
//go:interrupt
func interruptINT2() {
	callHandlers(IRQ_INT2)
}

//export __vector_WDT
//go:interrupt
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export __vector_EE_READY
//go:interrupt
func interruptEE_READY() {
	callHandlers(IRQ_EE_READY)
}

//export __vector_TIMER0_COMPB
//go:interrupt
func interruptTIMER0_COMPB() {
	callHandlers(IRQ_TIMER0_COMPB)
}

//export __vector_INT3
//go:interrupt
func interruptINT3() {
	callHandlers(IRQ_INT3)
}

//export __vector_RESERVED30
//go:interrupt
func interruptRESERVED30() {
	callHandlers(IRQ_RESERVED30)
}

//export __vector_RESERVED31
//go:interrupt
func interruptRESERVED31() {
	callHandlers(IRQ_RESERVED31)
}

//export __vector_SPM_READY
//go:interrupt
func interruptSPM_READY() {
	callHandlers(IRQ_SPM_READY)
}

// Peripherals.
var (
	// Fuses
	EXTENDED = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2)))
	HIGH     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x1)))
	LOW      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Lockbits
	LOCKBIT = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// I/O Port
	PORTB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x25)))
	DDRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x24)))
	PINB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x23)))
	PORTD = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2b)))
	DDRD  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2a)))
	PIND  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x29)))
	PORTE = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2e)))
	DDRE  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2d)))
	PINE  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2c)))

	// Bootloader
	SPMCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x57)))

	// Extended USART
	EUDR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xce)))
	EUCSRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc8)))
	EUCSRB = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc9)))
	EUCSRC = (*volatile.Register8)(unsafe.Pointer(uintptr(0xca)))
	MUBRRH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcd)))
	MUBRRL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcc)))

	// Analog Comparator
	AC0CON = (*volatile.Register8)(unsafe.Pointer(uintptr(0xad)))
	AC1CON = (*volatile.Register8)(unsafe.Pointer(uintptr(0xae)))
	AC2CON = (*volatile.Register8)(unsafe.Pointer(uintptr(0xaf)))
	ACSR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x50)))

	// Digital-to-Analog Converter
	DACL  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xab)))
	DACH  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xac)))
	DACON = (*volatile.Register8)(unsafe.Pointer(uintptr(0xaa)))

	// CPU Registers
	SREG   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5f)))
	SPL    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5d)))
	SPH    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5e)))
	MCUCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x55)))
	MCUSR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x54)))
	OSCCAL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x66)))
	CLKPR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x61)))
	SMCR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x53)))
	GPIOR3 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3b)))
	GPIOR2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3a)))
	GPIOR1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x39)))
	GPIOR0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3e)))
	PLLCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x49)))
	PRR    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x64)))

	// Timer/Counter, 8-bit
	TIMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6e)))
	TIFR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x35)))
	TCCR0A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x44)))
	TCCR0B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x45)))
	TCNT0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x46)))
	OCR0A  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x47)))
	OCR0B  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x48)))
	GTCCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x43)))

	// Timer/Counter, 16-bit
	TIMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6f)))
	TIFR1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x36)))
	TCCR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x80)))
	TCCR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x81)))
	TCCR1C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x82)))
	TCNT1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x84)))
	TCNT1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x85)))
	OCR1AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x88)))
	OCR1AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x89)))
	OCR1BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8a)))
	OCR1BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8b)))
	ICR1L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x86)))
	ICR1H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x87)))

	// Analog-to-Digital Converter
	ADMUX   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7c)))
	ADCSRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7a)))
	ADCL    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x78)))
	ADCH    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x79)))
	ADCSRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7b)))
	DIDR0   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7e)))
	DIDR1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7f)))
	AMP0CSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x76)))
	AMP1CSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x77)))

	// USART
	UDR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc6)))
	UCSRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc0)))
	UCSRB = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc1)))
	UCSRC = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc2)))
	UBRRH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc5)))
	UBRRL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc4)))

	// Serial Peripheral Interface
	SPCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4c)))
	SPSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4d)))
	SPDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4e)))

	// Watchdog Timer
	WDTCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x60)))

	// External Interrupts
	EICRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x69)))
	EIMSK = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3d)))
	EIFR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3c)))

	// EEPROM
	EEARL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x41)))
	EEARH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x42)))
	EEDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x40)))
	EECR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3f)))

	// Power Stage Controller
	PICR0L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xde)))
	PICR0H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xdf)))
	PFRC0B  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xdd)))
	PFRC0A  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xdc)))
	PCTL0   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xdb)))
	PCNF0   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xda)))
	OCR0RBL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd8)))
	OCR0RBH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd9)))
	OCR0SBL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd6)))
	OCR0SBH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd7)))
	OCR0RAL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd4)))
	OCR0RAH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd5)))
	OCR0SAL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd2)))
	OCR0SAH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd3)))
	PSOC0   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd0)))
	PIM0    = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa1)))
	PIFR0   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa0)))
	PICR2L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xfe)))
	PICR2H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xff)))
	PFRC2B  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xfd)))
	PFRC2A  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xfc)))
	PCTL2   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xfb)))
	PCNF2   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xfa)))
	OCR2RBL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf8)))
	OCR2RBH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf9)))
	OCR2SBL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf6)))
	OCR2SBH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf7)))
	OCR2RAL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf4)))
	OCR2RAH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf5)))
	OCR2SAL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf2)))
	OCR2SAH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf3)))
	POM2    = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf1)))
	PSOC2   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf0)))
	PIM2    = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa5)))
	PIFR2   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa4)))
)

// Bitfields for FUSE: Fuses
const (
	// EXTENDED
	EXTENDED_PSC2RB      = 0x80 // PSC2 Reset Behavior
	EXTENDED_PSC2RB_Msk  = 0x80 // PSC2 Reset Behavior
	EXTENDED_PSC1RB      = 0x40 // PSC1 Reset Behavior
	EXTENDED_PSC1RB_Msk  = 0x40 // PSC1 Reset Behavior
	EXTENDED_PSC0RB      = 0x20 // PSC0 Reset Behavior
	EXTENDED_PSC0RB_Msk  = 0x20 // PSC0 Reset Behavior
	EXTENDED_PSCRV       = 0x10 // PSCOUT Reset Value
	EXTENDED_PSCRV_Msk   = 0x10 // PSCOUT Reset Value
	EXTENDED_BOOTSZ0     = 0x2  // Select Boot Size
	EXTENDED_BOOTSZ1     = 0x4  // Select Boot Size
	EXTENDED_BOOTSZ_Msk  = 0x6  // Select Boot Size
	EXTENDED_BOOTRST     = 0x1  // Select Reset Vector
	EXTENDED_BOOTRST_Msk = 0x1  // Select Reset Vector

	// HIGH
	HIGH_RSTDISBL     = 0x80 // Reset Disabled (Enable PC6 as i/o pin)
	HIGH_RSTDISBL_Msk = 0x80 // Reset Disabled (Enable PC6 as i/o pin)
	HIGH_DWEN         = 0x40 // Debug Wire enable
	HIGH_DWEN_Msk     = 0x40 // Debug Wire enable
	HIGH_SPIEN        = 0x20 // Serial program downloading (SPI) enabled
	HIGH_SPIEN_Msk    = 0x20 // Serial program downloading (SPI) enabled
	HIGH_WDTON        = 0x10 // Watch-dog Timer always on
	HIGH_WDTON_Msk    = 0x10 // Watch-dog Timer always on
	HIGH_EESAVE       = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_EESAVE_Msk   = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_BODLEVEL0    = 0x1  // Brown-out Detector Trigger Level
	HIGH_BODLEVEL1    = 0x2  // Brown-out Detector Trigger Level
	HIGH_BODLEVEL2    = 0x4  // Brown-out Detector Trigger Level
	HIGH_BODLEVEL_Msk = 0x7  // Brown-out Detector Trigger Level

	// LOW
	LOW_CKDIV8        = 0x80 // Divide clock by 8 internally
	LOW_CKDIV8_Msk    = 0x80 // Divide clock by 8 internally
	LOW_CKOUT         = 0x40 // Clock output on PORTB0
	LOW_CKOUT_Msk     = 0x40 // Clock output on PORTB0
	LOW_SUT_CKSEL0    = 0x1  // Select Clock Source
	LOW_SUT_CKSEL1    = 0x2  // Select Clock Source
	LOW_SUT_CKSEL2    = 0x4  // Select Clock Source
	LOW_SUT_CKSEL3    = 0x8  // Select Clock Source
	LOW_SUT_CKSEL4    = 0x10 // Select Clock Source
	LOW_SUT_CKSEL5    = 0x20 // Select Clock Source
	LOW_SUT_CKSEL_Msk = 0x3f // Select Clock Source
)

// Bitfields for LOCKBIT: Lockbits
const (
	// LOCKBIT
	LOCKBIT_LB0      = 0x1  // Memory Lock
	LOCKBIT_LB1      = 0x2  // Memory Lock
	LOCKBIT_LB_Msk   = 0x3  // Memory Lock
	LOCKBIT_BLB00    = 0x4  // Boot Loader Protection Mode
	LOCKBIT_BLB01    = 0x8  // Boot Loader Protection Mode
	LOCKBIT_BLB0_Msk = 0xc  // Boot Loader Protection Mode
	LOCKBIT_BLB10    = 0x10 // Boot Loader Protection Mode
	LOCKBIT_BLB11    = 0x20 // Boot Loader Protection Mode
	LOCKBIT_BLB1_Msk = 0x30 // Boot Loader Protection Mode
)

// Bitfields for BOOT_LOAD: Bootloader
const (
	// SPMCSR: Store Program Memory Control Register
	SPMCSR_SPMIE      = 0x80 // SPM Interrupt Enable
	SPMCSR_SPMIE_Msk  = 0x80 // SPM Interrupt Enable
	SPMCSR_RWWSB      = 0x40 // Read While Write Section Busy
	SPMCSR_RWWSB_Msk  = 0x40 // Read While Write Section Busy
	SPMCSR_RWWSRE     = 0x10 // Read While Write section read enable
	SPMCSR_RWWSRE_Msk = 0x10 // Read While Write section read enable
	SPMCSR_BLBSET     = 0x8  // Boot Lock Bit Set
	SPMCSR_BLBSET_Msk = 0x8  // Boot Lock Bit Set
	SPMCSR_PGWRT      = 0x4  // Page Write
	SPMCSR_PGWRT_Msk  = 0x4  // Page Write
	SPMCSR_PGERS      = 0x2  // Page Erase
	SPMCSR_PGERS_Msk  = 0x2  // Page Erase
	SPMCSR_SPMEN      = 0x1  // Store Program Memory Enable
	SPMCSR_SPMEN_Msk  = 0x1  // Store Program Memory Enable
)

// Bitfields for EUSART: Extended USART
const (
	// EUCSRA: EUSART Control and Status Register A
	EUCSRA_UTxS0    = 0x10 // EUSART Control and Status Register A Bits
	EUCSRA_UTxS1    = 0x20 // EUSART Control and Status Register A Bits
	EUCSRA_UTxS2    = 0x40 // EUSART Control and Status Register A Bits
	EUCSRA_UTxS3    = 0x80 // EUSART Control and Status Register A Bits
	EUCSRA_UTxS_Msk = 0xf0 // EUSART Control and Status Register A Bits
	EUCSRA_URxS0    = 0x1  // EUSART Control and Status Register A Bits
	EUCSRA_URxS1    = 0x2  // EUSART Control and Status Register A Bits
	EUCSRA_URxS2    = 0x4  // EUSART Control and Status Register A Bits
	EUCSRA_URxS3    = 0x8  // EUSART Control and Status Register A Bits
	EUCSRA_URxS_Msk = 0xf  // EUSART Control and Status Register A Bits

	// EUCSRB: EUSART Control Register B
	EUCSRB_EUSART     = 0x10 // EUSART Enable Bit
	EUCSRB_EUSART_Msk = 0x10 // EUSART Enable Bit
	EUCSRB_EUSBS      = 0x8  // EUSBS Enable Bit
	EUCSRB_EUSBS_Msk  = 0x8  // EUSBS Enable Bit
	EUCSRB_EMCH       = 0x2  // Manchester Mode Bit
	EUCSRB_EMCH_Msk   = 0x2  // Manchester Mode Bit
	EUCSRB_BODR       = 0x1  // Order Bit
	EUCSRB_BODR_Msk   = 0x1  // Order Bit

	// EUCSRC: EUSART Status Register C
	EUCSRC_FEM       = 0x8 // Frame Error Manchester Bit
	EUCSRC_FEM_Msk   = 0x8 // Frame Error Manchester Bit
	EUCSRC_F1617     = 0x4 // F1617 Bit
	EUCSRC_F1617_Msk = 0x4 // F1617 Bit
	EUCSRC_STP0      = 0x1 // Stop Bits
	EUCSRC_STP1      = 0x2 // Stop Bits
	EUCSRC_STP_Msk   = 0x3 // Stop Bits

	// MUBRRH: Manchester Receiver Baud Rate Register High Byte
	MUBRRH_MUBRR0    = 0x1  // Manchester Receiver Baud Rate Register Bits
	MUBRRH_MUBRR1    = 0x2  // Manchester Receiver Baud Rate Register Bits
	MUBRRH_MUBRR2    = 0x4  // Manchester Receiver Baud Rate Register Bits
	MUBRRH_MUBRR3    = 0x8  // Manchester Receiver Baud Rate Register Bits
	MUBRRH_MUBRR4    = 0x10 // Manchester Receiver Baud Rate Register Bits
	MUBRRH_MUBRR5    = 0x20 // Manchester Receiver Baud Rate Register Bits
	MUBRRH_MUBRR6    = 0x40 // Manchester Receiver Baud Rate Register Bits
	MUBRRH_MUBRR7    = 0x80 // Manchester Receiver Baud Rate Register Bits
	MUBRRH_MUBRR_Msk = 0xff // Manchester Receiver Baud Rate Register Bits

	// MUBRRL: Manchester Receiver Baud Rate Register Low Byte
	MUBRRL_MUBRR0    = 0x1  // Manchester Receiver Baud Rate Register Bits
	MUBRRL_MUBRR1    = 0x2  // Manchester Receiver Baud Rate Register Bits
	MUBRRL_MUBRR2    = 0x4  // Manchester Receiver Baud Rate Register Bits
	MUBRRL_MUBRR3    = 0x8  // Manchester Receiver Baud Rate Register Bits
	MUBRRL_MUBRR4    = 0x10 // Manchester Receiver Baud Rate Register Bits
	MUBRRL_MUBRR5    = 0x20 // Manchester Receiver Baud Rate Register Bits
	MUBRRL_MUBRR6    = 0x40 // Manchester Receiver Baud Rate Register Bits
	MUBRRL_MUBRR7    = 0x80 // Manchester Receiver Baud Rate Register Bits
	MUBRRL_MUBRR_Msk = 0xff // Manchester Receiver Baud Rate Register Bits
)

// Bitfields for AC: Analog Comparator
const (
	// AC0CON: Analog Comparator 0 Control Register
	AC0CON_AC0EN     = 0x80 // Analog Comparator 0 Enable Bit
	AC0CON_AC0EN_Msk = 0x80 // Analog Comparator 0 Enable Bit
	AC0CON_AC0IE     = 0x40 // Analog Comparator 0 Interrupt Enable Bit
	AC0CON_AC0IE_Msk = 0x40 // Analog Comparator 0 Interrupt Enable Bit
	AC0CON_AC0IS0    = 0x10 // Analog Comparator 0  Interrupt Select Bit
	AC0CON_AC0IS1    = 0x20 // Analog Comparator 0  Interrupt Select Bit
	AC0CON_AC0IS_Msk = 0x30 // Analog Comparator 0  Interrupt Select Bit
	AC0CON_AC0M0     = 0x1  // Analog Comparator 0 Multiplexer Register
	AC0CON_AC0M1     = 0x2  // Analog Comparator 0 Multiplexer Register
	AC0CON_AC0M2     = 0x4  // Analog Comparator 0 Multiplexer Register
	AC0CON_AC0M_Msk  = 0x7  // Analog Comparator 0 Multiplexer Register

	// AC1CON: Analog Comparator 1 Control Register
	AC1CON_AC1EN      = 0x80 // Analog Comparator 1 Enable Bit
	AC1CON_AC1EN_Msk  = 0x80 // Analog Comparator 1 Enable Bit
	AC1CON_AC1IE      = 0x40 // Analog Comparator 1 Interrupt Enable Bit
	AC1CON_AC1IE_Msk  = 0x40 // Analog Comparator 1 Interrupt Enable Bit
	AC1CON_AC1IS0     = 0x10 // Analog Comparator 1  Interrupt Select Bit
	AC1CON_AC1IS1     = 0x20 // Analog Comparator 1  Interrupt Select Bit
	AC1CON_AC1IS_Msk  = 0x30 // Analog Comparator 1  Interrupt Select Bit
	AC1CON_AC1ICE     = 0x8  // Analog Comparator 1 Interrupt Capture Enable Bit
	AC1CON_AC1ICE_Msk = 0x8  // Analog Comparator 1 Interrupt Capture Enable Bit
	AC1CON_AC1M0      = 0x1  // Analog Comparator 1 Multiplexer Register
	AC1CON_AC1M1      = 0x2  // Analog Comparator 1 Multiplexer Register
	AC1CON_AC1M2      = 0x4  // Analog Comparator 1 Multiplexer Register
	AC1CON_AC1M_Msk   = 0x7  // Analog Comparator 1 Multiplexer Register

	// AC2CON: Analog Comparator 2 Control Register
	AC2CON_AC2EN     = 0x80 // Analog Comparator 2 Enable Bit
	AC2CON_AC2EN_Msk = 0x80 // Analog Comparator 2 Enable Bit
	AC2CON_AC2IE     = 0x40 // Analog Comparator 2 Interrupt Enable Bit
	AC2CON_AC2IE_Msk = 0x40 // Analog Comparator 2 Interrupt Enable Bit
	AC2CON_AC2IS0    = 0x10 // Analog Comparator 2  Interrupt Select Bit
	AC2CON_AC2IS1    = 0x20 // Analog Comparator 2  Interrupt Select Bit
	AC2CON_AC2IS_Msk = 0x30 // Analog Comparator 2  Interrupt Select Bit
	AC2CON_AC2M0     = 0x1  // Analog Comparator 2 Multiplexer Register
	AC2CON_AC2M1     = 0x2  // Analog Comparator 2 Multiplexer Register
	AC2CON_AC2M2     = 0x4  // Analog Comparator 2 Multiplexer Register
	AC2CON_AC2M_Msk  = 0x7  // Analog Comparator 2 Multiplexer Register

	// ACSR: Analog Comparator Status Register
	ACSR_ACCKDIV     = 0x80 // Analog Comparator Clock Divider
	ACSR_ACCKDIV_Msk = 0x80 // Analog Comparator Clock Divider
	ACSR_AC2IF       = 0x40 // Analog Comparator 2 Interrupt Flag Bit
	ACSR_AC2IF_Msk   = 0x40 // Analog Comparator 2 Interrupt Flag Bit
	ACSR_AC1IF       = 0x20 // Analog Comparator 1  Interrupt Flag Bit
	ACSR_AC1IF_Msk   = 0x20 // Analog Comparator 1  Interrupt Flag Bit
	ACSR_AC0IF       = 0x10 // Analog Comparator 0 Interrupt Flag Bit
	ACSR_AC0IF_Msk   = 0x10 // Analog Comparator 0 Interrupt Flag Bit
	ACSR_AC2O        = 0x4  // Analog Comparator 2 Output Bit
	ACSR_AC2O_Msk    = 0x4  // Analog Comparator 2 Output Bit
	ACSR_AC1O        = 0x2  // Analog Comparator 1 Output Bit
	ACSR_AC1O_Msk    = 0x2  // Analog Comparator 1 Output Bit
	ACSR_AC0O        = 0x1  // Analog Comparator 0 Output Bit
	ACSR_AC0O_Msk    = 0x1  // Analog Comparator 0 Output Bit
)

// Bitfields for DAC: Digital-to-Analog Converter
const (
	// DACL: DAC Data Register Bytes

	// DACH: DAC Data Register Bytes
	DAC_DAC0    = 0x1    // DAC Data Register Bits
	DAC_DAC1    = 0x2    // DAC Data Register Bits
	DAC_DAC2    = 0x4    // DAC Data Register Bits
	DAC_DAC3    = 0x8    // DAC Data Register Bits
	DAC_DAC4    = 0x10   // DAC Data Register Bits
	DAC_DAC5    = 0x20   // DAC Data Register Bits
	DAC_DAC6    = 0x40   // DAC Data Register Bits
	DAC_DAC7    = 0x80   // DAC Data Register Bits
	DAC_DAC_Msk = 0xffff // DAC Data Register Bits

	// DACON: DAC Control Register
	DACON_DAATE     = 0x80 // DAC Auto Trigger Enable Bit
	DACON_DAATE_Msk = 0x80 // DAC Auto Trigger Enable Bit
	DACON_DATS0     = 0x10 // DAC Trigger Selection Bits
	DACON_DATS1     = 0x20 // DAC Trigger Selection Bits
	DACON_DATS2     = 0x40 // DAC Trigger Selection Bits
	DACON_DATS_Msk  = 0x70 // DAC Trigger Selection Bits
	DACON_DALA      = 0x4  // DAC Left Adjust
	DACON_DALA_Msk  = 0x4  // DAC Left Adjust
	DACON_DAOE      = 0x2  // DAC Output Enable
	DACON_DAOE_Msk  = 0x2  // DAC Output Enable
	DACON_DAEN      = 0x1  // DAC Enable Bit
	DACON_DAEN_Msk  = 0x1  // DAC Enable Bit
)

// Bitfields for CPU: CPU Registers
const (
	// SREG: Status Register
	SREG_I     = 0x80 // Global Interrupt Enable
	SREG_I_Msk = 0x80 // Global Interrupt Enable
	SREG_T     = 0x40 // Bit Copy Storage
	SREG_T_Msk = 0x40 // Bit Copy Storage
	SREG_H     = 0x20 // Half Carry Flag
	SREG_H_Msk = 0x20 // Half Carry Flag
	SREG_S     = 0x10 // Sign Bit
	SREG_S_Msk = 0x10 // Sign Bit
	SREG_V     = 0x8  // Two's Complement Overflow Flag
	SREG_V_Msk = 0x8  // Two's Complement Overflow Flag
	SREG_N     = 0x4  // Negative Flag
	SREG_N_Msk = 0x4  // Negative Flag
	SREG_Z     = 0x2  // Zero Flag
	SREG_Z_Msk = 0x2  // Zero Flag
	SREG_C     = 0x1  // Carry Flag
	SREG_C_Msk = 0x1  // Carry Flag

	// MCUCR: MCU Control Register
	MCUCR_SPIPS     = 0x80 // SPI Pin Select
	MCUCR_SPIPS_Msk = 0x80 // SPI Pin Select
	MCUCR_PUD       = 0x10 // Pull-up disable
	MCUCR_PUD_Msk   = 0x10 // Pull-up disable
	MCUCR_IVSEL     = 0x2  // Interrupt Vector Select
	MCUCR_IVSEL_Msk = 0x2  // Interrupt Vector Select
	MCUCR_IVCE      = 0x1  // Interrupt Vector Change Enable
	MCUCR_IVCE_Msk  = 0x1  // Interrupt Vector Change Enable

	// MCUSR: MCU Status Register
	MCUSR_WDRF      = 0x8 // Watchdog Reset Flag
	MCUSR_WDRF_Msk  = 0x8 // Watchdog Reset Flag
	MCUSR_BORF      = 0x4 // Brown-out Reset Flag
	MCUSR_BORF_Msk  = 0x4 // Brown-out Reset Flag
	MCUSR_EXTRF     = 0x2 // External Reset Flag
	MCUSR_EXTRF_Msk = 0x2 // External Reset Flag
	MCUSR_PORF      = 0x1 // Power-on reset flag
	MCUSR_PORF_Msk  = 0x1 // Power-on reset flag

	// OSCCAL: Oscillator Calibration Value
	OSCCAL_OSCCAL0    = 0x1  // Oscillator Calibration
	OSCCAL_OSCCAL1    = 0x2  // Oscillator Calibration
	OSCCAL_OSCCAL2    = 0x4  // Oscillator Calibration
	OSCCAL_OSCCAL3    = 0x8  // Oscillator Calibration
	OSCCAL_OSCCAL4    = 0x10 // Oscillator Calibration
	OSCCAL_OSCCAL5    = 0x20 // Oscillator Calibration
	OSCCAL_OSCCAL6    = 0x40 // Oscillator Calibration
	OSCCAL_OSCCAL7    = 0x80 // Oscillator Calibration
	OSCCAL_OSCCAL_Msk = 0xff // Oscillator Calibration

	// CLKPR
	CLKPR_CLKPCE     = 0x80
	CLKPR_CLKPCE_Msk = 0x80
	CLKPR_CLKPS0     = 0x1
	CLKPR_CLKPS1     = 0x2
	CLKPR_CLKPS2     = 0x4
	CLKPR_CLKPS3     = 0x8
	CLKPR_CLKPS_Msk  = 0xf

	// SMCR: Sleep Mode Control Register
	SMCR_SM0    = 0x2 // Sleep Mode Select bits
	SMCR_SM1    = 0x4 // Sleep Mode Select bits
	SMCR_SM2    = 0x8 // Sleep Mode Select bits
	SMCR_SM_Msk = 0xe // Sleep Mode Select bits
	SMCR_SE     = 0x1 // Sleep Enable
	SMCR_SE_Msk = 0x1 // Sleep Enable

	// GPIOR3: General Purpose IO Register 3
	GPIOR3_GPIOR0    = 0x1  // General Purpose IO Register 3 bis
	GPIOR3_GPIOR1    = 0x2  // General Purpose IO Register 3 bis
	GPIOR3_GPIOR2    = 0x4  // General Purpose IO Register 3 bis
	GPIOR3_GPIOR3    = 0x8  // General Purpose IO Register 3 bis
	GPIOR3_GPIOR4    = 0x10 // General Purpose IO Register 3 bis
	GPIOR3_GPIOR5    = 0x20 // General Purpose IO Register 3 bis
	GPIOR3_GPIOR6    = 0x40 // General Purpose IO Register 3 bis
	GPIOR3_GPIOR7    = 0x80 // General Purpose IO Register 3 bis
	GPIOR3_GPIOR_Msk = 0xff // General Purpose IO Register 3 bis

	// GPIOR2: General Purpose IO Register 2
	GPIOR2_GPIOR0    = 0x1  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR1    = 0x2  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR2    = 0x4  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR3    = 0x8  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR4    = 0x10 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR5    = 0x20 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR6    = 0x40 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR7    = 0x80 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR_Msk = 0xff // General Purpose IO Register 2 bis

	// GPIOR1: General Purpose IO Register 1
	GPIOR1_GPIOR0    = 0x1  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR1    = 0x2  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR2    = 0x4  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR3    = 0x8  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR4    = 0x10 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR5    = 0x20 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR6    = 0x40 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR7    = 0x80 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR_Msk = 0xff // General Purpose IO Register 1 bis

	// GPIOR0: General Purpose IO Register 0
	GPIOR0_GPIOR07     = 0x80 // General Purpose IO Register 0 bit 7
	GPIOR0_GPIOR07_Msk = 0x80 // General Purpose IO Register 0 bit 7
	GPIOR0_GPIOR06     = 0x40 // General Purpose IO Register 0 bit 6
	GPIOR0_GPIOR06_Msk = 0x40 // General Purpose IO Register 0 bit 6
	GPIOR0_GPIOR05     = 0x20 // General Purpose IO Register 0 bit 5
	GPIOR0_GPIOR05_Msk = 0x20 // General Purpose IO Register 0 bit 5
	GPIOR0_GPIOR04     = 0x10 // General Purpose IO Register 0 bit 4
	GPIOR0_GPIOR04_Msk = 0x10 // General Purpose IO Register 0 bit 4
	GPIOR0_GPIOR03     = 0x8  // General Purpose IO Register 0 bit 3
	GPIOR0_GPIOR03_Msk = 0x8  // General Purpose IO Register 0 bit 3
	GPIOR0_GPIOR02     = 0x4  // General Purpose IO Register 0 bit 2
	GPIOR0_GPIOR02_Msk = 0x4  // General Purpose IO Register 0 bit 2
	GPIOR0_GPIOR01     = 0x2  // General Purpose IO Register 0 bit 1
	GPIOR0_GPIOR01_Msk = 0x2  // General Purpose IO Register 0 bit 1
	GPIOR0_GPIOR00     = 0x1  // General Purpose IO Register 0 bit 0
	GPIOR0_GPIOR00_Msk = 0x1  // General Purpose IO Register 0 bit 0

	// PLLCSR: PLL Control And Status Register
	PLLCSR_PLLF      = 0x4 // PLL Factor
	PLLCSR_PLLF_Msk  = 0x4 // PLL Factor
	PLLCSR_PLLE      = 0x2 // PLL Enable
	PLLCSR_PLLE_Msk  = 0x2 // PLL Enable
	PLLCSR_PLOCK     = 0x1 // PLL Lock Detector
	PLLCSR_PLOCK_Msk = 0x1 // PLL Lock Detector

	// PRR: Power Reduction Register
	PRR_PRPSC2       = 0x80 // Power Reduction PSC2
	PRR_PRPSC2_Msk   = 0x80 // Power Reduction PSC2
	PRR_PRPSC1       = 0x40 // Power Reduction PSC1
	PRR_PRPSC1_Msk   = 0x40 // Power Reduction PSC1
	PRR_PRPSC0       = 0x20 // Power Reduction PSC0
	PRR_PRPSC0_Msk   = 0x20 // Power Reduction PSC0
	PRR_PRTIM1       = 0x10 // Power Reduction Timer/Counter1
	PRR_PRTIM1_Msk   = 0x10 // Power Reduction Timer/Counter1
	PRR_PRTIM0       = 0x8  // Power Reduction Timer/Counter0
	PRR_PRTIM0_Msk   = 0x8  // Power Reduction Timer/Counter0
	PRR_PRSPI        = 0x4  // Power Reduction Serial Peripheral Interface
	PRR_PRSPI_Msk    = 0x4  // Power Reduction Serial Peripheral Interface
	PRR_PRUSART0     = 0x2  // Power Reduction USART
	PRR_PRUSART0_Msk = 0x2  // Power Reduction USART
	PRR_PRADC        = 0x1  // Power Reduction ADC
	PRR_PRADC_Msk    = 0x1  // Power Reduction ADC
)

// Bitfields for TC8: Timer/Counter, 8-bit
const (
	// TIMSK0: Timer/Counter0 Interrupt Mask Register
	TIMSK0_OCIE0B     = 0x4 // Timer/Counter0 Output Compare Match B Interrupt Enable
	TIMSK0_OCIE0B_Msk = 0x4 // Timer/Counter0 Output Compare Match B Interrupt Enable
	TIMSK0_OCIE0A     = 0x2 // Timer/Counter0 Output Compare Match A Interrupt Enable
	TIMSK0_OCIE0A_Msk = 0x2 // Timer/Counter0 Output Compare Match A Interrupt Enable
	TIMSK0_TOIE0      = 0x1 // Timer/Counter0 Overflow Interrupt Enable
	TIMSK0_TOIE0_Msk  = 0x1 // Timer/Counter0 Overflow Interrupt Enable

	// TIFR0: Timer/Counter0 Interrupt Flag register
	TIFR0_OCF0B     = 0x4 // Timer/Counter0 Output Compare Flag 0B
	TIFR0_OCF0B_Msk = 0x4 // Timer/Counter0 Output Compare Flag 0B
	TIFR0_OCF0A     = 0x2 // Timer/Counter0 Output Compare Flag 0A
	TIFR0_OCF0A_Msk = 0x2 // Timer/Counter0 Output Compare Flag 0A
	TIFR0_TOV0      = 0x1 // Timer/Counter0 Overflow Flag
	TIFR0_TOV0_Msk  = 0x1 // Timer/Counter0 Overflow Flag

	// TCCR0A: Timer/Counter Control Register A
	TCCR0A_COM0A0    = 0x40 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0A1    = 0x80 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0A_Msk = 0xc0 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0B0    = 0x10 // Compare Output Mode, Fast PWm
	TCCR0A_COM0B1    = 0x20 // Compare Output Mode, Fast PWm
	TCCR0A_COM0B_Msk = 0x30 // Compare Output Mode, Fast PWm
	TCCR0A_WGM00     = 0x1  // Waveform Generation Mode
	TCCR0A_WGM01     = 0x2  // Waveform Generation Mode
	TCCR0A_WGM0_Msk  = 0x3  // Waveform Generation Mode

	// TCCR0B: Timer/Counter Control Register B
	TCCR0B_FOC0A     = 0x80 // Force Output Compare A
	TCCR0B_FOC0A_Msk = 0x80 // Force Output Compare A
	TCCR0B_FOC0B     = 0x40 // Force Output Compare B
	TCCR0B_FOC0B_Msk = 0x40 // Force Output Compare B
	TCCR0B_WGM02     = 0x8
	TCCR0B_WGM02_Msk = 0x8
	TCCR0B_CS00      = 0x1 // Clock Select
	TCCR0B_CS01      = 0x2 // Clock Select
	TCCR0B_CS02      = 0x4 // Clock Select
	TCCR0B_CS0_Msk   = 0x7 // Clock Select

	// TCNT0: Timer/Counter0
	TCNT0_TCNT00    = 0x1  // Timer Counter 0 value
	TCNT0_TCNT01    = 0x2  // Timer Counter 0 value
	TCNT0_TCNT02    = 0x4  // Timer Counter 0 value
	TCNT0_TCNT03    = 0x8  // Timer Counter 0 value
	TCNT0_TCNT04    = 0x10 // Timer Counter 0 value
	TCNT0_TCNT05    = 0x20 // Timer Counter 0 value
	TCNT0_TCNT06    = 0x40 // Timer Counter 0 value
	TCNT0_TCNT07    = 0x80 // Timer Counter 0 value
	TCNT0_TCNT0_Msk = 0xff // Timer Counter 0 value

	// OCR0A: Timer/Counter0 Output Compare Register
	OCR0A_OCR0A0    = 0x1  // Output Compare A value
	OCR0A_OCR0A1    = 0x2  // Output Compare A value
	OCR0A_OCR0A2    = 0x4  // Output Compare A value
	OCR0A_OCR0A3    = 0x8  // Output Compare A value
	OCR0A_OCR0A4    = 0x10 // Output Compare A value
	OCR0A_OCR0A5    = 0x20 // Output Compare A value
	OCR0A_OCR0A6    = 0x40 // Output Compare A value
	OCR0A_OCR0A7    = 0x80 // Output Compare A value
	OCR0A_OCR0A_Msk = 0xff // Output Compare A value

	// OCR0B: Timer/Counter0 Output Compare Register
	OCR0B_OCR0B0    = 0x1  // Output Compare B value
	OCR0B_OCR0B1    = 0x2  // Output Compare B value
	OCR0B_OCR0B2    = 0x4  // Output Compare B value
	OCR0B_OCR0B3    = 0x8  // Output Compare B value
	OCR0B_OCR0B4    = 0x10 // Output Compare B value
	OCR0B_OCR0B5    = 0x20 // Output Compare B value
	OCR0B_OCR0B6    = 0x40 // Output Compare B value
	OCR0B_OCR0B7    = 0x80 // Output Compare B value
	OCR0B_OCR0B_Msk = 0xff // Output Compare B value

	// GTCCR: General Timer/Counter Control Register
	GTCCR_TSM         = 0x80 // Timer/Counter Synchronization Mode
	GTCCR_TSM_Msk     = 0x80 // Timer/Counter Synchronization Mode
	GTCCR_ICPSEL1     = 0x40 // Timer1 Input Capture Selection Bit
	GTCCR_ICPSEL1_Msk = 0x40 // Timer1 Input Capture Selection Bit
	GTCCR_PSRSYNC     = 0x1  // Prescaler Reset Timer/Counter1 and Timer/Counter0
	GTCCR_PSRSYNC_Msk = 0x1  // Prescaler Reset Timer/Counter1 and Timer/Counter0
)

// Bitfields for TC16: Timer/Counter, 16-bit
const (
	// TIMSK1: Timer/Counter Interrupt Mask Register
	TIMSK1_ICIE1      = 0x20 // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK1_ICIE1_Msk  = 0x20 // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK1_OCIE1B     = 0x4  // Timer/Counter1 Output CompareB Match Interrupt Enable
	TIMSK1_OCIE1B_Msk = 0x4  // Timer/Counter1 Output CompareB Match Interrupt Enable
	TIMSK1_OCIE1A     = 0x2  // Timer/Counter1 Output CompareA Match Interrupt Enable
	TIMSK1_OCIE1A_Msk = 0x2  // Timer/Counter1 Output CompareA Match Interrupt Enable
	TIMSK1_TOIE1      = 0x1  // Timer/Counter1 Overflow Interrupt Enable
	TIMSK1_TOIE1_Msk  = 0x1  // Timer/Counter1 Overflow Interrupt Enable

	// TIFR1: Timer/Counter Interrupt Flag register
	TIFR1_ICF1      = 0x20 // Input Capture Flag 1
	TIFR1_ICF1_Msk  = 0x20 // Input Capture Flag 1
	TIFR1_OCF1B     = 0x4  // Output Compare Flag 1B
	TIFR1_OCF1B_Msk = 0x4  // Output Compare Flag 1B
	TIFR1_OCF1A     = 0x2  // Output Compare Flag 1A
	TIFR1_OCF1A_Msk = 0x2  // Output Compare Flag 1A
	TIFR1_TOV1      = 0x1  // Timer/Counter1 Overflow Flag
	TIFR1_TOV1_Msk  = 0x1  // Timer/Counter1 Overflow Flag

	// TCCR1A: Timer/Counter1 Control Register A
	TCCR1A_COM1A0    = 0x40 // Compare Output Mode 1A, bits
	TCCR1A_COM1A1    = 0x80 // Compare Output Mode 1A, bits
	TCCR1A_COM1A_Msk = 0xc0 // Compare Output Mode 1A, bits
	TCCR1A_COM1B0    = 0x10 // Compare Output Mode 1B, bits
	TCCR1A_COM1B1    = 0x20 // Compare Output Mode 1B, bits
	TCCR1A_COM1B_Msk = 0x30 // Compare Output Mode 1B, bits
	TCCR1A_WGM10     = 0x1  // Waveform Generation Mode
	TCCR1A_WGM11     = 0x2  // Waveform Generation Mode
	TCCR1A_WGM1_Msk  = 0x3  // Waveform Generation Mode

	// TCCR1B: Timer/Counter1 Control Register B
	TCCR1B_ICNC1     = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICNC1_Msk = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICES1     = 0x40 // Input Capture 1 Edge Select
	TCCR1B_ICES1_Msk = 0x40 // Input Capture 1 Edge Select
	TCCR1B_WGM10     = 0x8  // Waveform Generation Mode
	TCCR1B_WGM11     = 0x10 // Waveform Generation Mode
	TCCR1B_WGM1_Msk  = 0x18 // Waveform Generation Mode
	TCCR1B_CS10      = 0x1  // Prescaler source of Timer/Counter 1
	TCCR1B_CS11      = 0x2  // Prescaler source of Timer/Counter 1
	TCCR1B_CS12      = 0x4  // Prescaler source of Timer/Counter 1
	TCCR1B_CS1_Msk   = 0x7  // Prescaler source of Timer/Counter 1

	// TCCR1C: Timer/Counter1 Control Register C
	TCCR1C_FOC1A     = 0x80
	TCCR1C_FOC1A_Msk = 0x80
	TCCR1C_FOC1B     = 0x40
	TCCR1C_FOC1B_Msk = 0x40

	// TCNT1L: Timer/Counter1 Bytes

	// TCNT1H: Timer/Counter1 Bytes
	TCNT1_TCNT10    = 0x1    // Timer/Counter1
	TCNT1_TCNT11    = 0x2    // Timer/Counter1
	TCNT1_TCNT12    = 0x4    // Timer/Counter1
	TCNT1_TCNT13    = 0x8    // Timer/Counter1
	TCNT1_TCNT14    = 0x10   // Timer/Counter1
	TCNT1_TCNT15    = 0x20   // Timer/Counter1
	TCNT1_TCNT16    = 0x40   // Timer/Counter1
	TCNT1_TCNT17    = 0x80   // Timer/Counter1
	TCNT1_TCNT1_Msk = 0xffff // Timer/Counter1

	// OCR1AL: Timer/Counter1 Output Compare Register Bytes

	// OCR1AH: Timer/Counter1 Output Compare Register Bytes
	OCR1A_OCR1A0    = 0x1    // Timer/Counter1 Output Compare A Register
	OCR1A_OCR1A1    = 0x2    // Timer/Counter1 Output Compare A Register
	OCR1A_OCR1A2    = 0x4    // Timer/Counter1 Output Compare A Register
	OCR1A_OCR1A3    = 0x8    // Timer/Counter1 Output Compare A Register
	OCR1A_OCR1A4    = 0x10   // Timer/Counter1 Output Compare A Register
	OCR1A_OCR1A5    = 0x20   // Timer/Counter1 Output Compare A Register
	OCR1A_OCR1A6    = 0x40   // Timer/Counter1 Output Compare A Register
	OCR1A_OCR1A7    = 0x80   // Timer/Counter1 Output Compare A Register
	OCR1A_OCR1A_Msk = 0xffff // Timer/Counter1 Output Compare A Register

	// OCR1BL: Timer/Counter1 Output Compare Register Bytes

	// OCR1BH: Timer/Counter1 Output Compare Register Bytes
	OCR1B_OCR1B0    = 0x1    // Timer/Counter1 Output Compare B Register
	OCR1B_OCR1B1    = 0x2    // Timer/Counter1 Output Compare B Register
	OCR1B_OCR1B2    = 0x4    // Timer/Counter1 Output Compare B Register
	OCR1B_OCR1B3    = 0x8    // Timer/Counter1 Output Compare B Register
	OCR1B_OCR1B4    = 0x10   // Timer/Counter1 Output Compare B Register
	OCR1B_OCR1B5    = 0x20   // Timer/Counter1 Output Compare B Register
	OCR1B_OCR1B6    = 0x40   // Timer/Counter1 Output Compare B Register
	OCR1B_OCR1B7    = 0x80   // Timer/Counter1 Output Compare B Register
	OCR1B_OCR1B_Msk = 0xffff // Timer/Counter1 Output Compare B Register

	// ICR1L: Timer/Counter1 Input Capture Register Bytes

	// ICR1H: Timer/Counter1 Input Capture Register Bytes
	ICR1_ICR10    = 0x1    // Timer/Counter Input Capture
	ICR1_ICR11    = 0x2    // Timer/Counter Input Capture
	ICR1_ICR12    = 0x4    // Timer/Counter Input Capture
	ICR1_ICR13    = 0x8    // Timer/Counter Input Capture
	ICR1_ICR14    = 0x10   // Timer/Counter Input Capture
	ICR1_ICR15    = 0x20   // Timer/Counter Input Capture
	ICR1_ICR16    = 0x40   // Timer/Counter Input Capture
	ICR1_ICR17    = 0x80   // Timer/Counter Input Capture
	ICR1_ICR1_Msk = 0xffff // Timer/Counter Input Capture
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// ADMUX: The ADC multiplexer Selection Register
	ADMUX_REFS0     = 0x40 // Reference Selection Bits
	ADMUX_REFS1     = 0x80 // Reference Selection Bits
	ADMUX_REFS_Msk  = 0xc0 // Reference Selection Bits
	ADMUX_ADLAR     = 0x20 // Left Adjust Result
	ADMUX_ADLAR_Msk = 0x20 // Left Adjust Result
	ADMUX_MUX0      = 0x1  // Analog Channel and Gain Selection Bits
	ADMUX_MUX1      = 0x2  // Analog Channel and Gain Selection Bits
	ADMUX_MUX2      = 0x4  // Analog Channel and Gain Selection Bits
	ADMUX_MUX3      = 0x8  // Analog Channel and Gain Selection Bits
	ADMUX_MUX_Msk   = 0xf  // Analog Channel and Gain Selection Bits

	// ADCSRA: The ADC Control and Status register
	ADCSRA_ADEN      = 0x80 // ADC Enable
	ADCSRA_ADEN_Msk  = 0x80 // ADC Enable
	ADCSRA_ADSC      = 0x40 // ADC Start Conversion
	ADCSRA_ADSC_Msk  = 0x40 // ADC Start Conversion
	ADCSRA_ADATE     = 0x20 // ADC Auto Trigger Enable
	ADCSRA_ADATE_Msk = 0x20 // ADC Auto Trigger Enable
	ADCSRA_ADIF      = 0x10 // ADC Interrupt Flag
	ADCSRA_ADIF_Msk  = 0x10 // ADC Interrupt Flag
	ADCSRA_ADIE      = 0x8  // ADC Interrupt Enable
	ADCSRA_ADIE_Msk  = 0x8  // ADC Interrupt Enable
	ADCSRA_ADPS0     = 0x1  // ADC Prescaler Select Bits
	ADCSRA_ADPS1     = 0x2  // ADC Prescaler Select Bits
	ADCSRA_ADPS2     = 0x4  // ADC Prescaler Select Bits
	ADCSRA_ADPS_Msk  = 0x7  // ADC Prescaler Select Bits

	// ADCSRB: ADC Control and Status Register B
	ADCSRB_ADHSM     = 0x80 // ADC High Speed Mode
	ADCSRB_ADHSM_Msk = 0x80 // ADC High Speed Mode
	ADCSRB_ADTS3     = 0x8  // ADC Auto Trigger Source Selection 3
	ADCSRB_ADTS3_Msk = 0x8  // ADC Auto Trigger Source Selection 3
	ADCSRB_ADTS2     = 0x4  // ADC Auto Trigger Source Selection 2
	ADCSRB_ADTS2_Msk = 0x4  // ADC Auto Trigger Source Selection 2
	ADCSRB_ADTS1     = 0x2  // ADC Auto Trigger Source Selection 1
	ADCSRB_ADTS1_Msk = 0x2  // ADC Auto Trigger Source Selection 1
	ADCSRB_ADTS0     = 0x1  // ADC Auto Trigger Source Selection 0
	ADCSRB_ADTS0_Msk = 0x1  // ADC Auto Trigger Source Selection 0

	// DIDR0: Digital Input Disable Register 0
	DIDR0_ADC7D     = 0x80
	DIDR0_ADC7D_Msk = 0x80
	DIDR0_ADC6D     = 0x40
	DIDR0_ADC6D_Msk = 0x40
	DIDR0_ADC5D     = 0x20
	DIDR0_ADC5D_Msk = 0x20
	DIDR0_ADC4D     = 0x10
	DIDR0_ADC4D_Msk = 0x10
	DIDR0_ADC3D     = 0x8
	DIDR0_ADC3D_Msk = 0x8
	DIDR0_ADC2D     = 0x4
	DIDR0_ADC2D_Msk = 0x4
	DIDR0_ADC1D     = 0x2
	DIDR0_ADC1D_Msk = 0x2
	DIDR0_ADC0D     = 0x1
	DIDR0_ADC0D_Msk = 0x1

	// DIDR1: Digital Input Disable Register 1
	DIDR1_ACMP0D     = 0x20
	DIDR1_ACMP0D_Msk = 0x20
	DIDR1_AMP0PD     = 0x10
	DIDR1_AMP0PD_Msk = 0x10
	DIDR1_AMP0ND     = 0x8
	DIDR1_AMP0ND_Msk = 0x8
	DIDR1_ADC10D     = 0x4
	DIDR1_ADC10D_Msk = 0x4
	DIDR1_ADC9D      = 0x2
	DIDR1_ADC9D_Msk  = 0x2
	DIDR1_ADC8D      = 0x1
	DIDR1_ADC8D_Msk  = 0x1

	// AMP0CSR
	AMP0CSR_AMP0EN     = 0x80
	AMP0CSR_AMP0EN_Msk = 0x80
	AMP0CSR_AMP0IS     = 0x40
	AMP0CSR_AMP0IS_Msk = 0x40
	AMP0CSR_AMP0G0     = 0x10
	AMP0CSR_AMP0G1     = 0x20
	AMP0CSR_AMP0G_Msk  = 0x30
	AMP0CSR_AMP0TS0    = 0x1
	AMP0CSR_AMP0TS1    = 0x2
	AMP0CSR_AMP0TS_Msk = 0x3

	// AMP1CSR
	AMP1CSR_AMP1EN     = 0x80
	AMP1CSR_AMP1EN_Msk = 0x80
	AMP1CSR_AMP1IS     = 0x40
	AMP1CSR_AMP1IS_Msk = 0x40
	AMP1CSR_AMP1G0     = 0x10
	AMP1CSR_AMP1G1     = 0x20
	AMP1CSR_AMP1G_Msk  = 0x30
	AMP1CSR_AMP1TS0    = 0x1
	AMP1CSR_AMP1TS1    = 0x2
	AMP1CSR_AMP1TS_Msk = 0x3
)

// Bitfields for USART: USART
const (
	// UCSRA: USART Control and Status register A
	UCSRA_RXC      = 0x80 // USART Receive Complete
	UCSRA_RXC_Msk  = 0x80 // USART Receive Complete
	UCSRA_TXC      = 0x40 // USART Transmitt Complete
	UCSRA_TXC_Msk  = 0x40 // USART Transmitt Complete
	UCSRA_UDRE     = 0x20 // USART Data Register Empty
	UCSRA_UDRE_Msk = 0x20 // USART Data Register Empty
	UCSRA_FE       = 0x10 // Framing Error
	UCSRA_FE_Msk   = 0x10 // Framing Error
	UCSRA_DOR      = 0x8  // Data Overrun
	UCSRA_DOR_Msk  = 0x8  // Data Overrun
	UCSRA_UPE      = 0x4  // USART Parity Error
	UCSRA_UPE_Msk  = 0x4  // USART Parity Error
	UCSRA_U2X      = 0x2  // Double USART Transmission Bit
	UCSRA_U2X_Msk  = 0x2  // Double USART Transmission Bit
	UCSRA_MPCM     = 0x1  // Multi-processor Communication Mode
	UCSRA_MPCM_Msk = 0x1  // Multi-processor Communication Mode

	// UCSRB: USART Control an Status register B
	UCSRB_RXCIE     = 0x80 // RX Complete Interrupt Enable
	UCSRB_RXCIE_Msk = 0x80 // RX Complete Interrupt Enable
	UCSRB_TXCIE     = 0x40 // TX Complete Interrupt Enable
	UCSRB_TXCIE_Msk = 0x40 // TX Complete Interrupt Enable
	UCSRB_UDRIE     = 0x20 // USART Data Register Empty Interrupt Enable
	UCSRB_UDRIE_Msk = 0x20 // USART Data Register Empty Interrupt Enable
	UCSRB_RXEN      = 0x10 // Receiver Enable
	UCSRB_RXEN_Msk  = 0x10 // Receiver Enable
	UCSRB_TXEN      = 0x8  // Transmitter Enable
	UCSRB_TXEN_Msk  = 0x8  // Transmitter Enable
	UCSRB_UCSZ2     = 0x4  // Character Size
	UCSRB_UCSZ2_Msk = 0x4  // Character Size
	UCSRB_RXB8      = 0x2  // Receive Data Bit 8
	UCSRB_RXB8_Msk  = 0x2  // Receive Data Bit 8
	UCSRB_TXB8      = 0x1  // Transmit Data Bit 8
	UCSRB_TXB8_Msk  = 0x1  // Transmit Data Bit 8

	// UCSRC: USART Control an Status register C
	UCSRC_UMSEL0     = 0x40 // USART Mode Select
	UCSRC_UMSEL0_Msk = 0x40 // USART Mode Select
	UCSRC_UPM0       = 0x10 // Parity Mode Bits
	UCSRC_UPM1       = 0x20 // Parity Mode Bits
	UCSRC_UPM_Msk    = 0x30 // Parity Mode Bits
	UCSRC_USBS       = 0x8  // Stop Bit Select
	UCSRC_USBS_Msk   = 0x8  // Stop Bit Select
	UCSRC_UCSZ0      = 0x2  // Character Size Bits
	UCSRC_UCSZ1      = 0x4  // Character Size Bits
	UCSRC_UCSZ_Msk   = 0x6  // Character Size Bits
	UCSRC_UCPOL      = 0x1  // Clock Polarity
	UCSRC_UCPOL_Msk  = 0x1  // Clock Polarity

	// UBRRH: USART Baud Rate Register High Byte
	UBRRH_UBRR0    = 0x1 // USART Baud Rate Register Bits
	UBRRH_UBRR1    = 0x2 // USART Baud Rate Register Bits
	UBRRH_UBRR2    = 0x4 // USART Baud Rate Register Bits
	UBRRH_UBRR3    = 0x8 // USART Baud Rate Register Bits
	UBRRH_UBRR_Msk = 0xf // USART Baud Rate Register Bits

	// UBRRL: USART Baud Rate Register Low Byte
	UBRRL_UBRR0    = 0x1  // USART Baud Rate Register bits
	UBRRL_UBRR1    = 0x2  // USART Baud Rate Register bits
	UBRRL_UBRR2    = 0x4  // USART Baud Rate Register bits
	UBRRL_UBRR3    = 0x8  // USART Baud Rate Register bits
	UBRRL_UBRR4    = 0x10 // USART Baud Rate Register bits
	UBRRL_UBRR5    = 0x20 // USART Baud Rate Register bits
	UBRRL_UBRR6    = 0x40 // USART Baud Rate Register bits
	UBRRL_UBRR7    = 0x80 // USART Baud Rate Register bits
	UBRRL_UBRR_Msk = 0xff // USART Baud Rate Register bits
)

// Bitfields for SPI: Serial Peripheral Interface
const (
	// SPCR: SPI Control Register
	SPCR_SPIE     = 0x80 // SPI Interrupt Enable
	SPCR_SPIE_Msk = 0x80 // SPI Interrupt Enable
	SPCR_SPE      = 0x40 // SPI Enable
	SPCR_SPE_Msk  = 0x40 // SPI Enable
	SPCR_DORD     = 0x20 // Data Order
	SPCR_DORD_Msk = 0x20 // Data Order
	SPCR_MSTR     = 0x10 // Master/Slave Select
	SPCR_MSTR_Msk = 0x10 // Master/Slave Select
	SPCR_CPOL     = 0x8  // Clock polarity
	SPCR_CPOL_Msk = 0x8  // Clock polarity
	SPCR_CPHA     = 0x4  // Clock Phase
	SPCR_CPHA_Msk = 0x4  // Clock Phase
	SPCR_SPR0     = 0x1  // SPI Clock Rate Selects
	SPCR_SPR1     = 0x2  // SPI Clock Rate Selects
	SPCR_SPR_Msk  = 0x3  // SPI Clock Rate Selects

	// SPSR: SPI Status Register
	SPSR_SPIF      = 0x80 // SPI Interrupt Flag
	SPSR_SPIF_Msk  = 0x80 // SPI Interrupt Flag
	SPSR_WCOL      = 0x40 // Write Collision Flag
	SPSR_WCOL_Msk  = 0x40 // Write Collision Flag
	SPSR_SPI2X     = 0x1  // Double SPI Speed Bit
	SPSR_SPI2X_Msk = 0x1  // Double SPI Speed Bit

	// SPDR: SPI Data Register
	SPDR_SPD0    = 0x1  // SPI Data
	SPDR_SPD1    = 0x2  // SPI Data
	SPDR_SPD2    = 0x4  // SPI Data
	SPDR_SPD3    = 0x8  // SPI Data
	SPDR_SPD4    = 0x10 // SPI Data
	SPDR_SPD5    = 0x20 // SPI Data
	SPDR_SPD6    = 0x40 // SPI Data
	SPDR_SPD7    = 0x80 // SPI Data
	SPDR_SPD_Msk = 0xff // SPI Data
)

// Bitfields for WDT: Watchdog Timer
const (
	// WDTCSR: Watchdog Timer Control Register
	WDTCSR_WDIF     = 0x80 // Watchdog Timeout Interrupt Flag
	WDTCSR_WDIF_Msk = 0x80 // Watchdog Timeout Interrupt Flag
	WDTCSR_WDIE     = 0x40 // Watchdog Timeout Interrupt Enable
	WDTCSR_WDIE_Msk = 0x40 // Watchdog Timeout Interrupt Enable
	WDTCSR_WDP0     = 0x1  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP1     = 0x2  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP2     = 0x4  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP3     = 0x20 // Watchdog Timer Prescaler Bits
	WDTCSR_WDP_Msk  = 0x27 // Watchdog Timer Prescaler Bits
	WDTCSR_WDCE     = 0x10 // Watchdog Change Enable
	WDTCSR_WDCE_Msk = 0x10 // Watchdog Change Enable
	WDTCSR_WDE      = 0x8  // Watch Dog Enable
	WDTCSR_WDE_Msk  = 0x8  // Watch Dog Enable
)

// Bitfields for EXINT: External Interrupts
const (
	// EICRA: External Interrupt Control Register A
	EICRA_ISC30    = 0x40 // External Interrupt Sense Control Bit
	EICRA_ISC31    = 0x80 // External Interrupt Sense Control Bit
	EICRA_ISC3_Msk = 0xc0 // External Interrupt Sense Control Bit
	EICRA_ISC20    = 0x10 // External Interrupt Sense Control Bit
	EICRA_ISC21    = 0x20 // External Interrupt Sense Control Bit
	EICRA_ISC2_Msk = 0x30 // External Interrupt Sense Control Bit
	EICRA_ISC10    = 0x4  // External Interrupt Sense Control Bit
	EICRA_ISC11    = 0x8  // External Interrupt Sense Control Bit
	EICRA_ISC1_Msk = 0xc  // External Interrupt Sense Control Bit
	EICRA_ISC00    = 0x1  // External Interrupt Sense Control Bit
	EICRA_ISC01    = 0x2  // External Interrupt Sense Control Bit
	EICRA_ISC0_Msk = 0x3  // External Interrupt Sense Control Bit

	// EIMSK: External Interrupt Mask Register
	EIMSK_INT0    = 0x1 // External Interrupt Mask
	EIMSK_INT1    = 0x2 // External Interrupt Mask
	EIMSK_INT2    = 0x4 // External Interrupt Mask
	EIMSK_INT3    = 0x8 // External Interrupt Mask
	EIMSK_INT_Msk = 0xf // External Interrupt Mask

	// EIFR: External Interrupt Flag Register
	EIFR_INTF0    = 0x1 // External Interrupt Flags
	EIFR_INTF1    = 0x2 // External Interrupt Flags
	EIFR_INTF2    = 0x4 // External Interrupt Flags
	EIFR_INTF3    = 0x8 // External Interrupt Flags
	EIFR_INTF_Msk = 0xf // External Interrupt Flags
)

// Bitfields for EEPROM: EEPROM
const (
	// EEARL: EEPROM Read/Write Access Bytes

	// EEARH: EEPROM Read/Write Access Bytes
	EEAR_EEAR0    = 0x1   // EEPROM Address bytes
	EEAR_EEAR1    = 0x2   // EEPROM Address bytes
	EEAR_EEAR2    = 0x4   // EEPROM Address bytes
	EEAR_EEAR3    = 0x8   // EEPROM Address bytes
	EEAR_EEAR4    = 0x10  // EEPROM Address bytes
	EEAR_EEAR5    = 0x20  // EEPROM Address bytes
	EEAR_EEAR6    = 0x40  // EEPROM Address bytes
	EEAR_EEAR7    = 0x80  // EEPROM Address bytes
	EEAR_EEAR_Msk = 0xfff // EEPROM Address bytes

	// EEDR: EEPROM Data Register
	EEDR_EEDR0    = 0x1  // EEPROM Data Bits
	EEDR_EEDR1    = 0x2  // EEPROM Data Bits
	EEDR_EEDR2    = 0x4  // EEPROM Data Bits
	EEDR_EEDR3    = 0x8  // EEPROM Data Bits
	EEDR_EEDR4    = 0x10 // EEPROM Data Bits
	EEDR_EEDR5    = 0x20 // EEPROM Data Bits
	EEDR_EEDR6    = 0x40 // EEPROM Data Bits
	EEDR_EEDR7    = 0x80 // EEPROM Data Bits
	EEDR_EEDR_Msk = 0xff // EEPROM Data Bits

	// EECR: EEPROM Control Register
	EECR_EEPM0     = 0x10 // EEPROM Programming Mode
	EECR_EEPM1     = 0x20 // EEPROM Programming Mode
	EECR_EEPM_Msk  = 0x30 // EEPROM Programming Mode
	EECR_EERIE     = 0x8  // EEPROM Ready Interrupt Enable
	EECR_EERIE_Msk = 0x8  // EEPROM Ready Interrupt Enable
	EECR_EEMWE     = 0x4  // EEPROM Master Write Enable
	EECR_EEMWE_Msk = 0x4  // EEPROM Master Write Enable
	EECR_EEWE      = 0x2  // EEPROM Write Enable
	EECR_EEWE_Msk  = 0x2  // EEPROM Write Enable
	EECR_EERE      = 0x1  // EEPROM Read Enable
	EECR_EERE_Msk  = 0x1  // EEPROM Read Enable
)

// Bitfields for PSC: Power Stage Controller
const (
	// PICR0L: PSC 0 Input Capture Register

	// PICR0H: PSC 0 Input Capture Register
	PICR0_PCST0     = 0x8000 // PSC 0 Input Capture Software Trig
	PICR0_PCST0_Msk = 0x8000 // PSC 0 Input Capture Software Trig
	PICR0_PICR00    = 0x1    // PSC 0 Input Capture Bytes
	PICR0_PICR01    = 0x2    // PSC 0 Input Capture Bytes
	PICR0_PICR02    = 0x4    // PSC 0 Input Capture Bytes
	PICR0_PICR03    = 0x8    // PSC 0 Input Capture Bytes
	PICR0_PICR04    = 0x10   // PSC 0 Input Capture Bytes
	PICR0_PICR05    = 0x20   // PSC 0 Input Capture Bytes
	PICR0_PICR06    = 0x40   // PSC 0 Input Capture Bytes
	PICR0_PICR07    = 0x80   // PSC 0 Input Capture Bytes
	PICR0_PICR0_Msk = 0xfff  // PSC 0 Input Capture Bytes

	// PFRC0B: PSC 0 Input B Control
	PFRC0B_PCAE0B      = 0x80 // PSC 0 Capture Enable Input Part B
	PFRC0B_PCAE0B_Msk  = 0x80 // PSC 0 Capture Enable Input Part B
	PFRC0B_PISEL0B     = 0x40 // PSC 0 Input Select for Part B
	PFRC0B_PISEL0B_Msk = 0x40 // PSC 0 Input Select for Part B
	PFRC0B_PELEV0B     = 0x20 // PSC 0 Edge Level Selector on Input Part B
	PFRC0B_PELEV0B_Msk = 0x20 // PSC 0 Edge Level Selector on Input Part B
	PFRC0B_PFLTE0B     = 0x10 // PSC 0 Filter Enable on Input Part B
	PFRC0B_PFLTE0B_Msk = 0x10 // PSC 0 Filter Enable on Input Part B
	PFRC0B_PRFM0B0     = 0x1  // PSC 0 Retrigger and Fault Mode for Part B
	PFRC0B_PRFM0B1     = 0x2  // PSC 0 Retrigger and Fault Mode for Part B
	PFRC0B_PRFM0B2     = 0x4  // PSC 0 Retrigger and Fault Mode for Part B
	PFRC0B_PRFM0B3     = 0x8  // PSC 0 Retrigger and Fault Mode for Part B
	PFRC0B_PRFM0B_Msk  = 0xf  // PSC 0 Retrigger and Fault Mode for Part B

	// PFRC0A: PSC 0 Input A Control
	PFRC0A_PCAE0A      = 0x80 // PSC 0 Capture Enable Input Part A
	PFRC0A_PCAE0A_Msk  = 0x80 // PSC 0 Capture Enable Input Part A
	PFRC0A_PISEL0A     = 0x40 // PSC 0 Input Select for Part A
	PFRC0A_PISEL0A_Msk = 0x40 // PSC 0 Input Select for Part A
	PFRC0A_PELEV0A     = 0x20 // PSC 0 Edge Level Selector on Input Part A
	PFRC0A_PELEV0A_Msk = 0x20 // PSC 0 Edge Level Selector on Input Part A
	PFRC0A_PFLTE0A     = 0x10 // PSC 0 Filter Enable on Input Part A
	PFRC0A_PFLTE0A_Msk = 0x10 // PSC 0 Filter Enable on Input Part A
	PFRC0A_PRFM0A0     = 0x1  // PSC 0 Retrigger and Fault Mode for Part A
	PFRC0A_PRFM0A1     = 0x2  // PSC 0 Retrigger and Fault Mode for Part A
	PFRC0A_PRFM0A2     = 0x4  // PSC 0 Retrigger and Fault Mode for Part A
	PFRC0A_PRFM0A3     = 0x8  // PSC 0 Retrigger and Fault Mode for Part A
	PFRC0A_PRFM0A_Msk  = 0xf  // PSC 0 Retrigger and Fault Mode for Part A

	// PCTL0: PSC 0 Control Register
	PCTL0_PPRE00     = 0x40 // PSC 0 Prescaler Selects
	PCTL0_PPRE01     = 0x80 // PSC 0 Prescaler Selects
	PCTL0_PPRE0_Msk  = 0xc0 // PSC 0 Prescaler Selects
	PCTL0_PBFM0      = 0x20 // PSC 0 Balance Flank Width Modulation
	PCTL0_PBFM0_Msk  = 0x20 // PSC 0 Balance Flank Width Modulation
	PCTL0_PAOC0B     = 0x10 // PSC 0 Asynchronous Output Control B
	PCTL0_PAOC0B_Msk = 0x10 // PSC 0 Asynchronous Output Control B
	PCTL0_PAOC0A     = 0x8  // PSC 0 Asynchronous Output Control A
	PCTL0_PAOC0A_Msk = 0x8  // PSC 0 Asynchronous Output Control A
	PCTL0_PARUN0     = 0x4  // PSC0 Auto Run
	PCTL0_PARUN0_Msk = 0x4  // PSC0 Auto Run
	PCTL0_PCCYC0     = 0x2  // PSC0 Complete Cycle
	PCTL0_PCCYC0_Msk = 0x2  // PSC0 Complete Cycle
	PCTL0_PRUN0      = 0x1  // PSC 0 Run
	PCTL0_PRUN0_Msk  = 0x1  // PSC 0 Run

	// PCNF0: PSC 0 Configuration Register
	PCNF0_PFIFTY0      = 0x80 // PSC 0 Fifty
	PCNF0_PFIFTY0_Msk  = 0x80 // PSC 0 Fifty
	PCNF0_PALOCK0      = 0x40 // PSC 0 Autolock
	PCNF0_PALOCK0_Msk  = 0x40 // PSC 0 Autolock
	PCNF0_PLOCK0       = 0x20 // PSC 0 Lock
	PCNF0_PLOCK0_Msk   = 0x20 // PSC 0 Lock
	PCNF0_PMODE00      = 0x8  // PSC 0 Mode
	PCNF0_PMODE01      = 0x10 // PSC 0 Mode
	PCNF0_PMODE0_Msk   = 0x18 // PSC 0 Mode
	PCNF0_POP0         = 0x4  // PSC 0 Output Polarity
	PCNF0_POP0_Msk     = 0x4  // PSC 0 Output Polarity
	PCNF0_PCLKSEL0     = 0x2  // PSC 0 Input Clock Select
	PCNF0_PCLKSEL0_Msk = 0x2  // PSC 0 Input Clock Select

	// PSOC0: PSC0 Synchro and Output Configuration
	PSOC0_PSYNC00    = 0x10 // Synchronization Out for ADC Selection
	PSOC0_PSYNC01    = 0x20 // Synchronization Out for ADC Selection
	PSOC0_PSYNC0_Msk = 0x30 // Synchronization Out for ADC Selection
	PSOC0_POEN0B     = 0x4  // PSCOUT01 Output Enable
	PSOC0_POEN0B_Msk = 0x4  // PSCOUT01 Output Enable
	PSOC0_POEN0A     = 0x1  // PSCOUT00 Output Enable
	PSOC0_POEN0A_Msk = 0x1  // PSCOUT00 Output Enable

	// PIM0: PSC0 Interrupt Mask Register
	PIM0_PSEIE0     = 0x20 // PSC 0 Synchro Error Interrupt Enable
	PIM0_PSEIE0_Msk = 0x20 // PSC 0 Synchro Error Interrupt Enable
	PIM0_PEVE0B     = 0x10 // External Event B Interrupt Enable
	PIM0_PEVE0B_Msk = 0x10 // External Event B Interrupt Enable
	PIM0_PEVE0A     = 0x8  // External Event A Interrupt Enable
	PIM0_PEVE0A_Msk = 0x8  // External Event A Interrupt Enable
	PIM0_PEOPE0     = 0x1  // End of Cycle Interrupt Enable
	PIM0_PEOPE0_Msk = 0x1  // End of Cycle Interrupt Enable

	// PIFR0: PSC0 Interrupt Flag Register
	PIFR0_POAC0B     = 0x80 // PSC 0 Output A Activity
	PIFR0_POAC0B_Msk = 0x80 // PSC 0 Output A Activity
	PIFR0_POAC0A     = 0x40 // PSC 0 Output A Activity
	PIFR0_POAC0A_Msk = 0x40 // PSC 0 Output A Activity
	PIFR0_PSEI0      = 0x20 // PSC 0 Synchro Error Interrupt
	PIFR0_PSEI0_Msk  = 0x20 // PSC 0 Synchro Error Interrupt
	PIFR0_PEV0B      = 0x10 // External Event B Interrupt
	PIFR0_PEV0B_Msk  = 0x10 // External Event B Interrupt
	PIFR0_PEV0A      = 0x8  // External Event A Interrupt
	PIFR0_PEV0A_Msk  = 0x8  // External Event A Interrupt
	PIFR0_PRN00      = 0x2  // Ramp Number
	PIFR0_PRN01      = 0x4  // Ramp Number
	PIFR0_PRN0_Msk   = 0x6  // Ramp Number
	PIFR0_PEOP0      = 0x1  // End of PSC0 Interrupt
	PIFR0_PEOP0_Msk  = 0x1  // End of PSC0 Interrupt

	// PICR2L: PSC 2 Input Capture Register

	// PICR2H: PSC 2 Input Capture Register
	PICR2_PCST2     = 0x8000 // PSC 2 Input Capture Software Trig
	PICR2_PCST2_Msk = 0x8000 // PSC 2 Input Capture Software Trig
	PICR2_PICR20    = 0x1    // PSC 2 Input Capture Bytes
	PICR2_PICR21    = 0x2    // PSC 2 Input Capture Bytes
	PICR2_PICR22    = 0x4    // PSC 2 Input Capture Bytes
	PICR2_PICR23    = 0x8    // PSC 2 Input Capture Bytes
	PICR2_PICR24    = 0x10   // PSC 2 Input Capture Bytes
	PICR2_PICR25    = 0x20   // PSC 2 Input Capture Bytes
	PICR2_PICR26    = 0x40   // PSC 2 Input Capture Bytes
	PICR2_PICR27    = 0x80   // PSC 2 Input Capture Bytes
	PICR2_PICR2_Msk = 0xfff  // PSC 2 Input Capture Bytes

	// PFRC2B: PSC 2 Input B Control
	PFRC2B_PCAE2B      = 0x80 // PSC 2 Capture Enable Input Part B
	PFRC2B_PCAE2B_Msk  = 0x80 // PSC 2 Capture Enable Input Part B
	PFRC2B_PISEL2B     = 0x40 // PSC 2 Input Select for Part B
	PFRC2B_PISEL2B_Msk = 0x40 // PSC 2 Input Select for Part B
	PFRC2B_PELEV2B     = 0x20 // PSC 2 Edge Level Selector on Input Part B
	PFRC2B_PELEV2B_Msk = 0x20 // PSC 2 Edge Level Selector on Input Part B
	PFRC2B_PFLTE2B     = 0x10 // PSC 2 Filter Enable on Input Part B
	PFRC2B_PFLTE2B_Msk = 0x10 // PSC 2 Filter Enable on Input Part B
	PFRC2B_PRFM2B0     = 0x1  // PSC 2 Retrigger and Fault Mode for Part B
	PFRC2B_PRFM2B1     = 0x2  // PSC 2 Retrigger and Fault Mode for Part B
	PFRC2B_PRFM2B2     = 0x4  // PSC 2 Retrigger and Fault Mode for Part B
	PFRC2B_PRFM2B3     = 0x8  // PSC 2 Retrigger and Fault Mode for Part B
	PFRC2B_PRFM2B_Msk  = 0xf  // PSC 2 Retrigger and Fault Mode for Part B

	// PFRC2A: PSC 2 Input B Control
	PFRC2A_PCAE2A      = 0x80 // PSC 2 Capture Enable Input Part A
	PFRC2A_PCAE2A_Msk  = 0x80 // PSC 2 Capture Enable Input Part A
	PFRC2A_PISEL2A     = 0x40 // PSC 2 Input Select for Part A
	PFRC2A_PISEL2A_Msk = 0x40 // PSC 2 Input Select for Part A
	PFRC2A_PELEV2A     = 0x20 // PSC 2 Edge Level Selector on Input Part A
	PFRC2A_PELEV2A_Msk = 0x20 // PSC 2 Edge Level Selector on Input Part A
	PFRC2A_PFLTE2A     = 0x10 // PSC 2 Filter Enable on Input Part A
	PFRC2A_PFLTE2A_Msk = 0x10 // PSC 2 Filter Enable on Input Part A
	PFRC2A_PRFM2A0     = 0x1  // PSC 2 Retrigger and Fault Mode for Part A
	PFRC2A_PRFM2A1     = 0x2  // PSC 2 Retrigger and Fault Mode for Part A
	PFRC2A_PRFM2A2     = 0x4  // PSC 2 Retrigger and Fault Mode for Part A
	PFRC2A_PRFM2A3     = 0x8  // PSC 2 Retrigger and Fault Mode for Part A
	PFRC2A_PRFM2A_Msk  = 0xf  // PSC 2 Retrigger and Fault Mode for Part A

	// PCTL2: PSC 2 Control Register
	PCTL2_PPRE20     = 0x40 // PSC 2 Prescaler Selects
	PCTL2_PPRE21     = 0x80 // PSC 2 Prescaler Selects
	PCTL2_PPRE2_Msk  = 0xc0 // PSC 2 Prescaler Selects
	PCTL2_PBFM2      = 0x20 // Balance Flank Width Modulation
	PCTL2_PBFM2_Msk  = 0x20 // Balance Flank Width Modulation
	PCTL2_PAOC2B     = 0x10 // PSC 2 Asynchronous Output Control B
	PCTL2_PAOC2B_Msk = 0x10 // PSC 2 Asynchronous Output Control B
	PCTL2_PAOC2A     = 0x8  // PSC 2 Asynchronous Output Control A
	PCTL2_PAOC2A_Msk = 0x8  // PSC 2 Asynchronous Output Control A
	PCTL2_PARUN2     = 0x4  // PSC2 Auto Run
	PCTL2_PARUN2_Msk = 0x4  // PSC2 Auto Run
	PCTL2_PCCYC2     = 0x2  // PSC2 Complete Cycle
	PCTL2_PCCYC2_Msk = 0x2  // PSC2 Complete Cycle
	PCTL2_PRUN2      = 0x1  // PSC 2 Run
	PCTL2_PRUN2_Msk  = 0x1  // PSC 2 Run

	// PCNF2: PSC 2 Configuration Register
	PCNF2_PFIFTY2      = 0x80 // PSC 2 Fifty
	PCNF2_PFIFTY2_Msk  = 0x80 // PSC 2 Fifty
	PCNF2_PALOCK2      = 0x40 // PSC 2 Autolock
	PCNF2_PALOCK2_Msk  = 0x40 // PSC 2 Autolock
	PCNF2_PLOCK2       = 0x20 // PSC 2 Lock
	PCNF2_PLOCK2_Msk   = 0x20 // PSC 2 Lock
	PCNF2_PMODE20      = 0x8  // PSC 2 Mode
	PCNF2_PMODE21      = 0x10 // PSC 2 Mode
	PCNF2_PMODE2_Msk   = 0x18 // PSC 2 Mode
	PCNF2_POP2         = 0x4  // PSC 2 Output Polarity
	PCNF2_POP2_Msk     = 0x4  // PSC 2 Output Polarity
	PCNF2_PCLKSEL2     = 0x2  // PSC 2 Input Clock Select
	PCNF2_PCLKSEL2_Msk = 0x2  // PSC 2 Input Clock Select
	PCNF2_POME2        = 0x1  // PSC 2 Output Matrix Enable
	PCNF2_POME2_Msk    = 0x1  // PSC 2 Output Matrix Enable

	// POM2: PSC 2 Output Matrix
	POM2_POMV2B0    = 0x10 // Output Matrix Output B Ramps
	POM2_POMV2B1    = 0x20 // Output Matrix Output B Ramps
	POM2_POMV2B2    = 0x40 // Output Matrix Output B Ramps
	POM2_POMV2B3    = 0x80 // Output Matrix Output B Ramps
	POM2_POMV2B_Msk = 0xf0 // Output Matrix Output B Ramps
	POM2_POMV2A0    = 0x1  // Output Matrix Output A Ramps
	POM2_POMV2A1    = 0x2  // Output Matrix Output A Ramps
	POM2_POMV2A2    = 0x4  // Output Matrix Output A Ramps
	POM2_POMV2A3    = 0x8  // Output Matrix Output A Ramps
	POM2_POMV2A_Msk = 0xf  // Output Matrix Output A Ramps

	// PSOC2: PSC2 Synchro and Output Configuration
	PSOC2_POS20      = 0x40 // PSC 2 Output 23 Select
	PSOC2_POS21      = 0x80 // PSC 2 Output 23 Select
	PSOC2_POS2_Msk   = 0xc0 // PSC 2 Output 23 Select
	PSOC2_PSYNC20    = 0x10 // Synchronization Out for ADC Selection
	PSOC2_PSYNC21    = 0x20 // Synchronization Out for ADC Selection
	PSOC2_PSYNC2_Msk = 0x30 // Synchronization Out for ADC Selection
	PSOC2_POEN2D     = 0x8  // PSCOUT23 Output Enable
	PSOC2_POEN2D_Msk = 0x8  // PSCOUT23 Output Enable
	PSOC2_POEN2B     = 0x4  // PSCOUT21 Output Enable
	PSOC2_POEN2B_Msk = 0x4  // PSCOUT21 Output Enable
	PSOC2_POEN2C     = 0x2  // PSCOUT22 Output Enable
	PSOC2_POEN2C_Msk = 0x2  // PSCOUT22 Output Enable
	PSOC2_POEN2A     = 0x1  // PSCOUT20 Output Enable
	PSOC2_POEN2A_Msk = 0x1  // PSCOUT20 Output Enable

	// PIM2: PSC2 Interrupt Mask Register
	PIM2_PSEIE2     = 0x20 // PSC 2 Synchro Error Interrupt Enable
	PIM2_PSEIE2_Msk = 0x20 // PSC 2 Synchro Error Interrupt Enable
	PIM2_PEVE2B     = 0x10 // External Event B Interrupt Enable
	PIM2_PEVE2B_Msk = 0x10 // External Event B Interrupt Enable
	PIM2_PEVE2A     = 0x8  // External Event A Interrupt Enable
	PIM2_PEVE2A_Msk = 0x8  // External Event A Interrupt Enable
	PIM2_PEOPE2     = 0x1  // End of Cycle Interrupt Enable
	PIM2_PEOPE2_Msk = 0x1  // End of Cycle Interrupt Enable

	// PIFR2: PSC2 Interrupt Flag Register
	PIFR2_POAC2B     = 0x80 // PSC 2 Output A Activity
	PIFR2_POAC2B_Msk = 0x80 // PSC 2 Output A Activity
	PIFR2_POAC2A     = 0x40 // PSC 2 Output A Activity
	PIFR2_POAC2A_Msk = 0x40 // PSC 2 Output A Activity
	PIFR2_PSEI2      = 0x20 // PSC 2 Synchro Error Interrupt
	PIFR2_PSEI2_Msk  = 0x20 // PSC 2 Synchro Error Interrupt
	PIFR2_PEV2B      = 0x10 // External Event B Interrupt
	PIFR2_PEV2B_Msk  = 0x10 // External Event B Interrupt
	PIFR2_PEV2A      = 0x8  // External Event A Interrupt
	PIFR2_PEV2A_Msk  = 0x8  // External Event A Interrupt
	PIFR2_PRN20      = 0x2  // Ramp Number
	PIFR2_PRN21      = 0x4  // Ramp Number
	PIFR2_PRN2_Msk   = 0x6  // Ramp Number
	PIFR2_PEOP2      = 0x1  // End of PSC2 Interrupt
	PIFR2_PEOP2_Msk  = 0x1  // End of PSC2 Interrupt
)
