// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-avr.go from AT90CAN32.atdf, see http://packs.download.atmel.com/

//go:build avr && at90can32
// +build avr,at90can32

// Device information for the AT90CAN32.
package avr

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "AT90CAN32"
	ARCH   = "AVR8"
	FAMILY = "megaAVR"
)

// Interrupts
const (
	IRQ_RESET        = 0  // External Pin, Power-on Reset, Brown-out Reset, Watchdog Reset and JTAG AVR Reset
	IRQ_INT0         = 1  // External Interrupt Request 0
	IRQ_INT1         = 2  // External Interrupt Request 1
	IRQ_INT2         = 3  // External Interrupt Request 2
	IRQ_INT3         = 4  // External Interrupt Request 3
	IRQ_INT4         = 5  // External Interrupt Request 4
	IRQ_INT5         = 6  // External Interrupt Request 5
	IRQ_INT6         = 7  // External Interrupt Request 6
	IRQ_INT7         = 8  // External Interrupt Request 7
	IRQ_TIMER2_COMP  = 9  // Timer/Counter2 Compare Match
	IRQ_TIMER2_OVF   = 10 // Timer/Counter2 Overflow
	IRQ_TIMER1_CAPT  = 11 // Timer/Counter1 Capture Event
	IRQ_TIMER1_COMPA = 12 // Timer/Counter1 Compare Match A
	IRQ_TIMER1_COMPB = 13 // Timer/Counter Compare Match B
	IRQ_TIMER1_COMPC = 14 // Timer/Counter1 Compare Match C
	IRQ_TIMER1_OVF   = 15 // Timer/Counter1 Overflow
	IRQ_TIMER0_COMP  = 16 // Timer/Counter0 Compare Match
	IRQ_TIMER0_OVF   = 17 // Timer/Counter0 Overflow
	IRQ_CANIT        = 18 // CAN Transfer Complete or Error
	IRQ_OVRIT        = 19 // CAN Timer Overrun
	IRQ_SPI_STC      = 20 // SPI Serial Transfer Complete
	IRQ_USART0_RX    = 21 // USART0, Rx Complete
	IRQ_USART0_UDRE  = 22 // USART0 Data Register Empty
	IRQ_USART0_TX    = 23 // USART0, Tx Complete
	IRQ_ANALOG_COMP  = 24 // Analog Comparator
	IRQ_ADC          = 25 // ADC Conversion Complete
	IRQ_EE_READY     = 26 // EEPROM Ready
	IRQ_TIMER3_CAPT  = 27 // Timer/Counter3 Capture Event
	IRQ_TIMER3_COMPA = 28 // Timer/Counter3 Compare Match A
	IRQ_TIMER3_COMPB = 29 // Timer/Counter3 Compare Match B
	IRQ_TIMER3_COMPC = 30 // Timer/Counter3 Compare Match C
	IRQ_TIMER3_OVF   = 31 // Timer/Counter3 Overflow
	IRQ_USART1_RX    = 32 // USART1, Rx Complete
	IRQ_USART1_UDRE  = 33 // USART1, Data Register Empty
	IRQ_USART1_TX    = 34 // USART1, Tx Complete
	IRQ_TWI          = 35 // 2-wire Serial Interface
	IRQ_SPM_READY    = 36 // Store Program Memory Read
	IRQ_max          = 36 // Highest interrupt number on this device.
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export __vector_RESET
//go:interrupt
func interruptRESET() {
	callHandlers(IRQ_RESET)
}

//export __vector_INT0
//go:interrupt
func interruptINT0() {
	callHandlers(IRQ_INT0)
}

//export __vector_INT1
//go:interrupt
func interruptINT1() {
	callHandlers(IRQ_INT1)
}

//export __vector_INT2
//go:interrupt
func interruptINT2() {
	callHandlers(IRQ_INT2)
}

//export __vector_INT3
//go:interrupt
func interruptINT3() {
	callHandlers(IRQ_INT3)
}

//export __vector_INT4
//go:interrupt
func interruptINT4() {
	callHandlers(IRQ_INT4)
}

//export __vector_INT5
//go:interrupt
func interruptINT5() {
	callHandlers(IRQ_INT5)
}

//export __vector_INT6
//go:interrupt
func interruptINT6() {
	callHandlers(IRQ_INT6)
}

//export __vector_INT7
//go:interrupt
func interruptINT7() {
	callHandlers(IRQ_INT7)
}

//export __vector_TIMER2_COMP
//go:interrupt
func interruptTIMER2_COMP() {
	callHandlers(IRQ_TIMER2_COMP)
}

//export __vector_TIMER2_OVF
//go:interrupt
func interruptTIMER2_OVF() {
	callHandlers(IRQ_TIMER2_OVF)
}

//export __vector_TIMER1_CAPT
//go:interrupt
func interruptTIMER1_CAPT() {
	callHandlers(IRQ_TIMER1_CAPT)
}

//export __vector_TIMER1_COMPA
//go:interrupt
func interruptTIMER1_COMPA() {
	callHandlers(IRQ_TIMER1_COMPA)
}

//export __vector_TIMER1_COMPB
//go:interrupt
func interruptTIMER1_COMPB() {
	callHandlers(IRQ_TIMER1_COMPB)
}

//export __vector_TIMER1_COMPC
//go:interrupt
func interruptTIMER1_COMPC() {
	callHandlers(IRQ_TIMER1_COMPC)
}

//export __vector_TIMER1_OVF
//go:interrupt
func interruptTIMER1_OVF() {
	callHandlers(IRQ_TIMER1_OVF)
}

//export __vector_TIMER0_COMP
//go:interrupt
func interruptTIMER0_COMP() {
	callHandlers(IRQ_TIMER0_COMP)
}

//export __vector_TIMER0_OVF
//go:interrupt
func interruptTIMER0_OVF() {
	callHandlers(IRQ_TIMER0_OVF)
}

//export __vector_CANIT
//go:interrupt
func interruptCANIT() {
	callHandlers(IRQ_CANIT)
}

//export __vector_OVRIT
//go:interrupt
func interruptOVRIT() {
	callHandlers(IRQ_OVRIT)
}

//export __vector_SPI_STC
//go:interrupt
func interruptSPI_STC() {
	callHandlers(IRQ_SPI_STC)
}

//export __vector_USART0_RX
//go:interrupt
func interruptUSART0_RX() {
	callHandlers(IRQ_USART0_RX)
}

//export __vector_USART0_UDRE
//go:interrupt
func interruptUSART0_UDRE() {
	callHandlers(IRQ_USART0_UDRE)
}

//export __vector_USART0_TX
//go:interrupt
func interruptUSART0_TX() {
	callHandlers(IRQ_USART0_TX)
}

//export __vector_ANALOG_COMP
//go:interrupt
func interruptANALOG_COMP() {
	callHandlers(IRQ_ANALOG_COMP)
}

//export __vector_ADC
//go:interrupt
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export __vector_EE_READY
//go:interrupt
func interruptEE_READY() {
	callHandlers(IRQ_EE_READY)
}

//export __vector_TIMER3_CAPT
//go:interrupt
func interruptTIMER3_CAPT() {
	callHandlers(IRQ_TIMER3_CAPT)
}

//export __vector_TIMER3_COMPA
//go:interrupt
func interruptTIMER3_COMPA() {
	callHandlers(IRQ_TIMER3_COMPA)
}

//export __vector_TIMER3_COMPB
//go:interrupt
func interruptTIMER3_COMPB() {
	callHandlers(IRQ_TIMER3_COMPB)
}

//export __vector_TIMER3_COMPC
//go:interrupt
func interruptTIMER3_COMPC() {
	callHandlers(IRQ_TIMER3_COMPC)
}

//export __vector_TIMER3_OVF
//go:interrupt
func interruptTIMER3_OVF() {
	callHandlers(IRQ_TIMER3_OVF)
}

//export __vector_USART1_RX
//go:interrupt
func interruptUSART1_RX() {
	callHandlers(IRQ_USART1_RX)
}

//export __vector_USART1_UDRE
//go:interrupt
func interruptUSART1_UDRE() {
	callHandlers(IRQ_USART1_UDRE)
}

//export __vector_USART1_TX
//go:interrupt
func interruptUSART1_TX() {
	callHandlers(IRQ_USART1_TX)
}

//export __vector_TWI
//go:interrupt
func interruptTWI() {
	callHandlers(IRQ_TWI)
}

//export __vector_SPM_READY
//go:interrupt
func interruptSPM_READY() {
	callHandlers(IRQ_SPM_READY)
}

// Peripherals.
var (
	// Fuses
	EXTENDED = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2)))
	HIGH     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x1)))
	LOW      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Lockbits
	LOCKBIT = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// I/O Port
	PORTA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x22)))
	DDRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x21)))
	PINA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x20)))
	PORTB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x25)))
	DDRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x24)))
	PINB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x23)))
	PORTC = (*volatile.Register8)(unsafe.Pointer(uintptr(0x28)))
	DDRC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x27)))
	PINC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x26)))
	PORTD = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2b)))
	DDRD  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2a)))
	PIND  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x29)))
	PORTE = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2e)))
	DDRE  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2d)))
	PINE  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2c)))
	PORTF = (*volatile.Register8)(unsafe.Pointer(uintptr(0x31)))
	DDRF  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x30)))
	PINF  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2f)))
	PORTG = (*volatile.Register8)(unsafe.Pointer(uintptr(0x34)))
	DDRG  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x33)))
	PING  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x32)))

	// JTAG Interface
	OCDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x51)))
	MCUCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x55)))
	MCUSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x54)))

	// Serial Peripheral Interface
	SPCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4c)))
	SPSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4d)))
	SPDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4e)))

	// Two Wire Serial Interface
	TWBR = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb8)))
	TWCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbc)))
	TWSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb9)))
	TWDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbb)))
	TWAR = (*volatile.Register8)(unsafe.Pointer(uintptr(0xba)))

	// USART
	UDR0   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc6)))
	UCSR0A = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc0)))
	UCSR0B = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc1)))
	UCSR0C = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc2)))
	UBRR0L = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc4)))
	UBRR0H = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc5)))
	UDR1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xce)))
	UCSR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc8)))
	UCSR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc9)))
	UCSR1C = (*volatile.Register8)(unsafe.Pointer(uintptr(0xca)))
	UBRR1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcc)))
	UBRR1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcd)))

	// CPU Registers
	SREG   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5f)))
	SPL    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5d)))
	SPH    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5e)))
	XMCRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x74)))
	XMCRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x75)))
	OSCCAL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x66)))
	CLKPR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x61)))
	SMCR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x53)))
	RAMPZ  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5b)))
	GPIOR2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4b)))
	GPIOR1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4a)))
	GPIOR0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3e)))

	// Bootloader
	SPMCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x57)))

	// External Interrupts
	EICRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x69)))
	EICRB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6a)))
	EIMSK = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3d)))
	EIFR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3c)))

	// EEPROM
	EEARL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x41)))
	EEARH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x42)))
	EEDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x40)))
	EECR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3f)))

	// Timer/Counter, 8-bit
	TCCR0A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x44)))
	TCNT0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x46)))
	OCR0A  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x47)))
	TIMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6e)))
	TIFR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x35)))
	GTCCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x43)))

	// Timer/Counter, 16-bit
	TCCR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x80)))
	TCCR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x81)))
	TCCR1C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x82)))
	TCNT1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x84)))
	TCNT1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x85)))
	OCR1AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x88)))
	OCR1AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x89)))
	OCR1BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8a)))
	OCR1BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8b)))
	OCR1CL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8c)))
	OCR1CH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8d)))
	ICR1L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x86)))
	ICR1H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x87)))
	TIMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6f)))
	TIFR1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x36)))
	TCCR3A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x90)))
	TCCR3B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x91)))
	TCCR3C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x92)))
	TCNT3L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x94)))
	TCNT3H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x95)))
	OCR3AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x98)))
	OCR3AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x99)))
	OCR3BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x9a)))
	OCR3BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x9b)))
	OCR3CL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x9c)))
	OCR3CH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x9d)))
	ICR3L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x96)))
	ICR3H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x97)))
	TIMSK3 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x71)))
	TIFR3  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x38)))

	// Timer/Counter, 8-bit Async
	TCCR2A = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb0)))
	TCNT2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb2)))
	OCR2A  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb3)))
	TIMSK2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x70)))
	TIFR2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x37)))
	ASSR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb6)))

	// Watchdog Timer
	WDTCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x60)))

	// Analog-to-Digital Converter
	ADMUX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7c)))
	ADCSRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7a)))
	ADCL   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x78)))
	ADCH   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x79)))
	ADCSRB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7b)))
	DIDR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7e)))

	// Analog Comparator
	ACSR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x50)))
	DIDR1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7f)))

	// Controller Area Network
	CANGCON  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd8)))
	CANGSTA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd9)))
	CANGIT   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xda)))
	CANGIE   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xdb)))
	CANEN2   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xdc)))
	CANEN1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xdd)))
	CANIE2   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xde)))
	CANIE1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xdf)))
	CANSIT2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe0)))
	CANSIT1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe1)))
	CANBT1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe2)))
	CANBT2   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe3)))
	CANBT3   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe4)))
	CANTCON  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe5)))
	CANTIML  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe6)))
	CANTIMH  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe7)))
	CANTTCL  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe8)))
	CANTTCH  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe9)))
	CANTEC   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xea)))
	CANREC   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xeb)))
	CANHPMOB = (*volatile.Register8)(unsafe.Pointer(uintptr(0xec)))
	CANPAGE  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xed)))
	CANSTMOB = (*volatile.Register8)(unsafe.Pointer(uintptr(0xee)))
	CANCDMOB = (*volatile.Register8)(unsafe.Pointer(uintptr(0xef)))
	CANIDT4  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf0)))
	CANIDT3  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf1)))
	CANIDT2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf2)))
	CANIDT1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf3)))
	CANIDM4  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf4)))
	CANIDM3  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf5)))
	CANIDM2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf6)))
	CANIDM1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf7)))
	CANSTML  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf8)))
	CANSTMH  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf9)))
	CANMSG   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xfa)))
)

// Bitfields for FUSE: Fuses
const (
	// EXTENDED
	EXTENDED_BODLEVEL0    = 0x2 // Brown-out Detector trigger level
	EXTENDED_BODLEVEL1    = 0x4 // Brown-out Detector trigger level
	EXTENDED_BODLEVEL2    = 0x8 // Brown-out Detector trigger level
	EXTENDED_BODLEVEL_Msk = 0xe // Brown-out Detector trigger level
	EXTENDED_TA0SEL       = 0x1 // Reserved for factory tests
	EXTENDED_TA0SEL_Msk   = 0x1 // Reserved for factory tests

	// HIGH
	HIGH_OCDEN       = 0x80 // On-Chip Debug Enabled
	HIGH_OCDEN_Msk   = 0x80 // On-Chip Debug Enabled
	HIGH_JTAGEN      = 0x40 // JTAG Interface Enabled
	HIGH_JTAGEN_Msk  = 0x40 // JTAG Interface Enabled
	HIGH_SPIEN       = 0x20 // Serial program downloading (SPI) enabled
	HIGH_SPIEN_Msk   = 0x20 // Serial program downloading (SPI) enabled
	HIGH_WDTON       = 0x10 // Watchdog timer always on
	HIGH_WDTON_Msk   = 0x10 // Watchdog timer always on
	HIGH_EESAVE      = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_EESAVE_Msk  = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_BOOTSZ0     = 0x2  // Select Boot Size
	HIGH_BOOTSZ1     = 0x4  // Select Boot Size
	HIGH_BOOTSZ_Msk  = 0x6  // Select Boot Size
	HIGH_BOOTRST     = 0x1  // Boot Reset vector Enabled
	HIGH_BOOTRST_Msk = 0x1  // Boot Reset vector Enabled

	// LOW
	LOW_CKDIV8        = 0x80 // Divide clock by 8 internally; [CKDIV8=0]
	LOW_CKDIV8_Msk    = 0x80 // Divide clock by 8 internally; [CKDIV8=0]
	LOW_CKOUT         = 0x40 // Clock output on PORTC7; [CKOUT=0]
	LOW_CKOUT_Msk     = 0x40 // Clock output on PORTC7; [CKOUT=0]
	LOW_SUT_CKSEL0    = 0x1  // Select Clock Source
	LOW_SUT_CKSEL1    = 0x2  // Select Clock Source
	LOW_SUT_CKSEL2    = 0x4  // Select Clock Source
	LOW_SUT_CKSEL3    = 0x8  // Select Clock Source
	LOW_SUT_CKSEL4    = 0x10 // Select Clock Source
	LOW_SUT_CKSEL5    = 0x20 // Select Clock Source
	LOW_SUT_CKSEL_Msk = 0x3f // Select Clock Source
)

// Bitfields for LOCKBIT: Lockbits
const (
	// LOCKBIT
	LOCKBIT_LB0      = 0x1  // Memory Lock
	LOCKBIT_LB1      = 0x2  // Memory Lock
	LOCKBIT_LB_Msk   = 0x3  // Memory Lock
	LOCKBIT_BLB00    = 0x4  // Boot Loader Protection Mode
	LOCKBIT_BLB01    = 0x8  // Boot Loader Protection Mode
	LOCKBIT_BLB0_Msk = 0xc  // Boot Loader Protection Mode
	LOCKBIT_BLB10    = 0x10 // Boot Loader Protection Mode
	LOCKBIT_BLB11    = 0x20 // Boot Loader Protection Mode
	LOCKBIT_BLB1_Msk = 0x30 // Boot Loader Protection Mode
)

// Bitfields for JTAG: JTAG Interface
const (
	// MCUCR: MCU Control Register
	MCUCR_JTD       = 0x80 // JTAG Interface Disable
	MCUCR_JTD_Msk   = 0x80 // JTAG Interface Disable
	MCUCR_PUD       = 0x10 // Pull-up disable
	MCUCR_PUD_Msk   = 0x10 // Pull-up disable
	MCUCR_IVSEL     = 0x2  // Interrupt Vector Select
	MCUCR_IVSEL_Msk = 0x2  // Interrupt Vector Select
	MCUCR_IVCE      = 0x1  // Interrupt Vector Change Enable
	MCUCR_IVCE_Msk  = 0x1  // Interrupt Vector Change Enable

	// MCUSR: MCU Status Register
	MCUSR_JTRF      = 0x10 // JTAG Reset Flag
	MCUSR_JTRF_Msk  = 0x10 // JTAG Reset Flag
	MCUSR_WDRF      = 0x8  // Watchdog Reset Flag
	MCUSR_WDRF_Msk  = 0x8  // Watchdog Reset Flag
	MCUSR_BORF      = 0x4  // Brown-out Reset Flag
	MCUSR_BORF_Msk  = 0x4  // Brown-out Reset Flag
	MCUSR_EXTRF     = 0x2  // External Reset Flag
	MCUSR_EXTRF_Msk = 0x2  // External Reset Flag
	MCUSR_PORF      = 0x1  // Power-on reset flag
	MCUSR_PORF_Msk  = 0x1  // Power-on reset flag
)

// Bitfields for SPI: Serial Peripheral Interface
const (
	// SPCR: SPI Control Register
	SPCR_SPIE     = 0x80 // SPI Interrupt Enable
	SPCR_SPIE_Msk = 0x80 // SPI Interrupt Enable
	SPCR_SPE      = 0x40 // SPI Enable
	SPCR_SPE_Msk  = 0x40 // SPI Enable
	SPCR_DORD     = 0x20 // Data Order
	SPCR_DORD_Msk = 0x20 // Data Order
	SPCR_MSTR     = 0x10 // Master/Slave Select
	SPCR_MSTR_Msk = 0x10 // Master/Slave Select
	SPCR_CPOL     = 0x8  // Clock polarity
	SPCR_CPOL_Msk = 0x8  // Clock polarity
	SPCR_CPHA     = 0x4  // Clock Phase
	SPCR_CPHA_Msk = 0x4  // Clock Phase
	SPCR_SPR0     = 0x1  // SPI Clock Rate Selects
	SPCR_SPR1     = 0x2  // SPI Clock Rate Selects
	SPCR_SPR_Msk  = 0x3  // SPI Clock Rate Selects

	// SPSR: SPI Status Register
	SPSR_SPIF      = 0x80 // SPI Interrupt Flag
	SPSR_SPIF_Msk  = 0x80 // SPI Interrupt Flag
	SPSR_WCOL      = 0x40 // Write Collision Flag
	SPSR_WCOL_Msk  = 0x40 // Write Collision Flag
	SPSR_SPI2X     = 0x1  // Double SPI Speed Bit
	SPSR_SPI2X_Msk = 0x1  // Double SPI Speed Bit

	// SPDR: SPI Data Register
	SPDR_SPD0    = 0x1  // SPI Data Register
	SPDR_SPD1    = 0x2  // SPI Data Register
	SPDR_SPD2    = 0x4  // SPI Data Register
	SPDR_SPD3    = 0x8  // SPI Data Register
	SPDR_SPD4    = 0x10 // SPI Data Register
	SPDR_SPD5    = 0x20 // SPI Data Register
	SPDR_SPD6    = 0x40 // SPI Data Register
	SPDR_SPD7    = 0x80 // SPI Data Register
	SPDR_SPD_Msk = 0xff // SPI Data Register
)

// Bitfields for TWI: Two Wire Serial Interface
const (
	// TWCR: TWI Control Register
	TWCR_TWINT     = 0x80 // TWI Interrupt Flag
	TWCR_TWINT_Msk = 0x80 // TWI Interrupt Flag
	TWCR_TWEA      = 0x40 // TWI Enable Acknowledge Bit
	TWCR_TWEA_Msk  = 0x40 // TWI Enable Acknowledge Bit
	TWCR_TWSTA     = 0x20 // TWI Start Condition Bit
	TWCR_TWSTA_Msk = 0x20 // TWI Start Condition Bit
	TWCR_TWSTO     = 0x10 // TWI Stop Condition Bit
	TWCR_TWSTO_Msk = 0x10 // TWI Stop Condition Bit
	TWCR_TWWC      = 0x8  // TWI Write Collition Flag
	TWCR_TWWC_Msk  = 0x8  // TWI Write Collition Flag
	TWCR_TWEN      = 0x4  // TWI Enable Bit
	TWCR_TWEN_Msk  = 0x4  // TWI Enable Bit
	TWCR_TWIE      = 0x1  // TWI Interrupt Enable
	TWCR_TWIE_Msk  = 0x1  // TWI Interrupt Enable

	// TWSR: TWI Status Register
	TWSR_TWS0     = 0x8  // TWI Status
	TWSR_TWS1     = 0x10 // TWI Status
	TWSR_TWS2     = 0x20 // TWI Status
	TWSR_TWS3     = 0x40 // TWI Status
	TWSR_TWS4     = 0x80 // TWI Status
	TWSR_TWS_Msk  = 0xf8 // TWI Status
	TWSR_TWPS0    = 0x1  // TWI Prescaler
	TWSR_TWPS1    = 0x2  // TWI Prescaler
	TWSR_TWPS_Msk = 0x3  // TWI Prescaler

	// TWAR: TWI (Slave) Address register
	TWAR_TWA0      = 0x2  // TWI (Slave) Address register Bits
	TWAR_TWA1      = 0x4  // TWI (Slave) Address register Bits
	TWAR_TWA2      = 0x8  // TWI (Slave) Address register Bits
	TWAR_TWA3      = 0x10 // TWI (Slave) Address register Bits
	TWAR_TWA4      = 0x20 // TWI (Slave) Address register Bits
	TWAR_TWA5      = 0x40 // TWI (Slave) Address register Bits
	TWAR_TWA6      = 0x80 // TWI (Slave) Address register Bits
	TWAR_TWA_Msk   = 0xfe // TWI (Slave) Address register Bits
	TWAR_TWGCE     = 0x1  // TWI General Call Recognition Enable Bit
	TWAR_TWGCE_Msk = 0x1  // TWI General Call Recognition Enable Bit
)

// Bitfields for USART: USART
const (
	// UCSR0A: USART Control and Status Register A
	UCSR0A_RXC0      = 0x80 // USART Receive Complete
	UCSR0A_RXC0_Msk  = 0x80 // USART Receive Complete
	UCSR0A_TXC0      = 0x40 // USART Transmitt Complete
	UCSR0A_TXC0_Msk  = 0x40 // USART Transmitt Complete
	UCSR0A_UDRE0     = 0x20 // USART Data Register Empty
	UCSR0A_UDRE0_Msk = 0x20 // USART Data Register Empty
	UCSR0A_FE0       = 0x10 // Framing Error
	UCSR0A_FE0_Msk   = 0x10 // Framing Error
	UCSR0A_DOR0      = 0x8  // Data overRun
	UCSR0A_DOR0_Msk  = 0x8  // Data overRun
	UCSR0A_UPE0      = 0x4  // Parity Error
	UCSR0A_UPE0_Msk  = 0x4  // Parity Error
	UCSR0A_U2X0      = 0x2  // Double the USART transmission speed
	UCSR0A_U2X0_Msk  = 0x2  // Double the USART transmission speed
	UCSR0A_MPCM0     = 0x1  // Multi-processor Communication Mode
	UCSR0A_MPCM0_Msk = 0x1  // Multi-processor Communication Mode

	// UCSR0B: USART Control and Status Register B
	UCSR0B_RXCIE0     = 0x80 // RX Complete Interrupt Enable
	UCSR0B_RXCIE0_Msk = 0x80 // RX Complete Interrupt Enable
	UCSR0B_TXCIE0     = 0x40 // TX Complete Interrupt Enable
	UCSR0B_TXCIE0_Msk = 0x40 // TX Complete Interrupt Enable
	UCSR0B_UDRIE0     = 0x20 // USART Data register Empty Interrupt Enable
	UCSR0B_UDRIE0_Msk = 0x20 // USART Data register Empty Interrupt Enable
	UCSR0B_RXEN0      = 0x10 // Receiver Enable
	UCSR0B_RXEN0_Msk  = 0x10 // Receiver Enable
	UCSR0B_TXEN0      = 0x8  // Transmitter Enable
	UCSR0B_TXEN0_Msk  = 0x8  // Transmitter Enable
	UCSR0B_UCSZ02     = 0x4  // Character Size
	UCSR0B_UCSZ02_Msk = 0x4  // Character Size
	UCSR0B_RXB80      = 0x2  // Receive Data Bit 8
	UCSR0B_RXB80_Msk  = 0x2  // Receive Data Bit 8
	UCSR0B_TXB80      = 0x1  // Transmit Data Bit 8
	UCSR0B_TXB80_Msk  = 0x1  // Transmit Data Bit 8

	// UCSR0C: USART Control and Status Register C
	UCSR0C_UMSEL0     = 0x40 // USART Mode Select
	UCSR0C_UMSEL0_Msk = 0x40 // USART Mode Select
	UCSR0C_UPM00      = 0x10 // Parity Mode Bits
	UCSR0C_UPM01      = 0x20 // Parity Mode Bits
	UCSR0C_UPM0_Msk   = 0x30 // Parity Mode Bits
	UCSR0C_USBS0      = 0x8  // Stop Bit Select
	UCSR0C_USBS0_Msk  = 0x8  // Stop Bit Select
	UCSR0C_UCSZ00     = 0x2  // Character Size
	UCSR0C_UCSZ01     = 0x4  // Character Size
	UCSR0C_UCSZ0_Msk  = 0x6  // Character Size
	UCSR0C_UCPOL0     = 0x1  // Clock Polarity
	UCSR0C_UCPOL0_Msk = 0x1  // Clock Polarity

	// UCSR1A: USART Control and Status Register A
	UCSR1A_RXC1      = 0x80 // USART Receive Complete
	UCSR1A_RXC1_Msk  = 0x80 // USART Receive Complete
	UCSR1A_TXC1      = 0x40 // USART Transmitt Complete
	UCSR1A_TXC1_Msk  = 0x40 // USART Transmitt Complete
	UCSR1A_UDRE1     = 0x20 // USART Data Register Empty
	UCSR1A_UDRE1_Msk = 0x20 // USART Data Register Empty
	UCSR1A_FE1       = 0x10 // Framing Error
	UCSR1A_FE1_Msk   = 0x10 // Framing Error
	UCSR1A_DOR1      = 0x8  // Data overRun
	UCSR1A_DOR1_Msk  = 0x8  // Data overRun
	UCSR1A_UPE1      = 0x4  // Parity Error
	UCSR1A_UPE1_Msk  = 0x4  // Parity Error
	UCSR1A_U2X1      = 0x2  // Double the USART transmission speed
	UCSR1A_U2X1_Msk  = 0x2  // Double the USART transmission speed
	UCSR1A_MPCM1     = 0x1  // Multi-processor Communication Mode
	UCSR1A_MPCM1_Msk = 0x1  // Multi-processor Communication Mode

	// UCSR1B: USART Control and Status Register B
	UCSR1B_RXCIE1     = 0x80 // RX Complete Interrupt Enable
	UCSR1B_RXCIE1_Msk = 0x80 // RX Complete Interrupt Enable
	UCSR1B_TXCIE1     = 0x40 // TX Complete Interrupt Enable
	UCSR1B_TXCIE1_Msk = 0x40 // TX Complete Interrupt Enable
	UCSR1B_UDRIE1     = 0x20 // USART Data register Empty Interrupt Enable
	UCSR1B_UDRIE1_Msk = 0x20 // USART Data register Empty Interrupt Enable
	UCSR1B_RXEN1      = 0x10 // Receiver Enable
	UCSR1B_RXEN1_Msk  = 0x10 // Receiver Enable
	UCSR1B_TXEN1      = 0x8  // Transmitter Enable
	UCSR1B_TXEN1_Msk  = 0x8  // Transmitter Enable
	UCSR1B_UCSZ12     = 0x4  // Character Size
	UCSR1B_UCSZ12_Msk = 0x4  // Character Size
	UCSR1B_RXB81      = 0x2  // Receive Data Bit 8
	UCSR1B_RXB81_Msk  = 0x2  // Receive Data Bit 8
	UCSR1B_TXB81      = 0x1  // Transmit Data Bit 8
	UCSR1B_TXB81_Msk  = 0x1  // Transmit Data Bit 8

	// UCSR1C: USART Control and Status Register C
	UCSR1C_UMSEL1     = 0x40 // USART Mode Select
	UCSR1C_UMSEL1_Msk = 0x40 // USART Mode Select
	UCSR1C_UPM10      = 0x10 // Parity Mode Bits
	UCSR1C_UPM11      = 0x20 // Parity Mode Bits
	UCSR1C_UPM1_Msk   = 0x30 // Parity Mode Bits
	UCSR1C_USBS1      = 0x8  // Stop Bit Select
	UCSR1C_USBS1_Msk  = 0x8  // Stop Bit Select
	UCSR1C_UCSZ10     = 0x2  // Character Size
	UCSR1C_UCSZ11     = 0x4  // Character Size
	UCSR1C_UCSZ1_Msk  = 0x6  // Character Size
	UCSR1C_UCPOL1     = 0x1  // Clock Polarity
	UCSR1C_UCPOL1_Msk = 0x1  // Clock Polarity
)

// Bitfields for CPU: CPU Registers
const (
	// SREG: Status Register
	SREG_I     = 0x80 // Global Interrupt Enable
	SREG_I_Msk = 0x80 // Global Interrupt Enable
	SREG_T     = 0x40 // Bit Copy Storage
	SREG_T_Msk = 0x40 // Bit Copy Storage
	SREG_H     = 0x20 // Half Carry Flag
	SREG_H_Msk = 0x20 // Half Carry Flag
	SREG_S     = 0x10 // Sign Bit
	SREG_S_Msk = 0x10 // Sign Bit
	SREG_V     = 0x8  // Two's Complement Overflow Flag
	SREG_V_Msk = 0x8  // Two's Complement Overflow Flag
	SREG_N     = 0x4  // Negative Flag
	SREG_N_Msk = 0x4  // Negative Flag
	SREG_Z     = 0x2  // Zero Flag
	SREG_Z_Msk = 0x2  // Zero Flag
	SREG_C     = 0x1  // Carry Flag
	SREG_C_Msk = 0x1  // Carry Flag

	// XMCRA: External Memory Control Register A
	XMCRA_SRE      = 0x80 // External SRAM Enable
	XMCRA_SRE_Msk  = 0x80 // External SRAM Enable
	XMCRA_SRL0     = 0x10 // Wait state page limit
	XMCRA_SRL1     = 0x20 // Wait state page limit
	XMCRA_SRL2     = 0x40 // Wait state page limit
	XMCRA_SRL_Msk  = 0x70 // Wait state page limit
	XMCRA_SRW10    = 0x4  // Wait state select bit upper page
	XMCRA_SRW11    = 0x8  // Wait state select bit upper page
	XMCRA_SRW1_Msk = 0xc  // Wait state select bit upper page
	XMCRA_SRW00    = 0x1  // Wait state select bit lower page
	XMCRA_SRW01    = 0x2  // Wait state select bit lower page
	XMCRA_SRW0_Msk = 0x3  // Wait state select bit lower page

	// XMCRB: External Memory Control Register B
	XMCRB_XMBK     = 0x80 // External Memory Bus Keeper Enable
	XMCRB_XMBK_Msk = 0x80 // External Memory Bus Keeper Enable
	XMCRB_XMM0     = 0x1  // External Memory High Mask
	XMCRB_XMM1     = 0x2  // External Memory High Mask
	XMCRB_XMM2     = 0x4  // External Memory High Mask
	XMCRB_XMM_Msk  = 0x7  // External Memory High Mask

	// OSCCAL: Oscillator Calibration Value
	OSCCAL_OSCCAL0    = 0x1  // Oscillator Calibration
	OSCCAL_OSCCAL1    = 0x2  // Oscillator Calibration
	OSCCAL_OSCCAL2    = 0x4  // Oscillator Calibration
	OSCCAL_OSCCAL3    = 0x8  // Oscillator Calibration
	OSCCAL_OSCCAL4    = 0x10 // Oscillator Calibration
	OSCCAL_OSCCAL5    = 0x20 // Oscillator Calibration
	OSCCAL_OSCCAL6    = 0x40 // Oscillator Calibration
	OSCCAL_OSCCAL7    = 0x80 // Oscillator Calibration
	OSCCAL_OSCCAL_Msk = 0xff // Oscillator Calibration

	// CLKPR: Clock Prescale Register
	CLKPR_CLKPCE     = 0x80
	CLKPR_CLKPCE_Msk = 0x80
	CLKPR_CLKPS0     = 0x1
	CLKPR_CLKPS1     = 0x2
	CLKPR_CLKPS2     = 0x4
	CLKPR_CLKPS3     = 0x8
	CLKPR_CLKPS_Msk  = 0xf

	// SMCR: Sleep Mode Control Register
	SMCR_SM0    = 0x2 // Sleep Mode Select bits
	SMCR_SM1    = 0x4 // Sleep Mode Select bits
	SMCR_SM2    = 0x8 // Sleep Mode Select bits
	SMCR_SM_Msk = 0xe // Sleep Mode Select bits
	SMCR_SE     = 0x1 // Sleep Enable
	SMCR_SE_Msk = 0x1 // Sleep Enable

	// RAMPZ: RAM Page Z Select Register - Not used.
	RAMPZ_RAMPZ0     = 0x1 // RAM Page Z Select Register Bit 0
	RAMPZ_RAMPZ0_Msk = 0x1 // RAM Page Z Select Register Bit 0

	// GPIOR2: General Purpose IO Register 2
	GPIOR2_GPIOR0    = 0x1  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR1    = 0x2  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR2    = 0x4  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR3    = 0x8  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR4    = 0x10 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR5    = 0x20 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR6    = 0x40 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR7    = 0x80 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR_Msk = 0xff // General Purpose IO Register 2 bis

	// GPIOR1: General Purpose IO Register 1
	GPIOR1_GPIOR0    = 0x1  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR1    = 0x2  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR2    = 0x4  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR3    = 0x8  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR4    = 0x10 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR5    = 0x20 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR6    = 0x40 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR7    = 0x80 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR_Msk = 0xff // General Purpose IO Register 1 bis

	// GPIOR0: General Purpose IO Register 0
	GPIOR0_GPIOR07     = 0x80 // General Purpose IO Register 0 bit 7
	GPIOR0_GPIOR07_Msk = 0x80 // General Purpose IO Register 0 bit 7
	GPIOR0_GPIOR06     = 0x40 // General Purpose IO Register 0 bit 6
	GPIOR0_GPIOR06_Msk = 0x40 // General Purpose IO Register 0 bit 6
	GPIOR0_GPIOR05     = 0x20 // General Purpose IO Register 0 bit 5
	GPIOR0_GPIOR05_Msk = 0x20 // General Purpose IO Register 0 bit 5
	GPIOR0_GPIOR04     = 0x10 // General Purpose IO Register 0 bit 4
	GPIOR0_GPIOR04_Msk = 0x10 // General Purpose IO Register 0 bit 4
	GPIOR0_GPIOR03     = 0x8  // General Purpose IO Register 0 bit 3
	GPIOR0_GPIOR03_Msk = 0x8  // General Purpose IO Register 0 bit 3
	GPIOR0_GPIOR02     = 0x4  // General Purpose IO Register 0 bit 2
	GPIOR0_GPIOR02_Msk = 0x4  // General Purpose IO Register 0 bit 2
	GPIOR0_GPIOR01     = 0x2  // General Purpose IO Register 0 bit 1
	GPIOR0_GPIOR01_Msk = 0x2  // General Purpose IO Register 0 bit 1
	GPIOR0_GPIOR00     = 0x1  // General Purpose IO Register 0 bit 0
	GPIOR0_GPIOR00_Msk = 0x1  // General Purpose IO Register 0 bit 0
)

// Bitfields for BOOT_LOAD: Bootloader
const (
	// SPMCSR: Store Program Memory Control Register
	SPMCSR_SPMIE      = 0x80 // SPM Interrupt Enable
	SPMCSR_SPMIE_Msk  = 0x80 // SPM Interrupt Enable
	SPMCSR_RWWSB      = 0x40 // Read While Write Section Busy
	SPMCSR_RWWSB_Msk  = 0x40 // Read While Write Section Busy
	SPMCSR_RWWSRE     = 0x10 // Read While Write section read enable
	SPMCSR_RWWSRE_Msk = 0x10 // Read While Write section read enable
	SPMCSR_BLBSET     = 0x8  // Boot Lock Bit Set
	SPMCSR_BLBSET_Msk = 0x8  // Boot Lock Bit Set
	SPMCSR_PGWRT      = 0x4  // Page Write
	SPMCSR_PGWRT_Msk  = 0x4  // Page Write
	SPMCSR_PGERS      = 0x2  // Page Erase
	SPMCSR_PGERS_Msk  = 0x2  // Page Erase
	SPMCSR_SPMEN      = 0x1  // Store Program Memory Enable
	SPMCSR_SPMEN_Msk  = 0x1  // Store Program Memory Enable
)

// Bitfields for EXINT: External Interrupts
const (
	// EICRA: External Interrupt Control Register A
	EICRA_ISC30    = 0x40 // External Interrupt Sense Control Bit
	EICRA_ISC31    = 0x80 // External Interrupt Sense Control Bit
	EICRA_ISC3_Msk = 0xc0 // External Interrupt Sense Control Bit
	EICRA_ISC20    = 0x10 // External Interrupt Sense Control Bit
	EICRA_ISC21    = 0x20 // External Interrupt Sense Control Bit
	EICRA_ISC2_Msk = 0x30 // External Interrupt Sense Control Bit
	EICRA_ISC10    = 0x4  // External Interrupt Sense Control Bit
	EICRA_ISC11    = 0x8  // External Interrupt Sense Control Bit
	EICRA_ISC1_Msk = 0xc  // External Interrupt Sense Control Bit
	EICRA_ISC00    = 0x1  // External Interrupt Sense Control Bit
	EICRA_ISC01    = 0x2  // External Interrupt Sense Control Bit
	EICRA_ISC0_Msk = 0x3  // External Interrupt Sense Control Bit

	// EICRB: External Interrupt Control Register B
	EICRB_ISC70    = 0x40 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC71    = 0x80 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC7_Msk = 0xc0 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC60    = 0x10 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC61    = 0x20 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC6_Msk = 0x30 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC50    = 0x4  // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC51    = 0x8  // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC5_Msk = 0xc  // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC40    = 0x1  // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC41    = 0x2  // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC4_Msk = 0x3  // External Interrupt 7-4 Sense Control Bit

	// EIMSK: External Interrupt Mask Register
	EIMSK_INT0    = 0x1  // External Interrupt Request 7 Enable
	EIMSK_INT1    = 0x2  // External Interrupt Request 7 Enable
	EIMSK_INT2    = 0x4  // External Interrupt Request 7 Enable
	EIMSK_INT3    = 0x8  // External Interrupt Request 7 Enable
	EIMSK_INT4    = 0x10 // External Interrupt Request 7 Enable
	EIMSK_INT5    = 0x20 // External Interrupt Request 7 Enable
	EIMSK_INT6    = 0x40 // External Interrupt Request 7 Enable
	EIMSK_INT7    = 0x80 // External Interrupt Request 7 Enable
	EIMSK_INT_Msk = 0xff // External Interrupt Request 7 Enable

	// EIFR: External Interrupt Flag Register
	EIFR_INTF0    = 0x1  // External Interrupt Flags
	EIFR_INTF1    = 0x2  // External Interrupt Flags
	EIFR_INTF2    = 0x4  // External Interrupt Flags
	EIFR_INTF3    = 0x8  // External Interrupt Flags
	EIFR_INTF4    = 0x10 // External Interrupt Flags
	EIFR_INTF5    = 0x20 // External Interrupt Flags
	EIFR_INTF6    = 0x40 // External Interrupt Flags
	EIFR_INTF7    = 0x80 // External Interrupt Flags
	EIFR_INTF_Msk = 0xff // External Interrupt Flags
)

// Bitfields for EEPROM: EEPROM
const (
	// EEARL: EEPROM Read/Write Access Bytes

	// EEARH: EEPROM Read/Write Access Bytes
	EEAR_EEAR0    = 0x1   // EEPROM Address bits
	EEAR_EEAR1    = 0x2   // EEPROM Address bits
	EEAR_EEAR2    = 0x4   // EEPROM Address bits
	EEAR_EEAR3    = 0x8   // EEPROM Address bits
	EEAR_EEAR4    = 0x10  // EEPROM Address bits
	EEAR_EEAR5    = 0x20  // EEPROM Address bits
	EEAR_EEAR6    = 0x40  // EEPROM Address bits
	EEAR_EEAR7    = 0x80  // EEPROM Address bits
	EEAR_EEAR_Msk = 0xfff // EEPROM Address bits

	// EEDR: EEPROM Data Register
	EEDR_EEDR0    = 0x1  // EEPROM Data bits
	EEDR_EEDR1    = 0x2  // EEPROM Data bits
	EEDR_EEDR2    = 0x4  // EEPROM Data bits
	EEDR_EEDR3    = 0x8  // EEPROM Data bits
	EEDR_EEDR4    = 0x10 // EEPROM Data bits
	EEDR_EEDR5    = 0x20 // EEPROM Data bits
	EEDR_EEDR6    = 0x40 // EEPROM Data bits
	EEDR_EEDR7    = 0x80 // EEPROM Data bits
	EEDR_EEDR_Msk = 0xff // EEPROM Data bits

	// EECR: EEPROM Control Register
	EECR_EERIE     = 0x8 // EEPROM Ready Interrupt Enable
	EECR_EERIE_Msk = 0x8 // EEPROM Ready Interrupt Enable
	EECR_EEMWE     = 0x4 // EEPROM Master Write Enable
	EECR_EEMWE_Msk = 0x4 // EEPROM Master Write Enable
	EECR_EEWE      = 0x2 // EEPROM Write Enable
	EECR_EEWE_Msk  = 0x2 // EEPROM Write Enable
	EECR_EERE      = 0x1 // EEPROM Read Enable
	EECR_EERE_Msk  = 0x1 // EEPROM Read Enable
)

// Bitfields for TC8: Timer/Counter, 8-bit
const (
	// TCCR0A: Timer/Counter0 Control Register
	TCCR0A_FOC0A     = 0x80 // Force Output Compare
	TCCR0A_FOC0A_Msk = 0x80 // Force Output Compare
	TCCR0A_WGM00     = 0x40 // Waveform Generation Mode 0
	TCCR0A_WGM00_Msk = 0x40 // Waveform Generation Mode 0
	TCCR0A_COM0A0    = 0x10 // Compare Match Output Modes
	TCCR0A_COM0A1    = 0x20 // Compare Match Output Modes
	TCCR0A_COM0A_Msk = 0x30 // Compare Match Output Modes
	TCCR0A_WGM01     = 0x8  // Waveform Generation Mode 1
	TCCR0A_WGM01_Msk = 0x8  // Waveform Generation Mode 1
	TCCR0A_CS00      = 0x1  // Clock Selects
	TCCR0A_CS01      = 0x2  // Clock Selects
	TCCR0A_CS02      = 0x4  // Clock Selects
	TCCR0A_CS0_Msk   = 0x7  // Clock Selects

	// OCR0A: Timer/Counter0 Output Compare Register
	OCR0A_OCR0A0    = 0x1  // Output Compare A bits
	OCR0A_OCR0A1    = 0x2  // Output Compare A bits
	OCR0A_OCR0A2    = 0x4  // Output Compare A bits
	OCR0A_OCR0A3    = 0x8  // Output Compare A bits
	OCR0A_OCR0A4    = 0x10 // Output Compare A bits
	OCR0A_OCR0A5    = 0x20 // Output Compare A bits
	OCR0A_OCR0A6    = 0x40 // Output Compare A bits
	OCR0A_OCR0A7    = 0x80 // Output Compare A bits
	OCR0A_OCR0A_Msk = 0xff // Output Compare A bits

	// TIMSK0: Timer/Counter0 Interrupt Mask Register
	TIMSK0_OCIE0A     = 0x2 // Timer/Counter0 Output Compare Match Interrupt Enable
	TIMSK0_OCIE0A_Msk = 0x2 // Timer/Counter0 Output Compare Match Interrupt Enable
	TIMSK0_TOIE0      = 0x1 // Timer/Counter0 Overflow Interrupt Enable
	TIMSK0_TOIE0_Msk  = 0x1 // Timer/Counter0 Overflow Interrupt Enable

	// TIFR0: Timer/Counter0 Interrupt Flag register
	TIFR0_OCF0A     = 0x2 // Timer/Counter0 Output Compare Flag 0
	TIFR0_OCF0A_Msk = 0x2 // Timer/Counter0 Output Compare Flag 0
	TIFR0_TOV0      = 0x1 // Timer/Counter0 Overflow Flag
	TIFR0_TOV0_Msk  = 0x1 // Timer/Counter0 Overflow Flag

	// GTCCR: General Timer/Control Register
	GTCCR_TSM        = 0x80 // Timer/Counter Synchronization Mode
	GTCCR_TSM_Msk    = 0x80 // Timer/Counter Synchronization Mode
	GTCCR_PSR310     = 0x1  // Prescaler Reset Timer/Counter1 and Timer/Counter0
	GTCCR_PSR310_Msk = 0x1  // Prescaler Reset Timer/Counter1 and Timer/Counter0
	GTCCR_PSR2       = 0x2  // Prescaler Reset Timer/Counter2
	GTCCR_PSR2_Msk   = 0x2  // Prescaler Reset Timer/Counter2
)

// Bitfields for TC16: Timer/Counter, 16-bit
const (
	// TCCR1A: Timer/Counter1 Control Register A
	TCCR1A_COM1A0    = 0x40 // Compare Output Mode 1A, bits
	TCCR1A_COM1A1    = 0x80 // Compare Output Mode 1A, bits
	TCCR1A_COM1A_Msk = 0xc0 // Compare Output Mode 1A, bits
	TCCR1A_COM1B0    = 0x10 // Compare Output Mode 1B, bits
	TCCR1A_COM1B1    = 0x20 // Compare Output Mode 1B, bits
	TCCR1A_COM1B_Msk = 0x30 // Compare Output Mode 1B, bits
	TCCR1A_COM1C0    = 0x4  // Compare Output Mode 1C, bits
	TCCR1A_COM1C1    = 0x8  // Compare Output Mode 1C, bits
	TCCR1A_COM1C_Msk = 0xc  // Compare Output Mode 1C, bits
	TCCR1A_WGM10     = 0x1  // Waveform Generation Mode
	TCCR1A_WGM11     = 0x2  // Waveform Generation Mode
	TCCR1A_WGM1_Msk  = 0x3  // Waveform Generation Mode

	// TCCR1B: Timer/Counter1 Control Register B
	TCCR1B_ICNC1     = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICNC1_Msk = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICES1     = 0x40 // Input Capture 1 Edge Select
	TCCR1B_ICES1_Msk = 0x40 // Input Capture 1 Edge Select
	TCCR1B_WGM10     = 0x8  // Waveform Generation Mode
	TCCR1B_WGM11     = 0x10 // Waveform Generation Mode
	TCCR1B_WGM1_Msk  = 0x18 // Waveform Generation Mode
	TCCR1B_CS10      = 0x1  // Prescaler source of Timer/Counter 1
	TCCR1B_CS11      = 0x2  // Prescaler source of Timer/Counter 1
	TCCR1B_CS12      = 0x4  // Prescaler source of Timer/Counter 1
	TCCR1B_CS1_Msk   = 0x7  // Prescaler source of Timer/Counter 1

	// TCCR1C: Timer/Counter 1 Control Register C
	TCCR1C_FOC1A     = 0x80 // Force Output Compare 1A
	TCCR1C_FOC1A_Msk = 0x80 // Force Output Compare 1A
	TCCR1C_FOC1B     = 0x40 // Force Output Compare 1B
	TCCR1C_FOC1B_Msk = 0x40 // Force Output Compare 1B
	TCCR1C_FOC1C     = 0x20 // Force Output Compare 1C
	TCCR1C_FOC1C_Msk = 0x20 // Force Output Compare 1C

	// TIMSK1: Timer/Counter Interrupt Mask Register
	TIMSK1_ICIE1      = 0x20 // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK1_ICIE1_Msk  = 0x20 // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK1_OCIE1C     = 0x8  // Timer/Counter1 Output CompareC Match Interrupt Enable
	TIMSK1_OCIE1C_Msk = 0x8  // Timer/Counter1 Output CompareC Match Interrupt Enable
	TIMSK1_OCIE1B     = 0x4  // Timer/Counter1 Output CompareB Match Interrupt Enable
	TIMSK1_OCIE1B_Msk = 0x4  // Timer/Counter1 Output CompareB Match Interrupt Enable
	TIMSK1_OCIE1A     = 0x2  // Timer/Counter1 Output CompareA Match Interrupt Enable
	TIMSK1_OCIE1A_Msk = 0x2  // Timer/Counter1 Output CompareA Match Interrupt Enable
	TIMSK1_TOIE1      = 0x1  // Timer/Counter1 Overflow Interrupt Enable
	TIMSK1_TOIE1_Msk  = 0x1  // Timer/Counter1 Overflow Interrupt Enable

	// TIFR1: Timer/Counter Interrupt Flag register
	TIFR1_ICF1      = 0x20 // Input Capture Flag 1
	TIFR1_ICF1_Msk  = 0x20 // Input Capture Flag 1
	TIFR1_OCF1C     = 0x8  // Output Compare Flag 1C
	TIFR1_OCF1C_Msk = 0x8  // Output Compare Flag 1C
	TIFR1_OCF1B     = 0x4  // Output Compare Flag 1B
	TIFR1_OCF1B_Msk = 0x4  // Output Compare Flag 1B
	TIFR1_OCF1A     = 0x2  // Output Compare Flag 1A
	TIFR1_OCF1A_Msk = 0x2  // Output Compare Flag 1A
	TIFR1_TOV1      = 0x1  // Timer/Counter1 Overflow Flag
	TIFR1_TOV1_Msk  = 0x1  // Timer/Counter1 Overflow Flag

	// TCCR3A: Timer/Counter3 Control Register A
	TCCR3A_COM3A0    = 0x40 // Compare Output Mode 3A, bits
	TCCR3A_COM3A1    = 0x80 // Compare Output Mode 3A, bits
	TCCR3A_COM3A_Msk = 0xc0 // Compare Output Mode 3A, bits
	TCCR3A_COM3B0    = 0x10 // Compare Output Mode 3B, bits
	TCCR3A_COM3B1    = 0x20 // Compare Output Mode 3B, bits
	TCCR3A_COM3B_Msk = 0x30 // Compare Output Mode 3B, bits
	TCCR3A_COM3C0    = 0x4  // Compare Output Mode 3C, bits
	TCCR3A_COM3C1    = 0x8  // Compare Output Mode 3C, bits
	TCCR3A_COM3C_Msk = 0xc  // Compare Output Mode 3C, bits
	TCCR3A_WGM30     = 0x1  // Waveform Generation Mode
	TCCR3A_WGM31     = 0x2  // Waveform Generation Mode
	TCCR3A_WGM3_Msk  = 0x3  // Waveform Generation Mode

	// TCCR3B: Timer/Counter3 Control Register B
	TCCR3B_ICNC3     = 0x80 // Input Capture 3 Noise Canceler
	TCCR3B_ICNC3_Msk = 0x80 // Input Capture 3 Noise Canceler
	TCCR3B_ICES3     = 0x40 // Input Capture 3 Edge Select
	TCCR3B_ICES3_Msk = 0x40 // Input Capture 3 Edge Select
	TCCR3B_WGM30     = 0x8  // Waveform Generation Mode
	TCCR3B_WGM31     = 0x10 // Waveform Generation Mode
	TCCR3B_WGM3_Msk  = 0x18 // Waveform Generation Mode
	TCCR3B_CS30      = 0x1  // Prescaler source of Timer/Counter 3
	TCCR3B_CS31      = 0x2  // Prescaler source of Timer/Counter 3
	TCCR3B_CS32      = 0x4  // Prescaler source of Timer/Counter 3
	TCCR3B_CS3_Msk   = 0x7  // Prescaler source of Timer/Counter 3

	// TCCR3C: Timer/Counter 3 Control Register C
	TCCR3C_FOC3A     = 0x80 // Force Output Compare 3A
	TCCR3C_FOC3A_Msk = 0x80 // Force Output Compare 3A
	TCCR3C_FOC3B     = 0x40 // Force Output Compare 3B
	TCCR3C_FOC3B_Msk = 0x40 // Force Output Compare 3B
	TCCR3C_FOC3C     = 0x20 // Force Output Compare 3C
	TCCR3C_FOC3C_Msk = 0x20 // Force Output Compare 3C

	// TIMSK3: Timer/Counter Interrupt Mask Register
	TIMSK3_ICIE3      = 0x20 // Timer/Counter3 Input Capture Interrupt Enable
	TIMSK3_ICIE3_Msk  = 0x20 // Timer/Counter3 Input Capture Interrupt Enable
	TIMSK3_OCIE3C     = 0x8  // Timer/Counter3 Output CompareC Match Interrupt Enable
	TIMSK3_OCIE3C_Msk = 0x8  // Timer/Counter3 Output CompareC Match Interrupt Enable
	TIMSK3_OCIE3B     = 0x4  // Timer/Counter3 Output CompareB Match Interrupt Enable
	TIMSK3_OCIE3B_Msk = 0x4  // Timer/Counter3 Output CompareB Match Interrupt Enable
	TIMSK3_OCIE3A     = 0x2  // Timer/Counter3 Output CompareA Match Interrupt Enable
	TIMSK3_OCIE3A_Msk = 0x2  // Timer/Counter3 Output CompareA Match Interrupt Enable
	TIMSK3_TOIE3      = 0x1  // Timer/Counter3 Overflow Interrupt Enable
	TIMSK3_TOIE3_Msk  = 0x1  // Timer/Counter3 Overflow Interrupt Enable

	// TIFR3: Timer/Counter Interrupt Flag register
	TIFR3_ICF3      = 0x20 // Input Capture Flag 3
	TIFR3_ICF3_Msk  = 0x20 // Input Capture Flag 3
	TIFR3_OCF3C     = 0x8  // Output Compare Flag 3C
	TIFR3_OCF3C_Msk = 0x8  // Output Compare Flag 3C
	TIFR3_OCF3B     = 0x4  // Output Compare Flag 3B
	TIFR3_OCF3B_Msk = 0x4  // Output Compare Flag 3B
	TIFR3_OCF3A     = 0x2  // Output Compare Flag 3A
	TIFR3_OCF3A_Msk = 0x2  // Output Compare Flag 3A
	TIFR3_TOV3      = 0x1  // Timer/Counter3 Overflow Flag
	TIFR3_TOV3_Msk  = 0x1  // Timer/Counter3 Overflow Flag
)

// Bitfields for TC8_ASYNC: Timer/Counter, 8-bit Async
const (
	// TCCR2A: Timer/Counter2 Control Register
	TCCR2A_FOC2A     = 0x80 // Force Output Compare
	TCCR2A_FOC2A_Msk = 0x80 // Force Output Compare
	TCCR2A_WGM20     = 0x40 // Waveform Genration Mode
	TCCR2A_WGM20_Msk = 0x40 // Waveform Genration Mode
	TCCR2A_COM2A0    = 0x10 // Compare Output Mode bits
	TCCR2A_COM2A1    = 0x20 // Compare Output Mode bits
	TCCR2A_COM2A_Msk = 0x30 // Compare Output Mode bits
	TCCR2A_WGM21     = 0x8  // Waveform Generation Mode
	TCCR2A_WGM21_Msk = 0x8  // Waveform Generation Mode
	TCCR2A_CS20      = 0x1  // Clock Select bits
	TCCR2A_CS21      = 0x2  // Clock Select bits
	TCCR2A_CS22      = 0x4  // Clock Select bits
	TCCR2A_CS2_Msk   = 0x7  // Clock Select bits

	// TIMSK2: Timer/Counter Interrupt Mask register
	TIMSK2_OCIE2A     = 0x2 // Timer/Counter2 Output Compare Match Interrupt Enable
	TIMSK2_OCIE2A_Msk = 0x2 // Timer/Counter2 Output Compare Match Interrupt Enable
	TIMSK2_TOIE2      = 0x1 // Timer/Counter2 Overflow Interrupt Enable
	TIMSK2_TOIE2_Msk  = 0x1 // Timer/Counter2 Overflow Interrupt Enable

	// TIFR2: Timer/Counter Interrupt Flag Register
	TIFR2_OCF2A     = 0x2 // Output Compare Flag 2
	TIFR2_OCF2A_Msk = 0x2 // Output Compare Flag 2
	TIFR2_TOV2      = 0x1 // Timer/Counter2 Overflow Flag
	TIFR2_TOV2_Msk  = 0x1 // Timer/Counter2 Overflow Flag

	// ASSR: Asynchronous Status Register
	ASSR_EXCLK      = 0x10 // Enable External Clock Interrupt
	ASSR_EXCLK_Msk  = 0x10 // Enable External Clock Interrupt
	ASSR_AS2        = 0x8  // AS2: Asynchronous Timer/Counter2
	ASSR_AS2_Msk    = 0x8  // AS2: Asynchronous Timer/Counter2
	ASSR_TCN2UB     = 0x4  // TCN2UB: Timer/Counter2 Update Busy
	ASSR_TCN2UB_Msk = 0x4  // TCN2UB: Timer/Counter2 Update Busy
	ASSR_OCR2UB     = 0x2  // Output Compare Register2 Update Busy
	ASSR_OCR2UB_Msk = 0x2  // Output Compare Register2 Update Busy
	ASSR_TCR2UB     = 0x1  // TCR2UB: Timer/Counter Control Register2 Update Busy
	ASSR_TCR2UB_Msk = 0x1  // TCR2UB: Timer/Counter Control Register2 Update Busy
)

// Bitfields for WDT: Watchdog Timer
const (
	// WDTCR: Watchdog Timer Control Register
	WDTCR_WDCE     = 0x10 // Watchdog Change Enable
	WDTCR_WDCE_Msk = 0x10 // Watchdog Change Enable
	WDTCR_WDE      = 0x8  // Watch Dog Enable
	WDTCR_WDE_Msk  = 0x8  // Watch Dog Enable
	WDTCR_WDP0     = 0x1  // Watch Dog Timer Prescaler bits
	WDTCR_WDP1     = 0x2  // Watch Dog Timer Prescaler bits
	WDTCR_WDP2     = 0x4  // Watch Dog Timer Prescaler bits
	WDTCR_WDP_Msk  = 0x7  // Watch Dog Timer Prescaler bits
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// ADMUX: The ADC multiplexer Selection Register
	ADMUX_REFS0     = 0x40 // Reference Selection Bits
	ADMUX_REFS1     = 0x80 // Reference Selection Bits
	ADMUX_REFS_Msk  = 0xc0 // Reference Selection Bits
	ADMUX_ADLAR     = 0x20 // Left Adjust Result
	ADMUX_ADLAR_Msk = 0x20 // Left Adjust Result
	ADMUX_MUX0      = 0x1  // Analog Channel and Gain Selection Bits
	ADMUX_MUX1      = 0x2  // Analog Channel and Gain Selection Bits
	ADMUX_MUX2      = 0x4  // Analog Channel and Gain Selection Bits
	ADMUX_MUX3      = 0x8  // Analog Channel and Gain Selection Bits
	ADMUX_MUX4      = 0x10 // Analog Channel and Gain Selection Bits
	ADMUX_MUX_Msk   = 0x1f // Analog Channel and Gain Selection Bits

	// ADCSRA: The ADC Control and Status register
	ADCSRA_ADEN      = 0x80 // ADC Enable
	ADCSRA_ADEN_Msk  = 0x80 // ADC Enable
	ADCSRA_ADSC      = 0x40 // ADC Start Conversion
	ADCSRA_ADSC_Msk  = 0x40 // ADC Start Conversion
	ADCSRA_ADATE     = 0x20 // ADC Auto Trigger Enable
	ADCSRA_ADATE_Msk = 0x20 // ADC Auto Trigger Enable
	ADCSRA_ADIF      = 0x10 // ADC Interrupt Flag
	ADCSRA_ADIF_Msk  = 0x10 // ADC Interrupt Flag
	ADCSRA_ADIE      = 0x8  // ADC Interrupt Enable
	ADCSRA_ADIE_Msk  = 0x8  // ADC Interrupt Enable
	ADCSRA_ADPS0     = 0x1  // ADC  Prescaler Select Bits
	ADCSRA_ADPS1     = 0x2  // ADC  Prescaler Select Bits
	ADCSRA_ADPS2     = 0x4  // ADC  Prescaler Select Bits
	ADCSRA_ADPS_Msk  = 0x7  // ADC  Prescaler Select Bits

	// ADCSRB: ADC Control and Status Register B
	ADCSRB_ADHSM     = 0x80 // ADC High Speed Mode
	ADCSRB_ADHSM_Msk = 0x80 // ADC High Speed Mode
	ADCSRB_ADTS0     = 0x1  // ADC Auto Trigger Sources
	ADCSRB_ADTS1     = 0x2  // ADC Auto Trigger Sources
	ADCSRB_ADTS2     = 0x4  // ADC Auto Trigger Sources
	ADCSRB_ADTS_Msk  = 0x7  // ADC Auto Trigger Sources
	ADCSRB_ACME      = 0x40 // Analog Comparator Multiplexer Enable
	ADCSRB_ACME_Msk  = 0x40 // Analog Comparator Multiplexer Enable

	// DIDR0: Digital Input Disable Register 1
	DIDR0_ADC7D     = 0x80 // ADC7 Digital input Disable
	DIDR0_ADC7D_Msk = 0x80 // ADC7 Digital input Disable
	DIDR0_ADC6D     = 0x40 // ADC6 Digital input Disable
	DIDR0_ADC6D_Msk = 0x40 // ADC6 Digital input Disable
	DIDR0_ADC5D     = 0x20 // ADC5 Digital input Disable
	DIDR0_ADC5D_Msk = 0x20 // ADC5 Digital input Disable
	DIDR0_ADC4D     = 0x10 // ADC4 Digital input Disable
	DIDR0_ADC4D_Msk = 0x10 // ADC4 Digital input Disable
	DIDR0_ADC3D     = 0x8  // ADC3 Digital input Disable
	DIDR0_ADC3D_Msk = 0x8  // ADC3 Digital input Disable
	DIDR0_ADC2D     = 0x4  // ADC2 Digital input Disable
	DIDR0_ADC2D_Msk = 0x4  // ADC2 Digital input Disable
	DIDR0_ADC1D     = 0x2  // ADC1 Digital input Disable
	DIDR0_ADC1D_Msk = 0x2  // ADC1 Digital input Disable
	DIDR0_ADC0D     = 0x1  // ADC0 Digital input Disable
	DIDR0_ADC0D_Msk = 0x1  // ADC0 Digital input Disable
)

// Bitfields for AC: Analog Comparator
const (
	// ACSR: Analog Comparator Control And Status Register
	ACSR_ACD      = 0x80 // Analog Comparator Disable
	ACSR_ACD_Msk  = 0x80 // Analog Comparator Disable
	ACSR_ACBG     = 0x40 // Analog Comparator Bandgap Select
	ACSR_ACBG_Msk = 0x40 // Analog Comparator Bandgap Select
	ACSR_ACO      = 0x20 // Analog Compare Output
	ACSR_ACO_Msk  = 0x20 // Analog Compare Output
	ACSR_ACI      = 0x10 // Analog Comparator Interrupt Flag
	ACSR_ACI_Msk  = 0x10 // Analog Comparator Interrupt Flag
	ACSR_ACIE     = 0x8  // Analog Comparator Interrupt Enable
	ACSR_ACIE_Msk = 0x8  // Analog Comparator Interrupt Enable
	ACSR_ACIC     = 0x4  // Analog Comparator Input Capture Enable
	ACSR_ACIC_Msk = 0x4  // Analog Comparator Input Capture Enable
	ACSR_ACIS0    = 0x1  // Analog Comparator Interrupt Mode Select bits
	ACSR_ACIS1    = 0x2  // Analog Comparator Interrupt Mode Select bits
	ACSR_ACIS_Msk = 0x3  // Analog Comparator Interrupt Mode Select bits

	// DIDR1
	DIDR1_AIN1D     = 0x2 // AIN1 Digital Input Disable
	DIDR1_AIN1D_Msk = 0x2 // AIN1 Digital Input Disable
	DIDR1_AIN0D     = 0x1 // AIN0 Digital Input Disable
	DIDR1_AIN0D_Msk = 0x1 // AIN0 Digital Input Disable
)

// Bitfields for CAN: Controller Area Network
const (
	// CANGCON: CAN General Control Register
	CANGCON_ABRQ       = 0x80 // Abort Request
	CANGCON_ABRQ_Msk   = 0x80 // Abort Request
	CANGCON_OVRQ       = 0x40 // Overload Frame Request
	CANGCON_OVRQ_Msk   = 0x40 // Overload Frame Request
	CANGCON_TTC        = 0x20 // Time Trigger Communication
	CANGCON_TTC_Msk    = 0x20 // Time Trigger Communication
	CANGCON_SYNTTC     = 0x10 // Synchronization of TTC
	CANGCON_SYNTTC_Msk = 0x10 // Synchronization of TTC
	CANGCON_LISTEN     = 0x8  // Listening Mode
	CANGCON_LISTEN_Msk = 0x8  // Listening Mode
	CANGCON_TEST       = 0x4  // Test Mode
	CANGCON_TEST_Msk   = 0x4  // Test Mode
	CANGCON_ENASTB     = 0x2  // Enable / Standby
	CANGCON_ENASTB_Msk = 0x2  // Enable / Standby
	CANGCON_SWRES      = 0x1  // Software Reset Request
	CANGCON_SWRES_Msk  = 0x1  // Software Reset Request

	// CANGSTA: CAN General Status Register
	CANGSTA_OVRG      = 0x40 // Overload Frame Flag
	CANGSTA_OVRG_Msk  = 0x40 // Overload Frame Flag
	CANGSTA_TXBSY     = 0x10 // Transmitter Busy
	CANGSTA_TXBSY_Msk = 0x10 // Transmitter Busy
	CANGSTA_RXBSY     = 0x8  // Receiver Busy
	CANGSTA_RXBSY_Msk = 0x8  // Receiver Busy
	CANGSTA_ENFG      = 0x4  // Enable Flag
	CANGSTA_ENFG_Msk  = 0x4  // Enable Flag
	CANGSTA_BOFF      = 0x2  // Bus Off Mode
	CANGSTA_BOFF_Msk  = 0x2  // Bus Off Mode
	CANGSTA_ERRP      = 0x1  // Error Passive Mode
	CANGSTA_ERRP_Msk  = 0x1  // Error Passive Mode

	// CANGIT: CAN General Interrupt Register
	CANGIT_CANIT      = 0x80 // General Interrupt Flag
	CANGIT_CANIT_Msk  = 0x80 // General Interrupt Flag
	CANGIT_BOFFIT     = 0x40 // Bus Off Interrupt Flag
	CANGIT_BOFFIT_Msk = 0x40 // Bus Off Interrupt Flag
	CANGIT_OVRTIM     = 0x20 // Overrun CAN Timer
	CANGIT_OVRTIM_Msk = 0x20 // Overrun CAN Timer
	CANGIT_BXOK       = 0x10 // Burst Receive Interrupt
	CANGIT_BXOK_Msk   = 0x10 // Burst Receive Interrupt
	CANGIT_SERG       = 0x8  // Stuff Error General
	CANGIT_SERG_Msk   = 0x8  // Stuff Error General
	CANGIT_CERG       = 0x4  // CRC Error General
	CANGIT_CERG_Msk   = 0x4  // CRC Error General
	CANGIT_FERG       = 0x2  // Form Error General
	CANGIT_FERG_Msk   = 0x2  // Form Error General
	CANGIT_AERG       = 0x1  // Ackknowledgement Error General
	CANGIT_AERG_Msk   = 0x1  // Ackknowledgement Error General

	// CANGIE: CAN General Interrupt Enable Register
	CANGIE_ENIT       = 0x80 // Enable all Interrupts
	CANGIE_ENIT_Msk   = 0x80 // Enable all Interrupts
	CANGIE_ENBOFF     = 0x40 // Enable Bus Off INterrupt
	CANGIE_ENBOFF_Msk = 0x40 // Enable Bus Off INterrupt
	CANGIE_ENRX       = 0x20 // Enable Receive Interrupt
	CANGIE_ENRX_Msk   = 0x20 // Enable Receive Interrupt
	CANGIE_ENTX       = 0x10 // Enable Transmitt Interrupt
	CANGIE_ENTX_Msk   = 0x10 // Enable Transmitt Interrupt
	CANGIE_ENERR      = 0x8  // Enable MOb Error Interrupt
	CANGIE_ENERR_Msk  = 0x8  // Enable MOb Error Interrupt
	CANGIE_ENBX       = 0x4  // Enable Burst Receive Interrupt
	CANGIE_ENBX_Msk   = 0x4  // Enable Burst Receive Interrupt
	CANGIE_ENERG      = 0x2  // Enable General Error Interrupt
	CANGIE_ENERG_Msk  = 0x2  // Enable General Error Interrupt
	CANGIE_ENOVRT     = 0x1  // Enable CAN Timer Overrun Interrupt
	CANGIE_ENOVRT_Msk = 0x1  // Enable CAN Timer Overrun Interrupt

	// CANEN2: Enable MOb Register
	CANEN2_ENMOB0    = 0x1  // Enable MOb
	CANEN2_ENMOB1    = 0x2  // Enable MOb
	CANEN2_ENMOB2    = 0x4  // Enable MOb
	CANEN2_ENMOB3    = 0x8  // Enable MOb
	CANEN2_ENMOB4    = 0x10 // Enable MOb
	CANEN2_ENMOB5    = 0x20 // Enable MOb
	CANEN2_ENMOB6    = 0x40 // Enable MOb
	CANEN2_ENMOB7    = 0x80 // Enable MOb
	CANEN2_ENMOB_Msk = 0xff // Enable MOb

	// CANEN1: Enable MOb Register
	CANEN1_ENMOB0    = 0x1  // Enable MOb
	CANEN1_ENMOB1    = 0x2  // Enable MOb
	CANEN1_ENMOB2    = 0x4  // Enable MOb
	CANEN1_ENMOB3    = 0x8  // Enable MOb
	CANEN1_ENMOB4    = 0x10 // Enable MOb
	CANEN1_ENMOB5    = 0x20 // Enable MOb
	CANEN1_ENMOB6    = 0x40 // Enable MOb
	CANEN1_ENMOB_Msk = 0x7f // Enable MOb

	// CANIE2: Enable Interrupt MOb Register
	CANIE2_IEMOB0    = 0x1  // Interrupt Enable by MOb
	CANIE2_IEMOB1    = 0x2  // Interrupt Enable by MOb
	CANIE2_IEMOB2    = 0x4  // Interrupt Enable by MOb
	CANIE2_IEMOB3    = 0x8  // Interrupt Enable by MOb
	CANIE2_IEMOB4    = 0x10 // Interrupt Enable by MOb
	CANIE2_IEMOB5    = 0x20 // Interrupt Enable by MOb
	CANIE2_IEMOB6    = 0x40 // Interrupt Enable by MOb
	CANIE2_IEMOB7    = 0x80 // Interrupt Enable by MOb
	CANIE2_IEMOB_Msk = 0xff // Interrupt Enable by MOb

	// CANIE1: Enable Interrupt MOb Register
	CANIE1_IEMOB0    = 0x1  // Interrupt Enable by MOb
	CANIE1_IEMOB1    = 0x2  // Interrupt Enable by MOb
	CANIE1_IEMOB2    = 0x4  // Interrupt Enable by MOb
	CANIE1_IEMOB3    = 0x8  // Interrupt Enable by MOb
	CANIE1_IEMOB4    = 0x10 // Interrupt Enable by MOb
	CANIE1_IEMOB5    = 0x20 // Interrupt Enable by MOb
	CANIE1_IEMOB6    = 0x40 // Interrupt Enable by MOb
	CANIE1_IEMOB_Msk = 0x7f // Interrupt Enable by MOb

	// CANSIT2: CAN Status Interrupt MOb Register
	CANSIT2_SIT0    = 0x1  // Status of Interrupt by MOb
	CANSIT2_SIT1    = 0x2  // Status of Interrupt by MOb
	CANSIT2_SIT2    = 0x4  // Status of Interrupt by MOb
	CANSIT2_SIT3    = 0x8  // Status of Interrupt by MOb
	CANSIT2_SIT4    = 0x10 // Status of Interrupt by MOb
	CANSIT2_SIT5    = 0x20 // Status of Interrupt by MOb
	CANSIT2_SIT6    = 0x40 // Status of Interrupt by MOb
	CANSIT2_SIT7    = 0x80 // Status of Interrupt by MOb
	CANSIT2_SIT_Msk = 0xff // Status of Interrupt by MOb

	// CANSIT1: CAN Status Interrupt MOb Register
	CANSIT1_SIT0    = 0x1  // Status of Interrupt by MOb
	CANSIT1_SIT1    = 0x2  // Status of Interrupt by MOb
	CANSIT1_SIT2    = 0x4  // Status of Interrupt by MOb
	CANSIT1_SIT3    = 0x8  // Status of Interrupt by MOb
	CANSIT1_SIT4    = 0x10 // Status of Interrupt by MOb
	CANSIT1_SIT5    = 0x20 // Status of Interrupt by MOb
	CANSIT1_SIT6    = 0x40 // Status of Interrupt by MOb
	CANSIT1_SIT_Msk = 0x7f // Status of Interrupt by MOb

	// CANBT1: Bit Timing Register 1
	CANBT1_BRP0    = 0x2  // Baud Rate Prescaler bits
	CANBT1_BRP1    = 0x4  // Baud Rate Prescaler bits
	CANBT1_BRP2    = 0x8  // Baud Rate Prescaler bits
	CANBT1_BRP3    = 0x10 // Baud Rate Prescaler bits
	CANBT1_BRP4    = 0x20 // Baud Rate Prescaler bits
	CANBT1_BRP5    = 0x40 // Baud Rate Prescaler bits
	CANBT1_BRP_Msk = 0x7e // Baud Rate Prescaler bits

	// CANBT2: Bit Timing Register 2
	CANBT2_SJW0    = 0x20 // Re-Sync Jump Width
	CANBT2_SJW1    = 0x40 // Re-Sync Jump Width
	CANBT2_SJW_Msk = 0x60 // Re-Sync Jump Width
	CANBT2_PRS0    = 0x2  // Propagation Time Segment
	CANBT2_PRS1    = 0x4  // Propagation Time Segment
	CANBT2_PRS2    = 0x8  // Propagation Time Segment
	CANBT2_PRS_Msk = 0xe  // Propagation Time Segment

	// CANBT3: Bit Timing Register 3
	CANBT3_PHS20    = 0x10 // Phase Segments
	CANBT3_PHS21    = 0x20 // Phase Segments
	CANBT3_PHS22    = 0x40 // Phase Segments
	CANBT3_PHS2_Msk = 0x70 // Phase Segments
	CANBT3_PHS10    = 0x2  // Phase Segment 1
	CANBT3_PHS11    = 0x4  // Phase Segment 1
	CANBT3_PHS12    = 0x8  // Phase Segment 1
	CANBT3_PHS1_Msk = 0xe  // Phase Segment 1
	CANBT3_SMP      = 0x1  // Sample Type
	CANBT3_SMP_Msk  = 0x1  // Sample Type

	// CANTCON: Timer Control Register
	CANTCON_TPRSC0    = 0x1  // CAN Timer Prescaler
	CANTCON_TPRSC1    = 0x2  // CAN Timer Prescaler
	CANTCON_TPRSC2    = 0x4  // CAN Timer Prescaler
	CANTCON_TPRSC3    = 0x8  // CAN Timer Prescaler
	CANTCON_TPRSC4    = 0x10 // CAN Timer Prescaler
	CANTCON_TPRSC5    = 0x20 // CAN Timer Prescaler
	CANTCON_TPRSC6    = 0x40 // CAN Timer Prescaler
	CANTCON_TPRSC7    = 0x80 // CAN Timer Prescaler
	CANTCON_TPRSC_Msk = 0xff // CAN Timer Prescaler

	// CANTIML: Timer Register

	// CANTIMH: Timer Register
	CANTIM_CANTIM0    = 0x1    // CAN Timer Count
	CANTIM_CANTIM1    = 0x2    // CAN Timer Count
	CANTIM_CANTIM2    = 0x4    // CAN Timer Count
	CANTIM_CANTIM3    = 0x8    // CAN Timer Count
	CANTIM_CANTIM4    = 0x10   // CAN Timer Count
	CANTIM_CANTIM5    = 0x20   // CAN Timer Count
	CANTIM_CANTIM6    = 0x40   // CAN Timer Count
	CANTIM_CANTIM7    = 0x80   // CAN Timer Count
	CANTIM_CANTIM_Msk = 0xffff // CAN Timer Count

	// CANTTCL: TTC Timer Register

	// CANTTCH: TTC Timer Register
	CANTTC_TIMTTC0    = 0x1    // TTC Timer Count
	CANTTC_TIMTTC1    = 0x2    // TTC Timer Count
	CANTTC_TIMTTC2    = 0x4    // TTC Timer Count
	CANTTC_TIMTTC3    = 0x8    // TTC Timer Count
	CANTTC_TIMTTC4    = 0x10   // TTC Timer Count
	CANTTC_TIMTTC5    = 0x20   // TTC Timer Count
	CANTTC_TIMTTC6    = 0x40   // TTC Timer Count
	CANTTC_TIMTTC7    = 0x80   // TTC Timer Count
	CANTTC_TIMTTC_Msk = 0xffff // TTC Timer Count

	// CANTEC: Transmit Error Counter Register
	CANTEC_TEC0    = 0x1  // Trasnmit Error Count
	CANTEC_TEC1    = 0x2  // Trasnmit Error Count
	CANTEC_TEC2    = 0x4  // Trasnmit Error Count
	CANTEC_TEC3    = 0x8  // Trasnmit Error Count
	CANTEC_TEC4    = 0x10 // Trasnmit Error Count
	CANTEC_TEC5    = 0x20 // Trasnmit Error Count
	CANTEC_TEC6    = 0x40 // Trasnmit Error Count
	CANTEC_TEC7    = 0x80 // Trasnmit Error Count
	CANTEC_TEC_Msk = 0xff // Trasnmit Error Count

	// CANREC: Receive Error Counter Register
	CANREC_REC0    = 0x1  // Receive Error Count
	CANREC_REC1    = 0x2  // Receive Error Count
	CANREC_REC2    = 0x4  // Receive Error Count
	CANREC_REC3    = 0x8  // Receive Error Count
	CANREC_REC4    = 0x10 // Receive Error Count
	CANREC_REC5    = 0x20 // Receive Error Count
	CANREC_REC6    = 0x40 // Receive Error Count
	CANREC_REC7    = 0x80 // Receive Error Count
	CANREC_REC_Msk = 0xff // Receive Error Count

	// CANHPMOB: Highest Priority MOb Register
	CANHPMOB_HPMOB0    = 0x10 // Highest Priority MOb number
	CANHPMOB_HPMOB1    = 0x20 // Highest Priority MOb number
	CANHPMOB_HPMOB2    = 0x40 // Highest Priority MOb number
	CANHPMOB_HPMOB3    = 0x80 // Highest Priority MOb number
	CANHPMOB_HPMOB_Msk = 0xf0 // Highest Priority MOb number
	CANHPMOB_CGP0      = 0x1  // CAN General purpose bits
	CANHPMOB_CGP1      = 0x2  // CAN General purpose bits
	CANHPMOB_CGP2      = 0x4  // CAN General purpose bits
	CANHPMOB_CGP3      = 0x8  // CAN General purpose bits
	CANHPMOB_CGP_Msk   = 0xf  // CAN General purpose bits

	// CANPAGE: Page MOb Register
	CANPAGE_MOBNB0    = 0x10 // MOb Number Bits
	CANPAGE_MOBNB1    = 0x20 // MOb Number Bits
	CANPAGE_MOBNB2    = 0x40 // MOb Number Bits
	CANPAGE_MOBNB3    = 0x80 // MOb Number Bits
	CANPAGE_MOBNB_Msk = 0xf0 // MOb Number Bits
	CANPAGE_AINC      = 0x8  // MOb Data Buffer Auto Increment
	CANPAGE_AINC_Msk  = 0x8  // MOb Data Buffer Auto Increment
	CANPAGE_INDX0     = 0x1  // Data Buffer Index Bits
	CANPAGE_INDX1     = 0x2  // Data Buffer Index Bits
	CANPAGE_INDX2     = 0x4  // Data Buffer Index Bits
	CANPAGE_INDX_Msk  = 0x7  // Data Buffer Index Bits

	// CANSTMOB: MOb Status Register
	CANSTMOB_DLCW     = 0x80 // Data Length Code Warning
	CANSTMOB_DLCW_Msk = 0x80 // Data Length Code Warning
	CANSTMOB_TXOK     = 0x40 // Transmit OK
	CANSTMOB_TXOK_Msk = 0x40 // Transmit OK
	CANSTMOB_RXOK     = 0x20 // Receive OK
	CANSTMOB_RXOK_Msk = 0x20 // Receive OK
	CANSTMOB_BERR     = 0x10 // Bit Error
	CANSTMOB_BERR_Msk = 0x10 // Bit Error
	CANSTMOB_SERR     = 0x8  // Stuff Error
	CANSTMOB_SERR_Msk = 0x8  // Stuff Error
	CANSTMOB_CERR     = 0x4  // CRC Error
	CANSTMOB_CERR_Msk = 0x4  // CRC Error
	CANSTMOB_FERR     = 0x2  // Form Error
	CANSTMOB_FERR_Msk = 0x2  // Form Error
	CANSTMOB_AERR     = 0x1  // Ackknowledgement Error
	CANSTMOB_AERR_Msk = 0x1  // Ackknowledgement Error

	// CANCDMOB: MOb Control and DLC Register
	CANCDMOB_CONMOB0    = 0x40 // MOb Config Bits
	CANCDMOB_CONMOB1    = 0x80 // MOb Config Bits
	CANCDMOB_CONMOB_Msk = 0xc0 // MOb Config Bits
	CANCDMOB_RPLV       = 0x20 // Reply Valid
	CANCDMOB_RPLV_Msk   = 0x20 // Reply Valid
	CANCDMOB_IDE        = 0x10 // Identifier Extension
	CANCDMOB_IDE_Msk    = 0x10 // Identifier Extension
	CANCDMOB_DLC0       = 0x1  // Data Length Code Bits
	CANCDMOB_DLC1       = 0x2  // Data Length Code Bits
	CANCDMOB_DLC2       = 0x4  // Data Length Code Bits
	CANCDMOB_DLC3       = 0x8  // Data Length Code Bits
	CANCDMOB_DLC_Msk    = 0xf  // Data Length Code Bits

	// CANIDT4: Identifier Tag Register 4
	CANIDT4_IDT0       = 0x8  // Identifier Tag
	CANIDT4_IDT1       = 0x10 // Identifier Tag
	CANIDT4_IDT2       = 0x20 // Identifier Tag
	CANIDT4_IDT3       = 0x40 // Identifier Tag
	CANIDT4_IDT4       = 0x80 // Identifier Tag
	CANIDT4_IDT_Msk    = 0xf8 // Identifier Tag
	CANIDT4_RTRTAG     = 0x4  // Remote Trasnmission Request Tag
	CANIDT4_RTRTAG_Msk = 0x4  // Remote Trasnmission Request Tag
	CANIDT4_RB1TAG     = 0x2  // Reserved Bit 1 Tag
	CANIDT4_RB1TAG_Msk = 0x2  // Reserved Bit 1 Tag
	CANIDT4_RB0TAG     = 0x1  // Reserved Bit 0 Tag
	CANIDT4_RB0TAG_Msk = 0x1  // Reserved Bit 0 Tag

	// CANIDT3: Identifier Tag Register 3
	CANIDT3_IDT0    = 0x1  // Identifier Tag
	CANIDT3_IDT1    = 0x2  // Identifier Tag
	CANIDT3_IDT2    = 0x4  // Identifier Tag
	CANIDT3_IDT3    = 0x8  // Identifier Tag
	CANIDT3_IDT4    = 0x10 // Identifier Tag
	CANIDT3_IDT5    = 0x20 // Identifier Tag
	CANIDT3_IDT6    = 0x40 // Identifier Tag
	CANIDT3_IDT7    = 0x80 // Identifier Tag
	CANIDT3_IDT_Msk = 0xff // Identifier Tag

	// CANIDT2: Identifier Tag Register 2
	CANIDT2_IDT0    = 0x1  // Identifier Tag
	CANIDT2_IDT1    = 0x2  // Identifier Tag
	CANIDT2_IDT2    = 0x4  // Identifier Tag
	CANIDT2_IDT3    = 0x8  // Identifier Tag
	CANIDT2_IDT4    = 0x10 // Identifier Tag
	CANIDT2_IDT5    = 0x20 // Identifier Tag
	CANIDT2_IDT6    = 0x40 // Identifier Tag
	CANIDT2_IDT7    = 0x80 // Identifier Tag
	CANIDT2_IDT_Msk = 0xff // Identifier Tag

	// CANIDT1: Identifier Tag Register 1
	CANIDT1_IDT0    = 0x1  // Identifier Tag
	CANIDT1_IDT1    = 0x2  // Identifier Tag
	CANIDT1_IDT2    = 0x4  // Identifier Tag
	CANIDT1_IDT3    = 0x8  // Identifier Tag
	CANIDT1_IDT4    = 0x10 // Identifier Tag
	CANIDT1_IDT5    = 0x20 // Identifier Tag
	CANIDT1_IDT6    = 0x40 // Identifier Tag
	CANIDT1_IDT7    = 0x80 // Identifier Tag
	CANIDT1_IDT_Msk = 0xff // Identifier Tag

	// CANIDM4: Identifier Mask Register 4
	CANIDM4_IDMSK0     = 0x8  // Identifier Mask
	CANIDM4_IDMSK1     = 0x10 // Identifier Mask
	CANIDM4_IDMSK2     = 0x20 // Identifier Mask
	CANIDM4_IDMSK3     = 0x40 // Identifier Mask
	CANIDM4_IDMSK4     = 0x80 // Identifier Mask
	CANIDM4_IDMSK_Msk  = 0xf8 // Identifier Mask
	CANIDM4_RTRMSK     = 0x4  // Remote Transmission Request Mask
	CANIDM4_RTRMSK_Msk = 0x4  // Remote Transmission Request Mask
	CANIDM4_IDEMSK     = 0x1  // Identifier Extension Mask
	CANIDM4_IDEMSK_Msk = 0x1  // Identifier Extension Mask

	// CANIDM3: Identifier Mask Register 3
	CANIDM3_IDMSK0    = 0x1  // Identifier Mask
	CANIDM3_IDMSK1    = 0x2  // Identifier Mask
	CANIDM3_IDMSK2    = 0x4  // Identifier Mask
	CANIDM3_IDMSK3    = 0x8  // Identifier Mask
	CANIDM3_IDMSK4    = 0x10 // Identifier Mask
	CANIDM3_IDMSK5    = 0x20 // Identifier Mask
	CANIDM3_IDMSK6    = 0x40 // Identifier Mask
	CANIDM3_IDMSK7    = 0x80 // Identifier Mask
	CANIDM3_IDMSK_Msk = 0xff // Identifier Mask

	// CANIDM2: Identifier Mask Register 2
	CANIDM2_IDMSK0    = 0x1  // Identifier Mask
	CANIDM2_IDMSK1    = 0x2  // Identifier Mask
	CANIDM2_IDMSK2    = 0x4  // Identifier Mask
	CANIDM2_IDMSK3    = 0x8  // Identifier Mask
	CANIDM2_IDMSK4    = 0x10 // Identifier Mask
	CANIDM2_IDMSK5    = 0x20 // Identifier Mask
	CANIDM2_IDMSK6    = 0x40 // Identifier Mask
	CANIDM2_IDMSK7    = 0x80 // Identifier Mask
	CANIDM2_IDMSK_Msk = 0xff // Identifier Mask

	// CANIDM1: Identifier Mask Register 1
	CANIDM1_IDMSK0    = 0x1  // Identifier Mask
	CANIDM1_IDMSK1    = 0x2  // Identifier Mask
	CANIDM1_IDMSK2    = 0x4  // Identifier Mask
	CANIDM1_IDMSK3    = 0x8  // Identifier Mask
	CANIDM1_IDMSK4    = 0x10 // Identifier Mask
	CANIDM1_IDMSK5    = 0x20 // Identifier Mask
	CANIDM1_IDMSK6    = 0x40 // Identifier Mask
	CANIDM1_IDMSK7    = 0x80 // Identifier Mask
	CANIDM1_IDMSK_Msk = 0xff // Identifier Mask

	// CANSTML: Time Stamp Register

	// CANSTMH: Time Stamp Register
	CANSTM_TIMSTM0    = 0x1    // Time Stamp Count
	CANSTM_TIMSTM1    = 0x2    // Time Stamp Count
	CANSTM_TIMSTM2    = 0x4    // Time Stamp Count
	CANSTM_TIMSTM3    = 0x8    // Time Stamp Count
	CANSTM_TIMSTM4    = 0x10   // Time Stamp Count
	CANSTM_TIMSTM5    = 0x20   // Time Stamp Count
	CANSTM_TIMSTM6    = 0x40   // Time Stamp Count
	CANSTM_TIMSTM7    = 0x80   // Time Stamp Count
	CANSTM_TIMSTM_Msk = 0xffff // Time Stamp Count

	// CANMSG: Message Data Register
	CANMSG_MSG0    = 0x1  // Message Data
	CANMSG_MSG1    = 0x2  // Message Data
	CANMSG_MSG2    = 0x4  // Message Data
	CANMSG_MSG3    = 0x8  // Message Data
	CANMSG_MSG4    = 0x10 // Message Data
	CANMSG_MSG5    = 0x20 // Message Data
	CANMSG_MSG6    = 0x40 // Message Data
	CANMSG_MSG7    = 0x80 // Message Data
	CANMSG_MSG_Msk = 0xff // Message Data
)
