/* Autogenerated by mlir-tblgen; don't manually edit */
#ifdef GEN_PASS_CLASSES

//===----------------------------------------------------------------------===//
// BroadcastPropagationPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class BroadcastPropagationPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = BroadcastPropagationPassBase;

  BroadcastPropagationPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  BroadcastPropagationPassBase(const BroadcastPropagationPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("mhlo-broadcast-propagation");
  }
  ::llvm::StringRef getArgument() const override { return "mhlo-broadcast-propagation"; }

  ::llvm::StringRef getDescription() const override { return "Move dynamic broadcasts up over element-wise operations and broadcast the operands rather than the result. This will eventually allow for larger fusions."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("BroadcastPropagationPass");
  }
  ::llvm::StringRef getName() const override { return "BroadcastPropagationPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(BroadcastPropagationPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// ChloLegalizeToHloPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ChloLegalizeToHloPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = ChloLegalizeToHloPassBase;

  ChloLegalizeToHloPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  ChloLegalizeToHloPassBase(const ChloLegalizeToHloPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("chlo-legalize-to-hlo");
  }
  ::llvm::StringRef getArgument() const override { return "chlo-legalize-to-hlo"; }

  ::llvm::StringRef getDescription() const override { return "Legalize CHLO to HLO."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ChloLegalizeToHloPass");
  }
  ::llvm::StringRef getName() const override { return "ChloLegalizeToHloPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ChloLegalizeToHloPassBase<DerivedT>)

protected:
  ::mlir::Pass::Option<bool> legalize_broadcasts_{*this, "legalize-broadcasts", ::llvm::cl::desc("Legalize implicit broadcasts to explicit HLO broadcasting forms"), ::llvm::cl::init(true)};
  ::mlir::Pass::Option<bool> expand_compositions_{*this, "expand-compositions", ::llvm::cl::desc("Expands client-centric compositions to HLO primitives"), ::llvm::cl::init(true)};
};

//===----------------------------------------------------------------------===//
// ChloLegalizeToLinalgPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ChloLegalizeToLinalgPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = ChloLegalizeToLinalgPassBase;

  ChloLegalizeToLinalgPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  ChloLegalizeToLinalgPassBase(const ChloLegalizeToLinalgPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("sparse-chlo-legalize-to-linalg");
  }
  ::llvm::StringRef getArgument() const override { return "sparse-chlo-legalize-to-linalg"; }

  ::llvm::StringRef getDescription() const override { return "Legalize from sparse ops in CHLO dialect to Linalg dialect."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ChloLegalizeToLinalgPass");
  }
  ::llvm::StringRef getName() const override { return "ChloLegalizeToLinalgPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ChloLegalizeToLinalgPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// CollapseElementwiseMapPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class CollapseElementwiseMapPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = CollapseElementwiseMapPassBase;

  CollapseElementwiseMapPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  CollapseElementwiseMapPassBase(const CollapseElementwiseMapPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("mhlo-collapse-elementwise-map");
  }
  ::llvm::StringRef getArgument() const override { return "mhlo-collapse-elementwise-map"; }

  ::llvm::StringRef getDescription() const override { return "Collapse the mhlo.map if the map only has elementwise ops."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("CollapseElementwiseMapPass");
  }
  ::llvm::StringRef getName() const override { return "CollapseElementwiseMapPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(CollapseElementwiseMapPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// ConstraintFusionPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConstraintFusionPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = ConstraintFusionPassBase;

  ConstraintFusionPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConstraintFusionPassBase(const ConstraintFusionPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("constraint-fusion");
  }
  ::llvm::StringRef getArgument() const override { return "constraint-fusion"; }

  ::llvm::StringRef getDescription() const override { return "Fuse shape constraints and merge all assuming regions."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ConstraintFusionPass");
  }
  ::llvm::StringRef getName() const override { return "ConstraintFusionPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ConstraintFusionPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// ConvertToSignlessPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConvertToSignlessPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = ConvertToSignlessPassBase;

  ConvertToSignlessPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertToSignlessPassBase(const ConvertToSignlessPassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("convert-to-signless");
  }
  ::llvm::StringRef getArgument() const override { return "convert-to-signless"; }

  ::llvm::StringRef getDescription() const override { return "Pass to transform the IR to be on signless integers."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ConvertToSignlessPass");
  }
  ::llvm::StringRef getName() const override { return "ConvertToSignlessPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ConvertToSignlessPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// ExpandHloTuplesPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ExpandHloTuplesPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = ExpandHloTuplesPassBase;

  ExpandHloTuplesPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ExpandHloTuplesPassBase(const ExpandHloTuplesPassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("expand-hlo-tuples");
  }
  ::llvm::StringRef getArgument() const override { return "expand-hlo-tuples"; }

  ::llvm::StringRef getDescription() const override { return "Expand HLO tuple for the entry function of the module."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ExpandHloTuplesPass");
  }
  ::llvm::StringRef getName() const override { return "ExpandHloTuplesPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<mhlo::MhloDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ExpandHloTuplesPassBase<DerivedT>)

protected:
  ::mlir::Pass::Option<std::string> entry_function_name_{*this, "entry-function", ::llvm::cl::desc("the name of entry function of the module")};
};

//===----------------------------------------------------------------------===//
// FlattenTuplePass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class FlattenTuplePassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = FlattenTuplePassBase;

  FlattenTuplePassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  FlattenTuplePassBase(const FlattenTuplePassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("mhlo-flatten-tuple");
  }
  ::llvm::StringRef getArgument() const override { return "mhlo-flatten-tuple"; }

  ::llvm::StringRef getDescription() const override { return "Flatten tuples in operands and results of operators that support both tuple and variadic type."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("FlattenTuplePass");
  }
  ::llvm::StringRef getName() const override { return "FlattenTuplePass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(FlattenTuplePassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// GroupReductionDimensionsPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class GroupReductionDimensionsPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = GroupReductionDimensionsPassBase;

  GroupReductionDimensionsPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  GroupReductionDimensionsPassBase(const GroupReductionDimensionsPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("group-reduction-dimensions");
  }
  ::llvm::StringRef getArgument() const override { return "group-reduction-dimensions"; }

  ::llvm::StringRef getDescription() const override { return "Group dimensions of reduction operations"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("GroupReductionDimensionsPass");
  }
  ::llvm::StringRef getName() const override { return "GroupReductionDimensionsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(GroupReductionDimensionsPassBase<DerivedT>)

protected:
  ::mlir::Pass::Option<bool> prefer_columns_reductions_{*this, "prefer-columns-reductions", ::llvm::cl::desc("When simplifying reductions, prefer to use column reductions over row reductions."), ::llvm::cl::init(true)};
};

//===----------------------------------------------------------------------===//
// HloCanonicalizeReductionPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class HloCanonicalizeReductionPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = HloCanonicalizeReductionPassBase;

  HloCanonicalizeReductionPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  HloCanonicalizeReductionPassBase(const HloCanonicalizeReductionPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("hlo-canonicalize-reduction");
  }
  ::llvm::StringRef getArgument() const override { return "hlo-canonicalize-reduction"; }

  ::llvm::StringRef getDescription() const override { return "canonicalize reduction ops to be suitable for codegen."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("HloCanonicalizeReductionPass");
  }
  ::llvm::StringRef getName() const override { return "HloCanonicalizeReductionPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(HloCanonicalizeReductionPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// HloLegalizeShapeComputationsPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class HloLegalizeShapeComputationsPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = HloLegalizeShapeComputationsPassBase;

  HloLegalizeShapeComputationsPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  HloLegalizeShapeComputationsPassBase(const HloLegalizeShapeComputationsPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("hlo-legalize-shape-computations");
  }
  ::llvm::StringRef getArgument() const override { return "hlo-legalize-shape-computations"; }

  ::llvm::StringRef getDescription() const override { return "Legalize HLOs shape operations to core-mlir operations."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("HloLegalizeShapeComputationsPass");
  }
  ::llvm::StringRef getName() const override { return "HloLegalizeShapeComputationsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(HloLegalizeShapeComputationsPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// HloLegalizeShapeOpsToStandardPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class HloLegalizeShapeOpsToStandardPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = HloLegalizeShapeOpsToStandardPassBase;

  HloLegalizeShapeOpsToStandardPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  HloLegalizeShapeOpsToStandardPassBase(const HloLegalizeShapeOpsToStandardPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("hlo-legalize-shapeops-to-standard");
  }
  ::llvm::StringRef getArgument() const override { return "hlo-legalize-shapeops-to-standard"; }

  ::llvm::StringRef getDescription() const override { return "Legalize shape operations from HLO dialect to standard dialect."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("HloLegalizeShapeOpsToStandardPass");
  }
  ::llvm::StringRef getName() const override { return "HloLegalizeShapeOpsToStandardPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(HloLegalizeShapeOpsToStandardPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// HloLegalizeSortPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class HloLegalizeSortPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = HloLegalizeSortPassBase;

  HloLegalizeSortPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  HloLegalizeSortPassBase(const HloLegalizeSortPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("hlo-legalize-sort");
  }
  ::llvm::StringRef getArgument() const override { return "hlo-legalize-sort"; }

  ::llvm::StringRef getDescription() const override { return "Legalize from MHLO sort to SCF control flow."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("HloLegalizeSortPass");
  }
  ::llvm::StringRef getName() const override { return "HloLegalizeSortPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<arith::ArithmeticDialect>();

  registry.insert<scf::SCFDialect>();

  registry.insert<tensor::TensorDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(HloLegalizeSortPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// HloLegalizeToArithmeticPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class HloLegalizeToArithmeticPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = HloLegalizeToArithmeticPassBase;

  HloLegalizeToArithmeticPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  HloLegalizeToArithmeticPassBase(const HloLegalizeToArithmeticPassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("hlo-legalize-to-arithmetic");
  }
  ::llvm::StringRef getArgument() const override { return "hlo-legalize-to-arithmetic"; }

  ::llvm::StringRef getDescription() const override { return "Legalize from HLO dialect to arithmetic dialect."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("HloLegalizeToArithmeticPass");
  }
  ::llvm::StringRef getName() const override { return "HloLegalizeToArithmeticPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(HloLegalizeToArithmeticPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// HloLegalizeToLhloPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class HloLegalizeToLhloPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = HloLegalizeToLhloPassBase;

  HloLegalizeToLhloPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  HloLegalizeToLhloPassBase(const HloLegalizeToLhloPassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("hlo-legalize-to-lhlo");
  }
  ::llvm::StringRef getArgument() const override { return "hlo-legalize-to-lhlo"; }

  ::llvm::StringRef getDescription() const override { return "Legalize from HLO dialect to LHLO dialect."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("HloLegalizeToLhloPass");
  }
  ::llvm::StringRef getName() const override { return "HloLegalizeToLhloPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(HloLegalizeToLhloPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// HloLegalizeToLinalgPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class HloLegalizeToLinalgPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = HloLegalizeToLinalgPassBase;

  HloLegalizeToLinalgPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  HloLegalizeToLinalgPassBase(const HloLegalizeToLinalgPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("hlo-legalize-to-linalg");
  }
  ::llvm::StringRef getArgument() const override { return "hlo-legalize-to-linalg"; }

  ::llvm::StringRef getDescription() const override { return "Legalize from HLO dialect to Linalg dialect."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("HloLegalizeToLinalgPass");
  }
  ::llvm::StringRef getName() const override { return "HloLegalizeToLinalgPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(HloLegalizeToLinalgPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// HloLegalizeToMemrefPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class HloLegalizeToMemrefPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = HloLegalizeToMemrefPassBase;

  HloLegalizeToMemrefPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  HloLegalizeToMemrefPassBase(const HloLegalizeToMemrefPassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("hlo-legalize-to-memref");
  }
  ::llvm::StringRef getArgument() const override { return "hlo-legalize-to-memref"; }

  ::llvm::StringRef getDescription() const override { return "Legalize from HLO dialect to memref dialect."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("HloLegalizeToMemrefPass");
  }
  ::llvm::StringRef getName() const override { return "HloLegalizeToMemrefPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(HloLegalizeToMemrefPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// LegalizeControlFlowPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class LegalizeControlFlowPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = LegalizeControlFlowPassBase;

  LegalizeControlFlowPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  LegalizeControlFlowPassBase(const LegalizeControlFlowPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("mhlo-legalize-control-flow");
  }
  ::llvm::StringRef getArgument() const override { return "mhlo-legalize-control-flow"; }

  ::llvm::StringRef getDescription() const override { return "Legalize from MHLO control flow to SCF control flow."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("LegalizeControlFlowPass");
  }
  ::llvm::StringRef getName() const override { return "LegalizeControlFlowPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<scf::SCFDialect>();

  registry.insert<tensor::TensorDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(LegalizeControlFlowPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// LegalizeEinsumToDotGeneralPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class LegalizeEinsumToDotGeneralPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = LegalizeEinsumToDotGeneralPassBase;

  LegalizeEinsumToDotGeneralPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  LegalizeEinsumToDotGeneralPassBase(const LegalizeEinsumToDotGeneralPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("mhlo-legalize-einsum-to-dot-general");
  }
  ::llvm::StringRef getArgument() const override { return "mhlo-legalize-einsum-to-dot-general"; }

  ::llvm::StringRef getDescription() const override { return "Legalizes einsum ops to dot_general ops."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("LegalizeEinsumToDotGeneralPass");
  }
  ::llvm::StringRef getName() const override { return "LegalizeEinsumToDotGeneralPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(LegalizeEinsumToDotGeneralPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// LegalizeGatherToTorchIndexSelectPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class LegalizeGatherToTorchIndexSelectPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = LegalizeGatherToTorchIndexSelectPassBase;

  LegalizeGatherToTorchIndexSelectPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  LegalizeGatherToTorchIndexSelectPassBase(const LegalizeGatherToTorchIndexSelectPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("mhlo-legalize-gather-to-torch-index-select");
  }
  ::llvm::StringRef getArgument() const override { return "mhlo-legalize-gather-to-torch-index-select"; }

  ::llvm::StringRef getDescription() const override { return "Legalizes gathers to a torch index select."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("LegalizeGatherToTorchIndexSelectPass");
  }
  ::llvm::StringRef getName() const override { return "LegalizeGatherToTorchIndexSelectPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(LegalizeGatherToTorchIndexSelectPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// LegalizeGeneralDotPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class LegalizeGeneralDotPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = LegalizeGeneralDotPassBase;

  LegalizeGeneralDotPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  LegalizeGeneralDotPassBase(const LegalizeGeneralDotPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("mhlo-test-lower-general-dot");
  }
  ::llvm::StringRef getArgument() const override { return "mhlo-test-lower-general-dot"; }

  ::llvm::StringRef getDescription() const override { return "Tests lowering general dot to a non-batched dot when possible."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("LegalizeGeneralDotPass");
  }
  ::llvm::StringRef getName() const override { return "LegalizeGeneralDotPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(LegalizeGeneralDotPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// LegalizeTanhToApproximationPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class LegalizeTanhToApproximationPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = LegalizeTanhToApproximationPassBase;

  LegalizeTanhToApproximationPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  LegalizeTanhToApproximationPassBase(const LegalizeTanhToApproximationPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("mhlo-legalize-trigonometric-to-approximation");
  }
  ::llvm::StringRef getArgument() const override { return "mhlo-legalize-trigonometric-to-approximation"; }

  ::llvm::StringRef getDescription() const override { return "Legalize trigonometric operations from standard dialect to an approximation."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("LegalizeTanhToApproximationPass");
  }
  ::llvm::StringRef getName() const override { return "LegalizeTanhToApproximationPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(LegalizeTanhToApproximationPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// LegalizeToStandardPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class LegalizeToStandardPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = LegalizeToStandardPassBase;

  LegalizeToStandardPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  LegalizeToStandardPassBase(const LegalizeToStandardPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("mhlo-legalize-to-std");
  }
  ::llvm::StringRef getArgument() const override { return "mhlo-legalize-to-std"; }

  ::llvm::StringRef getDescription() const override { return "Legalize from MHLO dialect to standard dialect."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("LegalizeToStandardPass");
  }
  ::llvm::StringRef getName() const override { return "LegalizeToStandardPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(LegalizeToStandardPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// LowerComplexPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class LowerComplexPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = LowerComplexPassBase;

  LowerComplexPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  LowerComplexPassBase(const LowerComplexPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("mhlo-test-lower-complex");
  }
  ::llvm::StringRef getArgument() const override { return "mhlo-test-lower-complex"; }

  ::llvm::StringRef getDescription() const override { return "Lower complex operations into non-complex operations."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("LowerComplexPass");
  }
  ::llvm::StringRef getName() const override { return "LowerComplexPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(LowerComplexPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// MergeAssumingOpsPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class MergeAssumingOpsPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = MergeAssumingOpsPassBase;

  MergeAssumingOpsPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  MergeAssumingOpsPassBase(const MergeAssumingOpsPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("mhlo-merge-assuming-ops");
  }
  ::llvm::StringRef getArgument() const override { return "mhlo-merge-assuming-ops"; }

  ::llvm::StringRef getDescription() const override { return "Prepare moving dynamic broadcasts up over element-wise operations and broadcast the operands rather than the result. This will eventually allow for larger fusions."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("MergeAssumingOpsPass");
  }
  ::llvm::StringRef getName() const override { return "MergeAssumingOpsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(MergeAssumingOpsPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// OptimizeMhloPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class OptimizeMhloPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = OptimizeMhloPassBase;

  OptimizeMhloPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  OptimizeMhloPassBase(const OptimizeMhloPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("mhlo-test-optimize");
  }
  ::llvm::StringRef getArgument() const override { return "mhlo-test-optimize"; }

  ::llvm::StringRef getDescription() const override { return "Run optional HLO optimizations."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("OptimizeMhloPass");
  }
  ::llvm::StringRef getName() const override { return "OptimizeMhloPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(OptimizeMhloPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// RankSpecializationClusterPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class RankSpecializationClusterPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = RankSpecializationClusterPassBase;

  RankSpecializationClusterPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  RankSpecializationClusterPassBase(const RankSpecializationClusterPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("mhlo-rank-specialization-cluster");
  }
  ::llvm::StringRef getArgument() const override { return "mhlo-rank-specialization-cluster"; }

  ::llvm::StringRef getDescription() const override { return ""; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("RankSpecializationClusterPass");
  }
  ::llvm::StringRef getName() const override { return "RankSpecializationClusterPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(RankSpecializationClusterPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// RankSpecializationToSCFPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class RankSpecializationToSCFPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = RankSpecializationToSCFPassBase;

  RankSpecializationToSCFPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  RankSpecializationToSCFPassBase(const RankSpecializationToSCFPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("mhlo-rank-specialization-to-scf");
  }
  ::llvm::StringRef getArgument() const override { return "mhlo-rank-specialization-to-scf"; }

  ::llvm::StringRef getDescription() const override { return ""; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("RankSpecializationToSCFPass");
  }
  ::llvm::StringRef getName() const override { return "RankSpecializationToSCFPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(RankSpecializationToSCFPassBase<DerivedT>)

protected:
  ::mlir::Pass::Option<int> max_target_rank_{*this, "max-target-rank", ::llvm::cl::desc("The maximum supported rank after rank specialization. Any argument of greater rank may result in a runtime failure."), ::llvm::cl::init(8)};
};

//===----------------------------------------------------------------------===//
// RestrictMaxRankPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class RestrictMaxRankPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = RestrictMaxRankPassBase;

  RestrictMaxRankPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  RestrictMaxRankPassBase(const RestrictMaxRankPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("mhlo-restrict-max-rank");
  }
  ::llvm::StringRef getArgument() const override { return "mhlo-restrict-max-rank"; }

  ::llvm::StringRef getDescription() const override { return "Restrict maximum rank of any of the intermediate tensors"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("RestrictMaxRankPass");
  }
  ::llvm::StringRef getName() const override { return "RestrictMaxRankPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(RestrictMaxRankPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// ShapeReificationPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ShapeReificationPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = ShapeReificationPassBase;

  ShapeReificationPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  ShapeReificationPassBase(const ShapeReificationPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("shape-reification");
  }
  ::llvm::StringRef getArgument() const override { return "shape-reification"; }

  ::llvm::StringRef getDescription() const override { return "Iteratively reify all shape computations."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ShapeReificationPass");
  }
  ::llvm::StringRef getName() const override { return "ShapeReificationPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ShapeReificationPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// SinkConstantsToControlFlowPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class SinkConstantsToControlFlowPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = SinkConstantsToControlFlowPassBase;

  SinkConstantsToControlFlowPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  SinkConstantsToControlFlowPassBase(const SinkConstantsToControlFlowPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("mhlo-sink-constants-to-control-flow");
  }
  ::llvm::StringRef getArgument() const override { return "mhlo-sink-constants-to-control-flow"; }

  ::llvm::StringRef getDescription() const override { return "Sink constants implicitly captured in control flow regions. This is necessary to export to XLA."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SinkConstantsToControlFlowPass");
  }
  ::llvm::StringRef getName() const override { return "SinkConstantsToControlFlowPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SinkConstantsToControlFlowPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// SparseRewritingPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class SparseRewritingPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = SparseRewritingPassBase;

  SparseRewritingPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  SparseRewritingPassBase(const SparseRewritingPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("mhlo-sparse-rewriting");
  }
  ::llvm::StringRef getArgument() const override { return "mhlo-sparse-rewriting"; }

  ::llvm::StringRef getDescription() const override { return "Pass to rewrite mhlo sparse tensor types."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SparseRewritingPass");
  }
  ::llvm::StringRef getName() const override { return "SparseRewritingPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SparseRewritingPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// TestInferShapedTypeMethodsPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TestInferShapedTypeMethodsPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = TestInferShapedTypeMethodsPassBase;

  TestInferShapedTypeMethodsPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  TestInferShapedTypeMethodsPassBase(const TestInferShapedTypeMethodsPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("mhlo-test-infer-shaped-type-methods");
  }
  ::llvm::StringRef getArgument() const override { return "mhlo-test-infer-shaped-type-methods"; }

  ::llvm::StringRef getDescription() const override { return "Uses test ops to invoke InferShapedTypeOpInterface methods."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TestInferShapedTypeMethodsPass");
  }
  ::llvm::StringRef getName() const override { return "TestInferShapedTypeMethodsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TestInferShapedTypeMethodsPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// TestMaterializeBroadcastsPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TestMaterializeBroadcastsPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = TestMaterializeBroadcastsPassBase;

  TestMaterializeBroadcastsPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  TestMaterializeBroadcastsPassBase(const TestMaterializeBroadcastsPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("mhlo-test-materialize-broadcasts");
  }
  ::llvm::StringRef getArgument() const override { return "mhlo-test-materialize-broadcasts"; }

  ::llvm::StringRef getDescription() const override { return "Test pass for materializing 'broadcast_dimensions' attributes."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TestMaterializeBroadcastsPass");
  }
  ::llvm::StringRef getName() const override { return "TestMaterializeBroadcastsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TestMaterializeBroadcastsPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// TestUnfuseBatchNormPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TestUnfuseBatchNormPassBase : public ::mlir::OperationPass<func::FuncOp> {
public:
  using Base = TestUnfuseBatchNormPassBase;

  TestUnfuseBatchNormPassBase() : ::mlir::OperationPass<func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  TestUnfuseBatchNormPassBase(const TestUnfuseBatchNormPassBase &other) : ::mlir::OperationPass<func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("mhlo-test-unfuse-batch-norm");
  }
  ::llvm::StringRef getArgument() const override { return "mhlo-test-unfuse-batch-norm"; }

  ::llvm::StringRef getDescription() const override { return "Test pass for materializing 'broadcast_dimensions' attributes."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TestUnfuseBatchNormPass");
  }
  ::llvm::StringRef getName() const override { return "TestUnfuseBatchNormPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<arith::ArithmeticDialect>();

  registry.insert<shape::ShapeDialect>();

  registry.insert<tensor::TensorDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TestUnfuseBatchNormPassBase<DerivedT>)

protected:
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// BroadcastPropagationPass Registration
//===----------------------------------------------------------------------===//

inline void registerBroadcastPropagationPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createBroadcastPropagationPass();
  });
}

//===----------------------------------------------------------------------===//
// ChloLegalizeToHloPass Registration
//===----------------------------------------------------------------------===//

inline void registerChloLegalizeToHloPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createChloLegalizeToHloPass();
  });
}

//===----------------------------------------------------------------------===//
// ChloLegalizeToLinalgPass Registration
//===----------------------------------------------------------------------===//

inline void registerChloLegalizeToLinalgPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createLegalizeSparseChloToLinalgPass();
  });
}

//===----------------------------------------------------------------------===//
// CollapseElementwiseMapPass Registration
//===----------------------------------------------------------------------===//

inline void registerCollapseElementwiseMapPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createCollapseElementwiseMapPass();
  });
}

//===----------------------------------------------------------------------===//
// ConstraintFusionPass Registration
//===----------------------------------------------------------------------===//

inline void registerConstraintFusionPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createConstraintFusionPass();
  });
}

//===----------------------------------------------------------------------===//
// ConvertToSignlessPass Registration
//===----------------------------------------------------------------------===//

inline void registerConvertToSignlessPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createConvertToSignlessPass();
  });
}

//===----------------------------------------------------------------------===//
// ExpandHloTuplesPass Registration
//===----------------------------------------------------------------------===//

inline void registerExpandHloTuplesPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createExpandHloTuplesPass();
  });
}

//===----------------------------------------------------------------------===//
// FlattenTuplePass Registration
//===----------------------------------------------------------------------===//

inline void registerFlattenTuplePassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createFlattenTuplePass();
  });
}

//===----------------------------------------------------------------------===//
// GroupReductionDimensionsPass Registration
//===----------------------------------------------------------------------===//

inline void registerGroupReductionDimensionsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createGroupReductionDimensionsPass();
  });
}

//===----------------------------------------------------------------------===//
// HloCanonicalizeReductionPass Registration
//===----------------------------------------------------------------------===//

inline void registerHloCanonicalizeReductionPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createHloCanonicalizeReductionPass();
  });
}

//===----------------------------------------------------------------------===//
// HloLegalizeShapeComputationsPass Registration
//===----------------------------------------------------------------------===//

inline void registerHloLegalizeShapeComputationsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createLegalizeShapeComputationsPass();
  });
}

//===----------------------------------------------------------------------===//
// HloLegalizeShapeOpsToStandardPass Registration
//===----------------------------------------------------------------------===//

inline void registerHloLegalizeShapeOpsToStandardPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createLegalizeHloShapeOpsToStandardPass();
  });
}

//===----------------------------------------------------------------------===//
// HloLegalizeSortPass Registration
//===----------------------------------------------------------------------===//

inline void registerHloLegalizeSortPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createLegalizeSortPass();
  });
}

//===----------------------------------------------------------------------===//
// HloLegalizeToArithmeticPass Registration
//===----------------------------------------------------------------------===//

inline void registerHloLegalizeToArithmeticPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createLegalizeToArithmeticPass();
  });
}

//===----------------------------------------------------------------------===//
// HloLegalizeToLhloPass Registration
//===----------------------------------------------------------------------===//

inline void registerHloLegalizeToLhloPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createLegalizeToLhloPass();
  });
}

//===----------------------------------------------------------------------===//
// HloLegalizeToLinalgPass Registration
//===----------------------------------------------------------------------===//

inline void registerHloLegalizeToLinalgPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createLegalizeHloToLinalgPass();
  });
}

//===----------------------------------------------------------------------===//
// HloLegalizeToMemrefPass Registration
//===----------------------------------------------------------------------===//

inline void registerHloLegalizeToMemrefPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createLegalizeToMemrefPass();
  });
}

//===----------------------------------------------------------------------===//
// LegalizeControlFlowPass Registration
//===----------------------------------------------------------------------===//

inline void registerLegalizeControlFlowPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createLegalizeControlFlowPass();
  });
}

//===----------------------------------------------------------------------===//
// LegalizeEinsumToDotGeneralPass Registration
//===----------------------------------------------------------------------===//

inline void registerLegalizeEinsumToDotGeneralPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createLegalizeEinsumToDotGeneralPass();
  });
}

//===----------------------------------------------------------------------===//
// LegalizeGatherToTorchIndexSelectPass Registration
//===----------------------------------------------------------------------===//

inline void registerLegalizeGatherToTorchIndexSelectPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createLegalizeGatherToTorchIndexSelectPass();
  });
}

//===----------------------------------------------------------------------===//
// LegalizeGeneralDotPass Registration
//===----------------------------------------------------------------------===//

inline void registerLegalizeGeneralDotPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createLegalizeGeneralDotPass();
  });
}

//===----------------------------------------------------------------------===//
// LegalizeTanhToApproximationPass Registration
//===----------------------------------------------------------------------===//

inline void registerLegalizeTanhToApproximationPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createLegalizeTrigonometricToApproximationPass();
  });
}

//===----------------------------------------------------------------------===//
// LegalizeToStandardPass Registration
//===----------------------------------------------------------------------===//

inline void registerLegalizeToStandardPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createLegalizeToStdPass();
  });
}

//===----------------------------------------------------------------------===//
// LowerComplexPass Registration
//===----------------------------------------------------------------------===//

inline void registerLowerComplexPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createLowerComplexPass();
  });
}

//===----------------------------------------------------------------------===//
// MergeAssumingOpsPass Registration
//===----------------------------------------------------------------------===//

inline void registerMergeAssumingOpsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createMergeAssumingOpsPass();
  });
}

//===----------------------------------------------------------------------===//
// OptimizeMhloPass Registration
//===----------------------------------------------------------------------===//

inline void registerOptimizeMhloPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createOptimizeMhloPass();
  });
}

//===----------------------------------------------------------------------===//
// RankSpecializationClusterPass Registration
//===----------------------------------------------------------------------===//

inline void registerRankSpecializationClusterPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createRankSpecializationClusterPass();
  });
}

//===----------------------------------------------------------------------===//
// RankSpecializationToSCFPass Registration
//===----------------------------------------------------------------------===//

inline void registerRankSpecializationToSCFPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createRankSpecializationToSCFPass();
  });
}

//===----------------------------------------------------------------------===//
// RestrictMaxRankPass Registration
//===----------------------------------------------------------------------===//

inline void registerRestrictMaxRankPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createRestrictMaxRankPass();
  });
}

//===----------------------------------------------------------------------===//
// ShapeReificationPass Registration
//===----------------------------------------------------------------------===//

inline void registerShapeReificationPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createShapeReificationPass();
  });
}

//===----------------------------------------------------------------------===//
// SinkConstantsToControlFlowPass Registration
//===----------------------------------------------------------------------===//

inline void registerSinkConstantsToControlFlowPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createSinkConstantsToControlFlowPass();
  });
}

//===----------------------------------------------------------------------===//
// SparseRewritingPass Registration
//===----------------------------------------------------------------------===//

inline void registerSparseRewritingPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createSparseRewritingPass();
  });
}

//===----------------------------------------------------------------------===//
// TestInferShapedTypeMethodsPass Registration
//===----------------------------------------------------------------------===//

inline void registerTestInferShapedTypeMethodsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTestInferShapedTypeMethodsPass();
  });
}

//===----------------------------------------------------------------------===//
// TestMaterializeBroadcastsPass Registration
//===----------------------------------------------------------------------===//

inline void registerTestMaterializeBroadcastsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTestMaterializeBroadcastsPass();
  });
}

//===----------------------------------------------------------------------===//
// TestUnfuseBatchNormPass Registration
//===----------------------------------------------------------------------===//

inline void registerTestUnfuseBatchNormPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTestUnfuseBatchNormPass();
  });
}

//===----------------------------------------------------------------------===//
// MHLO Registration
//===----------------------------------------------------------------------===//

inline void registerMHLOPasses() {
  registerBroadcastPropagationPassPass();
  registerChloLegalizeToHloPassPass();
  registerChloLegalizeToLinalgPassPass();
  registerCollapseElementwiseMapPassPass();
  registerConstraintFusionPassPass();
  registerConvertToSignlessPassPass();
  registerExpandHloTuplesPassPass();
  registerFlattenTuplePassPass();
  registerGroupReductionDimensionsPassPass();
  registerHloCanonicalizeReductionPassPass();
  registerHloLegalizeShapeComputationsPassPass();
  registerHloLegalizeShapeOpsToStandardPassPass();
  registerHloLegalizeSortPassPass();
  registerHloLegalizeToArithmeticPassPass();
  registerHloLegalizeToLhloPassPass();
  registerHloLegalizeToLinalgPassPass();
  registerHloLegalizeToMemrefPassPass();
  registerLegalizeControlFlowPassPass();
  registerLegalizeEinsumToDotGeneralPassPass();
  registerLegalizeGatherToTorchIndexSelectPassPass();
  registerLegalizeGeneralDotPassPass();
  registerLegalizeTanhToApproximationPassPass();
  registerLegalizeToStandardPassPass();
  registerLowerComplexPassPass();
  registerMergeAssumingOpsPassPass();
  registerOptimizeMhloPassPass();
  registerRankSpecializationClusterPassPass();
  registerRankSpecializationToSCFPassPass();
  registerRestrictMaxRankPassPass();
  registerShapeReificationPassPass();
  registerSinkConstantsToControlFlowPassPass();
  registerSparseRewritingPassPass();
  registerTestInferShapedTypeMethodsPassPass();
  registerTestMaterializeBroadcastsPassPass();
  registerTestUnfuseBatchNormPassPass();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
