/* Autogenerated by mlir-tblgen; don't manually edit */
#ifdef GEN_PASS_CLASSES

//===----------------------------------------------------------------------===//
// AddDefaultAttrs
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class AddDefaultAttrsBase : public ::mlir::OperationPass<> {
public:
  using Base = AddDefaultAttrsBase;

  AddDefaultAttrsBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  AddDefaultAttrsBase(const AddDefaultAttrsBase &other) : ::mlir::OperationPass<>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tfg-add-default-attrs");
  }
  ::llvm::StringRef getArgument() const override { return "tfg-add-default-attrs"; }

  ::llvm::StringRef getDescription() const override { return "Add default-valued attributes to the graph"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("AddDefaultAttrs");
  }
  ::llvm::StringRef getName() const override { return "AddDefaultAttrs"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(AddDefaultAttrsBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// CSEPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class CSEPassBase : public ::mlir::OperationPass<GraphFuncOp> {
public:
  using Base = CSEPassBase;

  CSEPassBase() : ::mlir::OperationPass<GraphFuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  CSEPassBase(const CSEPassBase &other) : ::mlir::OperationPass<GraphFuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tfg-cse");
  }
  ::llvm::StringRef getArgument() const override { return "tfg-cse"; }

  ::llvm::StringRef getDescription() const override { return "Common sub-expression elimination, ignoring op names"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("CSEPass");
  }
  ::llvm::StringRef getName() const override { return "CSEPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(CSEPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// ConsolidateAttributes
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConsolidateAttributesBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = ConsolidateAttributesBase;

  ConsolidateAttributesBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConsolidateAttributesBase(const ConsolidateAttributesBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tfg-consolidate-attrs");
  }
  ::llvm::StringRef getArgument() const override { return "tfg-consolidate-attrs"; }

  ::llvm::StringRef getDescription() const override { return "Reify type data from attributes to types."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ConsolidateAttributes");
  }
  ::llvm::StringRef getName() const override { return "ConsolidateAttributes"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ConsolidateAttributesBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// ConstantFoldingPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ConstantFoldingPassBase : public ::mlir::OperationPass<GraphFuncOp> {
public:
  using Base = ConstantFoldingPassBase;

  ConstantFoldingPassBase() : ::mlir::OperationPass<GraphFuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConstantFoldingPassBase(const ConstantFoldingPassBase &other) : ::mlir::OperationPass<GraphFuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tfg-constant-folding");
  }
  ::llvm::StringRef getArgument() const override { return "tfg-constant-folding"; }

  ::llvm::StringRef getDescription() const override { return "constant-folding on tfg"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ConstantFoldingPass");
  }
  ::llvm::StringRef getName() const override { return "ConstantFoldingPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ConstantFoldingPassBase<DerivedT>)

protected:
  ::mlir::Pass::ListOption<std::string> nodes_to_preserve_{*this, "nodes-to-preserve", ::llvm::cl::desc("Comma separated list of ops that won't be optimized."), llvm::cl::ZeroOrMore};
  ::mlir::Pass::ListOption<std::string> feeds_{*this, "feeds", ::llvm::cl::desc("Comma separated list of feed ops."), llvm::cl::ZeroOrMore};
  ::mlir::Pass::ListOption<std::string> fetches_{*this, "fetches", ::llvm::cl::desc("Comma separated list of fetch ops."), llvm::cl::ZeroOrMore};
  ::mlir::Pass::Option<bool> disable_compressed_tensor_optimization_{*this, "disable-compressed-tensor-optimization", ::llvm::cl::desc("Determine if we should disable compressed tensor optimization"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> fold_quantization_emulation_{*this, "fold-quantization-emulation", ::llvm::cl::desc("Determine if we should fold quantization emulation ops"), ::llvm::cl::init(true)};
  ::mlir::Pass::Option<int> pattern_category_{*this, "pattern-category", ::llvm::cl::desc("Select the pattern kind that we would like to run:0 = all patterns, 1 = folder patterns, 2 = propagation patterns"), ::llvm::cl::init(0)};
};

//===----------------------------------------------------------------------===//
// ControlFlowSink
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ControlFlowSinkBase : public ::mlir::OperationPass<GraphFuncOp> {
public:
  using Base = ControlFlowSinkBase;

  ControlFlowSinkBase() : ::mlir::OperationPass<GraphFuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  ControlFlowSinkBase(const ControlFlowSinkBase &other) : ::mlir::OperationPass<GraphFuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tfg-cf-sink");
  }
  ::llvm::StringRef getArgument() const override { return "tfg-cf-sink"; }

  ::llvm::StringRef getDescription() const override { return "Perform control-flow sink on region-based control-flow ops."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ControlFlowSink");
  }
  ::llvm::StringRef getName() const override { return "ControlFlowSink"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ControlFlowSinkBase<DerivedT>)

protected:
  ::mlir::Pass::Statistic num_sunk{this, "num-sunk", "Number of operations sunk"};
};

//===----------------------------------------------------------------------===//
// DedupeAndHoistConstant
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class DedupeAndHoistConstantBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = DedupeAndHoistConstantBase;

  DedupeAndHoistConstantBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  DedupeAndHoistConstantBase(const DedupeAndHoistConstantBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tfg-dedupe-hoist-constant");
  }
  ::llvm::StringRef getArgument() const override { return "tfg-dedupe-hoist-constant"; }

  ::llvm::StringRef getDescription() const override { return "Dedupe and hoist constants"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("DedupeAndHoistConstant");
  }
  ::llvm::StringRef getName() const override { return "DedupeAndHoistConstant"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(DedupeAndHoistConstantBase<DerivedT>)

protected:
  ::mlir::Pass::Option<int64_t> max_size_{*this, "max-size", ::llvm::cl::desc("The maximum number of elements when considering whether a constant is small"), ::llvm::cl::init(10)};
  ::mlir::Pass::Option<bool> assume_strict_calls_{*this, "assume-strict-calls", ::llvm::cl::desc("Assume all function calls are stricts, that is operands are evaluated prior to the call"), ::llvm::cl::init(false)};
};

//===----------------------------------------------------------------------===//
// DropOutputShapesAttr
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class DropOutputShapesAttrBase : public ::mlir::OperationPass<> {
public:
  using Base = DropOutputShapesAttrBase;

  DropOutputShapesAttrBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  DropOutputShapesAttrBase(const DropOutputShapesAttrBase &other) : ::mlir::OperationPass<>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tfg-drop-unregistered-output-shapes");
  }
  ::llvm::StringRef getArgument() const override { return "tfg-drop-unregistered-output-shapes"; }

  ::llvm::StringRef getDescription() const override { return "Drop _output_shapes attribute"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("DropOutputShapesAttr");
  }
  ::llvm::StringRef getName() const override { return "DropOutputShapesAttr"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(DropOutputShapesAttrBase<DerivedT>)

protected:
  ::mlir::Pass::ListOption<std::string> skip_{*this, "skip", ::llvm::cl::desc("Comma separated list of ops that will be skipped.")};
};

//===----------------------------------------------------------------------===//
// EliminatePassthroughIterArgs
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class EliminatePassthroughIterArgsBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = EliminatePassthroughIterArgsBase;

  EliminatePassthroughIterArgsBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  EliminatePassthroughIterArgsBase(const EliminatePassthroughIterArgsBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tfg-eliminate-passthrough-iter-args");
  }
  ::llvm::StringRef getArgument() const override { return "tfg-eliminate-passthrough-iter-args"; }

  ::llvm::StringRef getDescription() const override { return "Eliminate passthrough loop iteration arguments."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("EliminatePassthroughIterArgs");
  }
  ::llvm::StringRef getName() const override { return "EliminatePassthroughIterArgs"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<tfg::TFGraphDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(EliminatePassthroughIterArgsBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// FuncToGraph
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class FuncToGraphBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = FuncToGraphBase;

  FuncToGraphBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  FuncToGraphBase(const FuncToGraphBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tfg-lower-func-to-graph");
  }
  ::llvm::StringRef getArgument() const override { return "tfg-lower-func-to-graph"; }

  ::llvm::StringRef getDescription() const override { return "Turns a function back to a graph"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("FuncToGraph");
  }
  ::llvm::StringRef getName() const override { return "FuncToGraph"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(FuncToGraphBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// FunctionalToRegion
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class FunctionalToRegionBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = FunctionalToRegionBase;

  FunctionalToRegionBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  FunctionalToRegionBase(const FunctionalToRegionBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tfg-functional-to-region");
  }
  ::llvm::StringRef getArgument() const override { return "tfg-functional-to-region"; }

  ::llvm::StringRef getDescription() const override { return "Convert functional control-flow ops to region-based."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("FunctionalToRegion");
  }
  ::llvm::StringRef getName() const override { return "FunctionalToRegion"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<tfg::TFGraphDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(FunctionalToRegionBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// GraphToFunc
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class GraphToFuncBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = GraphToFuncBase;

  GraphToFuncBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  GraphToFuncBase(const GraphToFuncBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tfg-lift-graph-to-func");
  }
  ::llvm::StringRef getArgument() const override { return "tfg-lift-graph-to-func"; }

  ::llvm::StringRef getDescription() const override { return "Turns a graph into a function."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("GraphToFunc");
  }
  ::llvm::StringRef getName() const override { return "GraphToFunc"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(GraphToFuncBase<DerivedT>)

protected:
  ::mlir::Pass::ListOption<std::string> feeds_{*this, "feeds", ::llvm::cl::desc("Comma separated list of ops that will be turned into arguments.")};
  ::mlir::Pass::ListOption<std::string> fetches_{*this, "fetches", ::llvm::cl::desc("Comma separated list of ops that will be turned into results.")};
  ::mlir::Pass::ListOption<std::string> control_rets_{*this, "control_rets", ::llvm::cl::desc("Comma separated list of ops that will be turned into control returned.")};
};

//===----------------------------------------------------------------------===//
// LiftLegacyCall
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class LiftLegacyCallBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = LiftLegacyCallBase;

  LiftLegacyCallBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  LiftLegacyCallBase(const LiftLegacyCallBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tfg-lift-legacy-call");
  }
  ::llvm::StringRef getArgument() const override { return "tfg-lift-legacy-call"; }

  ::llvm::StringRef getDescription() const override { return "Tag legacy calls with symbol references to add symbol uses"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("LiftLegacyCall");
  }
  ::llvm::StringRef getName() const override { return "LiftLegacyCall"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(LiftLegacyCallBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// NameCompress
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class NameCompressBase : public ::mlir::OperationPass<GraphFuncOp> {
public:
  using Base = NameCompressBase;

  NameCompressBase() : ::mlir::OperationPass<GraphFuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  NameCompressBase(const NameCompressBase &other) : ::mlir::OperationPass<GraphFuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tfg-name-compress");
  }
  ::llvm::StringRef getArgument() const override { return "tfg-name-compress"; }

  ::llvm::StringRef getDescription() const override { return "Compress the graph by shortening names"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("NameCompress");
  }
  ::llvm::StringRef getName() const override { return "NameCompress"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(NameCompressBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// PrepareAttributesForExport
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class PrepareAttributesForExportBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = PrepareAttributesForExportBase;

  PrepareAttributesForExportBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  PrepareAttributesForExportBase(const PrepareAttributesForExportBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tfg-prepare-attrs-export");
  }
  ::llvm::StringRef getArgument() const override { return "tfg-prepare-attrs-export"; }

  ::llvm::StringRef getDescription() const override { return "Legalize ops' attributes for export."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("PrepareAttributesForExport");
  }
  ::llvm::StringRef getName() const override { return "PrepareAttributesForExport"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(PrepareAttributesForExportBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// RegionToFunctional
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class RegionToFunctionalBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = RegionToFunctionalBase;

  RegionToFunctionalBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  RegionToFunctionalBase(const RegionToFunctionalBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tfg-region-to-functional");
  }
  ::llvm::StringRef getArgument() const override { return "tfg-region-to-functional"; }

  ::llvm::StringRef getDescription() const override { return "Convert region-based control-flow ops to functional."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("RegionToFunctional");
  }
  ::llvm::StringRef getName() const override { return "RegionToFunctional"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<tfg::TFGraphDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(RegionToFunctionalBase<DerivedT>)

protected:
  ::mlir::Pass::Option<bool> force_control_capture{*this, "force-control-capture", ::llvm::cl::desc("Force the capture of control tokens by inserting chain `Const` ops"), ::llvm::cl::init(false)};
};

//===----------------------------------------------------------------------===//
// Remapper
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class RemapperBase : public ::mlir::OperationPass<> {
public:
  using Base = RemapperBase;

  RemapperBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  RemapperBase(const RemapperBase &other) : ::mlir::OperationPass<>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tfg-remapper");
  }
  ::llvm::StringRef getArgument() const override { return "tfg-remapper"; }

  ::llvm::StringRef getDescription() const override { return "Remap operations to decrease amount of operations"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("Remapper");
  }
  ::llvm::StringRef getName() const override { return "Remapper"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(RemapperBase<DerivedT>)

protected:
  ::mlir::Pass::Option<bool> enable_mkl_patterns_{*this, "enable-mkl-patterns", ::llvm::cl::desc("Enable the MKL related patterns."), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> verify_pdll_patterns_only_{*this, "verify-pdll-patterns-only", ::llvm::cl::desc("Only enable PDLL patterns."), ::llvm::cl::init(false)};
};

//===----------------------------------------------------------------------===//
// ShapeInference
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ShapeInferenceBase : public ::mlir::OperationPass<> {
public:
  using Base = ShapeInferenceBase;

  ShapeInferenceBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ShapeInferenceBase(const ShapeInferenceBase &other) : ::mlir::OperationPass<>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tfg-shape-inference");
  }
  ::llvm::StringRef getArgument() const override { return "tfg-shape-inference"; }

  ::llvm::StringRef getDescription() const override { return "Infer the output shape of operations"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ShapeInference");
  }
  ::llvm::StringRef getName() const override { return "ShapeInference"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ShapeInferenceBase<DerivedT>)

protected:
  ::mlir::Pass::Option<int> graph_version_{*this, "graph-version", ::llvm::cl::desc("The graph producer version")};
};

//===----------------------------------------------------------------------===//
// StripDefaultAttrs
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class StripDefaultAttrsBase : public ::mlir::OperationPass<> {
public:
  using Base = StripDefaultAttrsBase;

  StripDefaultAttrsBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  StripDefaultAttrsBase(const StripDefaultAttrsBase &other) : ::mlir::OperationPass<>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tfg-strip-default-attrs");
  }
  ::llvm::StringRef getArgument() const override { return "tfg-strip-default-attrs"; }

  ::llvm::StringRef getDescription() const override { return "Removes default-valued attributes from the graph"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("StripDefaultAttrs");
  }
  ::llvm::StringRef getName() const override { return "StripDefaultAttrs"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(StripDefaultAttrsBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// TopoSort
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TopoSortBase : public ::mlir::OperationPass<> {
public:
  using Base = TopoSortBase;

  TopoSortBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  TopoSortBase(const TopoSortBase &other) : ::mlir::OperationPass<>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tfg-toposort");
  }
  ::llvm::StringRef getArgument() const override { return "tfg-toposort"; }

  ::llvm::StringRef getDescription() const override { return "Topologically sort graph and function regions"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TopoSort");
  }
  ::llvm::StringRef getName() const override { return "TopoSort"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TopoSortBase<DerivedT>)

protected:
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// AddDefaultAttrs Registration
//===----------------------------------------------------------------------===//

inline void registerAddDefaultAttrsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateAddDefaultAttrsPass();
  });
}

//===----------------------------------------------------------------------===//
// CSEPass Registration
//===----------------------------------------------------------------------===//

inline void registerCSEPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateCSEPass();
  });
}

//===----------------------------------------------------------------------===//
// ConsolidateAttributes Registration
//===----------------------------------------------------------------------===//

inline void registerConsolidateAttributesPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateConsolidateAttributesPass();
  });
}

//===----------------------------------------------------------------------===//
// ConstantFoldingPass Registration
//===----------------------------------------------------------------------===//

inline void registerConstantFoldingPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateConstantFoldingPass();
  });
}

//===----------------------------------------------------------------------===//
// ControlFlowSink Registration
//===----------------------------------------------------------------------===//

inline void registerControlFlowSinkPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateControlFlowSinkPass();
  });
}

//===----------------------------------------------------------------------===//
// DedupeAndHoistConstant Registration
//===----------------------------------------------------------------------===//

inline void registerDedupeAndHoistConstantPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateDedupeAndHoistConstantPass();
  });
}

//===----------------------------------------------------------------------===//
// DropOutputShapesAttr Registration
//===----------------------------------------------------------------------===//

inline void registerDropOutputShapesAttrPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateDropOutputShapesAttrPass();
  });
}

//===----------------------------------------------------------------------===//
// EliminatePassthroughIterArgs Registration
//===----------------------------------------------------------------------===//

inline void registerEliminatePassthroughIterArgsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateEliminatePassthroughIterArgsPass();
  });
}

//===----------------------------------------------------------------------===//
// FuncToGraph Registration
//===----------------------------------------------------------------------===//

inline void registerFuncToGraphPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateFuncToGraphPass();
  });
}

//===----------------------------------------------------------------------===//
// FunctionalToRegion Registration
//===----------------------------------------------------------------------===//

inline void registerFunctionalToRegionPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateFunctionalToRegionPass();
  });
}

//===----------------------------------------------------------------------===//
// GraphToFunc Registration
//===----------------------------------------------------------------------===//

inline void registerGraphToFuncPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateGraphToFuncPass();
  });
}

//===----------------------------------------------------------------------===//
// LiftLegacyCall Registration
//===----------------------------------------------------------------------===//

inline void registerLiftLegacyCallPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateLiftLegacyCallPass();
  });
}

//===----------------------------------------------------------------------===//
// NameCompress Registration
//===----------------------------------------------------------------------===//

inline void registerNameCompressPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateNameCompressPass();
  });
}

//===----------------------------------------------------------------------===//
// PrepareAttributesForExport Registration
//===----------------------------------------------------------------------===//

inline void registerPrepareAttributesForExportPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreatePrepareAttributesForExportPass();
  });
}

//===----------------------------------------------------------------------===//
// RegionToFunctional Registration
//===----------------------------------------------------------------------===//

inline void registerRegionToFunctionalPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateRegionToFunctionalPass();
  });
}

//===----------------------------------------------------------------------===//
// Remapper Registration
//===----------------------------------------------------------------------===//

inline void registerRemapperPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateRemapperPass();
  });
}

//===----------------------------------------------------------------------===//
// ShapeInference Registration
//===----------------------------------------------------------------------===//

inline void registerShapeInferencePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateShapeInferencePass();
  });
}

//===----------------------------------------------------------------------===//
// StripDefaultAttrs Registration
//===----------------------------------------------------------------------===//

inline void registerStripDefaultAttrsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateStripDefaultAttrsPass();
  });
}

//===----------------------------------------------------------------------===//
// TopoSort Registration
//===----------------------------------------------------------------------===//

inline void registerTopoSortPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateTopoSortPass();
  });
}

//===----------------------------------------------------------------------===//
// TFGraph Registration
//===----------------------------------------------------------------------===//

inline void registerTFGraphPasses() {
  registerAddDefaultAttrsPass();
  registerCSEPassPass();
  registerConsolidateAttributesPass();
  registerConstantFoldingPassPass();
  registerControlFlowSinkPass();
  registerDedupeAndHoistConstantPass();
  registerDropOutputShapesAttrPass();
  registerEliminatePassthroughIterArgsPass();
  registerFuncToGraphPass();
  registerFunctionalToRegionPass();
  registerGraphToFuncPass();
  registerLiftLegacyCallPass();
  registerNameCompressPass();
  registerPrepareAttributesForExportPass();
  registerRegionToFunctionalPass();
  registerRemapperPass();
  registerShapeInferencePass();
  registerStripDefaultAttrsPass();
  registerTopoSortPass();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
