/* Autogenerated by mlir-tblgen; don't manually edit */
#ifdef GEN_PASS_CLASSES

//===----------------------------------------------------------------------===//
// ComposeSetOpsPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ComposeSetOpsPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = ComposeSetOpsPassBase;

  ComposeSetOpsPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  ComposeSetOpsPassBase(const ComposeSetOpsPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-compose-set-ops");
  }
  ::llvm::StringRef getArgument() const override { return "gml-compose-set-ops"; }

  ::llvm::StringRef getDescription() const override { return "Compose set operations."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ComposeSetOpsPass");
  }
  ::llvm::StringRef getName() const override { return "ComposeSetOpsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ComposeSetOpsPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// FusionPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class FusionPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = FusionPassBase;

  FusionPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  FusionPassBase(const FusionPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-fusion");
  }
  ::llvm::StringRef getArgument() const override { return "gml-fusion"; }

  ::llvm::StringRef getDescription() const override { return "Fuse producers in into `gml_st.materialize` operations"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("FusionPass");
  }
  ::llvm::StringRef getName() const override { return "FusionPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(FusionPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// GmlStToScf
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class GmlStToScfBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = GmlStToScfBase;

  GmlStToScfBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  GmlStToScfBase(const GmlStToScfBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-st-to-scf");
  }
  ::llvm::StringRef getArgument() const override { return "gml-st-to-scf"; }

  ::llvm::StringRef getDescription() const override { return "Lower `gml_st.loop` to SCF loops and parallel loops"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("GmlStToScf");
  }
  ::llvm::StringRef getName() const override { return "GmlStToScf"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<::mlir::scf::SCFDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(GmlStToScfBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// LegalizeMHLOToGMLPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class LegalizeMHLOToGMLPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = LegalizeMHLOToGMLPassBase;

  LegalizeMHLOToGMLPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  LegalizeMHLOToGMLPassBase(const LegalizeMHLOToGMLPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("legalize-mhlo-to-gml");
  }
  ::llvm::StringRef getArgument() const override { return "legalize-mhlo-to-gml"; }

  ::llvm::StringRef getDescription() const override { return "TBD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("LegalizeMHLOToGMLPass");
  }
  ::llvm::StringRef getName() const override { return "LegalizeMHLOToGMLPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(LegalizeMHLOToGMLPassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// TiledLoopBufferizePass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TiledLoopBufferizePassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = TiledLoopBufferizePassBase;

  TiledLoopBufferizePassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  TiledLoopBufferizePassBase(const TiledLoopBufferizePassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-tiled-loop-bufferize");
  }
  ::llvm::StringRef getArgument() const override { return "gml-tiled-loop-bufferize"; }

  ::llvm::StringRef getDescription() const override { return "Pass to bufferize linalg.tiled_loop with the ops inside it."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TiledLoopBufferizePass");
  }
  ::llvm::StringRef getName() const override { return "TiledLoopBufferizePass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TiledLoopBufferizePassBase<DerivedT>)

protected:
};

//===----------------------------------------------------------------------===//
// TilingPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TilingPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = TilingPassBase;

  TilingPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  TilingPassBase(const TilingPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("gml-tiling");
  }
  ::llvm::StringRef getArgument() const override { return "gml-tiling"; }

  ::llvm::StringRef getDescription() const override { return "Tile operations to produce gml_st.parallel or gml_st.for"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TilingPass");
  }
  ::llvm::StringRef getName() const override { return "TilingPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TilingPassBase<DerivedT>)

protected:
  ::mlir::Pass::ListOption<int64_t> tileSizes{*this, "tile-sizes", ::llvm::cl::desc("Tile sizes"), llvm::cl::ZeroOrMore};
};

//===----------------------------------------------------------------------===//
// VectorizeGmlStLoopsPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class VectorizeGmlStLoopsPassBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = VectorizeGmlStLoopsPassBase;

  VectorizeGmlStLoopsPassBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  VectorizeGmlStLoopsPassBase(const VectorizeGmlStLoopsPassBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("vectorize-gml-st-loops");
  }
  ::llvm::StringRef getArgument() const override { return "vectorize-gml-st-loops"; }

  ::llvm::StringRef getDescription() const override { return "Pass to vectorize linalg.generic ops tiled to gml_st.parallel and gml_st.for loops."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("VectorizeGmlStLoopsPass");
  }
  ::llvm::StringRef getName() const override { return "VectorizeGmlStLoopsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<::mlir::vector::VectorDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(VectorizeGmlStLoopsPassBase<DerivedT>)

protected:
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// ComposeSetOpsPass Registration
//===----------------------------------------------------------------------===//

inline void registerComposeSetOpsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::createComposeSetOpsPass();
  });
}

//===----------------------------------------------------------------------===//
// FusionPass Registration
//===----------------------------------------------------------------------===//

inline void registerFusionPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::createFusionPass();
  });
}

//===----------------------------------------------------------------------===//
// GmlStToScf Registration
//===----------------------------------------------------------------------===//

inline void registerGmlStToScfPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::createGmlStToScfPass();
  });
}

//===----------------------------------------------------------------------===//
// LegalizeMHLOToGMLPass Registration
//===----------------------------------------------------------------------===//

inline void registerLegalizeMHLOToGMLPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::createLegalizeMHLOToGMLPass();
  });
}

//===----------------------------------------------------------------------===//
// TiledLoopBufferizePass Registration
//===----------------------------------------------------------------------===//

inline void registerTiledLoopBufferizePassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::CreateTiledLoopBufferizePass();
  });
}

//===----------------------------------------------------------------------===//
// TilingPass Registration
//===----------------------------------------------------------------------===//

inline void registerTilingPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::createTilingPass();
  });
}

//===----------------------------------------------------------------------===//
// VectorizeGmlStLoopsPass Registration
//===----------------------------------------------------------------------===//

inline void registerVectorizeGmlStLoopsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return ::mlir::gml_st::createVectorizeGmlStLoopsPass();
  });
}

//===----------------------------------------------------------------------===//
// GmlSt Registration
//===----------------------------------------------------------------------===//

inline void registerGmlStPasses() {
  registerComposeSetOpsPassPass();
  registerFusionPassPass();
  registerGmlStToScfPass();
  registerLegalizeMHLOToGMLPassPass();
  registerTiledLoopBufferizePassPass();
  registerTilingPassPass();
  registerVectorizeGmlStLoopsPassPass();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
