/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mp4.media;

import com.drew.imaging.mp4.Mp4Handler;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.ByteTrie;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.iptc.IptcReader;
import com.drew.metadata.mp4.Mp4Context;
import com.drew.metadata.mp4.boxes.Box;
import com.drew.metadata.mp4.boxes.UuidBox;
import com.drew.metadata.mp4.media.Mp4UuidBoxDirectory;
import com.drew.metadata.photoshop.PhotoshopReader;
import com.drew.metadata.xmp.XmpReader;
import java.io.IOException;

public class Mp4UuidBoxHandler
extends Mp4Handler<Mp4UuidBoxDirectory> {
    private static final ByteTrie<UuidType> _uuidLookup = new ByteTrie();

    public Mp4UuidBoxHandler(Metadata metadata) {
        super(metadata);
    }

    @Override
    protected Mp4UuidBoxDirectory getDirectory() {
        return new Mp4UuidBoxDirectory();
    }

    @Override
    protected boolean shouldAcceptBox(Box box) {
        return box.type.equals("uuid");
    }

    @Override
    protected boolean shouldAcceptContainer(Box box) {
        return false;
    }

    @Override
    public Mp4Handler processBox(Box box, byte[] payload, Mp4Context context) throws IOException {
        if (payload != null && payload.length >= 16) {
            UuidType type = _uuidLookup.find(payload);
            switch (type) {
                case Exif: {
                    new ExifReader().extract(new ByteArrayReader(payload, 16), this.metadata, 0, this.directory);
                    break;
                }
                case IptcIim: {
                    new IptcReader().extract(new SequentialByteArrayReader(payload, 16), this.metadata, payload.length - 16, this.directory);
                    break;
                }
                case PhotoshopImageResources: {
                    new PhotoshopReader().extract(new SequentialByteArrayReader(payload, 16), payload.length - 16, this.metadata, this.directory);
                    break;
                }
                case Xmp: {
                    new XmpReader().extract(payload, 16, payload.length - 16, this.metadata, this.directory);
                    break;
                }
                default: {
                    SequentialByteArrayReader reader = new SequentialByteArrayReader(payload);
                    UuidBox userBox = new UuidBox(reader, box);
                    userBox.addMetadata(this.directory);
                }
            }
        }
        return this;
    }

    static {
        _uuidLookup.setDefaultValue(UuidType.Unknown);
        _uuidLookup.addPath(UuidType.Exif, new byte[][]{{5, 55, -51, -85, -99, 12, 68, 49, -89, 42, -6, 86, 31, 42, 17, 62}});
        _uuidLookup.addPath(UuidType.PhotoshopImageResources, new byte[][]{{44, 76, 1, 0, -123, 4, 64, -71, -96, 62, 86, 33, 72, -42, -33, -21}});
        _uuidLookup.addPath(UuidType.IptcIim, new byte[][]{{51, -57, -92, -46, -72, 29, 71, 35, -96, -70, -15, -93, -32, -105, -83, 56}});
        _uuidLookup.addPath(UuidType.PiffTrackEncryptionBox, new byte[][]{{-119, 116, -37, -50, 123, -25, 76, 81, -124, -7, 113, 72, -7, -120, 37, 84}});
        _uuidLookup.addPath(UuidType.GeoJp2WorldFileBox, new byte[][]{{-106, -87, -15, -15, -36, -104, 64, 45, -89, -82, -42, -114, 52, 69, 24, 9}});
        _uuidLookup.addPath(UuidType.PiffSampleEncryptionBox, new byte[][]{{-94, 57, 79, 82, 90, -101, 79, 20, -94, 68, 108, 66, 124, 100, -115, -12}});
        _uuidLookup.addPath(UuidType.GeoJp2GeoTiffBox, new byte[][]{{-79, 75, -8, -67, 8, 61, 75, 67, -91, -82, -116, -41, -43, -90, -50, 3}});
        _uuidLookup.addPath(UuidType.Xmp, new byte[][]{{-66, 122, -49, -53, -105, -87, 66, -24, -100, 113, -103, -108, -111, -29, -81, -84}});
        _uuidLookup.addPath(UuidType.PiffProtectionSystemSpecificHeaderBox, new byte[][]{{-48, -118, 79, 24, 16, -13, 74, -126, -74, -56, 50, -40, -85, -95, -125, -45}});
    }

    private static enum UuidType {
        Unknown,
        Exif,
        PhotoshopImageResources,
        IptcIim,
        PiffTrackEncryptionBox,
        GeoJp2WorldFileBox,
        PiffSampleEncryptionBox,
        GeoJp2GeoTiffBox,
        Xmp,
        PiffProtectionSystemSpecificHeaderBox;

    }
}

