#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 ShellCheck
version:              0.8.0
visibility:           public
id:                   ShellCheck-0.8.0-1JOe8onn60A15Yyj9DGfJj
key:                  ShellCheck-0.8.0-1JOe8onn60A15Yyj9DGfJj
license:              GPL-3.0-only
maintainer:           vidar@vidarholen.net
author:               Vidar Holen
homepage:             https://www.shellcheck.net/
synopsis:             Shell script analysis tool
description:
    The goals of ShellCheck are:

    * To point out and clarify typical beginner'\''s syntax issues,
    that causes a shell to give cryptic error messages.

    * To point out and clarify typical intermediate level semantic problems,
    that causes a shell to behave strangely and counter-intuitively.

    * To point out subtle caveats, corner cases and pitfalls, that may cause an
    advanced user'\''s otherwise working script to fail under future circumstances.

category:             Static Analysis
abi:                  30178788e8a17e2e8b83ad6792c3dbb6
exposed:              True
exposed-modules:
    ShellCheck.AST ShellCheck.ASTLib ShellCheck.Analytics
    ShellCheck.Analyzer ShellCheck.AnalyzerLib ShellCheck.Checker
    ShellCheck.Checks.Commands ShellCheck.Checks.Custom
    ShellCheck.Checks.ShellSupport ShellCheck.Data ShellCheck.Fixer
    ShellCheck.Formatter.CheckStyle ShellCheck.Formatter.Diff
    ShellCheck.Formatter.Format ShellCheck.Formatter.GCC
    ShellCheck.Formatter.JSON ShellCheck.Formatter.JSON1
    ShellCheck.Formatter.Quiet ShellCheck.Formatter.TTY
    ShellCheck.Interface ShellCheck.Parser ShellCheck.Regex

hidden-modules:       Paths_ShellCheck
import-dirs:          /usr/lib/ghc-9.0.2/site-local/ShellCheck-0.8.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/ShellCheck-0.8.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/shellcheck
hs-libraries:         HSShellCheck-0.8.0-1JOe8onn60A15Yyj9DGfJj
depends:
    Diff-0.4.1-2jMKpzJJQmAHzE6LyB7Qjk
    QuickCheck-2.14.2-JoFwhdHSVnjCwZaPGQEEzD
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT array-0.5.4.0 base-4.15.1.0
    bytestring-0.10.12.1 containers-0.6.4.1 deepseq-1.4.5.0
    directory-1.3.6.2 filepath-1.4.2.1 mtl-2.2.2 parsec-3.1.14.0
    process-1.6.13.2 regex-tdfa-1.3.2-tNtR2SpOBLAbbzDX5vBu9

haddock-interfaces:   /usr/share/doc/shellcheck/html/ShellCheck.haddock
haddock-html:         /usr/share/doc/shellcheck/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

