/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbc.IfxJSON;
import com.informix.jdbc.udt.Binary18;
import com.informix.jdbc.udt.BinaryVar;
import com.informix.jdbcx.TypeMapBuilder;
import com.informix.util.IfxMap;
import java.util.HashMap;
import java.util.Map;

public class TypeMapFactory {
    private static final Map<String, Class<?>> DEFAULT_MAP = new HashMap();
    private static TypeMapBuilder BUILDER = isDelimIdent -> {
        HashMap<String, Class<Object>> userMap = null;
        userMap = isDelimIdent ? new HashMap() : new IfxMap(isDelimIdent);
        userMap.putAll(DEFAULT_MAP);
        return userMap;
    };

    public static void setCustomTypeMap(Map<String, Class<?>> map) {
        DEFAULT_MAP.clear();
        DEFAULT_MAP.putAll(map);
    }

    public static void setCustomType(String name, Class<?> type) {
        DEFAULT_MAP.put(name, type);
    }

    public static Map<String, Class<?>> createMap(boolean isDelimIdent) {
        return BUILDER.getTypeMap(isDelimIdent);
    }

    public static void setCustomTypeBuilder(TypeMapBuilder builder) {
        BUILDER = builder;
    }

    private TypeMapFactory() {
    }

    static {
        try {
            DEFAULT_MAP.put("bson", Class.forName("com.informix.jdbc.IfxBSONObject"));
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            // empty catch block
        }
        DEFAULT_MAP.put("json", IfxJSON.class);
        DEFAULT_MAP.put("binary18", Binary18.class);
        DEFAULT_MAP.put("binaryvar", BinaryVar.class);
    }
}

