/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm;

import com.informix.csm.IfxCsm;
import com.informix.csm.IfxCsmBuffer;
import com.informix.csm.IfxCsmException;
import com.informix.csm.IfxCsmReadBuffer;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class IfxCssInputStream
extends FilterInputStream {
    static final int STREAM_BUF_SIZE = 4096;
    private InputStream IfxIs = null;
    private IfxCsmBuffer outputStream = null;
    private IfxCsmReadBuffer csmProcessedData = null;
    private IfxCsm myCSM = null;
    private IfxCsm.Status csmStatus = new IfxCsm.Status();

    public IfxCssInputStream(InputStream Is, IfxCsm myCSM) {
        super(Is);
        this.IfxIs = Is;
        this.myCSM = myCSM;
        this.outputStream = new IfxCsmBuffer();
        this.csmProcessedData = null;
    }

    @Override
    public int available() throws IOException {
        if (this.csmProcessedData != null) {
            return this.csmProcessedData.available();
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        if (this.csmProcessedData != null) {
            this.csmProcessedData.close();
        }
        super.close();
    }

    @Override
    public int read() throws IOException {
        int byteRead = 0;
        if (this.csmProcessedData.available() < 1) {
            this.fillOutputStream();
        }
        byteRead = this.csmProcessedData.read();
        return byteRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int len) throws IOException {
        int returnValue = 0;
        while (this.csmProcessedData == null || this.csmProcessedData.available() < len) {
            this.fillOutputStream();
        }
        returnValue = this.csmProcessedData.read(b, offset, len);
        return returnValue;
    }

    @Override
    public void reset() throws IOException {
        if (this.csmProcessedData != null) {
            this.csmProcessedData.reset();
        }
    }

    @Override
    public long skip(long n) throws IOException {
        boolean done = false;
        while (!done) {
            if (this.csmProcessedData == null || (long)this.csmProcessedData.available() < n) {
                this.fillOutputStream();
                continue;
            }
            done = true;
        }
        long returnValue = this.csmProcessedData.skip(n);
        return returnValue;
    }

    private void fillOutputStream() throws IOException {
        block6: {
            block5: {
                byte[] tmpBuffer = new byte[4096];
                int numByteRead = 0;
                this.outputStream.reset();
                if (this.csmProcessedData != null && this.csmProcessedData.available() > 0) {
                    this.outputStream.write(this.csmProcessedData.readFully());
                }
                do {
                    if (this.csmStatus.getCsmCode() != 2L && (numByteRead = this.IfxIs.read(tmpBuffer)) == -1) {
                        throw new IOException();
                    }
                    int return_flag = -1;
                    try {
                        return_flag = this.myCSM.ifxCsmProcessInMessage(new IfxCsmReadBuffer(tmpBuffer, 0, numByteRead), this.outputStream, this.csmStatus);
                    }
                    catch (IfxCsmException ice) {
                        throw new IOException(ice.toString());
                    }
                    if (return_flag == 1) break block5;
                } while (this.csmStatus.getCsmCode() == 5L);
                break block6;
            }
            throw new IOException(this.csmStatus.getCsmString());
        }
        this.csmProcessedData = new IfxCsmReadBuffer(this.outputStream);
    }
}

