/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.scheduler;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import us.fatehi.utility.scheduler.TaskDefinition;
import us.fatehi.utility.scheduler.TaskInfo;

class TimedTask
implements Runnable {
    private final TaskDefinition task;
    private final List<TaskInfo> taskResults;

    TimedTask(List<TaskInfo> taskResults, TaskDefinition task) {
        this.taskResults = Objects.requireNonNull(taskResults, "Tasks results list not provided");
        this.task = Objects.requireNonNull(task, "Task not provided");
    }

    @Override
    public void run() {
        Instant start = Instant.now();
        RuntimeException ex = null;
        try {
            this.task.run();
        }
        catch (RuntimeException e) {
            ex = e;
        }
        Instant stop = Instant.now();
        Duration runTime = Duration.between(start, stop);
        TaskInfo taskInfo = new TaskInfo(this.task.getTaskName(), runTime);
        this.taskResults.add(taskInfo);
        if (ex != null) {
            throw ex;
        }
    }
}

