/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.server.postgresql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.plugin.EnumDataTypeHelper;
import schemacrawler.plugin.EnumDataTypeInfo;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import us.fatehi.utility.database.DatabaseUtility;
import us.fatehi.utility.string.StringFormat;

public class PostgreSQLEnumDataTypeHelper
implements EnumDataTypeHelper {
    private static final Logger LOGGER = Logger.getLogger(PostgreSQLEnumDataTypeHelper.class.getName());
    private final Set<ColumnDataType> visitedDataTypes = new HashSet<ColumnDataType>();

    private static String constructEnumSql(ColumnDataType columnDataType) {
        String columnDataTypeName = columnDataType.getName();
        String sql = String.format("SELECT  \n  e.enumlabel AS ENUM_LABEL  \nFROM  \n  pg_enum e  \n  INNER JOIN pg_type t  \n    ON e.enumtypid = t.oid  \n  INNER JOIN pg_catalog.pg_namespace n  \n    ON n.oid = t.typnamespace  \nWHERE  \n  t.typname = '%s'  \n", columnDataTypeName);
        return sql;
    }

    private static List<String> getEnumValues(ColumnDataType columnDataType, Connection connection) {
        List list;
        block8: {
            Objects.requireNonNull(columnDataType, "No column provided");
            String sql = PostgreSQLEnumDataTypeHelper.constructEnumSql(columnDataType);
            Statement statement = connection.createStatement();
            try {
                List enumValues;
                ResultSet resultSet = DatabaseUtility.executeSql((Statement)statement, (String)sql);
                list = enumValues = DatabaseUtility.readResultsVector((ResultSet)resultSet);
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Error executing SQL <%s>", new Object[]{sql}));
                    return new ArrayList<String>();
                }
            }
            statement.close();
        }
        return list;
    }

    public EnumDataTypeInfo getEnumDataTypeInfo(Column column, ColumnDataType columnDataType, Connection connection) {
        Objects.requireNonNull(columnDataType, "No column data type provided");
        if (this.visitedDataTypes.contains(columnDataType)) {
            EnumDataTypeInfo.EnumDataTypeTypes enumType = columnDataType.isEnumerated() ? EnumDataTypeInfo.EnumDataTypeTypes.enumerated_data_type : EnumDataTypeInfo.EnumDataTypeTypes.not_enumerated;
            return new EnumDataTypeInfo(enumType, columnDataType.getEnumValues());
        }
        try {
            DatabaseUtility.checkConnection((Connection)connection);
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not obtain enumerated column values", e);
        }
        List<String> enumValues = PostgreSQLEnumDataTypeHelper.getEnumValues(columnDataType, connection);
        this.visitedDataTypes.add(columnDataType);
        EnumDataTypeInfo.EnumDataTypeTypes enumType = enumValues.isEmpty() ? EnumDataTypeInfo.EnumDataTypeTypes.not_enumerated : EnumDataTypeInfo.EnumDataTypeTypes.enumerated_data_type;
        return new EnumDataTypeInfo(enumType, enumValues);
    }
}

