/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.connector;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.LocalTransactionException;
import oracle.jdbc.connector.OracleManagedConnection;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CONN_MANAGEMENT})
public class OracleLocalTransaction
implements LocalTransaction {
    private OracleManagedConnection managedConnection;
    private Connection connection;
    boolean isBeginCalled;
    private static final String RAERR_LTXN_COMMIT = "commit without begin";
    private static final String RAERR_LTXN_ROLLBACK = "rollback without begin";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    OracleLocalTransaction(OracleManagedConnection omc) throws ResourceException {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleLocalTransaction.class, $$$methodRef$$$3, null, omc);
            }
            this.managedConnection = null;
            this.connection = null;
            this.isBeginCalled = false;
            this.managedConnection = omc;
            this.connection = omc.getPhysicalConnection();
            this.isBeginCalled = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleLocalTransaction.class, $$$methodRef$$$3, null);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleLocalTransaction.class, $$$methodRef$$$3, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleLocalTransaction.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    public void begin() throws ResourceException {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleLocalTransaction.class, $$$methodRef$$$0, this, new Object[0]);
            }
            try {
                if (((OracleConnection)this.connection).getTxnMode() == 1) {
                    IllegalStateException illegalStateException = new IllegalStateException("Could not start a new transaction inside an active transaction");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleLocalTransaction.class, $$$methodRef$$$0, this, (Throwable)illegalStateException);
                    }
                    throw illegalStateException;
                }
                if (this.connection.getAutoCommit()) {
                    this.connection.setAutoCommit(false);
                }
                this.isBeginCalled = true;
            }
            catch (SQLException exc) {
                EISSystemException rexc = new EISSystemException("SQLException: " + exc.getMessage());
                rexc.setLinkedException((Exception)exc);
                EISSystemException eISSystemException = rexc;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleLocalTransaction.class, $$$methodRef$$$0, this, (Throwable)eISSystemException);
                }
                throw eISSystemException;
            }
            this.managedConnection.eventOccurred(2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleLocalTransaction.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleLocalTransaction.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleLocalTransaction.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    public void commit() throws ResourceException {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleLocalTransaction.class, $$$methodRef$$$1, this, new Object[0]);
            }
            if (!this.isBeginCalled) {
                LocalTransactionException localTransactionException = new LocalTransactionException("begin() must be called before commit()", RAERR_LTXN_COMMIT);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleLocalTransaction.class, $$$methodRef$$$1, this, (Throwable)localTransactionException);
                }
                throw localTransactionException;
            }
            try {
                this.connection.commit();
            }
            catch (SQLException exc) {
                EISSystemException rexc = new EISSystemException("SQLException: " + exc.getMessage());
                rexc.setLinkedException((Exception)exc);
                EISSystemException eISSystemException = rexc;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleLocalTransaction.class, $$$methodRef$$$1, this, (Throwable)eISSystemException);
                }
                throw eISSystemException;
            }
            this.isBeginCalled = false;
            this.managedConnection.eventOccurred(3);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleLocalTransaction.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleLocalTransaction.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleLocalTransaction.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    public void rollback() throws ResourceException {
        boolean bl = (0x80000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleLocalTransaction.class, $$$methodRef$$$2, this, new Object[0]);
            }
            if (!this.isBeginCalled) {
                LocalTransactionException localTransactionException = new LocalTransactionException("begin() must be called before rollback()", RAERR_LTXN_ROLLBACK);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleLocalTransaction.class, $$$methodRef$$$2, this, (Throwable)localTransactionException);
                }
                throw localTransactionException;
            }
            try {
                this.connection.rollback();
            }
            catch (SQLException exc) {
                EISSystemException rexc = new EISSystemException("SQLException: " + exc.getMessage());
                rexc.setLinkedException((Exception)exc);
                EISSystemException eISSystemException = rexc;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleLocalTransaction.class, $$$methodRef$$$2, this, (Throwable)eISSystemException);
                }
                throw eISSystemException;
            }
            this.isBeginCalled = false;
            this.managedConnection.eventOccurred(4);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleLocalTransaction.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleLocalTransaction.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleLocalTransaction.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$3 = OracleLocalTransaction.class.getDeclaredConstructor(OracleManagedConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleLocalTransaction.class.getDeclaredMethod("rollback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleLocalTransaction.class.getDeclaredMethod("commit", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleLocalTransaction.class.getDeclaredMethod("begin", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

