/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxComplex;
import com.informix.jdbc.IfxComplexInput;
import com.informix.jdbc.IfxComplexOutput;
import com.informix.jdbc.IfxConnection;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.List;
import java.util.Map;

public class IfxStruct
implements Struct {
    private static final Object logger = Trace.getLoggerForClass(IfxStruct.class);
    private Map<String, Class<?>> typeMap;
    private IfxComplexInput inputStream;
    private IfxComplexOutput outputStream;
    private Object[] attributes = null;
    private final IfxConnection conn;
    private Trace trace;
    private String SQLTypeName = null;

    IfxStruct(byte[] b, List<IfxColumnInfo> typeInfoVector, IfxConnection conn) throws SQLException {
        this.conn = conn;
        if (conn == null) {
            throw IfxErrMsg.getSQLException(-79716, conn);
        }
        this.trace = conn.getTrace();
        this.inputStream = new IfxComplexInput(b, 0, b.length, typeInfoVector, false, conn);
        this.outputStream = new IfxComplexOutput(true, false);
        this.outputStream.setConnection(conn);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxStruct() constructor entered/exited");
        }
        this.SQLTypeName = IfxComplex.getExtendedName(typeInfoVector, this.trace, conn.getclLocale());
    }

    @Override
    public String getSQLTypeName() {
        return this.SQLTypeName;
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxStruct().getAttributes(void) called");
        }
        return this.getAttributes(this.conn.getTypeMap());
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxStruct().getAttributes(Map) called");
        }
        if (this.attributes != null && map == this.typeMap) {
            return this.attributes;
        }
        this.setAttributes(map);
        this.typeMap = map;
        return this.attributes;
    }

    private void clear() {
        this.attributes = null;
        this.outputStream.reset();
    }

    private void setAttributes(Map<String, Class<?>> map) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxStruct().setAttributes(Map) called");
        }
        if (this.inputStream == null) {
            throw IfxErrMsg.getSQLException(-79716, this.conn);
        }
        this.inputStream.setTypeMap(map);
        this.attributes = this.inputStream.readStructAttributes();
    }

    public String toString() {
        return "IfxStruct. Type: " + this.SQLTypeName;
    }
}

