/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.batching;

import net.snowflake.client.jdbc.internal.google.api.core.BetaApi;
import net.snowflake.client.jdbc.internal.google.api.gax.batching.ElementCounter;
import net.snowflake.client.jdbc.internal.google.api.gax.batching.FlowController;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.primitives.Ints;

@BetaApi(value="The surface for batching is not stable yet and may change in the future.")
public class BatchingFlowController<T> {
    private final FlowController flowController;
    private final ElementCounter<T> elementCounter;
    private final ElementCounter<T> byteCounter;

    public BatchingFlowController(FlowController flowController, ElementCounter<T> elementCounter, ElementCounter<T> byteCounter) {
        this.flowController = flowController;
        this.elementCounter = elementCounter;
        this.byteCounter = byteCounter;
    }

    public void reserve(T batch) throws FlowController.FlowControlException {
        Preconditions.checkNotNull(batch);
        int elements = Ints.checkedCast((long)this.elementCounter.count(batch));
        int bytes = Ints.checkedCast((long)this.byteCounter.count(batch));
        this.flowController.reserve(elements, bytes);
    }

    public void release(T batch) {
        Preconditions.checkNotNull(batch);
        int elements = Ints.checkedCast((long)this.elementCounter.count(batch));
        int bytes = Ints.checkedCast((long)this.byteCounter.count(batch));
        this.flowController.release(elements, bytes);
    }
}

