/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/Device','sap/ui/mdc/enum/EditMode','sap/ui/mdc/enum/FieldDisplay','sap/ui/mdc/field/FieldBaseRenderer','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/condition/Condition','sap/ui/mdc/field/ConditionType','sap/ui/mdc/field/ConditionsType','sap/ui/mdc/enum/BaseType','sap/ui/mdc/util/DateUtil','sap/ui/core/library','sap/ui/mdc/Control','sap/ui/core/LabelEnablement','sap/ui/core/message/MessageMixin','sap/base/util/ObjectPath','sap/base/util/deepEqual','sap/base/util/merge','sap/base/Log','sap/base/util/isEmptyObject','sap/ui/dom/containsOrEquals','sap/ui/model/Filter','sap/ui/model/BindingMode','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException','sap/ui/model/base/ManagedObjectModel','sap/ui/base/ManagedObjectObserver','sap/ui/base/SyncPromise','sap/base/util/restricted/_throttle','sap/ui/events/KeyCodes'],function(q,D,E,F,a,b,C,c,d,B,e,f,g,L,M,O,h,m,k,l,n,o,p,r,P,V,s,t,S,u,K){"use strict";var v=f.ValueState;var w=f.CalendarType;var x=g.extend("sap.ui.mdc.field.FieldBase",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.ui.mdc",properties:{dataType:{type:"string",group:"Data",defaultValue:'sap.ui.model.type.String'},dataTypeConstraints:{type:"object",group:"Data",defaultValue:null},dataTypeFormatOptions:{type:"object",group:"Data",defaultValue:null},editMode:{type:"sap.ui.mdc.enum.EditMode",group:"Data",defaultValue:E.Editable},required:{type:"boolean",group:"Data",defaultValue:false},display:{type:"sap.ui.mdc.enum.FieldDisplay",defaultValue:F.Value},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:sap.ui.core.TextAlign.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},placeholder:{type:"string",group:"Misc",defaultValue:""},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:sap.ui.core.ValueState.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},multipleLines:{type:"boolean",group:"Appearance",defaultValue:false},maxConditions:{type:"int",group:"Behavior",defaultValue:-1},conditions:{type:"object[]",group:"Data",defaultValue:[],byValue:true},label:{type:"string",group:"Misc",defaultValue:""},delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/field/FieldBaseDelegate",payload:{}}},_fieldHelpEnabled:{type:"boolean",group:"Appearance",defaultValue:false,visibility:"hidden"},_ariaAttributes:{type:"object",defaultValue:{},byValue:true,visibility:"hidden"}},aggregations:{content:{type:"sap.ui.core.Control",multiple:false},contentEdit:{type:"sap.ui.core.Control",multiple:false},contentDisplay:{type:"sap.ui.core.Control",multiple:false},_content:{type:"sap.ui.core.Control",multiple:true,visibility:"hidden"},fieldInfo:{type:"sap.ui.mdc.field.FieldInfoBase",multiple:false}},associations:{fieldHelp:{type:"sap.ui.mdc.field.FieldHelpBase",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{liveChange:{parameters:{value:{type:"string"},escPressed:{type:"boolean"},previousValue:{type:"string"}}},press:{},submit:{parameters:{promise:{type:"Promise"}}}},publicMethods:[],defaultAggregation:"content"},_oManagedObjectModel:null});M.call(x.prototype);var y={Default:{edit:"sap/ui/mdc/field/FieldInput",editMulti:["sap/ui/mdc/field/FieldMultiInput","sap/m/Token"],editMultiLine:"sap/m/TextArea",display:"sap/m/Text",createEdit:q1,createEditMulti:s1,createEditMultiLine:t1,createDisplay:u1,useDefaultFieldHelp:{name:"defineConditions",oneOperatorSingle:false,oneOperatorMulti:false},defaultEnterHandler:true},Search:{edit:"sap/m/SearchField",display:"sap/m/Text",createEdit:r1,createDisplay:u1,useDefaultFieldHelp:false,defaultEnterHandler:false},Date:{edit:"sap/ui/mdc/field/FieldInput",editMulti:["sap/ui/mdc/field/FieldMultiInput","sap/m/Token"],display:"sap/m/Text",editOperator:{"EQ":{name:"sap/m/DatePicker",create:v1},"BT":{name:"sap/m/DateRangeSelection",create:w1}},createEdit:q1,createEditMulti:s1,createDisplay:u1,useDefaultFieldHelp:{name:"defineConditions",oneOperatorSingle:false,oneOperatorMulti:true},defaultEnterHandler:true},Time:{edit:"sap/ui/mdc/field/FieldInput",editMulti:["sap/ui/mdc/field/FieldMultiInput","sap/m/Token"],display:"sap/m/Text",editOperator:{"EQ":{name:"sap/m/TimePicker",create:v1}},createEdit:q1,createEditMulti:s1,createDisplay:u1,useDefaultFieldHelp:{name:"defineConditions",oneOperatorSingle:false,oneOperatorMulti:true},defaultEnterHandler:true},DateTime:{edit:"sap/ui/mdc/field/FieldInput",editMulti:["sap/ui/mdc/field/FieldMultiInput","sap/m/Token"],display:"sap/m/Text",editOperator:{"EQ":{name:"sap/m/DateTimePicker",create:v1}},createEdit:q1,createEditMulti:s1,createDisplay:u1,useDefaultFieldHelp:{name:"defineConditions",oneOperatorSingle:false,oneOperatorMulti:true},defaultEnterHandler:true},Link:{edit:"sap/ui/mdc/field/FieldInput",editMulti:["sap/ui/mdc/field/FieldMultiInput","sap/m/Token"],editMultiLine:"sap/m/TextArea",display:"sap/m/Link",createEdit:q1,createEditMulti:s1,createEditMultiLine:t1,createDisplay:x1,useDefaultFieldHelp:false,defaultEnterHandler:true},Boolean:{edit:"sap/ui/mdc/field/FieldInput",display:"sap/m/Text",createEdit:y1,createDisplay:u1,useDefaultFieldHelp:{name:"bool",oneOperatorSingle:true,oneOperatorMulti:true},defaultEnterHandler:true},Unit:{edit:"sap/ui/mdc/field/FieldInput",editMulti:["sap/ui/mdc/field/FieldMultiInput","sap/ui/mdc/field/FieldInput","sap/m/Token"],display:"sap/m/Text",createEdit:z1,createEditMulti:A1,createDisplay:u1,useDefaultFieldHelp:false,defaultEnterHandler:true}};var z={onsapprevious:C1,onsapnext:C1,onsapup:C1,onsapdown:C1,onsapbackspace:C1};var A={onsapenter:I};var G;var H;x._init=function(){G={};if(H&&H.bool&&H.bool.control){H.bool.control.destroy();}if(H&&H.defineConditions&&H.defineConditions.control){H.defineConditions.control.destroy();}H={bool:{name:"sap/ui/mdc/field/BoolFieldHelp",id:"BoolDefaultHelp",getDelegate:"getDefaultFieldHelpBaseDelegate",properties:{},control:undefined},defineConditions:{name:"sap/ui/mdc/field/FieldValueHelp",id:"Field-DefineConditions-Help",getDelegate:"getDefaultFieldValueHelpDelegate",properties:{showConditionPanel:true},control:undefined}};};x._init();x.prototype.init=function(){g.prototype.init.apply(this,arguments);this._oManagedObjectModel=new s(this);this._oObserver=new t(this._observeChanges.bind(this));this._oObserver.observe(this,{properties:["display","editMode","dataType","dataTypeFormatOptions","dataTypeConstraints","multipleLines","maxConditions","conditions","delegate"],aggregations:["fieldInfo","content","contentEdit","contentDisplay"],associations:["fieldHelp","ariaLabelledBy"]});this._oDatePickerRequested={};this.attachEvent("modelContextChange",this._handleModelContextChange,this);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._aAsyncChanges=[];this._bPreventGetDescription=false;};x.prototype.exit=function(){var i=this.getFieldInfo();if(i){i.detachEvent("dataUpdate",e2,this);}var j=this.getContent();if(j){j1.call(this,j);}var p2=this.getContentEdit();if(p2){j1.call(this,p2);}var q2=this.getContentDisplay();if(q2){j1.call(this,q2);}this._oManagedObjectModel.destroy();delete this._oManagedObjectModel;this._oObserver.disconnect();this._oObserver=undefined;if(this._oConditionType&&this._oConditionType._bCreatedByField){this._oConditionType.destroy();this._oConditionType=undefined;}if(this._oConditionsType&&this._oConditionsType._bCreatedByField){this._oConditionsType.destroy();this._oConditionsType=undefined;}var r2=U1.call(this);if(r2){r2.detachEvent("dataUpdate",$1,this);if(this._bConnected){_1.call(this);r2.connect();}}P1.call(this);delete this._fnLiveChangeTimer;};x.prototype.applySettings=function(){g.prototype.applySettings.apply(this,arguments);if(!this.bDelegateInitialized&&!this.bDelegateLoaded){this.initControlDelegate();}return this;};x.prototype.setProperty=function(i,j,p2){if(i!=="width"&&i!=="editMode"){p2=true;}return g.prototype.setProperty.apply(this,[i,j,p2]);};x.prototype.onBeforeRendering=function(){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){l1.call(this);}.bind(this));return;}l1.call(this);};x.prototype.onAfterRendering=function(){};x.prototype.onfocusin=function(i){a2.call(this);};x.prototype.onsapfocusleave=function(i){P1.call(this);};x.prototype.onsapup=function(i){var j=U1.call(this);var p2=i.srcControl;if(j&&(!this._bIsMeasure||p2.getShowValueHelp())){i.preventDefault();i.stopPropagation();j.navigate(-1);}};x.prototype.onsapdown=function(i){var j=U1.call(this);var p2=i.srcControl;if(j&&(!this._bIsMeasure||p2.getShowValueHelp())){i.preventDefault();i.stopPropagation();j.navigate(1);}};x.prototype.onsapenter=function(i){var j=U1.call(this);if(j&&j.isOpen(true)){j.close();}};x.prototype.onsapescape=function(i){this.onsapenter(i);};x.prototype.ontap=function(i){var j=U1.call(this);if(j&&j.openByClick()&&!j.isOpen(true)){j.open(true);}};x.prototype.clone=function(i,j){this.detachEvent("modelContextChange",this._handleModelContextChange,this);var p2=this.getContent();if(p2){j1.call(this,p2);}var q2=this.getContentEdit();if(q2){j1.call(this,q2);}var r2=this.getContentDisplay();if(r2){j1.call(this,r2);}var s2=this.getFieldInfo();if(s2){s2.detachEvent("dataUpdate",e2,this);}var t2=g.prototype.clone.apply(this,arguments);this.attachEvent("modelContextChange",this._handleModelContextChange,this);if(p2){i1.call(this,p2);}if(q2){i1.call(this,q2);}if(r2){i1.call(this,r2);}if(s2){s2.attachEvent("dataUpdate",e2,this);}return t2;};x.prototype.getFieldPath=function(){var i=this.getBindingPath("conditions");if(i&&i.startsWith("/conditions/")){return i.slice(12);}else{return"";}};function _(i,j,p2,q2){if(!q2){if(j){q2=Promise.resolve(this._getResultForPromise(i));}else{q2=Promise.reject(p2);}}this._fireChange(i,j,p2,q2);}x.prototype._fireChange=function(i,j,p2,q2){};function I(j){var p2=this.getEditMode();if(Y(p2)&&this.hasListeners("submit")){var q2=[];var r2;for(var i=0;i<this._aAsyncChanges.length;i++){q2.push(this._aAsyncChanges[i].promise);}if(q2.length>0){r2=Promise.all(q2).then(function(){return this._getResultForPromise(this.getConditions());}.bind(this));}else if(this._bParseError){r2=Promise.reject();}else{r2=Promise.resolve(this._getResultForPromise(this.getConditions()));}this.fireSubmit({promise:r2});}}function J(){if(!this._oDataType){var i=this.getDataType();if(typeof i==="string"){this._oDataType=this.getTypeUtil().getDataTypeInstance(i,this.getDataTypeFormatOptions(),this.getDataTypeConstraints());this._oDataType._bCreatedByField=true;}}return this._oDataType;}x.prototype._initDataType=function(){if(this._oDataType){this._oDataType.destroy();this._oDataType=undefined;}if(this._oDateOriginalType){if(this._oDateOriginalType._bCreatedByField){this._oDateOriginalType.destroy();}this._oDateOriginalType=undefined;}if(this._oUnitOriginalType){if(this._oUnitOriginalType._bCreatedByField){this._oUnitOriginalType.destroy();}this._oUnitOriginalType=undefined;}delete this._sDisplayFormat;delete this._sValueFormat;delete this._sCalendarType;};function N(){if(this._oDataType&&typeof this._oDataType==="object"){return this._oDataType.getMetadata().getName();}else if(this.bDelegateInitialized){return this.getControlDelegate().getDataTypeClass(this.getPayload(),this.getDataType());}else{return this.getDataType();}}function Q(){if(this._oDataType&&typeof this._oDataType==="object"&&this._oDataType.oConstraints){return this._oDataType.oConstraints;}else{return this.getDataTypeConstraints();}}function R(){if(this._oDataType&&typeof this._oDataType==="object"&&this._oDataType.oFormatOptions){return this._oDataType.oFormatOptions;}else{return this.getDataTypeFormatOptions();}}function T(i,j,p2){var q2=this.getTypeUtil().getBaseType(i,j,p2);switch(q2){case B.Date:this._sValueFormat="yyyy-MM-dd";break;case B.DateTime:this._sValueFormat="yyyy-MM-dd'T'HH:mm:ss";break;case B.Time:this._sValueFormat="HH:mm:ss";break;default:return;}this._sDisplayFormat="medium";if(j){if(j.style){this._sDisplayFormat=j.style;}else if(j.pattern){this._sDisplayFormat=j.pattern;}if(j.calendarType){this._sCalendarType=j.calendarType;}}}function U(){var i=J.call(this);var j=i.getMetadata().getName();var p2=i.oFormatOptions;var q2=i.oConstraints;T.call(this,j,p2,q2);if(!p2||p2.style||!p2.pattern||p2.pattern!==this._sValueFormat||!p2.calendarType||p2.calendarType!==w.Gregorian){this._oDateOriginalType=this._oDataType;this._oDataType=e.createInternalType(i,this._sValueFormat);g2.call(this);}}function W(){var i=J.call(this);var j=i.getMetadata().getName();var p2=i.oFormatOptions;var q2=l(i.oConstraints)?undefined:i.oConstraints;if(!p2||!p2.hasOwnProperty("showMeasure")||p2.showMeasure){p2=m({},p2);p2.showMeasure=false;p2.strictParsing=true;if(p2.customCurrencies){delete p2.customCurrencies;}if(p2.customUnits){delete p2.customUnits;}var r2=O.get(j);this._oUnitOriginalType=this._oDataType;this._oDataType=new r2(p2,q2);this.getControlDelegate().initializeInternalUnitType(this.getPayload(),this._oDataType,this._oTypeInitialization);g2.call(this);}}function X(i,j){var p2=U1.call(this);if(p2&&this._bConnected){V1.call(this,i,p2);}}x.prototype._getContent=function(){var i=this.getContent();if(!i){if(this.getEditMode()===E.Display){i=this.getContentDisplay();}else{i=this.getContentEdit();}}if(i){return[i];}else{return this.getAggregation("_content",[]);}};function Y(i){if(i===E.Editable||i===E.EditableReadOnly||i===E.EditableDisplay){return true;}else{return false;}}function Z(i){if(i===E.Editable){return true;}else{return false;}}function $(i){if(i&&i!==E.Disabled){return true;}else{return false;}}function a1(i){if(i&&i!==E.Editable){return true;}else{return false;}}x.prototype._handleModelContextChange=function(i){};function b1(i){this.setValueState(v.Error);this.setValueStateText(i);}function c1(){this.setValueState(v.None);this.setValueStateText();}x.prototype._observeChanges=function(j){var p2=function(){if(this.getAggregation("_content",[]).length>0){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){l1.call(this);}.bind(this));}else{l1.call(this);}}};if(j.name==="multipleLines"){p2.call(this);}if(j.name==="dataType"){if(this._oDataType){var q2=function(t2){var u2=this.getTypeUtil().getDataTypeClass(j.current);if(!(this._oDataType instanceof u2)){this._initDataType();this.destroyAggregation("_content");g2.call(this);}}.bind(this);if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){q2.call(this,j.current);}.bind(this));return;}q2.call(this,j.current);}}if(j.name==="dataTypeFormatOptions"||j.name==="dataTypeConstraints"){if(this._oDataType){this._initDataType();this.destroyAggregation("_content");g2.call(this);}}if(j.name==="maxConditions"){p2.call(this);g2.call(this);}if(j.name==="conditions"){this._bParseError=false;X.call(this,j.current,j.old);var r2=false;var i=0;for(i=0;i<this._aAsyncChanges.length;i++){var s2=this._aAsyncChanges[i];if(s2.waitForUpdate&&h(s2.result,j.current)){M1.call(this,s2);r2=true;break;}}if(r2){this._aAsyncChanges.splice(i,1);}}if(j.name==="display"){n1.call(this);g2.call(this);}if(j.name==="fieldHelp"&&j.ids){S1.call(this,j.ids,j.mutation);g2.call(this);}if(j.name==="fieldInfo"&&j.child){d2.call(this,j.child,j.mutation);}if(j.name==="content"&&j.child){h1.call(this,j.child,j.mutation,j.name);}if(j.name==="contentEdit"&&j.child){h1.call(this,j.child,j.mutation,j.name);}if(j.name==="contentDisplay"&&j.child){h1.call(this,j.child,j.mutation,j.name);}if(j.name==="delegate"&&!this.bDelegateInitialized&&!this.bDelegateLoaded){this.initControlDelegate.call(this);}if(j.name==="ariaLabelledBy"&&j.ids){d1.call(this,j.ids,j.mutation);}};x.prototype.getFocusDomRef=function(){var i=this._getContent();if(i.length>0){return i[0].getFocusDomRef();}else{return this.getDomRef();}};x.prototype.getIdForLabel=function(){var i;var j=this._getContent();if(j.length>0){i=j[0].getIdForLabel();}else{i=m1.call(this);}return i;};x.prototype.getControlForSuggestion=function(){var i=this._getContent();if(i.length>0){if(this._bIsMeasure){return i[1];}else{return i[0];}}else{return this;}};x.prototype.getMaxConditionsForHelp=function(){if(this._bIsMeasure){return 1;}else{return this.getMaxConditions();}};x.prototype.enhanceAccessibilityState=function(i,j){var p2=this.getParent();if(p2&&p2.enhanceAccessibilityState){p2.enhanceAccessibilityState(this,j);}return j;};x.prototype.getAccessibilityInfo=function(){var i=this._getContent();if(i.length>0&&i[0].getAccessibilityInfo){return i[0].getAccessibilityInfo();}else{return{};}};function d1(j,p2){var q2=this.getAggregation("_content",[]);var r2=this.getContent();if(r2){q2.push(r2);}r2=this.getContentDisplay();if(r2){q2.push(r2);}r2=this.getContentEdit();if(r2){q2.push(r2);}for(var i=0;i<q2.length;i++){r2=q2[i];if(r2.getMetadata().getAllAssociations().ariaLabelledBy){if(p2==="remove"){r2.removeAriaLabelledBy(j);}else if(p2==="insert"){r2.addAriaLabelledBy(j);}}}}function e1(j){var p2=this.getAriaLabelledBy();for(var i=0;i<p2.length;i++){var q2=p2[i];j.addAriaLabelledBy(q2);}}function f1(i,j){var p2={aria:{}};var q2=U1.call(this);if(q2){var r2=q2.getRoleDescription();p2["role"]="combobox";if(r2){p2.aria["roledescription"]=r2;}p2.aria["haspopup"]="listbox";p2["autocomplete"]="off";if(i){p2.aria["expanded"]="true";p2.aria["controls"]=q2.getContentId();if(j){p2.aria["activedescendant"]=j;}}else{p2.aria["expanded"]="false";}}this.setProperty("_ariaAttributes",p2,true);}x.prototype.connectLabel=function(i){p1.call(this,i);i.bindProperty("text",{path:"$field>/label"});i.setLabelFor(this);return this;};function g1(){var j=L.getReferencingLabels(this);for(var i=0;i<j.length;i++){var p2=sap.ui.getCore().byId(j[i]);p2.invalidate();}}function h1(i,j,p2){if(j==="remove"){j1.call(this,i);E1.call(this,i);if(this._oContentConditionTypes){delete this._oContentConditionTypes[p2];}i.setModel(null,"$field");}else if(j==="insert"){D1.call(this,i,true);i1.call(this,i);if(this.getAggregation("_content",[]).length>0){n1.call(this);}if(!this._oContentConditionTypes){this._oContentConditionTypes={};}if(!this._oContentConditionTypes[p2]){this._oContentConditionTypes[p2]={};}var q2;var r2;for(r2 in i.getMetadata().getAllProperties()){if(i.getBindingPath(r2)==="/conditions"){q2=i.getBindingInfo(r2);if(q2&&q2.type&&q2.type instanceof d){this._oContentConditionTypes[p2].oConditionsType=q2.type;}this._sBoundProperty=r2;}if(r2==="editable"&&!i.getBindingPath(r2)&&i.isPropertyInitial(r2)){i.bindProperty(r2,{path:"$field>/editMode",formatter:Y});}if(r2==="enabled"&&!i.getBindingPath(r2)&&i.isPropertyInitial(r2)){i.bindProperty(r2,{path:"$field>/editMode",formatter:$});}if(r2==="displayOnly"&&!i.getBindingPath(r2)&&i.isPropertyInitial(r2)){i.bindProperty(r2,{path:"$field>/editMode",formatter:a1});}if(r2==="required"&&!i.getBindingPath(r2)&&i.isPropertyInitial(r2)){i.bindProperty(r2,{path:"$field>/required"});}if(r2==="textAlign"&&!i.getBindingPath(r2)&&i.isPropertyInitial(r2)){i.bindProperty(r2,{path:"$field>/textAlign"});}if(r2==="textDirection"&&!i.getBindingPath(r2)&&i.isPropertyInitial(r2)){i.bindProperty(r2,{path:"$field>/textDirection"});}if(r2==="valueState"&&!i.getBindingPath(r2)&&i.isPropertyInitial(r2)){i.bindProperty(r2,{path:"$field>/valueState"});}if(r2==="valueStateText"&&!i.getBindingPath(r2)&&i.isPropertyInitial(r2)){i.bindProperty(r2,{path:"$field>/valueStateText"});}if(r2==="placeholder"&&!i.getBindingPath(r2)&&i.isPropertyInitial(r2)){i.bindProperty(r2,{path:"$field>/placeholder"});}}for(var s2 in i.getMetadata().getAllAggregations()){if(i.getBindingPath(s2)==="/conditions"){q2=i.getBindingInfo(s2);if(q2&&q2.template){for(r2 in q2.template.getMetadata().getAllProperties()){var t2=q2.template.getBindingInfo(r2);if(t2&&t2.type&&t2.type instanceof c){this._oContentConditionTypes[p2].oConditionType=t2.type;break;}}}}if(s2==="tooltip"&&!i.getBindingPath(s2)&&!i.getAggregation(s2)){i.bindProperty(s2,{path:"$field>/tooltip"});}}if(i.getMetadata().getAllAssociations().ariaLabelledBy){e1.call(this,i);}}}function i1(i){if(i.getMetadata().getEvents().change){i.attachEvent("change",L1,this);}if(i.getMetadata().getEvents().liveChange){i.attachEvent("liveChange",O1,this);}if(i.getMetadata().getEvents().press){i.attachEvent("press",Q1,this);}}function j1(i){if(i.getMetadata().getEvents().change){i.detachEvent("change",L1,this);}if(i.getMetadata().getEvents().liveChange){i.detachEvent("liveChange",O1,this);}if(i.getMetadata().getEvents().press){i.detachEvent("press",Q1,this);}}function k1(){if(this._oConditionType&&!this._oConditionType._bCreatedByField){this._oConditionType=undefined;}if(this._oConditionsType&&!this._oConditionsType._bCreatedByField){this._oConditionsType=undefined;}var i=this.getEditMode();var j;var p2;if(this.getContent()){if(this._oContentConditionTypes.content){j=this._oContentConditionTypes.content.oConditionType;p2=this._oContentConditionTypes.content.oConditionsType;}}else if(i===E.Display&&this.getContentDisplay()){if(this._oContentConditionTypes.contentDisplay){j=this._oContentConditionTypes.contentDisplay.oConditionType;p2=this._oContentConditionTypes.contentDisplay.oConditionsType;}}else if(i!==E.Display&&this.getContentEdit()){if(this._oContentConditionTypes.contentEdit){j=this._oContentConditionTypes.contentEdit.oConditionType;p2=this._oContentConditionTypes.contentEdit.oConditionsType;}}if(j){if(this._oConditionType&&this._oConditionType._bCreatedByField){this._oConditionType.destroy();}this._oConditionType=j;}if(p2){if(this._oConditionsType&&this._oConditionsType._bCreatedByField){this._oConditionsType.destroy();}this._oConditionsType=p2;}g2.call(this);}function l1(){k1.call(this);T1.call(this,this.getFieldHelp());f1.call(this,false);var j=this.getEditMode();if(this.getContent()||this._bIsBeingDestroyed||(j===E.Display&&this.getContentDisplay())||(j!==E.Display&&this.getContentEdit())){n1.call(this);var p2=this._getContent();if(p2.length===1){p1.call(this,p2[0]);}return;}var q2=N.call(this);var r2=Q.call(this);var s2=R.call(this);var t2=this.getTypeUtil().getBaseType(q2,s2,r2);var u2=this.getMaxConditions();var v2=this._getOperators();var w2;var x2;var y2;var z2=this.getAggregation("_content",[]);var A2;var B2;if(z2.length>0){A2=z2[0];B2=A2.getMetadata().getName().replace(/\./g,"/");}w2=y[t2];if(!w2){if(this.getFieldInfo()&&this._bTriggerable){w2=y.Link;}else{var C2=new RegExp("^\\*(.*)\\*|\\$search$");if(C2.test(this.getFieldPath())&&this.getMaxConditions()===1){w2=y.Search;}else{w2=y.Default;}}}if(j===E.Display){x2=w2.display;y2=w2.createDisplay;}else if(u2!==1){x2=w2.editMulti;y2=w2.createEditMulti;}else if(this.getMultipleLines()){x2=w2.editMultiLine;y2=w2.createEditMultiLine;}else if(v2.length===1&&w2.editOperator&&w2.editOperator[v2[0]]){x2=w2.editOperator[v2[0]].name;y2=w2.editOperator[v2[0]].create;}else{x2=w2.edit;y2=w2.createEdit;}if(!x2){throw new Error("No control defined for type "+q2+" in "+this);}var D2;if(Array.isArray(x2)){D2=x2;x2=D2[0];}else{D2=[x2];}if(x2!==B2){this._bHideOperator=I1.call(this,v2);if(A2){n1.call(this);if(A2.isA("sap.m.DateTimeField")){this._initDataType();}g2.call(this);}var E2;var i=0;for(i=0;i<D2.length;i++){var F2=D2[i];if(!G[F2]){G[F2]={};}if(!G[F2].control){G[F2].control=sap.ui.require(F2);if(!G[F2].control){E2=undefined;}}if(i===0){E2=G[F2].control;}}if(!E2){if(G[x2].promise){G[x2].promise.then(l1.bind(this));return;}else{G[x2].promise=new Promise(function(J2){G[x2].resolve=J2;sap.ui.require(D2,o1.bind(this));}.bind(this)).then(l1.bind(this));return;}}if(H1.call(this,w2,v2,j,u2)){F1.call(this,w2.useDefaultFieldHelp.name);}else if(this._sDefaultFieldHelp){delete this._sDefaultFieldHelp;}var G2=m1.call(this);var H2=y2.call(this,E2,G2);for(i=0;i<H2.length;i++){var I2=H2[i];I2.attachEvent("parseError",J1,this);I2.attachEvent("validationError",K1,this);D1.call(this,I2,w2.defaultEnterHandler);p1.call(this,I2);if(this._bConnected&&((i===0&&!this._bIsMeasure)||(i===1&&this._bIsMeasure))){b2.call(this,I2);}this.addAggregation("_content",I2);}g1.call(this);}}function m1(){return this.getId()+"-inner";}function n1(){this.destroyAggregation("_content");if(this._oDateOriginalType){this._oDataType=this._oDateOriginalType;this._oDateOriginalType=undefined;}else if(this._oUnitOriginalType){this._oDataType=this._oUnitOriginalType;this._oUnitOriginalType=undefined;}if(this._bParseError){this._bParseError=false;c1.call(this);}}function o1(){for(var i=0;i<arguments.length;i++){var j=arguments[i];var p2=j.getMetadata().getName();p2=p2.replace(/\./g,"/");G[p2].control=j;if(G[p2].resolve){G[p2].resolve();delete G[p2].resolve;}}}function p1(i){i.setModel(this._oManagedObjectModel,"$field");}function q1(i,j){var p2=i2.call(this);var q2=new i(j,{value:{path:"$field>/conditions",type:p2},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:Y},enabled:{path:"$field>/editMode",formatter:$},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",showValueHelp:"{$field>/_fieldHelpEnabled}",ariaAttributes:"{$field>/_ariaAttributes}",width:"100%",tooltip:"{$field>/tooltip}",change:L1.bind(this),liveChange:O1.bind(this),valueHelpRequest:W1.bind(this)});q2._setPreferUserInteraction(true);c2.call(this,q2);e1.call(this,q2);this._sBoundProperty="value";return[q2];}function r1(i,j){this._bHideOperator=true;var p2=i2.call(this);g2.call(this);var q2=new i(j,{value:{path:"$field>/conditions",type:p2,mode:p.OneWay},placeholder:"{$field>/placeholder}",width:"100%",tooltip:"{$field>/tooltip}",search:I.bind(this),change:L1.bind(this),liveChange:O1.bind(this)});e1.call(this,q2);this._sBoundProperty="value";return[q2];}function s1(i,j){var p2=sap.ui.require("sap/m/Token");var q2=h2.call(this);var r2=new p2(j+"-token",{text:{path:'$field>',type:q2}});var s2=new i(j,{placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:Y},enabled:{path:"$field>/editMode",formatter:$},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",showValueHelp:"{$field>/_fieldHelpEnabled}",ariaAttributes:"{$field>/_ariaAttributes}",width:"100%",tooltip:"{$field>/tooltip}",tokens:{path:"$field>/conditions",template:r2},dependents:[r2],change:L1.bind(this),liveChange:O1.bind(this),tokenUpdate:R1.bind(this),valueHelpRequest:W1.bind(this)});s2._setPreferUserInteraction(true);c2.call(this,s2);e1.call(this,s2);return[s2];}function t1(i,j){var p2=i2.call(this);var q2=new i(j,{value:{path:"$field>/conditions",type:p2},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:Y},enabled:{path:"$field>/editMode",formatter:$},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",width:"100%",rows:4,tooltip:"{$field>/tooltip}",change:L1.bind(this),liveChange:O1.bind(this)});q2._setPreferUserInteraction(true);e1.call(this,q2);this._sBoundProperty="value";return[q2];}function u1(i,j){var p2=i2.call(this);var q2=new i(j,{text:{path:"$field>/conditions",type:p2},textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",wrapping:"{$field>/multipleLines}",width:"100%",tooltip:"{$field>/tooltip}"});this._sBoundProperty="text";return[q2];}function v1(i,j){this._bHideOperator=true;var p2=i2.call(this);U.call(this);var q2=new i(j,{value:{path:"$field>/conditions",type:p2},displayFormat:this._sDisplayFormat,valueFormat:this._sValueFormat,placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:Y},enabled:{path:"$field>/editMode",formatter:$},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",width:"100%",tooltip:"{$field>/tooltip}",change:L1.bind(this)});if(q2.setDisplayFormatType){q2.setDisplayFormatType(this._sCalendarType);}q2._setPreferUserInteraction(true);e1.call(this,q2);this._sBoundProperty="value";return[q2];}function w1(i,j){var p2=i2.call(this);U.call(this);var q2=new i(j,{value:{path:"$field>/conditions",type:p2},displayFormat:this._sDisplayFormat,valueFormat:this._sValueFormat,delimiter:"...",displayFormatType:this._sCalendarType,placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:Y},enabled:{path:"$field>/editMode",formatter:$},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",width:"100%",tooltip:"{$field>/tooltip}",change:L1.bind(this)});q2._setPreferUserInteraction(true);e1.call(this,q2);this._sBoundProperty="value";return[q2];}function x1(i,j){var p2=this.getFieldInfo();var q2=i2.call(this);var r2=new i(j,{text:{path:"$field>/conditions",type:q2},textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",tooltip:"{$field>/tooltip}",press:Q1.bind(this),wrapping:true});if(p2){p2.getDirectLinkHrefAndTarget().then(f2.bind(this));}e1.call(this,r2);this._sBoundProperty="text";return[r2];}function y1(i,j){return q1.call(this,i,j);}function z1(i,j){W.call(this);this._bIsMeasure=true;var p2=i2.call(this);var q2=[];var r2=new i(j,{value:{path:"$field>/conditions",type:p2},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:Y},enabled:{path:"$field>/editMode",formatter:$},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",showValueHelp:false,width:"70%",tooltip:"{$field>/tooltip}",change:L1.bind(this),liveChange:O1.bind(this)});r2._setPreferUserInteraction(true);e1.call(this,r2);q2.push(r2);q2=B1.call(this,q2,j,i);this._sBoundProperty="value";return q2;}function A1(i,j){W.call(this);this._bIsMeasure=true;var p2=sap.ui.require("sap/m/Token");var q2=sap.ui.require("sap/m/Input");var r2=h2.call(this);var s2=[];var t2=new p2(j+"-token",{text:{path:'$field>',type:r2}});var u2=new o({path:"values",test:function(w2){if(!Array.isArray(w2[0])||w2[0][0]){return true;}else{return false;}}});var v2=new i(j,{placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:Y},enabled:{path:"$field>/editMode",formatter:$},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",showValueHelp:false,width:"70%",tooltip:"{$field>/tooltip}",tokens:{path:"$field>/conditions",template:t2,filters:[u2]},dependents:[t2],change:L1.bind(this),liveChange:O1.bind(this),tokenUpdate:R1.bind(this)});v2._setPreferUserInteraction(true);e1.call(this,v2);s2.push(v2);s2=B1.call(this,s2,j,q2);this._sBoundProperty="value";return s2;}function B1(i,j,p2){var q2=j2.call(this);if(this.getEditMode()===E.EditableDisplay){i[0].bindProperty("description",{path:"$field>/conditions",type:q2});i[0].setWidth("100%");i[0].setFieldWidth("70%");}else{var r2=new p2(j+"-unit",{value:{path:"$field>/conditions",type:q2},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:Z},enabled:{path:"$field>/editMode",formatter:$},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",showValueHelp:"{$field>/_fieldHelpEnabled}",ariaAttributes:"{$field>/_ariaAttributes}",width:"30%",tooltip:"{$field>/tooltip}",change:L1.bind(this),liveChange:O1.bind(this),valueHelpRequest:W1.bind(this)});r2._setPreferUserInteraction(true);c2.call(this,r2);e1.call(this,r2);i.push(r2);}return i;}function C1(i){var j=false;var p2=U1.call(this);if(!p2){return;}else if(p2.isOpen()){j=true;}else{switch(i.type){case"sapprevious":case"sapup":if(i.keyCode===K.ARROW_UP){j=true;}break;case"sapnext":case"sapdown":if(i.keyCode===K.ARROW_DOWN){j=true;}break;default:break;}}if(j){i.stopPropagation();i.stopImmediatePropagation(true);switch(i.type){case"sapup":this.onsapup(i);break;case"sapdown":this.onsapdown(i);break;default:break;}}}function D1(i,j){i.addDelegate(z,true,this);if(j){i.addDelegate(A,false,this);}}function E1(i){i.removeDelegate(z);i.removeDelegate(A);}function F1(i){this.setProperty("_fieldHelpEnabled",true,true);this._sDefaultFieldHelp=H[i].id;var j=H[i].control;if(j&&j.bIsDestroyed){H[i].control=undefined;j=undefined;}if(!j){if(H[i].promise){H[i].promise.then(G1.bind(this));}var p2=sap.ui.require(H[i].name);if(!p2&&!H[i].promise){H[i].promise=new Promise(function(s2){H[i].resolve=s2;sap.ui.require([H[i].name],function(t2){F1.call(this,i);}.bind(this));}.bind(this)).then(G1.bind(this));}if(p2){var q2=this.bDelegateInitialized&&this.getControlDelegate()[H[i].getDelegate]();var r2=m({delegate:q2},H[i].properties);j=new p2(H[i].id,r2);H[i].control=j;j.connect(this);if(H[i].resolve){H[i].resolve();delete H[i].resolve;}if(!H[i].promise){G1.call(this);}}}else{G1.call(this);}}function G1(){S1.call(this,"BoolDefaultHelp","insert");c2.call(this,this.getAggregation("_content",[])[0]);}function H1(i,j,p2,q2){if(i.useDefaultFieldHelp&&!this.getFieldHelp()&&p2!==E.Display){if(j.length===1){var r2=I1.call(this,j);if(q2===1){if(!(i.editOperator&&i.editOperator[j[0]])&&(i.useDefaultFieldHelp.oneOperatorSingle||!r2)){return true;}}else if(i.useDefaultFieldHelp.oneOperatorMulti||!r2){return true;}}else{return true;}}return false;}function I1(i){if(i.length===1){var j=b.getOperator(i[0]);return!j||j.isSingleValue();}else{return false;}}function J1(i){this._bParseError=true;}function K1(p2){this._bParseError=true;var q2=p2.getParameter("newValue");var r2=false;var i=0;for(i=0;i<this._aAsyncChanges.length;i++){var s2=this._aAsyncChanges[i];if(s2.waitForUpdate&&Array.isArray(s2.result)){for(var j=0;j<s2.result.length;j++){var t2=s2.result[j];if(h(t2.values[0],q2)||(t2.operator==="BT"&&h(t2.values[1],q2))){s2.reject(p2.getParameter("exception"));r2=true;break;}}if(r2){break;}}}if(r2){this._aAsyncChanges.splice(i,1);}}function L1(i){var j={parameters:m({},i.getParameters()),source:i.getSource()};var p2=this._aAsyncChanges.length;if(p2>0&&!this._aAsyncChanges[p2-1].changeFired){this._aAsyncChanges[p2-1].changeFired=true;this._aAsyncChanges[p2-1].changeEvent=j;_.call(this,undefined,undefined,undefined,this._aAsyncChanges[p2-1].promise);return;}var q2={changeEvent:j};M1.call(this,q2);}function M1(i){var j=this.getConditions();var p2;var q2=true;var r2;var s2;var t2=i.changeEvent.source;var u2=false;var v2=true;var w2=false;if(i.changeEvent.parameters.hasOwnProperty("valid")){q2=i.changeEvent.parameters["valid"];if(!q2&&i.changeEvent.parameters.hasOwnProperty("value")){r2=i.changeEvent.parameters["value"];}}var x2=false;var y2=this._sBoundProperty&&t2.getBinding(this._sBoundProperty);if(y2&&y2.getBindingMode()!==p.OneWay&&y2.getPath()==="/conditions"&&q2){s2=j[0];p2=j[0]&&j[0].values[0];}else if(i.changeEvent.parameters.hasOwnProperty("value")){p2=i.changeEvent.parameters["value"];if(q2){x2=true;}}else{s2=j[0];p2=j[0]&&j[0].values[0];}if(x2){c1.call(this);var z2;var A2;if(this._bIgnoreInputValue){this._bIgnoreInputValue=false;t2.setDOMValue("");return;}s2=S.resolve().then(function(){var C2=this.getMaxConditions();if(this._oNavigateCondition){q2=true;return this._oNavigateCondition;}else if(p2===""&&C2!==1){return null;}else{z2=h2.call(this);var D2=z2.parseValue(p2);var E2=this._aAsyncChanges.length;if(E2>0&&!this._aAsyncChanges[E2-1].changeFired){A2=this._aAsyncChanges[E2-1];A2.changeFired=true;A2.changeEvent=i.changeEvent;_.call(this,undefined,undefined,undefined,A2.promise);}return D2;}}.bind(this)).then(function(s2){v2=N1.call(this,s2,j,z2,q2,p2,t2,A2||i);v2=v2||w2;return s2;}.bind(this)).catch(function(C2){if(C2&&!(C2 instanceof P)&&!(C2 instanceof r)&&!(C2 instanceof V)){throw C2;}q2=false;r2=p2;this._bParseError=true;b1.call(this,C2.message);if(A2&&A2.reject){if(n2.call(this,A2)){A2.reject(C2);}}else if(u2){_.call(this,j,q2,r2);}}.bind(this)).unwrap();if(s2 instanceof Promise){u2=true;}}else if(!i.changeEvent.parameters.hasOwnProperty("valid")&&this._bParseError){r2=i.changeEvent.parameters["value"];q2=false;}var B2=U1.call(this);if(B2&&this._bConnected){if(sap.ui.getCore().getCurrentFocusedControlId()===t2.getId()){B2.close();}B2.setFilterValue("");if(!u2&&q2){V1.call(this,j,B2);B2.onFieldChange();}P1.call(this);}if(this._oNavigateCondition){this._oNavigateCondition=undefined;g2.call(this);}if(i.resolve){m2.call(this,i);}else if(!u2&&v2){_.call(this,j,q2,r2);}}function N1(i,j,p2,q2,r2,s2,t2){var u2=this.getMaxConditions();var v2=false;if(i===null&&u2!==1){return true;}if(p2){p2.validateValue(i);}if(q2){if(i){if(this._bIsMeasure&&j.length===1&&j[0].values[0][0]===undefined){j=[];}if(u2!==1&&b.indexOfCondition(i,j)>=0){throw new P(this._oResourceBundle.getText("field.CONDITION_ALREADY_EXIST",[r2]));}else{if(u2>0&&u2<=j.length){j.splice(0,j.length-u2+1);}j.push(i);}}else if(u2===1){j=[];}if(!h(j,this.getConditions())){this.setProperty("conditions",j,true);v2=true;}if(u2!==1){s2.setValue("");}}if(t2.resolve){var w2=U1.call(this);if(w2&&this._bConnected){V1.call(this,j,w2);w2.onFieldChange();}t2.result=j;m2.call(this,t2);n2.call(this,t2);}return v2;}function O1(j){var p2;var q2;var r2=false;var s2=j.getSource();this._oNavigateCondition=undefined;g2.call(this);if("value"in j.getParameters()){p2=j.getParameter("value");}else if("newValue"in j.getParameters()){p2=j.getParameter("newValue");}if("escPressed"in j.getParameters()){r2=j.getParameter("escPressed");}if("previousValue"in j.getParameters()){q2=j.getParameter("previousValue");}else{var t2=this.getConditions();q2=t2[0]&&t2[0].values[0];}this._bParseError=false;var u2=U1.call(this);if(u2&&(!this._bIsMeasure||s2.getShowValueHelp())){if(r2){if(u2.isOpen(true)){u2.close();P1.call(this);}}else{var v2=this._getOperators();var w2=false;for(var i=0;i<v2.length;i++){var x2=b.getOperator(v2[i]);if(x2.validateInput){w2=true;break;}}if(w2){this._bIgnoreInputValue=false;this._vLiveChangeValue=p2;if(!this._fnLiveChangeTimer){this._fnLiveChangeTimer=u(function(){var z2=this.getDisplay();var A2="";if(this._vLiveChangeValue){var x2=b.getEQOperator();var B2=x2.getValues(this._vLiveChangeValue,z2,true);if(B2[0]){A2=B2[0];if(B2[1]){A2=A2+" ";}}if(B2[1]){A2=A2+B2[1];}}var y2=u2.openByTyping();if(this._bConnected&&this._getContent()[0]&&y2&&!(y2 instanceof Promise)&&(sap.ui.getCore().getCurrentFocusedControlId()===this._getContent()[0].getId()||(this._getContent()[1]&&sap.ui.getCore().getCurrentFocusedControlId()===this._getContent()[1].getId()))){u2.setFilterValue(A2);if(this.getMaxConditionsForHelp()===1&&u2.getConditions().length>0){u2.setConditions([]);}u2.open(true);f1.call(this,true);delete this._vLiveChangeValue;}}.bind(this),300,{leading:false,trailing:true});}var y2=u2.openByTyping();if(y2 instanceof Promise){y2.then(function(){var z2=document.activeElement;if(z2&&(n(this.getDomRef(),z2))&&this._fnLiveChangeTimer){this._fnLiveChangeTimer();}}.bind(this));}this._fnLiveChangeTimer();}}}this.fireLiveChange({value:p2,escPressed:r2,previousValue:q2});}function P1(){if(this._fnLiveChangeTimer){this._fnLiveChangeTimer.cancel();delete this._vLiveChangeValue;}}function Q1(i){var j=this.getFieldInfo();if(j){j.getTriggerHref().then(function(p2){if(!p2){j.open(this._getContent()[0]);f1.call(this,true);}}.bind(this));}this.firePress();}function R1(j){if(j.getParameter("type")==="removed"){var p2=j.getParameter("removedTokens");var q2=this.getConditions();var r2;var i;for(i=0;i<p2.length;i++){var s2=p2[i];var t2=s2.getBindingContext("$field").sPath;var u2=parseInt(t2.slice(t2.lastIndexOf("/")+1));q2[u2].delete=true;}for(i=q2.length-1;i>=0;i--){if(q2[i].delete){if(this._bIsMeasure){r2=q2[i].values[0][1];}q2.splice(i,1);}}if(this._bIsMeasure&&r2&&q2.length===0){q2=[C.createItemCondition([undefined,r2],undefined)];}this.setProperty("conditions",q2,true);_.call(this,q2,true);j.preventDefault(true);}}function S1(i,j){if(j==="remove"){var p2=sap.ui.getCore().byId(i);if(p2){p2.detachEvent("select",X1,this);p2.detachEvent("navigate",Y1,this);p2.detachEvent("dataUpdate",$1,this);p2.detachEvent("disconnect",_1,this);p2.detachEvent("afterClose",Z1,this);}this.setProperty("_fieldHelpEnabled",false,true);}else if(j==="insert"){T1.call(this,i);}X.call(this,this.getConditions());}function T1(i){if(i&&!this.getProperty("_fieldHelpEnabled")){var j=sap.ui.getCore().byId(i);if(j){j.attachEvent("dataUpdate",$1,this);this.setProperty("_fieldHelpEnabled",true,true);}}}function U1(){var i=this.getFieldHelp();var j;if(!i&&this._sDefaultFieldHelp){i=this._sDefaultFieldHelp;}if(i){j=sap.ui.getCore().byId(i);}return j;}function V1(j,p2){if(!p2){p2=U1.call(this);}if(this._bIsMeasure){var q2=[];for(var i=0;i<j.length;i++){var r2=j[i];if(r2.values[0]&&r2.values[0][1]){var s2=C.createItemCondition(r2.values[0][1],undefined,r2.inParameters,r2.outParameters);q2.push(s2);}}p2.setConditions(q2);}else{p2.setConditions(j);}}function W1(i){var j=U1.call(this);if(j){j.setFilterValue("");var p2=this.getConditions();V1.call(this,p2,j);j.toggleOpen(false);f1.call(this,true);if(!j.isFocusInHelp()){var q2=i.getSource();if(q2.bValueHelpRequested){q2.bValueHelpRequested=false;}}}}function X1(j){var p2=this.getConditions();var q2=j.getParameter("conditions");var r2=j.getParameter("add");var s2=j.getParameter("close");var t2=j.oSource;var u2=this.getMaxConditions();var v2;var w2=this.getControlForSuggestion();var x2;var i=0;if(this._bIsMeasure){if(q2.length>1){throw new Error("Only one item must be selected! "+this);}if(q2[0].operator!=="EQ"){throw new Error("Only EQ allowed! "+this);}if(p2.length>0){for(i=0;i<p2.length;i++){p2[i].values[0][1]=q2[0].values[0];if(p2[i].operator==="BT"){p2[i].values[1][1]=q2[0].values[0];}if(q2[0].inParameters){p2[i].inParameters=q2[0].inParameters;}if(q2[0].outParameters){p2[i].outParameters=q2[0].outParameters;}}}else{v2=m({},q2[0]);v2.values[0]=[undefined,v2.values[0]];v2.values[1]=undefined;p2.push(v2);if(this._oConditionType){x2=this._oConditionType.formatValue(v2);}else if(this._oConditionsType){x2=this._oConditionsType.formatValue(p2);}}}else{if(!r2){p2=[];}for(i=0;i<q2.length;i++){v2=q2[i];if(!o2.call(this,v2.operator)){continue;}var y2=r2?-1:b.indexOfCondition(v2,p2);if(y2===-1){p2.push(v2);}else if(v2.values[1]!==p2[y2].values[1]&&p2[y2].values[1]){p2[y2].values[1]=v2.values[1];}}}if(u2>0&&u2<p2.length){p2.splice(0,p2.length-u2);}if(w2&&w2.setDOMValue){if(this.getMaxConditionsForHelp()===1&&p2.length>0){if(this._bIsMeasure&&this._oUnitConditionsType){x2=this._oUnitConditionsType.formatValue(p2);}else if(this._oConditionType){x2=this._oConditionType.formatValue(p2[0]);}else if(this._oConditionsType){x2=this._oConditionsType.formatValue(p2);}if(x2 instanceof Promise){x2.then(function(A2){w2.setDOMValue("");w2.setDOMValue(A2);});}else{w2.setDOMValue("");w2.setDOMValue(x2);}}else if(s2){w2.setDOMValue("");t2.setFilterValue("");this._bIgnoreInputValue=false;}else{this._bIgnoreInputValue=true;}}var z2=this.getConditions();if(!h(p2,z2)){this._oNavigateCondition=undefined;g2.call(this);this.setProperty("conditions",p2,true);if(!b.compareConditionsArray(p2,z2)){t2.onFieldChange();_.call(this,p2,true);}}}function Y1(i){var j=i.getParameter("value");var p2=i.getParameter("key");var q2=i.getParameter("condition");var r2=i.getParameter("itemId");var s2;var t2;var u2=this.getControlForSuggestion();if(q2){this._oNavigateCondition=m({},q2);p2=q2.values[0];j=q2.values[1];}else{this._oNavigateCondition=C.createItemCondition(p2,j);}if(this._bIsMeasure){var v2=this.getConditions();if(v2.length>0){this._oNavigateCondition.operator=v2[0].operator;this._oNavigateCondition.values[0]=[v2[0].values[0][0],this._oNavigateCondition.values[0]];if(v2[0].operator==="BT"){this._oNavigateCondition.values[1]=[v2[0].values[1][0],this._oNavigateCondition.values[0][1]];}else{this._oNavigateCondition.values[1]=undefined;}}else{this._oNavigateCondition.values=[[undefined,this._oNavigateCondition.values[0]],undefined];}}this._bPreventGetDescription=true;g2.call(this);if(this.getDisplay()!==F.Value){s2=p2;}else if(j){s2=j;}else{s2=p2;}if(u2&&u2.setDOMValue){if(!t2){if(this._bIsMeasure&&this._oUnitConditionsType&&this._oNavigateCondition){t2=this._oUnitConditionsType.formatValue([this._oNavigateCondition]);}else if(this._oConditionType&&this._oNavigateCondition){t2=this._oConditionType.formatValue(this._oNavigateCondition);}else if(this._oConditionsType&&this._oNavigateCondition){t2=this._oConditionsType.formatValue([this._oNavigateCondition]);}else{t2=j||p2;}}u2.setDOMValue(t2);u2._doSelect();}this._bPreventGetDescription=false;g2.call(this);f1.call(this,true,r2);this._bIgnoreInputValue=false;this.fireLiveChange({value:s2});}function Z1(i){if(this._bIgnoreInputValue){var j=this.getControlForSuggestion();this._bIgnoreInputValue=false;j.setDOMValue("");}f1.call(this,false);}function $1(i){var j=this.getEditMode()===E.Editable&&this._getContent().length>0&&sap.ui.getCore().getCurrentFocusedControlId()===this._getContent()[0].getId();if(!j&&!this._bPendingConditionUpdate&&this.getConditions().length>0&&(this.getMaxConditions()!==1||(this.getDisplay()!==F.Value&&!this._bParseError))){this._oManagedObjectModel.checkUpdate(true);}}function _1(i){var j=U1.call(this);j.detachEvent("select",X1,this);j.detachEvent("navigate",Y1,this);j.detachEvent("disconnect",_1,this);j.detachEvent("afterClose",Z1,this);this._bConnected=false;}function a2(){var i=U1.call(this);if(i&&!this._bConnected){i.connect(this);this._bConnected=true;i.attachEvent("select",X1,this);i.attachEvent("navigate",Y1,this);i.attachEvent("disconnect",_1,this);i.attachEvent("afterClose",Z1,this);var j=this.getConditions();V1.call(this,j,i);var p2=this.getControlForSuggestion();b2.call(this,p2);}}function b2(i){if(i&&!i.orgOnsapfocusleave&&i.onsapfocusleave){i.orgOnsapfocusleave=i.onsapfocusleave;i.onsapfocusleave=function(j){var p2=U1.call(this.getParent());if(p2){var q2=sap.ui.getCore().byId(j.relatedControlId);if(q2){if(n(p2.getDomRef(),q2.getFocusDomRef())){j.stopPropagation();return;}else{p2.skipOpening();}}}this.orgOnsapfocusleave(j);};}}function c2(i){var j=U1.call(this);if(j&&i&&i.addEndIcon){var p2=j.getIcon();var q2=i.getAggregation("_endIcon",[])[0];if(q2){q2.setSrc(p2);}else{i.addEndIcon({id:i.getId()+"-vhi",src:p2,useIconTooltip:false,noTabStop:true,press:function(r2){if(!this.getValueHelpOnly()){var s2;if(D.support.touch){s2=this.$('inner');s2.attr('readonly','readonly');this.focus();s2.removeAttr('readonly');}else{this.focus();}this.bValueHelpRequested=true;this.fireValueHelpRequest({fromSuggestions:false});}}.bind(i)});}}}function d2(i,j){if(j==="remove"){i.detachEvent("dataUpdate",e2,this);}else if(j==="insert"){i.attachEvent("dataUpdate",e2,this);e2.call(this);}}function e2(){var i=this.getFieldInfo();var j=this;i.isTriggerable().then(function(p2){j._bTriggerable=p2;if(j.getAggregation("_content",[]).length>0&&j.getEditMode()===E.Display){l1.call(j);if(j._bTriggerable){i.getDirectLinkHrefAndTarget().then(f2.bind(j));}}});}function f2(i){if(i){var j=this.getAggregation("_content",[])[0];j.setHref(i.href);j.setTarget(i.target);}}x.prototype._getFormatOptions=function(){if(!this._asyncParsingCall){this._asyncParsingCall=l2.bind(this);}return{valueType:J.call(this),originalDateType:this._oDateOriginalType||this._oUnitOriginalType,display:this._bIsMeasure?F.Value:this.getDisplay(),fieldHelpID:this._bIsMeasure?undefined:this.getFieldHelp()||this._sDefaultFieldHelp,operators:this._getOperators(),hideOperator:this._bHideOperator,maxConditions:this.getMaxConditions(),bindingContext:this.getBindingContext(),asyncParsing:this._asyncParsingCall,navigateCondition:this._oNavigateCondition,delegate:this.getControlDelegate(),delegateName:this.getDelegate()&&this.getDelegate().name,payload:this.getPayload(),preventGetDescription:this._bPreventGetDescription};};function g2(){if(this._oConditionType||this._oConditionsType){var i=this._getFormatOptions();if(this._oConditionType){this._oConditionType.setFormatOptions(i);}if(this._oConditionsType){this._oConditionsType.setFormatOptions(i);}if(this._oUnitConditionsType){i=k2.call(this);this._oUnitConditionsType.setFormatOptions(i);}}}x.prototype._updateConditionType=function(){g2.call(this);};function h2(){if(!this._oConditionType){var i=this._getFormatOptions();this._oConditionType=new c(i);this._oConditionType._bCreatedByField=true;}return this._oConditionType;}function i2(){if(!this._oConditionsType){var i=this._getFormatOptions();this._oConditionsType=new d(i);this._oConditionsType._bCreatedByField=true;}return this._oConditionsType;}x.prototype._checkValueInitial=function(i){if(i===null||i===undefined){return true;}if(i===""){var j=J.call(this);var p2=j.parseValue(i,"string");if(p2===i){return true;}else{try{j.validateValue(p2);}catch(q2){return true;}}}else{var r2=N.call(this);if(this.getTypeUtil().getBaseType(r2)===B.Unit&&Array.isArray(i)&&i.length>1&&(i[0]===undefined||i[0]===null)&&!i[1]){return true;}}return false;};function j2(){if(!this._oUnitConditionsType){var i=k2.call(this);this._oUnitConditionsType=new d(i);this._oUnitConditionsType._bCreatedByField=true;}return this._oUnitConditionsType;}function k2(){if(!this._asyncParsingCall){this._asyncParsingCall=l2.bind(this);}return{valueType:undefined,originalDateType:J.call(this),display:this.getDisplay(),fieldHelpID:this.getFieldHelp()||this._sDefaultFieldHelp,operators:["EQ"],hideOperator:true,maxConditions:1,bindingContext:this.getBindingContext(),asyncParsing:this._asyncParsingCall,navigateCondition:this._oNavigateCondition,delegate:this.getControlDelegate(),payload:this.getPayload(),preventGetDescription:this._bPreventGetDescription,isUnit:true,getConditions:this.getConditions.bind(this)};}function l2(i){var j=U1.call(this);if(j&&j.isOpen()){var p2=document.activeElement;if(p2&&(n(this.getDomRef(),p2)||n(j.getDomRef(),p2))){j.close();}}var q2={};var r2=new Promise(function(s2,t2){q2.resolve=s2;q2.reject=t2;i.then(function(u2){q2.result=u2;this._bParseError=false;var v2=this.getConditions();if(h(u2,v2)){m2.call(this,q2);n2.call(this,q2);}else{q2.waitForUpdate=true;}}.bind(this)).catch(function(u2){if(u2&&!(u2 instanceof P)&&!(u2 instanceof r)&&!(u2 instanceof V)){throw u2;}this._bParseError=true;t2(u2);n2.call(this,q2);}.bind(this));}.bind(this));q2.promise=r2;this._aAsyncChanges.push(q2);}x.prototype._getResultForPromise=function(i){return i;};function m2(i){i.resolve(this._getResultForPromise(i.result));}function n2(j){var p2=false;var i=0;for(i=0;i<this._aAsyncChanges.length;i++){if(j===this._aAsyncChanges[i]){p2=true;break;}}if(p2){this._aAsyncChanges.splice(i,1);}return p2;}x.prototype._getOperators=function(){var i=new RegExp("^\\*(.*)\\*|\\$search$");if(i.test(this.getFieldPath())&&this.getMaxConditions()===1){return["Contains"];}var j=N.call(this);var p2=Q.call(this);var q2=R.call(this);var r2=this.getTypeUtil().getBaseType(j,q2,p2);if(r2===B.Unit){r2=B.Numeric;}return b.getOperatorsForType(r2);};function o2(j){var p2=this._getOperators();for(var i=0;i<p2.length;i++){if(j===p2[i]){return true;}}return false;}return x;});
