/*
 * ! OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/mdc/filterbar/aligned/FilterContainer","sap/ui/mdc/filterbar/aligned/FilterItemLayout","sap/ui/mdc/filterbar/FilterBarBase","sap/ui/mdc/filterbar/FilterBarBaseRenderer",'sap/m/library','sap/m/Button',"sap/ui/mdc/p13n/StateUtil","sap/base/util/merge","sap/ui/mdc/filterbar/p13n/AdaptationFilterBar"],function(F,a,b,c,l,B,S,m,A){"use strict";var d=b.extend("sap.ui.mdc.FilterBar",{metadata:{designtime:"sap/ui/mdc/designtime/filterbar/FilterBar.designtime",properties:{showAdaptFiltersButton:{type:"boolean",defaultValue:true},showGoButton:{type:"boolean",defaultValue:true},p13nMode:{type:"sap.ui.mdc.FilterBarP13nMode[]"},_p13nModeItem:{type:"boolean",visibility:"hidden",defaultValue:false},_p13nModeValue:{type:"boolean",visibility:"hidden",defaultValue:false}}},renderer:c});var e=l.ButtonType;d.prototype._createInnerLayout=function(){this._cLayoutItem=a;this._oFilterBarLayout=new F();this._oFilterBarLayout.getInner().setParent(this);this._oFilterBarLayout.getInner().addStyleClass("sapUiMdcFilterBarBaseAFLayout");this.setAggregation("layout",this._oFilterBarLayout,true);this._addButtons();};d.prototype.setP13nMode=function(M){var o=this.getP13nMode();this.setProperty("p13nMode",M||[],false);M&&M.forEach(function(s){if(!o||o.indexOf(s)<0){this._setP13nMode(s,true);}}.bind(this));o&&o.forEach(function(s){if(!M||M.indexOf(s)<0){this._setP13nMode(s,false);}}.bind(this));return this;};d.prototype._setP13nMode=function(M,v){switch(M){case"Item":this._setP13nModeItem(v);break;case"Value":this._setP13nModeValue(v);break;}};d.prototype.setFilterConditions=function(v,s){S.checkConditionOperatorSanity(v);if(this._oP13nFB){this._oP13nFB.setFilterConditions(m({},v));}this.setProperty("filterConditions",v,s);return this;};d.prototype._getP13nModeItem=function(){return this._oModel.getProperty("/_p13nModeItem");};d.prototype._setP13nModeItem=function(v){this._oModel.setProperty("/_p13nModeItem",v,true);};d.prototype._getP13nModeValue=function(){return this._oModel.getProperty("/_p13nModeValue");};d.prototype._setP13nModeValue=function(v){this._oModel.setProperty("/_p13nModeValue",v,false);this._bPersistValues=v;};d.prototype._addButtons=function(){if(this._oFilterBarLayout){this.setProperty("_filterCount",this._oRb.getText("filterbar.ADAPT"),false);this._btnAdapt=new B(this.getId()+"-btnAdapt",{type:e.Transparent,text:"{"+b.INNER_MODEL_NAME+">/_filterCount}",press:this.onAdaptFilters.bind(this)});this._btnAdapt.setModel(this._oModel,b.INNER_MODEL_NAME);this._btnAdapt.bindProperty("visible",{parts:[{path:'/showAdaptFiltersButton',model:b.INNER_MODEL_NAME},{path:"/_p13nModeItem",model:b.INNER_MODEL_NAME}],formatter:function(v,V){return v&&V;}});this._btnAdapt.addStyleClass("sapUiMdcFilterBarBaseButtonPaddingRight");this._oFilterBarLayout.addButton(this._btnAdapt);this._btnSearch=this._getSearchButton();this._btnSearch.setModel(this._oModel,b.INNER_MODEL_NAME);this._btnSearch.bindProperty("visible",{parts:[{path:'/showGoButton',model:b.INNER_MODEL_NAME},{path:"/liveMode",model:b.INNER_MODEL_NAME}],formatter:function(v,V){return v&&((this._isPhone())?true:!V);}.bind(this)});this._oFilterBarLayout.addButton(this._btnSearch);}};d.prototype.retrieveInbuiltFilter=function(){var i=b.prototype.retrieveInbuiltFilter.apply(this,arguments);return i.then(function(I){I._bPersistValues=this._bPersistValues;return I;}.bind(this));};d.prototype.onAdaptFilters=function(E){return new Promise(function(r,f){return this._oMetadataAppliedPromise.then(function(){sap.ui.require(["sap/base/util/UriParameters"],function(g){var u=new g(window.location.search);var C=u.getAll("sap-ui-xx-complexP13n")[0]==="true";this.retrieveAdaptationController().then(function(o){o.setLiveMode(!C);r(o.showP13n(this._btnAdapt,C?"Filter":"Item"));}.bind(this));}.bind(this),f);}.bind(this),f);}.bind(this));};d.prototype.getCurrentState=function(){var s=b.prototype.getCurrentState.apply(this,arguments);if(!this.getProperty("_p13nModeItem")){delete s.items;}return s;};return d;});
