/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/EventProvider','sap/ui/base/ManagedObject','sap/ui/model/message/MessageModel','./Message','./ControlMessageProcessor','sap/ui/core/message/MessageProcessor',"sap/base/util/deepEqual","sap/base/Log",'sap/base/util/merge','sap/base/util/array/uniqueSort'],function(E,M,a,b,C,c,d,L,m,u){"use strict";var e=E.extend("sap.ui.core.message.MessageManager",{constructor:function(){E.apply(this,arguments);this.mProcessors={};this.mObjects={};this.mMessages={};var h=sap.ui.getCore().getConfiguration().getHandleValidation();if(h){sap.ui.getCore().attachValidationSuccess(h,this._handleSuccess,this);sap.ui.getCore().attachValidationError(h,this._handleError,this);sap.ui.getCore().attachParseError(h,this._handleError,this);sap.ui.getCore().attachFormatError(h,this._handleError,this);}},metadata:{publicMethods:["addMessages","removeMessages","removeAllMessages","registerMessageProcessor","unregisterMessageProcessor","registerObject","unregisterObject","getMessageModel","destroy"]}});e.prototype._handleError=function(o,h){if(!this.oControlMessageProcessor){this.oControlMessageProcessor=new C();}if(h){var f=o.getParameter("element");var p=o.getParameter("property");var t=f.getId()+'/'+p;var P=this.oControlMessageProcessor.getId();var T=o.sId==="formatError";if(this.mMessages[P]&&this.mMessages[P][t]){this._removeMessages(this.mMessages[P][t],true);}var r={};r[f.getId()]={properties:{},fieldGroupIds:f.getFieldGroupIds?f.getFieldGroupIds():undefined};r[f.getId()].properties[p]=true;var g=new b({type:sap.ui.core.MessageType.Error,message:o.getParameter("message"),target:t,processor:this.oControlMessageProcessor,technical:T,references:r,validation:true});this.addMessages(g);}o.cancelBubble();};e.prototype._handleSuccess=function(o,h){if(!this.oControlMessageProcessor){this.oControlMessageProcessor=new C();}if(h){var f=o.getParameter("element");var p=o.getParameter("property");var t=f.getId()+'/'+p;var P=this.oControlMessageProcessor.getId();if(this.mMessages[P]&&this.mMessages[P][t]){this._removeMessages(this.mMessages[P][t],true);}}o.cancelBubble();};e.prototype.addMessages=function(v){var o=v,p=this.getAffectedProcessors(v);if(!v){return;}else if(Array.isArray(v)){for(var i=0;i<v.length;i++){o=v[i];this._importMessage(o);}}else{this._importMessage(v);}this._updateMessageModel(p);};e.prototype._importMessage=function(o){var p=o.getMessageProcessor(),P=p&&p.getId(),t=o.getTargets(),f=this;if(!this.mMessages[P]){this.mMessages[P]={};}if(!t.length){t=[undefined];}t.forEach(function(T){var g=f.mMessages[P][T]?f.mMessages[P][T]:[];g.push(o);f.mMessages[P][T]=g;});};e.prototype._pushMessages=function(p){var P,i;for(i in p){P=p[i];var v=this.mMessages[i]?this.mMessages[i]:{};this._sortMessages(v);v=Object.keys(v).length===0?null:m({},v);P.setMessages(v);}};e.prototype._sortMessages=function(v){var t,f;if(Array.isArray(v)){v={"ignored":v};}for(t in v){f=v[t];if(f.length>1){f.sort(b.compare);}}};e.prototype._updateMessageModel=function(p){var A=new Map(),P,o=this.getMessageModel(),t;function s(f){A.set(f,true);}for(P in this.mMessages){for(t in this.mMessages[P]){this.mMessages[P][t].forEach(s);}}this._pushMessages(p);o.setData(Array.from(A.keys()));};e.prototype.removeAllMessages=function(){var p={};for(var P in this.mMessages){var f=Object.keys(this.mMessages[P])[0];var v=this.mMessages[P][f];Object.assign(p,this.getAffectedProcessors(v));}this.aMessages=[];this.mMessages={};this._updateMessageModel(p);};e.prototype.removeMessages=function(v){return this._removeMessages.apply(this,arguments);};e.prototype._removeMessages=function(v,o){var p=this.getAffectedProcessors(v);if(!v||(Array.isArray(v)&&v.length==0)){return;}else if(Array.isArray(v)){var O=v.slice(0);for(var i=0;i<O.length;i++){if(!o||O[i].validation){this._removeMessage(O[i]);}}}else if(v instanceof b&&(!o||v.validation)){this._removeMessage(v);}else{for(var t in v){this._removeMessages(v[t],o);}}this._updateMessageModel(p);};e.prototype._removeMessage=function(o){var p=o.getMessageProcessor(),P=p&&p.getId(),f=this.mMessages[P],t;if(!f){return;}t=o.getTargets();if(!t.length){t=[undefined];}t.forEach(function(T){var g=f[T];if(g){for(var i=0;i<g.length;i++){var h=g[i];if(d(h,o)){g.splice(i,1);--i;}}if(f[T].length===0){delete f[T];}}});};e.prototype.onMessageChange=function(o){var O=o.getParameter('oldMessages');var n=o.getParameter('newMessages');this.removeMessages(O);this.addMessages(n);};e.prototype.registerMessageProcessor=function(p){var P=p.getId(),f={};if(!this.mProcessors[P]){this.mProcessors[P]=P;p.attachMessageChange(this.onMessageChange,this);if(P in this.mMessages){f[P]=p;this._pushMessages(f);}}};e.prototype.unregisterMessageProcessor=function(p){this.removeMessagesByProcessor(p.getId());delete this.mProcessors[p.getId()];p.detachMessageChange(this.onMessageChange,this);};e.prototype.registerObject=function(o,h){if(!o instanceof M){L.error(this+" : "+o.toString()+" is not an instance of sap.ui.base.ManagedObject");return;}o.attachValidationSuccess(h,this._handleSuccess,this);o.attachValidationError(h,this._handleError,this);o.attachParseError(h,this._handleError,this);o.attachFormatError(h,this._handleError,this);};e.prototype.unregisterObject=function(o){if(!o instanceof M){L.error(this+" : "+o.toString()+" is not an instance of sap.ui.base.ManagedObject");return;}o.detachValidationSuccess(this._handleSuccess,this);o.detachValidationError(this._handleError,this);o.detachParseError(this._handleError,this);o.detachFormatError(this._handleError,this);};e.prototype.destroy=function(){L.warning("Deprecated: Do not call destroy on a MessageManager");};e.prototype.getMessageModel=function(){if(!this.oMessageModel){this.oMessageModel=new a(this);this.oMessageModel.setData([]);}return this.oMessageModel;};e.prototype.getAffectedProcessors=function(v){var p,P,f={};if(v){if(!Array.isArray(v)){v=[v];}v.forEach(function(o){p=o.getMessageProcessor();if(p instanceof c){P=p.getId();f[P]=p;}});}return f;};e.prototype.removeMessagesByProcessor=function(p){delete this.mMessages[p];this._updateMessageModel({});};return e;});
