/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','./library','sap/ui/core/Control','./PaginatorRenderer',"sap/ui/dom/jquery/Selectors"],function(q,l,C,P){"use strict";var a=l.PaginatorEvent;var b=C.extend("sap.ui.commons.Paginator",{metadata:{library:"sap.ui.commons",properties:{currentPage:{type:"int",group:"Misc",defaultValue:1},numberOfPages:{type:"int",group:"Misc",defaultValue:null}},events:{page:{parameters:{srcPage:{type:"int"},targetPage:{type:"int"},type:{type:"sap.ui.commons.PaginatorEvent"}}}}}});b.MAX_NUMBER_PAGES=5;b.prototype.init=function(){this.bShowAnimation=true;};b.prototype.onclick=function(e){this._handleSelect(e);};b.prototype.setCurrentPage=function(t,s){this.setProperty("currentPage",t,s);if(this.getDomRef()){P.updateBackAndForward(this);}return this;};b.prototype.triggerPaginatorAnimation=function(){var I=[];var c=[];var d=this.$("pages").children();var n=this._calculatePagesRange();var o;if(this._oOldRange){o=this._oOldRange;}else{o={};var p=d[0].id.split("--");o.firstPage=parseInt(p[p.length-1]);p=d[d.length-1].id.split("--");o.lastPage=parseInt(p[p.length-1]);}var i;for(i=n.firstPage;i<=n.lastPage;i++){if(i<o.firstPage||i>o.lastPage){c.push(i);}}var e={firstPage:c[0],lastPage:c[c.length-1]};for(i=o.firstPage;i<=o.lastPage;i++){if(i<n.firstPage||i>n.lastPage){I.push(i);}}var f=P.getPagesHtml(this.getId(),o,this.getCurrentPage(),true);var g=P.getPagesHtml(this.getId(),e,this.getCurrentPage(),false);if(o.firstPage<e.firstPage){g=f+g;}else{g=g+f;}var h=document.activeElement;var j=h?h.id:undefined;this.getDomRef("pages").innerHTML=g;if(j){h=document.getElementById(j);}else{h=document.getElementById("testPaginator-a--"+this.getCurrentPage());}if(h){h.focus();}var k="li--";this._oOldRange=n;function r(){var m=document.getElementById(this.id);if(m){m.parentNode.removeChild(m);}}for(i=0;i<I.length;i++){this.$(k+I[i]).hide(400,r);}for(i=0;i<c.length;i++){this.$(k+c[i]).show(400);}};b.prototype._calculatePagesRange=function(){var f=1;var L=this.getNumberOfPages();var c=this.getCurrentPage();var n=this.getNumberOfPages();if(c<4){f=1;if(L>b.MAX_NUMBER_PAGES){L=b.MAX_NUMBER_PAGES;}}else if(c==L){if(n<5){f=1;}else{f=L-4;}}else if(L-c<3){f=L-4;}else{f=c-2;L=c+2;}return{firstPage:f,lastPage:L};};b.prototype.onkeydown=function(e){var E=e.getPseudoTypes();if(E.indexOf("saptabnext")!=-1){this.triggerTabbingNavigation(e,false);}else if(E.indexOf("saptabprevious")!=-1){this.triggerTabbingNavigation(e,true);}else if(E.indexOf("sapincrease")!=-1){this.triggerInternalNavigation(e,"next");}else if(E.indexOf("sapdecrease")!=-1){this.triggerInternalNavigation(e,"previous");}else if(E.indexOf("sapenter")!=-1){this._handleSelect(e);}};b.prototype.triggerInternalNavigation=function(e,d){var f=this.$().find(":sapFocusable");var c=q(f).index(e.target);var n,N;if(d=="next"){n=c+1;if(q(e.target).hasClass("sapUiPagCurrentPage")){n=n+1;}N=f[n];if(N){q(N).trigger("focus");e.preventDefault();e.stopPropagation();}}else if(d=="previous"&&f[c-1]){n=c-1;N=f[n];if(N&&q(N).hasClass("sapUiPagCurrentPage")){N=f[n-1];}if(N){q(N).trigger("focus");e.preventDefault();e.stopPropagation();}}};b.prototype.triggerTabbingNavigation=function(e,s){var f=this.$().find(":sapFocusable");if(!s){q(f[f.length-1]).trigger("focus");}else{var c=q(f).index(e.target);if(c!=0){q(f[0]).trigger("focus");}}};b.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return C.prototype.getFocusInfo.apply(this,arguments);}};b.prototype.applyFocusInfo=function(f){if(f&&f.customId){this.$().find("#"+f.customId).trigger("focus");}else{C.prototype.getFocusInfo.apply(this,arguments);}return this;};b.prototype._handleSelect=function(e){if(e&&e.target){e.preventDefault();var t=e.target;if(!t.id){t=t.parentNode;}if(t.id&&t.id!=this.getId()+"-pages"){var A=t.id.split("--");if(A.length>1){var c=A[A.length-1];var E=null;var s=this.getCurrentPage();var T=s;if(c.match(/^\d+$/)){E=a.Goto;T=parseInt(c);}else if(c=="firstPageLink"){E=a.First;T=1;}else if(c=="backLink"){E=a.Previous;T=Math.max(s-1,1);}else if(c=="forwardLink"){E=a.Next;T=Math.min(s+1,this.getNumberOfPages());}else if(c=="lastPageLink"){E=a.Last;T=this.getNumberOfPages();}if(T!=s){if(this.bShowAnimation){this.setCurrentPage(T,true);this.triggerPaginatorAnimation();}else{this.setCurrentPage(T);}this.firePage({srcPage:s,targetPage:T,type:E});}}}}};return b;});
