/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control','sap/ui/core/ValueStateSupport','sap/ui/core/IndicationColorSupport','sap/ui/core/library','sap/ui/base/DataType','./ObjectStatusRenderer'],function(l,C,V,I,c,D,O){"use strict";var a=l.ImageHelper;var T=c.TextDirection;var b=c.ValueState;var d=C.extend("sap.m.ObjectStatus",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",designtime:"sap/m/designtime/ObjectStatus.designtime",properties:{title:{type:"string",group:"Misc",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null},active:{type:"boolean",group:"Misc",defaultValue:false},state:{type:"string",group:"Misc",defaultValue:b.None},inverted:{type:"boolean",group:"Misc",defaultValue:false},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{press:{}},dnd:{draggable:true,droppable:false}}});d.prototype.exit=function(){if(this._oImageControl){this._oImageControl.destroy();this._oImageControl=null;}};d.prototype._getImageControl=function(){var i=this.getId()+'-icon',e=!this.getText()&&!this.getTitle(),p={src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false};if(e){p.decorative=false;p.alt=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("OBJECT_STATUS_ICON");}this._oImageControl=a.getImageControl(i,this._oImageControl,this,p);return this._oImageControl;};d.prototype.setState=function(v){if(v==null){v=b.None;}else if(!D.getType("sap.ui.core.ValueState").isValid(v)&&!D.getType("sap.ui.core.IndicationColor").isValid(v)){throw new Error('"'+v+'" is not a value of the enums sap.ui.core.ValueState or sap.ui.core.IndicationColor for property "state" of '+this);}return this.setProperty("state",v);};d.prototype.ontap=function(e){if(this._isClickable(e)){this.firePress();}};d.prototype.onsapenter=function(e){if(this._isActive()){this.firePress();e.setMarked();}};d.prototype.onsapspace=function(e){this.onsapenter(e);};d.prototype._isActive=function(){return this.getActive()&&(this.getText().trim()||this.getIcon().trim());};d.prototype._isEmpty=function(){return!(this.getText().trim()||this.getIcon().trim()||this.getTitle().trim());};d.prototype.ontouchstart=function(e){if(this._isClickable(e)){e.setMarked();}};d.prototype.getAccessibilityInfo=function(){var s=V.getAdditionalText(this.getState());if(this.getState()!=b.None){s=(s!==null)?s:I.getAdditionalText(this.getState());}return{description:((this.getTitle()||"")+" "+(this.getText()||"")+" "+(s!==null?s:"")+" "+(this.getTooltip()||"")+" "+sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("OBJECT_STATUS")).trim()};};d.prototype._isClickable=function(e){var s=e.target.id;return this._isActive()&&(s===this.getId()+"-link"||s===this.getId()+"-text"||s===this.getId()+"-statusIcon"||s===this.getId()+"-icon");};return d;});
