/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./InputBase','./ComboBoxTextField','./ComboBoxBase','./Tokenizer','./Token','./List','./StandardListItem','./Popover','./GroupHeaderListItem','./library','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','sap/ui/core/library','sap/ui/Device','sap/ui/core/Item','sap/ui/core/SeparatorItem','sap/ui/core/ResizeHandler','./MultiComboBoxRenderer',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/base/util/deepEqual","sap/base/assert","sap/base/Log","sap/ui/core/Core",'sap/ui/core/InvisibleText',"sap/ui/thirdparty/jquery","sap/ui/dom/jquery/cursorPos","sap/ui/dom/jquery/control"],function(I,C,a,T,b,L,S,P,G,l,E,c,d,D,e,f,R,M,g,K,h,j,k,m,n,q){"use strict";var o=l.ListType;var p=l.ListMode;var V=d.ValueState;var O=d.OpenState;var r=l.PlacementType;var s=l.TokenizerRenderMode;var t=a.extend("sap.m.MultiComboBox",{metadata:{library:"sap.m",designtime:"sap/m/designtime/MultiComboBox.designtime",properties:{selectedKeys:{type:"string[]",group:"Data",defaultValue:[]}},associations:{selectedItems:{type:"sap.ui.core.Item",multiple:true,singularName:"selectedItem"}},aggregations:{tokenizer:{type:"sap.m.Tokenizer",multiple:false,visibility:"hidden"}},events:{selectionChange:{parameters:{changedItem:{type:"sap.ui.core.Item"},selected:{type:"boolean"}}},selectionFinish:{parameters:{selectedItems:{type:"sap.ui.core.Item[]"}}}},dnd:{draggable:false,droppable:true}}});c.insertFontFaceStyle();E.apply(t.prototype,[true]);t.prototype.clone=function(i){var u=a.prototype.clone.apply(this,arguments),v=this._getList();if(v){u.syncPickerContent();}return u;};t.prototype.open=function(){if(!this.isOpen()){this._bPickerIsOpening=true;}this.syncPickerContent();return a.prototype.open.apply(this,arguments);};t.prototype.onsapend=function(i){if(i.isMarked("forwardFocusToParent")){this.focus();}};t.prototype.onsaphome=function(i){if(!this.getFocusDomRef().selectionStart){T.prototype.onsaphome.apply(this.getAggregation("tokenizer"),arguments);}i.setMarked();};t.prototype.onsapdown=function(i){if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();i.preventDefault();this.syncPickerContent();var u=this.getSelectableItems();var v=u[0];var w=this;if(v&&this.isOpen()&&this.getValueStateLinks().length){this._handleFormattedTextNav();return;}else if(v&&this.isOpen()){setTimeout(function(){w.getListItem(v).focus();},0);return;}if(this.isFocusInTokenizer()){return;}this._oTraversalItem=this._getNextTraversalItem();if(this._oTraversalItem&&!this.isComposingCharacter()){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length);}};t.prototype.onsapup=function(i){if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();i.preventDefault();this.syncPickerContent();if(this.isFocusInTokenizer()){return;}this._oTraversalItem=this._getPreviousTraversalItem();if(this._oTraversalItem){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length);}};t.prototype.isFocusInTokenizer=function(){return q.contains(this.getAggregation("tokenizer").getFocusDomRef(),document.activeElement);};t.prototype.onsapshow=function(i){this._handleItemToFocus();a.prototype.onsapshow.apply(this,arguments);};t.prototype._handlePopupOpenAndItemsLoad=function(){this._handleItemToFocus();a.prototype._handlePopupOpenAndItemsLoad.apply(this,arguments);};t.prototype._valueStateNavDelegate=function(v,F,i){var u=this;this.oValueStateNavDelegate={};this.oValueStateNavDelegate.onsapdown=function(){u.getListItem(u.getSelectableItems()[0]).focus();};this.oValueStateNavDelegate.onsapup=function(){u.getFocusDomRef().focus();};this.oValueStateNavDelegate.onsapend=function(w){w.preventDefault();var x=u.getSelectableItems();u.getListItem(u.getSelectableItems()[x.length-1]).focus();};this.oValueStateNavDelegate.onfocusout=function(w){v.removeStyleClass("sapMFocusable");if(!v.getDomRef().contains(w.relatedTarget)){i.forEach(function(x){x.getDomRef().setAttribute("tabindex","-1");});}if(D.browser.msie){F.removeStyleClass("sapMPseudoFocus");}};return this.oValueStateNavDelegate;};t.prototype._closePickerDelegate={onsaptabnext:function(){if(D.browser.msie){this.getPicker().getCustomHeader().getFormattedText().removeStyleClass("sapMPseudoFocus");}this.close();setTimeout(function(){this.closeValueStateMessage();}.bind(this),0);}};t.prototype._formattedTextLinksNav={onsapup:function(){this.focus();},onsapdown:function(){this.getSelectableItems()[0].focus();}};t.prototype._handleFormattedTextNav=function(){var i=this.getPicker().getCustomHeader(),v=this.getValueStateLinks(),F=i.getFormattedText(),u=this.oValueStateNavDelegate||this._valueStateNavDelegate(i,F,v),w=v?v[v.length-1]:null,x=v?v[0]:null;if(!v.length||i.getDomRef()===document.activeElement){return;}i.getDomRef().setAttribute("tabindex","-1");i.addDelegate(u);i.addStyleClass("sapMFocusable");i.focus();if(D.browser.msie){F.addStyleClass("sapMPseudoFocus");}v.forEach(function(y){y.getDomRef().setAttribute("tabindex","0");y.addDelegate(this._formattedTextLinksNav,this);},this);this.oMoveFocusBackToVSHeader=!this.oMoveFocusBackToVSHeader?{onsaptabprevious:function(y){y.preventDefault();i.focus();i.addStyleClass("sapMFocusable");}}:this.oMoveFocusBackToVSHeader;w.addDelegate(this._closePickerDelegate,this);x.addDelegate(this.oMoveFocusBackToVSHeader,this);};t.prototype.onsaphide=t.prototype.onsapshow;t.prototype._selectItemByKey=function(u){var v,w,x,i,y,z,A=this.isOpen();if(!this.getEnabled()||!this.getEditable()){return;}if(u){u.setMarked();}v=this._getUnselectedItems(A?"":this.getValue());for(i=0;i<v.length;i++){z=!(v[i].getKey()===undefined||v[i].getKey()===null)&&!v[i].isA("sap.ui.core.SeparatorItem");if(v[i].getText().toUpperCase()===this.getValue().toUpperCase()&&z){x=v[i];y=true;break;}}if(y){w={item:x,id:x.getId(),key:x.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false};this._bPreventValueRemove=false;if(this.getValue()===""||(typeof this.getValue()==="string"&&x.getText().toLowerCase().startsWith(this.getValue().toLowerCase()))){if(this.getListItem(x).isSelected()){this.setValue('');}else{this.setSelection(w);}}}else{this._bPreventValueRemove=true;}if(u){this.close();}};t.prototype.onsapenter=function(i){var u=this.getAggregation("tokenizer");I.prototype.onsapenter.apply(this,arguments);this._showAlreadySelectedVisualEffect();if(this.getValue()){this._selectItemByKey(i);}if(!this.getEditable()&&u.getHiddenTokensCount()&&i.target===this.getFocusDomRef()){u._togglePopup(u.getTokensPopup());}};t.prototype.onsaptabnext=function(i){var u=this.getValue();if(u){var v=this._getUnselectedItemsStartingText(u);if(v.length===1){this._selectItemByKey(i);}else{this._showWrongValueVisualEffect();}}};t.prototype.onsaptabprevious=t.prototype.onsaptabnext;t.prototype.onsapfocusleave=function(i){var u=this.isPlatformTablet(),v=m.byId(i.relatedControlId),F=v&&v.getFocusDomRef(),w=this.getValue(),x=this.getPicker(),y=this.getAggregation("tokenizer");if(!this._bPickerIsOpening&&(!x||!x.getFocusDomRef()||!F||!q.contains(x.getFocusDomRef(),F))){this.setValue(null);if(w){this.fireChangeEvent("",{value:w});}if(!q.contains(this.getDomRef(),document.activeElement)){y.setRenderMode(s.Narrow);}}if(x&&F){if(h(x.getFocusDomRef(),F)&&!u&&!this.isPickerDialog()){this.focus();}}};t.prototype.onfocusin=function(i){var u=this.getPicker();var v=false;var w=u&&u.getFocusDomRef();var x=(u&&u.oPopup.getOpenState())||O.CLOSED;var y=x===O.CLOSING||x===O.CLOSED;var z=this.getPickerType()==="Dropdown";var A=this.getAggregation("tokenizer");if(z){v=w&&q.contains(w,i.relatedTarget);}if(this.getEditable()&&i.target===this.getDomRef("inner")){A.setRenderMode(s.Loose);}if(i.target===this.getFocusDomRef()){A.hasOneTruncatedToken()&&A.setFirstTokenTruncated(false);this.getEnabled()&&this.addStyleClass("sapMFocus");!y&&v&&this.handleInputValidation(i,false);}if(i.target===this.getOpenArea()&&z&&!this.isPlatformTablet()){this.focus();}if(!this.isOpen()&&this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}};t.prototype._handleItemTap=function(i){var u=q(i.target).control(0);if(!u.isA("sap.m.CheckBox")&&!u.isA("sap.m.GroupHeaderListItem")){this._bCheckBoxClicked=false;}};t.prototype._handleItemPress=function(i){if(this.isOpen()&&this._isListInSuggestMode()&&this.getPicker().oPopup.getOpenState()!==O.CLOSING){this.clearFilter();var u=this._getLastSelectedItem();if(u){this.getListItem(u).focus();}}};t.prototype._handleSelectionLiveChange=function(i){var u=i.getParameter("listItem");var v=i.getParameter("selected");var N=this._getItemByListItem(u);var w=this.isPickerDialog()?this.getPickerTextField():this;if(u.getType()==="Inactive"){return;}j(N,"The corresponding mapped item was not found on "+this);if(!N){return;}var x={item:N,id:N.getId(),key:N.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:true};if(v){this.fireChangeEvent(N.getText());this.setSelection(x);}else{this.fireChangeEvent(N.getText());this.removeSelection(x);}if(this._bCheckBoxClicked){w.setValue(this._sOldInput);if(this.isOpen()&&this.getPicker().oPopup.getOpenState()!==O.CLOSING){u.focus();}}else{this._bCheckBoxClicked=true;this.setValue("");this.close();}};t.prototype.onkeydown=function(i){var u=this.getEditable(),v=this.getAggregation("tokenizer"),w=v.getTokens().length;a.prototype.onkeydown.apply(this,arguments);if(!this.getEnabled()){return;}if((i.ctrlKey||i.metaKey)&&i.which===K.I&&w){i.preventDefault();if(u){this._togglePopover();}else{this._handleIndicatorPress();}return;}this._bIsPasteEvent=(i.ctrlKey||i.metaKey)&&(i.which===K.V);if(this.getValue().length===0&&(i.ctrlKey||i.metaKey)&&(i.which===K.A)&&this._hasTokens()){v.focus();v.selectAllTokens(true);i.preventDefault();}if(this.isPickerDialog()){this._sOldValue=this.getPickerTextField().getValue();this._iOldCursorPos=q(this.getFocusDomRef()).cursorPos();}this._bDoTypeAhead=!D.os.android&&(i.which!==K.BACKSPACE)&&(i.which!==K.DELETE);};t.prototype.oninput=function(i){a.prototype.oninput.apply(this,arguments);var u=i.srcControl,v=this.isPickerDialog(),w=v?this.getPickerTextField():this,x=w.getValueState();if(x===V.Error&&this._bAlreadySelected){w.setValueState(this._sInitialValueState);w.setValueStateText(this._sInitialValueStateText);this._bAlreadySelected=false;}if(!this.getEnabled()||!this.getEditable()){return;}this.syncPickerContent();this.handleInputValidation(i,this.isComposingCharacter());if(this._bIsPasteEvent){u.updateDomValue(this._sOldValue||i.target.value||"");return;}if(this.isOpen()){setTimeout(this._highlightList.bind(this,this._sOldInput));}if(this._getItemsShownWithFilter()){this.toggleIconPressedStyle(true);}};t.prototype.filterItems=function(i){var F=this.fnFilter?this.fnFilter:a.DEFAULT_TEXT_FILTER;var u=[];var v=false;var w=[];i.items.forEach(function(x){if(x.isA("sap.ui.core.SeparatorItem")){w.push({separator:x});this.getListItem(x).setVisible(false);v=true;return;}var y=!!F(i.value,x,"getText");if(i.value===""){y=true;if(!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){return;}}if(v&&y){this.getListItem(w[w.length-1].separator).setVisible(true);}var z=this.getListItem(x);if(z){z.setVisible(y);y&&u.push(x);}},this);return u;};t.prototype.onkeyup=function(i){if(!this.getEnabled()||!this.getEditable()){return;}this._sOldValue=this.getValue();this._iOldCursorPos=q(this.getFocusDomRef()).cursorPos();};t.prototype._showWrongValueVisualEffect=function(){var i=this._getSuggestionsPopover();var u=this._sInitialValueStateText;var v=this._sInitialValueState;var w=u||this._oRbC.getText("VALUE_STATE_ERROR");var x=this;if(v===V.Error){return;}if(i){i.updateValueState(V.Error,w,true);setTimeout(i.updateValueState.bind(i,x.getValueState(),w,true),1000);}if(!this.isPickerDialog()){this.setValueState(V.Error);this.setValueStateText(this.getValueStateText()||w);setTimeout(this["setValueState"].bind(this,v||V.Error),1000);}this._syncInputWidth(this.getAggregation("tokenizer"));};t.prototype._showAlreadySelectedVisualEffect=function(){var A=this._oRbM.getText("VALUE_STATE_ERROR_ALREADY_SELECTED");if(!this.getValue()){return;}var i=!!this.getSelectedItems().filter(function(u){return u.getText().toLowerCase()===this.getValue().toLowerCase();},this).length;var N=this.getItems().filter(function(u){return u.getText().toLowerCase()===this.getValue().toLowerCase();},this).length;if(i){this._sInitialValueState=this.getValueState();this._sInitialValueStateText=this.getValueStateText();this.setValueStateText(A);this._bAlreadySelected=true;this.setValueState("Error");return;}else if(N){return;}else{this._showWrongValueVisualEffect();}};t.prototype._hasShowSelectedButton=function(){return true;};t.prototype.forwardEventHandlersToSuggPopover=function(i){a.prototype.forwardEventHandlersToSuggPopover.apply(this,arguments);i.setShowSelectedPressHandler(this._filterSelectedItems.bind(this));};t.prototype._createReadOnlyPopover=function(){return new P({showArrow:true,placement:r.Auto,showHeader:false,contentMinWidth:"auto"}).addStyleClass("sapMMultiComboBoxReadOnlyPopover");};t.prototype.configPicker=function(i){var u=this.getRenderer(),v=u.CSS_CLASS_MULTICOMBOBOX;i.setHorizontalScrolling(false).addStyleClass(u.CSS_CLASS_COMBOBOXBASE+"Picker").addStyleClass(v+"Picker").addStyleClass(v+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this);};t.prototype._configureList=function(i){if(!i){return;}i.setMode(p.MultiSelect);i.setIncludeItemInSelection(true);i.attachBrowserEvent("tap",this._handleItemTap,this).attachSelectionChange(this._handleSelectionLiveChange,this).attachItemPress(this._handleItemPress,this);i.addEventDelegate({onAfterRendering:this.onAfterRenderingList,onfocusin:this.onFocusinList},this);};t.prototype._modifyPopupInput=function(i){a.prototype._modifyPopupInput.apply(this,arguments);i.attachSubmit(function(u){var v=i.getValue();if(v){this.setValue(v);this._selectItemByKey();this.setValue(this._sOldInput);this.close();}}.bind(this));i.addEventDelegate({onfocusout:this._handleInputFocusOut},this);return i;};t.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);this._bInitialSelectedKeysSettersCompleted=true;this.getAggregation("tokenizer").setEnabled(this.getEnabled());if(this._getList()){this.syncPickerContent(true);}this._deregisterResizeHandler();this._synchronizeSelectedItemAndKey();if(!this._bAlreadySelected){this._sInitialValueStateText=this.getValueStateText();}if(this.getValueState()!==V.Error){this._sInitialValueState=this.getValueState();}};t.prototype.syncPickerContent=function(F){var i,u,v=this.getPicker();if(!v){v=this.createPicker(this.getPickerType());this._updateSuggestionsPopoverValueState();F=true;}if(F){u=this._getList();i=this.getEditable()?this.getItems():this.getSelectedItems();this._synchronizeSelectedItemAndKey();u.destroyItems();this._clearTokenizer();this._fillList(i);if(u.getItemNavigation()){this._iFocusedIndex=u.getItemNavigation().getFocusedIndex();}}return v;};t.prototype._registerResizeHandler=function(){j(!this._iResizeHandlerId,"Resize handler already registered");this._iResizeHandlerId=R.register(this,this._onResize.bind(this));};t.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){R.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null;}};t.prototype._onResize=function(){var i=this.getAggregation("tokenizer");i.setMaxWidth(this._calculateSpaceForTokenizer());this._syncInputWidth(i);this._handleNMoreAccessibility();};t.prototype.onBeforeRenderingPicker=function(){var i=this["_onBeforeRendering"+this.getPickerType()];if(i){i.call(this);}};t.prototype.onAfterRenderingPicker=function(){var i=this["_onAfterRendering"+this.getPickerType()];if(i){i.call(this);}};t.prototype.onBeforeOpen=function(){a.prototype.onBeforeOpen.apply(this,arguments);var i=this["_onBeforeOpen"+this.getPickerType()];this._resetCurrentItem();this.addContent();this._aInitiallySelectedItems=this.getSelectedItems();this._synchronizeSelectedItemAndKey();if(i){i.call(this);}};t.prototype.onAfterOpen=function(){var i=this.getFocusDomRef(),v=this.getValueStateLinks();i&&this.getFocusDomRef().setAttribute("aria-expanded","true");this._bPickerIsOpening=false;if(!this.isPlatformTablet()){this.getPicker().setInitialFocus(this);}v.forEach(function(u){u.addDelegate({onAfterRendering:function(){if(this.getFocusDomRef()){this.getFocusDomRef().setAttribute("tabindex","-1");}}},u);});this.closeValueStateMessage();};t.prototype.onBeforeClose=function(){a.prototype.onBeforeClose.apply(this,arguments);};t.prototype.onAfterClose=function(){var u=!q.contains(this.getDomRef(),document.activeElement)||this.isPickerDialog(),i=this.getFocusDomRef();i&&this.getFocusDomRef().setAttribute("aria-expanded","false");this.toggleIconPressedStyle(false);this.clearFilter();!this.isComposingCharacter()&&!this._bPreventValueRemove&&this.setValue("");this._sOldValue="";this._sOldInput="";this._getSuggestionsPopover()._sTypedInValue="";if(this.isPickerDialog()){this.getPickerTextField().setValue("");this.getFilterSelectedButton()&&this.getFilterSelectedButton().setPressed(false);}this.fireSelectionFinish({selectedItems:this.getSelectedItems()});this.getAggregation("tokenizer").setRenderMode(u?s.Narrow:s.Loose);if(this.getValueState()==V.Error&&document.activeElement===this.getFocusDomRef()){this.selectText(0,this.getValue().length);}};t.prototype._onBeforeOpenDialog=function(){};t.prototype._onBeforeOpenDropdown=function(){var i=this.getPicker(),u=this.getDomRef(),w;if(u&&i){w=(u.offsetWidth/parseFloat(l.BaseFontSize))+"rem";i.setContentMinWidth(w);}};t.prototype.getFilterSelectedButton=function(){return this._getSuggestionsPopover().getFilterSelectedButton();};t.prototype._filterSelectedItems=function(i,F){var u=i.oSource,v,w,x=this.getPickerTextField()?this.getPickerTextField().getValue():"",y=(u&&u.getPressed&&u.getPressed())||F,z=this.getVisibleItems(),A=this.getItems(),B=this.getSelectedItems(),H=null;if(y){z.forEach(function(J){w=B.indexOf(J)>-1?true:false;v=this.getListItem(J);if(!v){return;}if(v.isA("sap.m.GroupHeaderListItem")){v.setVisible(false);H=v;}else{v.setVisible(w);if(w&&H){H.setVisible(true);}}},this);}else{this.filterItems({value:x,items:A});}};t.prototype.revertSelection=function(){this.setSelectedItems(this._aInitiallySelectedItems);};t.prototype.setSelection=function(i){var u=this._getList();if(i.item&&this.isItemSelected(i.item)){return;}if(!i.item){return;}if(!i.listItemUpdated&&this.getListItem(i.item)&&u){u.setSelectedItem(this.getListItem(i.item),true);}var v=new b({key:i.key});v.setText(i.item.getText());i.item.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",v);this.getAggregation("tokenizer").addToken(v);this.$().toggleClass("sapMMultiComboBoxHasToken",this._hasTokens());this.setValue('');this.addAssociation("selectedItems",i.item,i.suppressInvalidate);var w=this.getSelectedKeys();var x=this.getKeys([i.item])[0];if(x===""||w.indexOf(x)===-1){w.push(x);this.setProperty("selectedKeys",w,i.suppressInvalidate);}if(i.fireChangeEvent){this.fireSelectionChange({changedItem:i.item,selected:true});}if(i.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()});}}};t.prototype.removeSelection=function(i){if(i.item&&!this.isItemSelected(i.item)){return;}if(!i.item){return;}this.removeAssociation("selectedItems",i.item,i.suppressInvalidate);var u=this.getSelectedKeys();var v=u.indexOf(i.item.getKey());u.splice(v,1);this.setProperty("selectedKeys",u,i.suppressInvalidate);if(!i.listItemUpdated&&this.getListItem(i.item)){var w=this.getListItem(i.item);this._getList().setSelectedItem(w,false);}if(!i.tokenUpdated){var x=this._getTokenByItem(i.item);i.item.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",null);this.getAggregation("tokenizer").removeToken(x);}this.$().toggleClass("sapMMultiComboBoxHasToken",this._hasTokens());if(i.fireChangeEvent){this.fireSelectionChange({changedItem:i.item,selected:false});}if(i.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()});}}};t.prototype._synchronizeSelectedItemAndKey=function(){var u=this.getSelectedKeys();var v=this.getKeys(this.getSelectedItems());if(!u.length){k.info("Info: _synchronizeSelectedItemAndKey() the MultiComboBox control does not contain any item on ",this);return;}for(var i=0,w=null,x=null,y=u.length;i<y;i++){w=u[i];if(v.indexOf(w)>-1){continue;}x=this.getItemByKey(""+w);if(x){this.setSelection({item:x,id:x.getId(),key:x.getKey(),fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:false});}}};t.prototype._getTokenByItem=function(i){return i?i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token"):null;};t.prototype.updateItems=function(i){var u=function(y){return y&&y.getKey&&y.getKey();},v,w=this.getSelectedItems().map(u),x=this.getSelectedKeys();var U=a.prototype.updateItems.apply(this,arguments);w=this.getSelectedItems().map(u).filter(function(y){return w.indexOf(y)>-1;});v=x.concat(w);this.setSelectedKeys(v);return U;};t.prototype._getSelectedItemsOf=function(u){for(var i=0,v=u.length,w=[];i<v;i++){if(this.getListItem(u[i]).isSelected()){w.push(u[i]);}}return w;};t.prototype._getLastSelectedItem=function(){var i=this.getAggregation("tokenizer").getTokens();var u=i.length?i[i.length-1]:null;if(!u){return null;}return this._getItemByToken(u);};t.prototype._getOrderedSelectedItems=function(){var u=[];for(var i=0,v=this.getAggregation("tokenizer").getTokens(),w=v.length;i<w;i++){u[i]=this._getItemByToken(v[i]);}return u;};t.prototype._getFocusedListItem=function(){if(!document.activeElement){return null;}var F=m.byId(document.activeElement.id);if(this._getList()&&g(this._getList().getFocusDomRef(),F.getFocusDomRef())){return F;}return null;};t.prototype._getFocusedItem=function(){var i=this._getFocusedListItem();return this._getItemByListItem(i);};t.prototype._isRangeSelectionSet=function(i){var $=i.getDomRef();return $.indexOf(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"ItemRangeSelection")>-1?true:false;};t.prototype._hasTokens=function(){return this.getAggregation("tokenizer").getTokens().length>0;};t.prototype._getCurrentItem=function(){if(!this._oCurrentItem){return this._getFocusedItem();}return this._oCurrentItem;};t.prototype._setCurrentItem=function(i){this._oCurrentItem=i;};t.prototype._resetCurrentItem=function(){this._oCurrentItem=null;};t.prototype._decorateListItem=function(i){i.addDelegate({onkeyup:function(u){var v=null;if(u.which==K.SPACE&&this.isOpen()&&this._isListInSuggestMode()){this.open();v=this._getLastSelectedItem();if(v){this.getListItem(v).focus();}return;}},onkeydown:function(u){var v=null,w=null;if(u.shiftKey&&u.which==K.ARROW_DOWN){w=this._getCurrentItem();v=this._getNextVisibleItemOf(w);}if(u.shiftKey&&u.which==K.ARROW_UP){w=this._getCurrentItem();v=this._getPreviousVisibleItemOf(w);}if(u.shiftKey&&u.which===K.SPACE){w=this._getCurrentItem();this._selectPreviousItemsOf(w);}if(v&&v!==w){if(this.getListItem(w).isSelected()){this.setSelection({item:v,id:v.getId(),key:v.getKey(),fireChangeEvent:true,suppressInvalidate:true});this._setCurrentItem(v);}else{this.removeSelection({item:v,id:v.getId(),key:v.getKey(),fireChangeEvent:true,suppressInvalidate:true});this._setCurrentItem(v);}return;}this._resetCurrentItem();if((u.ctrlKey||u.metaKey)&&u.which==K.A){u.setMarked();u.preventDefault();var x=this.getSelectableItems();var y=this._getSelectedItemsOf(x);if(y.length!==x.length){x.forEach(function(v){this.setSelection({item:v,id:v.getId(),key:v.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}else{x.forEach(function(v){this.removeSelection({item:v,id:v.getId(),key:v.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}}}},true,this);i.addEventDelegate({onsapbackspace:function(u){u.preventDefault();},onsapshow:function(u){u.setMarked();if(this.isOpen()){this.close();return;}if(this.hasContent()){this.open();}},onsaphide:function(u){this.onsapshow(u);},onsapenter:function(u){u.setMarked();this.close();},onsaphome:function(u){u.setMarked();u.preventDefault();if(this.getValueStateLinks().length){this._handleFormattedTextNav();u.stopPropagation(true);return;}var v=this.getSelectableItems();var w=v[0];this.getListItem(w).focus();},onsapend:function(u){u.setMarked();u.preventDefault();var v=this.getSelectableItems();var w=v[v.length-1];this.getListItem(w).focus();},onsapup:function(u){u.setMarked();u.preventDefault();var v=this.getSelectableItems();var w=v[0];var x=q(document.activeElement).control()[0];if(x===this.getListItem(w)&&this.getValueStateLinks().length){this._handleFormattedTextNav();u.stopPropagation(true);return;}else if(x===this.getListItem(w)){this.focus();u.stopPropagation(true);}},onfocusin:function(u){this.addStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused");},onfocusout:function(u){this.removeStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused");},onsapfocusleave:function(u){var v=this.getAggregation("picker");var w=m.byId(u.relatedControlId);if(v&&w&&h(v.getFocusDomRef(),w.getFocusDomRef())){if(u.srcControl){u.srcControl.focus();}}}},this);if(D.support.touch){i.addEventDelegate({ontouchstart:function(u){u.setMark("cancelAutoClose");}});}};t.prototype._handleInputFocusOut=function(){var i=this.isPickerDialog()?this.getPickerTextField():this,u=this._sOldInput||this._sOldValue||"";i.updateDomValue(u);this._bIsPasteEvent=null;};t.prototype.onItemChange=function(i){var v=a.prototype.onItemChange.apply(this,arguments);this._forwardItemInfoToToken(i);return v;};t.prototype._forwardItemInfoToToken=function(i){var u=i.getSource(),v=i.getParameters(),w=this._getTokenByItem(u);if(!w){return;}if(v.name==="enabled"){w.setVisible(v.newValue);}else if(w.getMetadata().hasProperty(v.name)){w.setProperty(v.name,v.newValue,false);}};t.prototype._handleIndicatorPress=function(){var i,u=this.getAggregation("tokenizer");if(this.getEditable()){this.syncPickerContent();this._filterSelectedItems({},true);this.focus();i=this.getPicker();i.open();}else{u._togglePopup(u.getTokensPopup());}if(this.isPickerDialog()){this.getFilterSelectedButton().setPressed(true);this.bOpenedByKeyboardOrButton=true;}};t.prototype._togglePopover=function(){var i=this.getPicker();if(!i){i=this.syncPickerContent(true);}if(i.isOpen()){i.close();}else{i.open();}};t.prototype._createTokenizer=function(){var i=new T({renderMode:s.Narrow}).attachTokenChange(this._handleTokenChange,this);i.getTokensPopup().attachAfterOpen(function(){if(i.hasOneTruncatedToken()){i.setFirstTokenTruncated(false);}}).attachAfterClose(function(){var u=i.getTokens();if(u.length===1&&!u[0].getTruncated()){i.setFirstTokenTruncated(true);}});i.addEventDelegate({onAfterRendering:this._onAfterRenderingTokenizer},this);return i;};t.prototype._onAfterRenderingTokenizer=function(){var i=this.getAggregation("tokenizer");if(this.getEditable()){i.addStyleClass("sapMTokenizerIndicatorDisabled");}else{i.removeStyleClass("sapMTokenizerIndicatorDisabled");}setTimeout(this._syncInputWidth.bind(this,i),0);setTimeout(this._handleNMoreAccessibility.bind(this),0);setTimeout(i["scrollToEnd"].bind(i),0);};t.prototype._handleTokenChange=function(i){var u=i.getParameter("type");var v=i.getParameter("token");var w=null;if(u!==T.TokenChangeType.Removed&&u!==T.TokenChangeType.Added){return;}if(u===T.TokenChangeType.Removed){w=(v&&this._getItemByToken(v));if(w&&this.isItemSelected(w)){this.removeSelection({item:w,id:w.getId(),key:w.getKey(),tokenUpdated:true,fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true});!this.isPickerDialog()&&!this.isFocusInTokenizer()&&this.focus();this.fireChangeEvent("");}}};t.prototype.onAfterRenderingList=function(){var i=this._getList();var u=document.activeElement===this.getFocusDomRef();if(this.getEditable()&&!u&&(this._iFocusedIndex!=null)&&(i.getItems().length>this._iFocusedIndex)){i.getItems()[this._iFocusedIndex].focus();this._iFocusedIndex=null;}};t.prototype.onFocusinList=function(){if(this._bListItemNavigationInvalidated&&this._getList().getItemNavigation()){this._getList().getItemNavigation().setSelectedIndex(this._iInitialItemFocus);this._bListItemNavigationInvalidated=false;}};t.prototype.onAfterRendering=function(){a.prototype.onAfterRendering.apply(this,arguments);this.getAggregation("tokenizer").setMaxWidth(this._calculateSpaceForTokenizer());this._registerResizeHandler();};t.prototype.onfocusout=function(i){this.isOpen()&&this._handleInputFocusOut();this.removeStyleClass("sapMFocus");if(this.getValueState()===V.Error&&this.getValueStateText()===this._oRbM.getText("VALUE_STATE_ERROR_ALREADY_SELECTED")){this.setValueState(this._sInitialValueState);this.setValueStateText(this._sInitialValueStateText);}a.prototype.onfocusout.apply(this,arguments);};t.prototype.onpaste=function(i){var u;if(window.clipboardData){u=window.clipboardData.getData("Text");}else{u=i.originalEvent.clipboardData.getData('text/plain');}var v=u.split(/\r\n|\r|\n/g);if(v&&v.length>0){this.getSelectableItems().forEach(function(w){if(v.indexOf(w.getText())>-1){this.setSelection({item:w,id:w.getId(),key:w.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false});}},this);}};t.prototype.onsapbackspace=function(i){if(!this.getEnabled()||!this.getEditable()){i.preventDefault();return;}if(this.getCursorPosition()>0||this.getValue().length>0){return;}if(!i.isMarked()){T.prototype.onsapbackspace.apply(this.getAggregation("tokenizer"),arguments);}if(i.isMarked("forwardFocusToParent")){this.focus();}i.preventDefault();};t.prototype.onsapdelete=function(i){if(!this.getEnabled()||!this.getEditable()){return;}if(this.getValue()&&!this._isCompleteTextSelected()){return;}if(!i.isMarked()){T.prototype.onsapbackspace.apply(this.getAggregation("tokenizer"),arguments);}if(i.isMarked("forwardFocusToParent")){this.focus();}};t.prototype.onsapnext=function(i){var u=this.getAggregation("tokenizer");if(i.isMarked()){return;}var F=q(document.activeElement).control()[0];if(!F){return;}if(F===u||u.$().find(F.$()).length>0&&this.getEditable()){this.focus();}};t.prototype.onsapprevious=function(i){if(this.getCursorPosition()===0&&!this._isCompleteTextSelected()){if(i.srcControl===this){T.prototype.onsapprevious.apply(this.getAggregation("tokenizer"),arguments);}}};t.prototype.onclick=function(i){var u=this.getEditable(),v=this.getEnabled(),N=i.target.className.indexOf("sapMTokenizerIndicator")>-1,w=i.target.className.indexOf("sapMToken")>-1&&this.getAggregation("tokenizer").hasOneTruncatedToken();if(u&&v&&(N||w)){i.preventDefault();this._handleIndicatorPress();}};t.prototype.ontap=function(i){a.prototype.ontap.apply(this,arguments);var u=this.getOpenArea();if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();if(this.isPickerDialog()&&u.contains(i.target)){this.open();}};t.prototype.getOpenArea=function(){if(this.isPickerDialog()){return this.getDomRef();}else{return a.prototype.getOpenArea.apply(this,arguments);}};t.prototype._getItemsStartingWithPerTerm=function(i,u){var v=[],w=u?this.getEnabledItems():this.getSelectableItems(),F=this.fnFilter?this.fnFilter:a.DEFAULT_TEXT_FILTER;w.forEach(function(x){if(F(i,x,"getText")){v.push(x);}},this);return v;};t.prototype._getItemsStartingWith=function(i,u){var v=[],w=u?this.getEnabledItems():this.getSelectableItems();w.forEach(function(x){if(typeof i==="string"&&i!==""&&x.getText().toLowerCase().startsWith(i.toLowerCase())){v.push(x);}},this);return v;};t.prototype._getUnselectedItemsStartingText=function(i){var u=[];this._getUnselectedItems().forEach(function(v){if(typeof i==="string"&&i!==""&&v.getText().toLowerCase().startsWith(i.toLowerCase())){u.push(v);}},this);return u;};t.prototype.getCursorPosition=function(){return this._$input.cursorPos();};t.prototype._isCompleteTextSelected=function(){if(!this.getValue().length){return false;}var i=this._$input[0];if(i.selectionStart!==0||i.selectionEnd!==this.getValue().length){return false;}return true;};t.prototype._selectPreviousItemsOf=function(i){var u;do{u=true;var v=this._getPreviousVisibleItemOf(i);if(v){var w=this.getListItem(v);if(w){u=this.getListItem(v).getSelected();}}this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true});i=v;}while(!u);};t.prototype._getNextVisibleItemOf=function(i){var u=this.getSelectableItems();var v=u.indexOf(i)+1;if(v<=0||v>u.length-1){return null;}return u[v];};t.prototype._getPreviousVisibleItemOf=function(i){var u=this.getSelectableItems();var v=u.indexOf(i)-1;if(v<0){return null;}return u[v];};t.prototype._getNextUnselectedItemOf=function(i){var u=this._getUnselectedItems();var v=u.indexOf(i)+1;if(v<=0||v>u.length-1){return null;}return u[v];};t.prototype._getPreviousUnselectedItemOf=function(i){var u=this._getUnselectedItems();var v=u.indexOf(i)-1;if(v<0){return null;}return u[v];};t.prototype._getNextTraversalItem=function(){var v=this.getValue();var i=v?this._getItemsStartingWithPerTerm(v):[];var u=this._getUnselectedItems();if(i.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getNextUnselectedItemOf(this._oTraversalItem);}if(i.length&&i[0].getText()===this.getValue()){return this._getNextUnselectedItemOf(i[0]);}return i.length?i[0]:u[0];};t.prototype._getPreviousTraversalItem=function(){var v=this.getValue();var i=v?this._getItemsStartingWithPerTerm(v):[];if(i.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getPreviousUnselectedItemOf(this._oTraversalItem);}if(i.length&&i[i.length-1].getText()===this.getValue()){return this._getPreviousUnselectedItemOf(i[i.length-1]);}if(i.length){return i[i.length-1];}else{var u=this._getUnselectedItems();if(u.length>0){return u[u.length-1];}else{return null;}}};t.prototype.setSelectedItems=function(i){this.removeAllSelectedItems();if(!i||!i.length){return this;}if(!Array.isArray(i)){k.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return this;}i.forEach(function(u){if(!(u instanceof e)&&(typeof u!=="string")){k.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return;}if(typeof u==="string"){u=m.byId(u);}this.setSelection({item:u?u:null,id:u?u.getId():"",key:u?u.getKey():"",suppressInvalidate:true});},this);return this;};t.prototype.addSelectedItem=function(i){if(!i){return this;}if(typeof i==="string"){i=m.byId(i);}this.setSelection({item:i?i:null,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true});return this;};t.prototype.removeSelectedItem=function(i){if(!i){return null;}if(typeof i==="string"){i=m.byId(i);}if(!this.isItemSelected(i)){return null;}this.removeSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:false,suppressInvalidate:true});return i;};t.prototype.removeAllSelectedItems=function(){var i=[];var u=this.getAssociation("selectedItems",[]);u.forEach(function(v){var w=this.removeSelectedItem(v);if(w){i.push(w.getId());}},this);return i;};t.prototype.removeSelectedKeys=function(i){var u,v=[];if(!i||!i.length||!Array.isArray(i)){return v;}i.forEach(function(w){u=this.getItemByKey(w);if(u){this.removeSelection({item:u?u:null,id:u?u.getId():"",key:u?u.getKey():"",fireChangeEvent:false,suppressInvalidate:true});v.push(u);}},this);return v;};t.prototype.setSelectedKeys=function(i){if(this._bInitialSelectedKeysSettersCompleted){this.setProperty("selectedKeys",[],true);this.removeAllSelectedItems();}this.addSelectedKeys(i);this._bInitialSelectedKeysSettersCompleted=true;return this;};t.prototype.addSelectedKeys=function(i){var u,v=[];i=this.validateProperty("selectedKeys",i);i.forEach(function(w){var x=this.getItemByKey(w);if(x){this.addSelectedItem(x);}else if(w!=null){v.push(w);}},this);if(v.length>0){u=this.getProperty("selectedKeys").filter(function(w){return v.indexOf(w)===-1;});v=u.concat(v);this.setProperty("selectedKeys",v,true);}return this;};t.prototype._getUnselectedItems=function(){var i=q(this.getSelectableItems()).not(this.getSelectedItems()).get();if(!this.isOpen()){return i.filter(function(u){return!u.isA("sap.ui.core.SeparatorItem");});}return i;};t.prototype.getSelectedItems=function(){var i=[],u=this.getAssociation("selectedItems")||[];u.forEach(function(v){var w=m.byId(v);if(w){i.push(w);}},this);return i;};t.prototype.getWidth=function(){return this.getProperty("width")||"100%";};t.prototype.setEditable=function(i){var u=this._getList(),v=this.getAggregation("tokenizer");a.prototype.setEditable.apply(this,arguments);v.setEditable(i);if(u){this.syncPickerContent(true);this._updatePopoverBasedOnEditMode(i);}return this;};t.prototype._updatePopoverBasedOnEditMode=function(i){var u=this._getList(),v=this._getSuggestionsPopover();if(!u){return;}if(i){v.addContent(u);}};t.prototype._mapItemToListItem=function(i){var u,v,w,A;var x=this.getRenderer();if(!i){return null;}A=(i.getAdditionalText&&this.getShowSecondaryValues())?i.getAdditionalText():"";if(i.isA("sap.ui.core.SeparatorItem")){u=this._mapSeparatorItemToGroupHeader(i,x);i.data(x.CSS_CLASS_COMBOBOXBASE+"ListItem",u);this._decorateListItem(u);return u;}v=x.CSS_CLASS_MULTICOMBOBOX+"Item";w=(this.isItemSelected(i))?v+"Selected":"";u=new S({type:o.Active,visible:i.getEnabled()}).addStyleClass(v+" "+w);u.setTooltip(i.getTooltip());i.data(x.CSS_CLASS_COMBOBOXBASE+"ListItem",u);u.setTitle(i.getText());u.setInfo(A);if(w){var y=new b({key:i.getKey()});y.setText(i.getText());i.data(x.CSS_CLASS_COMBOBOXBASE+"Token",y);this.getAggregation("tokenizer").addToken(y,true);}this.setSelectable(i,i.getEnabled());this._decorateListItem(u);return u;};t.prototype.setSelectable=function(i,u){a.prototype.setSelectable.call(this,i,u);var v=this._getTokenByItem(i);if(v){v.setVisible(u);}};t.prototype._fillList=function(u){if(!u){return null;}if(!this._oListItemEnterEventDelegate){this._oListItemEnterEventDelegate={onsapenter:function(x){if(x.srcControl.isSelected()){x.setMarked();}}};}for(var i=0,v,w=u.length;i<w;i++){v=this._mapItemToListItem(u[i]);v.removeEventDelegate(this._oListItemEnterEventDelegate);v.addDelegate(this._oListItemEnterEventDelegate,true,this,true);this._getList().addAggregation("items",v,true);if(this.isItemSelected(u[i])){this._getList().setSelectedItem(v,true);}}};t.prototype.handleInputValidation=function(i,u){var v=i.target.value,w=this._sOldInput&&this._sOldInput.length>v.length,x=this.isValueValid(v),y,z,A;var B=i.srcControl;if(!x&&v!==""&&!u){this._handleFieldValidationState(B);return;}A=this._getItemsStartingWith(v,true);if(!u||this._bIsPasteEvent){this._handleTypeAhead(v,A,B);}y=this.getEnabledItems();if(this.isPickerDialog()){z=this.getFilterSelectedButton();if(z!=null&&z.getPressed()){z.setPressed(false);}}if(w){y=this.getItems();}this.filterItems({value:v,items:y});this._sOldInput=v;if((!this.getValue()||!x)&&!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){this.close();}else{this.open();}};t.prototype.isValueValid=function(v){var i=this._getItemsStartingWith(v,true);var u=this._getItemsStartingWithPerTerm(v,true);return i.length||u.length;};t.prototype._handleTypeAhead=function(v,i,u){var w=this.getSelectedItems();var x=i.filter(function(y){if(y.isA("sap.ui.core.SeparatorItem")){return false;}return w.indexOf(y)===-1;});if(this._bDoTypeAhead&&x.length){u.updateDomValue(x[0].getText());if(document.activeElement===u.getFocusDomRef()){u.selectText(v.length,u.getValue().length);}}};t.prototype._handleFieldValidationState=function(i){if(this._sOldInput&&this.isValueValid(this._sOldInput)){i.updateDomValue(this._sOldInput);}else if(this._sOldValue&&this.isValueValid(this._sOldValue)){i.updateDomValue(this._sOldValue);}else{i.updateDomValue("");}if(this._iOldCursorPos){q(i.getFocusDomRef()).cursorPos(this._iOldCursorPos);}this._showWrongValueVisualEffect();};t.prototype.init=function(){this._oRb=m.getLibraryResourceBundle("sap.m");a.prototype.init.apply(this,arguments);this._bInitialSelectedKeysSettersCompleted=false;this._bListItemNavigationInvalidated=false;this._iInitialItemFocus=-1;this._bCheckBoxClicked=true;this._bPreventValueRemove=false;this._oTokenizer=this._createTokenizer();this.setAggregation("tokenizer",this._oTokenizer);this._aInitiallySelectedItems=[];this._oRbM=m.getLibraryResourceBundle("sap.m");this._oRbC=m.getLibraryResourceBundle("sap.ui.core");this._fillList();};t.prototype.clearSelection=function(){this.removeAllSelectedItems();};t.prototype.insertItem=function(i,u){this.insertAggregation("items",i,u,true);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this._getList()){this._getList().insertItem(this._mapItemToListItem(i),u);}return this;};t.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(this._getList()){this._getList().removeItem(i&&this.getListItem(i));}this.removeSelection({item:i,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:true});return i;};t.prototype.isItemSelected=function(i){return this.getSelectedItems().indexOf(i)>-1;};t.prototype._clearTokenizer=function(){this.getAggregation("tokenizer").destroyTokens();};t.prototype.exit=function(){var i=["_oSuggestionPopover","_oToggleButton","_oPickerCustomHeader","_oCustomHeaderToolbar","_oPickerCloseButton"],u=this;a.prototype.exit.apply(this,arguments);this._deregisterResizeHandler();i.forEach(function(v){if(u[v]){u[v].destroy();u[v]=null;}});this._sInitialValueState=null;};t.prototype.destroyItems=function(){this.destroyAggregation("items");this.setProperty("selectedKeys",[],true);if(this._getList()){this._getList().destroyItems();}this.getAggregation("tokenizer").destroyTokens();return this;};t.prototype.removeAllItems=function(){var i=this.removeAllAggregation("items");this.removeAllSelectedItems();if(this._getList()){this._getList().removeAllItems();}return i;};t.prototype._getItemByToken=function(i){return this._getItemBy(i,"Token");};t.prototype._getItemByValue=function(v){return this.getSelectableItems().find(function(i){return i.getText().toLowerCase()===v.toLowerCase();});};t.prototype._handleItemToFocus=function(){if(this.isOpen()){return;}this.syncPickerContent();var i,u,v=m.byId(document.activeElement.id),w=this.getSelectedItems(),x=this.getSelectableItems(),y=this._getList(),z=y&&y.getItemNavigation(),A=this.getValue(),B=this.getPicker();if(v&&v.isA("sap.m.Token")){u=this._getItemByToken(v);}else if(A){u=this._getItemByValue(A);}if(!u){u=w.length?this._getItemByListItem(this._getList().getSelectedItems()[0]):x[0];}i=x.indexOf(u);if(z){z.setSelectedIndex(i);}else{this._bListItemNavigationInvalidated=true;this._iInitialItemFocus=i;}B.setInitialFocus(y);};t.prototype.getAccessibilityInfo=function(){var i=this.getSelectedItems().map(function(v){return v.getText();}).join(" ");var u=a.prototype.getAccessibilityInfo.apply(this,arguments);u.type=m.getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_MULTICOMBO");u.description=((u.description||"")+" "+i).trim();return u;};t.prototype._calculateSpaceForTokenizer=function(){if(this.getDomRef()){var i,u=this.getDomRef().offsetWidth,v=this._calculateIconsSpace(),w=this.$().find(".sapMInputBaseInner"),x=["min-width","padding-right","padding-left"],y=x.reduce(function(A,z){return A+(parseInt(w.css(z))||0);},0);i=u-(v+y);i=i<0?0:i;return i+"px";}else{return null;}};t.prototype._syncInputWidth=function(i){var F=this.getDomRef('inner'),u,v;if(!F||(i&&!i.getDomRef())){return;}v=parseFloat(i.getDomRef().getBoundingClientRect().width.toFixed(2));u=this._calculateIconsSpace();F.style.width='calc(100% - '+parseFloat(u+v)+"px)";};t.prototype._handleNMoreAccessibility=function(){var i=n.getStaticId("sap.m","MULTICOMBOBOX_OPEN_NMORE_POPOVER"),u=this.getAggregation("tokenizer"),F=this.getFocusDomRef(),A=(F&&F.getAttribute("aria-labelledby")),v=A?A.split(" "):[],N=v.indexOf(i),w=this.getEnabled(),x=!this.getEditable()&&u&&u.getHiddenTokensCount();if(x&&N===-1){v.push(i);w&&this.getFocusDomRef().setAttribute("aria-keyshortcuts","Enter");}else if(N!==-1&&!x){v.splice(N,1);this.getFocusDomRef().removeAttribute("aria-keyshortcuts");}if(F&&v.length){F.setAttribute("aria-labelledby",v.join(" ").trim());}};t.prototype.applyShowItemsFilters=function(){this.syncPickerContent();this.filterItems({value:this.getValue()||"_",items:this.getItems()});};return t;});
