/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control','sap/ui/core/Popup','sap/m/Text','sap/m/Button','sap/ui/core/ResizeHandler','sap/ui/Device','sap/ui/core/Icon','sap/ui/layout/VerticalLayout','./InstanceManager','sap/ui/core/InvisibleText','sap/ui/core/library','./LightBoxRenderer','sap/m/BusyIndicator',"sap/ui/thirdparty/jquery",'sap/ui/core/Core','sap/ui/dom/units/Rem'],function(l,C,P,T,B,R,D,I,V,a,b,c,L,d,q,e,f){'use strict';var O=c.OpenState;var g=c.TextAlign;var h=l.ButtonType;var i=l.LightBoxLoadingStates;var j=C.extend('sap.m.LightBox',{metadata:{interfaces:['sap.ui.core.PopupInterface'],library:'sap.m',aggregations:{imageContent:{type:'sap.m.LightBoxItem',multiple:true,bindable:"bindable"},_closeButton:{type:'sap.m.Button',multiple:false,visibility:'hidden'},_errorIcon:{type:'sap.ui.core.Icon',multiple:false,visibility:'hidden'},_errorTitle:{type:'sap.m.Text',multiple:false,visibility:'hidden'},_errorSubtitle:{type:'sap.m.Text',multiple:false,visibility:'hidden'},_verticalLayout:{type:'sap.ui.layout.VerticalLayout',multiple:false,visibility:'hidden'},_invisiblePopupText:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"},_busy:{type:"sap.m.BusyIndicator",multiple:false,visibility:"hidden"}},events:{},defaultAggregation:'imageContent',designtime:"sap/m/designtime/LightBox.designtime"}});j.prototype.init=function(){this._createPopup();this._width=0;this._height=0;this._isRendering=true;this._resizeListenerId=null;this._$lightBox=null;this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._closeButtonText=this._rb.getText("LIGHTBOX_CLOSE_BUTTON");if(sap.ui.getCore().getConfiguration().getAccessibility()){this.setAggregation("_invisiblePopupText",new b());}};j.prototype.onBeforeRendering=function(){var o=this._getImageContent(),n=o._getNativeImage(),s=o.getImageSrc(),S=o._getImageState(),m=this.getAggregation('_invisiblePopupText'),p=this._rb.getText("LIGHTBOX_ARIA_ENLARGED",[o.getTitle(),o.getSubtitle()]),r=this._rb.getText('LIGHTBOX_IMAGE_ERROR'),t=this._rb.getText('LIGHTBOX_IMAGE_ERROR_DETAILS');this._createErrorControls();if(n.getAttribute('src')!==s){n.src=s;}if(this._resizeListenerId){D.resize.detachHandler(this._onResizeHandler);R.deregister(this._resizeListenerId);this._resizeListenerId=null;}switch(S){case i.Loading:this._timeoutId=setTimeout(function(){o._setImageState(i.TimeOutError);},10000);break;case i.Loaded:clearTimeout(this._timeoutId);this._calculateSizes(n);break;case i.Error:clearTimeout(this._timeoutId);p+=" "+r+" "+t;break;default:break;}if(o&&m){m.setText(p);}this._isRendering=true;};j.prototype.onAfterRendering=function(){this._isRendering=false;this._$lightBox=this.$();if(!this._resizeListenerId){this._onResizeHandler=this._onResize.bind(this);D.resize.attachHandler(this._onResizeHandler);this._resizeListenerId=R.register(this,this._onResizeHandler);}};j.prototype.forceInvalidate=C.prototype.invalidate;j.prototype.invalidate=function(o){var m=this._getImageContent();if(this.isOpen()){if(m&&m.getImageSrc()){this.forceInvalidate(o);}else{this.close();}}return this;};j.prototype.exit=function(){if(this._oPopup){this._oPopup.detachOpened(this._fnOpened,this);this._oPopup.detachClosed(this._fnClosed,this);this._oPopup.destroy();this._oPopup=null;}if(this._resizeListenerId){D.resize.detachHandler(this._onResizeHandler);R.deregister(this._resizeListenerId);this._resizeListenerId=null;}a.removeLightBoxInstance(this);};j.prototype.open=function(){var m=this._getImageContent();this._oPopup.setContent(this);if(m&&m.getImageSrc()){this._oPopup.open(300,'center center','center center',document.body,null);a.addLightBoxInstance(this);}return this;};j.prototype.isOpen=function(){if(this._oPopup&&this._oPopup.isOpen()){return true;}return false;};j.prototype.close=function(){if(this._resizeListenerId){D.resize.detachHandler(this._onResizeHandler);R.deregister(this._resizeListenerId);this._resizeListenerId=null;}this._oPopup.close();a.removeLightBoxInstance(this);return this;};j.prototype._getCloseButton=function(){var m=this.getAggregation('_closeButton');if(!m){m=new B({id:this.getId()+'-closeButton',text:this._closeButtonText,type:h.Transparent,press:function(){this.close();}.bind(this)});this.setAggregation('_closeButton',m,true);}return m;};j.prototype._getBusyIndicator=function(){var m=this.getAggregation("_busy");if(!m){m=new d();this.setAggregation("_busy",m,true);}return m;};j.prototype._imageStateChanged=function(n){var s=n===i.Loaded||n===i.Error;if(s&&!this._isRendering){this.rerender();}};j.prototype._createPopup=function(){this._oPopup=new P(this,true,true);this._oPopup.attachOpened(this._fnOpened,this);this._oPopup.attachClosed(this._fnClosed,this);};j.prototype._fnOpened=function(){var t=this;t._onResize();q('#sap-ui-blocklayer-popup').on("click",function(){t.close();});};j.prototype._fnClosed=function(){q('#sap-ui-blocklayer-popup').off("click");};j.prototype._createErrorControls=function(){var r=this._rb;var m;var n;if(this._getImageContent()._getImageState()===i.TimeOutError){m=r.getText('LIGHTBOX_IMAGE_TIMED_OUT');n=r.getText('LIGHTBOX_IMAGE_TIMED_OUT_DETAILS');}else{m=r.getText('LIGHTBOX_IMAGE_ERROR');n=r.getText('LIGHTBOX_IMAGE_ERROR_DETAILS');}if(!this.getAggregation('_verticalLayout')){var o=new T({text:m,textAlign:g.Center}).addStyleClass("sapMLightBoxErrorTitle"),p=new T({text:n,textAlign:g.Center}).addStyleClass("sapMLightBoxErrorSubtitle"),s=new I({src:"sap-icon://picture"}).addStyleClass("sapMLightBoxErrorIcon");this.setAggregation('_verticalLayout',new V({content:[s,o,p]}).addStyleClass('sapMLightBoxVerticalLayout'));}};j.prototype._onResize=function(){var m=k()/2+'px',t=m,n=m,o='',p='',r=this._getImageContent(),s=this.getDomRef(),u,v,w=k();if(r._getImageState()===i.Loaded){this._calculateSizes(r._getNativeImage());u=this._width;v=this._height;this._$lightBox.width(u);this._$lightBox.height(v);}else{u=s.clientWidth;v=s.clientHeight;}if(window.innerWidth>u+w){n='50%';p=Math.round(-u/2);}if(window.innerHeight>v+w){t='50%';o=Math.round(-v/2);}this._$lightBox.css({'top':t,'margin-top':o,'left':n,'margin-left':p});};j.prototype._calculateSizes=function(m){var F=this._calculateFooterHeightInPx(),n=288-F,o=this._getImageContent().getAggregation("_image"),p;this._setImageSize(o,m.naturalWidth,m.naturalHeight);this._calculateAndSetLightBoxSize(o);p=this._pxToNumber(o.getHeight());this.toggleStyleClass('sapMLightBoxMinSize',(p<n));this._isBusy=false;};j.prototype._calculateFooterHeightInPx=function(){var m=this.$().parents().hasClass('sapUiSizeCompact');var s=this._getImageContent().getSubtitle();var F=3;if(m&&!s){F-=0.5;}if(s){F+=0.5;}return f.toPx(F);};j.prototype._calculateAndSetLightBoxSize=function(m){var n,o,p=(20*16),r=(18*16),F=this._calculateFooterHeightInPx();n=this._pxToNumber(m.getHeight());o=this._pxToNumber(m.getWidth());this._width=Math.max(p,o);this._height=Math.max(r,n+F);this._isLightBoxBiggerThanMinDimensions=(o>=p)&&(n>=(r-F));};j.prototype._setImageSize=function(m,n,o){var p=this._calculateFooterHeightInPx(),r=this._getDimensions(n,o,p),w=r.width+'px',s=r.height+'px',t=m.getDomRef();m.setProperty('width',w,true);m.setProperty('height',s,true);if(t){t.style.width=w;t.style.height=s;}};j.prototype._getDimensions=function(m,n,o){var p=20*16,r=18*16,$=q(window),w=$.height(),s=$.width(),t=k(),u=Math.max(s-t,p),v=Math.max(w-t,r),x;v-=o;if(n<=v){if(m<=u){}else{n*=u/m;m=u;}}else{if(m<=u){m*=v/n;n=v;}else{x=Math.max(m/u,n/v);m/=x;n/=x;}}return{width:Math.round(m),height:Math.round(n)};};j.prototype._pxToNumber=function(s){return(s.substring(0,(s.length-2)))*1;};j.prototype._getImageContent=function(){var r=this.getAggregation('imageContent');return r&&r[0];};function k(){var s=D.system;if(s.desktop){return 4*16;}if(s.tablet){return 2*16;}if(s.phone&&D.resize.width>320){return 1*16;}return 0;}j.prototype.onsapescape=function(E){var m=this._oPopup.getOpenState();if(m!==O.CLOSED&&m!==O.CLOSING){this.close();E.stopPropagation();}};return j;});
