/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/library","sap/ui/core/Core","sap/ui/core/Item","sap/ui/core/Renderer","sap/ui/core/IconPool","sap/ui/core/InvisibleText","sap/ui/core/Control",'sap/ui/Device',"./AccButton","sap/m/BadgeCustomData","sap/m/Button","sap/m/ResponsivePopover","sap/m/IconTabBarSelectList","sap/m/BadgeEnabler"],function(l,c,C,I,R,a,b,d,D,A,B,e,f,g,h){"use strict";var T=c.TextAlign;var j=c.TextDirection;var k=l.ButtonType;var P=l.PlacementType;var m=l.ImageHelper;var n=l.IconTabFilterDesign;var o=l.BadgeStyle;var p=c.IconColor;var q=3000;var r=I.extend("sap.m.IconTabFilter",{metadata:{interfaces:["sap.m.IconTab","sap.ui.core.PopupInterface","sap.m.IBadge"],library:"sap.m",designtime:"sap/m/designtime/IconTabFilter.designtime",properties:{count:{type:"string",group:"Data",defaultValue:''},showAll:{type:"boolean",group:"Misc",defaultValue:false},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:''},iconColor:{type:"sap.ui.core.IconColor",group:"Appearance",defaultValue:p.Default},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true},visible:{type:"boolean",group:"Behavior",defaultValue:true},design:{type:"sap.m.IconTabFilterDesign",group:"Appearance",defaultValue:n.Vertical}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},items:{type:"sap.m.IconTab",multiple:true,singularName:"item"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}}}});h.call(r.prototype);var s=C.getLibraryResourceBundle("sap.m");r._aAllIconColors=['sapMITBFilterCritical','sapMITBFilterPositive','sapMITBFilterNegative','sapMITBFilterDefault','sapMITBFilterNeutral'];r.prototype._getImageControl=function(i,t,u){var v={src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false};if(v.src){this._oImageControl=m.getImageControl(this.getId()+"-icon",this._oImageControl,t,v,i,u);}else if(this._oImageControl){this._oImageControl.destroy();this._oImageControl=null;}return this._oImageControl;};r.prototype.init=function(){this._oDragEventDelegate={onlongdragover:this._handleOnLongDragOver,ondragover:this._handleOnDragOver,ondragleave:this._handleOnDragLeave,ondrop:this._handleOnDrop};this.initBadgeEnablement({style:o.Attention,selector:{selector:".sapMITBBadgeHolder"}});this._oCloneInList=null;};r.prototype.exit=function(E){if(this._oImageControl){this._oImageControl.destroy();}if(I.prototype.exit){I.prototype.exit.call(this,E);}if(this._invisibleText){this._invisibleText.destroy();this._invisibleText=null;}if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}if(this._oExpandButton){this._oExpandButton.removeEventDelegate(this._oDragEventDelegate);this._oExpandButton.destroy();this._oExpandButton=null;}this.removeEventDelegate(this._oDragEventDelegate);this._oDragEventDelegate=null;if(this._iHideBadgeTimeout){clearTimeout(this._iHideBadgeTimeout);}};r.prototype.invalidate=function(){var i=this.getParent(),t,O;if(!i){return;}t=i.getParent();if(!(t instanceof sap.m.IconTabBar)){i.invalidate();return;}O=t.getParent();if(O instanceof sap.m.ObjectHeader){O.invalidate();}else{t.invalidate();}};r.prototype.setProperty=function(i,v,S){switch(i){case'enabled':case'textDirection':case'text':case'count':case'showAll':case'icon':case'iconColor':case'iconDensityAware':case'design':if(this.getProperty(i)===v){return this;}d.prototype.setProperty.call(this,i,v,true);if(!S){var t=this.getParent();if(t instanceof sap.m.IconTabHeader){t.invalidate();}}break;default:d.prototype.setProperty.apply(this,arguments);break;}return this;};r.prototype._getNonEmptyKey=function(){var K=this.getKey();if(K){return K;}return this.getId();};r.prototype._getRealTab=function(){return this._oRealItem||this;};r.prototype._getRootTab=function(){var t=this._getRealTab(),i=t.getParent();while(i&&i.isA("sap.m.IconTabFilter")){t=i;i=i.getParent();}return t;};r.prototype._getNestedLevel=function(){var i=this._getRealTab().getParent(),L;for(L=1;i&&i.isA("sap.m.IconTabFilter");L++){i=i.getParent();}return L;};r.prototype.render=function(i,v,V){if(!this.getVisible()){return;}this._prepareDragEventDelegate();var t=this.getParent(),u=t.getParent(),H=t._isInsideIconTabBar(),w={role:"tab"},x=this.getId(),y=this.getCount(),z=this.getText(),E=this.getIcon(),F=this.getIconColor(),S=F==='Positive'||F==='Critical'||F==='Negative'||F==='Neutral',G=this.getDesign()===n.Horizontal,J=t._bTextOnly,K=t._bInLine||t.isInlineMode(),L=this.getShowAll();if(H){w.controls=u.getId()+"-content";}if(this.getItems().length){w.roledescription=s.getText("ICONTABFILTER_SPLIT_TAB");}if(z.length||y!==""||E){var M=[];if(y!==""){M.push(x+"-count");}if(z.length){M.push(x+"-text");}if(E){M.push(x+"-icon");}if(S){M.push(x+"-iconColor");}w.labelledby=M.join(" ");}if(v!==undefined&&V!==undefined){Object.assign(w,{posinset:v+1,setsize:V});}i.openStart("div",this).accessibilityState(w).class("sapMITBItem");if(!y){i.class("sapMITBItemNoCount");}if(G){i.class("sapMITBHorizontal");}else{i.class("sapMITBVertical");}if(L){i.class("sapMITBAll");}else{i.class("sapMITBFilter").class("sapMITBFilter"+F);}if(t._isUnselectable(this)){i.class("sapMITHUnselectable");}if(this.getItems().length>0){i.class("sapMITBFilterWithItems");}if(!this.getEnabled()){i.class("sapMITBDisabled").attr("aria-disabled",true);}i.attr("aria-selected",false);var N=this.getTooltip_AsString();if(N){i.attr("title",N);}if(this._bIsOverflow||this.getItems().length){i.attr("aria-haspopup","menu");}i.openEnd();i.openStart("div").class("sapMITBFilterWrapper").openEnd();if(!K){i.openStart("div",x+"-tab").class("sapMITBTab").openEnd();if(!L||!E){if(S){i.openStart("div",x+"-iconColor").style("display","none").openEnd().text(s.getText('ICONTABBAR_ICONCOLOR_'+F.toUpperCase())).close("div");}i.renderControl(this._getImageControl(['sapMITBFilterIcon',"sapMITBBadgeHolder",'sapMITBFilter'+F],t,r._aAllIconColors));}if(!L&&!E&&!J){i.openStart("span").class("sapMITBFilterNoIcon").openEnd().close("span");}if(G&&!L){i.close("div");i.openStart("div").class("sapMITBHorizontalWrapper").openEnd();}i.openStart("span",x+"-count").class("sapMITBCount");if(L||(!E&&!z.length)){i.class("sapMITBBadgeHolder");}i.openEnd();if(y===""&&G){i.unsafeHtml("&nbsp;");}else{i.text(y);}i.close("span");if(!G){i.close("div");}}if(z.length){i.openStart("div",x+"-text").class("sapMITBText");if(H&&u.getUpperCase()){i.class("sapMITBTextUpperCase");}if(K){i.attr("dir","ltr");}i.openEnd();i.openStart("span").class("sapMITHTextContent");if(!E&&!L){i.class("sapMITBBadgeHolder");}i.openEnd();i.text(t._getDisplayText(this));i.close("span");if(this._bIsOverflow||this.getItems().length&&t._isUnselectable(this)){i.openStart("span",this.getId()+"-expandButton").class("sapMITHShowSubItemsIcon").openEnd();i.icon(a.getIconURI("slim-arrow-down"),null,{"title":null,"aria-hidden":true});i.close("span");}i.close("div");}if(!K&&G){i.close("div");}i.openStart("div").class("sapMITBContentArrow").openEnd().close("div");i.close("div");if(this.getItems().length&&!t._isUnselectable(this)){i.openStart("span").accessibilityState({role:"separator"}).openEnd().close("span");i.renderControl(this._getExpandButton());}if(this.getItems().length){this._updateExpandButtonBadge();}i.close("div");};r.prototype.renderInSelectList=function(i,S,t,u,v){if(this._invisibleText){this._invisibleText.destroy();this._invisibleText=null;}if(!this.getVisible()){return;}var w=true,x=S._bIconOnly,y=S._oIconTabHeader;if(y){w=y._bTextOnly;}i.openStart("li",this).class("sapMITBSelectItem").attr("tabindex","-1").attr("role","menuitem");if(v){i.style("padding-left",v+"rem");}if(t!==undefined&&u!==undefined){i.attr("aria-posinset",t+1);i.attr("aria-setsize",u);i.attr("aria-level",this._getNestedLevel());}var z=this.getTooltip_AsString();if(z){i.attr("title",z);}if(y._isUnselectable(this)){i.class("sapMITHUnselectable");}if(!this.getEnabled()){i.class("sapMITBDisabled").attr("aria-disabled",true);}if(S.getSelectedItem()==this){i.class("sapMITBSelectItemSelected");i.attr("aria-selected",true);}var E=this.getIconColor();i.class("sapMITBFilter"+E);var F=this.getId(),G=E=='Positive'||E=='Critical'||E=='Negative'||E=='Neutral',L=[];if(!x){L.push(F+"-text");}if(!w&&this.getIcon()){L.push(F+"-icon");}if(G){this._invisibleText=new b({text:s.getText('ICONTABBAR_ICONCOLOR_'+E.toUpperCase())});L.push(this._invisibleText.getId());}i.accessibilityState({labelledby:L.join(" ")}).openEnd();if(this._invisibleText){i.renderControl(this._invisibleText);}if(!w){this._renderIcon(i,x);}if(!x){this._renderText(i);}i.close("li");};r.prototype._onAfterParentRendering=function(){this._renderBadge();};r.prototype._renderIcon=function(i,t){var u=this.getIcon();if(u){var v=a.getIconInfo(u),w=["sapMITBSelectItemIcon"];if(v&&!v.suppressMirroring){w.push("sapUiIconMirrorInRTL");}if(t){w.push("sapMITBBadgeHolder");}i.icon(u,w,{id:this.getId()+"-icon","aria-hidden":true});}else{i.openStart("span").class("sapUiIcon").openEnd().close("span");}};r.prototype._renderText=function(i){var t=this.getText(),u=this.getCount(),v=C.getConfiguration().getRTL(),w=this.getTextDirection();i.openStart("span",this.getId()+"-text").attr("dir","ltr").class("sapMText").class("sapMTextNoWrap").class("sapMITBText").class("sapMITBBadgeHolder");if(w!==j.Inherit){i.attr('dir',w.toLowerCase());}var x=R.getTextAlign(T.Begin,w);if(x){i.style("text-align",x);}if(u){if(v){t='('+u+') '+t;}else{t+=' ('+u+')';}}i.openEnd().text(t).close("span");};r.prototype._getSelectList=function(){if(!this._oSelectList){this._oSelectList=new g({selectionChange:function(E){var t=E.getParameter("selectedItem");this._oIconTabHeader.setSelectedItem(t._getRealTab());this._oTabFilter._closePopover();}});this._oSelectList._oIconTabHeader=this.getParent();this._oSelectList._oTabFilter=this;this._oSelectList._bIsOverflow=this._bIsOverflow;}return this._oSelectList;};r.prototype._prepareDragEventDelegate=function(){if(this.getEnabled()){this.addEventDelegate(this._oDragEventDelegate,this);}else{this.removeEventDelegate(this._oDragEventDelegate);}};r.prototype._getExpandButton=function(){this._oExpandButton=this.getAggregation("_expandButton");if(!this._oExpandButton){this._oExpandButton=new A(this.getId()+"-expandButton",{type:k.Transparent,icon:a.getIconURI("slim-arrow-down"),tooltip:s.getText("ICONTABHEADER_OVERFLOW_MORE"),tabIndex:"-1",press:this._expandButtonPress.bind(this)}).addStyleClass("sapMITBFilterExpandBtn");this.setAggregation("_expandButton",this._oExpandButton);}return this._oExpandButton;};r.prototype._updateExpandButtonBadge=function(){var H=this.getBadgeCustomData()&&this.getBadgeCustomData().getVisible(),i=this._hasChildWithBadge();if(i&&!H){this.addCustomData(new B({visible:true}));}else if(!i&&H){this.getBadgeCustomData().setVisible(false);}};r.prototype._hasChildWithBadge=function(){var i=this._bIsOverflow?this._getIconTabHeader()._getItemsForOverflow():this._getAllSubItems();return i.some(function(t){return t.isA("sap.m.IBadge")&&t.getBadgeCustomData()&&t.getBadgeCustomData().getVisible();});};r.prototype._expandButtonPress=function(){if(!this.getEnabled()){return;}this.$().trigger("focus");if(!this._oPopover){this._oPopover=new f({showArrow:false,showHeader:false,offsetY:0,offsetX:0,placement:P.VerticalPreferredBottom}).addStyleClass("sapMITBFilterPopover");this._oPopover.attachBeforeClose(function(){this._getSelectList().destroyItems();},this);if(D.system.phone){this._oPopover._oControl.addButton(this._createPopoverCloseButton());}this.addDependent(this._oPopover);this._oPopover._oControl._adaptPositionParams=function(){var i=this.$().parents().hasClass("sapUiSizeCompact");this._arrowOffset=0;if(i){this._offsets=["0 0","0 0","0 4","0 0"];}else{this._offsets=["0 0","0 0","0 5","0 0"];}this._atPositions=["end top","end top","end bottom","begin top"];this._myPositions=["end bottom","begin top","end top","end top"];};}var H=this._setSelectListItems();var S=this._getSelectList();this._oPopover.removeAllContent();if(this.getItems().length||this._bIsOverflow){this._oPopover.addContent(S);this._oPopover.setInitialFocus(H?S.getSelectedItem():S.getVisibleTabFilters()[0]);this._oPopover.openBy(this);}};r.prototype._getAllSubItems=function(){var i=[];this._getRealTab().getItems().forEach(function(t){if(t.isA("sap.m.IconTabFilter")){i=i.concat(t,t._getAllSubItems());}else{i=i.concat(t);}});return i;};r.prototype._getAllSubFilters=function(){return this._getAllSubItems().filter(function(i){return i.isA("sap.m.IconTabFilter");});};r.prototype._getAllSubFiltersDomRefs=function(){return this._getAllSubFilters().filter(function(S){return Boolean(S._getRealTab().getDomRef());}).map(function(S){return S._getRealTab().getDomRef();});};r.prototype._getFirstAvailableSubFilter=function(){var t=this._getAllSubFilters();for(var i=0;i<t.length;i++){var u=t[i];if(u.getContent().length&&u.getVisible()){return u;}}return this;};r.prototype._isParentOf=function(t){var u=this._getAllSubFilters();for(var i=0;i<u.length;i++){if(u[i]._getRealTab()===t){return true;}}return false;};r.prototype._createPopoverCloseButton=function(){return new e({text:s.getText("SELECT_CANCEL_BUTTON"),press:this._closePopover.bind(this)});};r.prototype._closePopover=function(){if(this._oPopover){this._oPopover.close();this._oPopover.removeAllContent();}if(this._bIsOverflow&&this.getParent().oSelectedItem){(this.getParent()._oSelectedRootItem||this.getParent().oSelectedItem).$().focus();}};r.prototype._handleOnDragOver=function(E){if(!this._bIsOverflow&&!this._getIconTabHeader().getMaxNestingLevel()){return;}this.getDomRef().classList.add("sapMITHDragOver");E.preventDefault();};r.prototype._handleOnLongDragOver=function(){if(!this._bIsOverflow&&!this._getIconTabHeader().getMaxNestingLevel()){return;}if(this._oPopover&&this._oPopover.isOpen()){return;}this._expandButtonPress();};r.prototype._handleOnDrop=function(){this.getDomRef().classList.remove("sapMITHDragOver");};r.prototype._handleOnDragLeave=function(){this.getDomRef().classList.remove("sapMITHDragOver");};r.prototype._setSelectListItems=function(){var t=this.getParent(),S=this._getSelectList(),u=this._getAllSubItems(),v=t.oSelectedItem,H=false,w;if(this._bIsOverflow){u=t._getItemsForOverflow();}S.destroyItems();S.setSelectedItem(null);for(var i=0;i<u.length;i++){w=u[i];var L=w.clone(undefined,undefined,{cloneChildren:false,cloneBindings:true});if(w instanceof r&&w.getBadgeCustomData()){L.addCustomData(w.getBadgeCustomData().clone());w._oCloneInList=L;}L._oRealItem=w;S.addItem(L);if(w.isA("sap.m.IconTabSeparator")){continue;}if(L._getRealTab()===v){S.setSelectedItem(L);H=true;continue;}if(L._getRealTab()._isParentOf(v)){S.setSelectedItem(v._getRealTab());H=true;}}return H;};r.prototype._getIconTabHeader=function(){return this._getRootTab().getParent();};r.prototype.onsapdown=function(E){if(!this.getEnabled()){return;}if(this._bIsOverflow||((this._getNestedLevel()===1&&this._getRealTab()===this)&&this._getRealTab().getItems().length!==0)){E.stopImmediatePropagation();this._expandButtonPress();}};r.prototype._startBadgeHiding=function(){if(this._iHideBadgeTimeout){return;}this._iHideBadgeTimeout=setTimeout(this._hideBadge.bind(this),q);};r.prototype._hideBadge=function(){var i=this.getBadgeCustomData();if(!i){return;}i.setVisible(false);this._getRootTab()._updateExpandButtonBadge();if(this._oCloneInList&&!this._oCloneInList.bIsDestroyed&&this._oCloneInList.getBadgeCustomData()){this._oCloneInList.getBadgeCustomData().setVisible(false);this._oCloneInList=null;}if(this._isInOverflow()){this._getIconTabHeader()._getOverflow()._updateExpandButtonBadge();}this._iHideBadgeTimeout=null;};r.prototype._isInOverflow=function(){var i=this.getDomRef();return i&&i.classList.contains("sapMITBFilterHidden");};return r;});
