/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/support/Plugin','sap/ui/core/support/controls/InteractionSlider','sap/ui/core/support/controls/InteractionTree','sap/ui/core/support/controls/TimelineOverview','sap/m/MessageToast','sap/ui/thirdparty/jszip','sap/ui/core/util/File',"sap/ui/performance/trace/Interaction","sap/ui/performance/Measurement"],function(q,P,I,a,T,M,J,F,b,c){"use strict";var d=P.extend("sap.ui.core.support.plugins.Interaction",{constructor:function(s){P.apply(this,["sapUiSupportInteraction","Interaction",s]);this._oStub=s;if(this.runsAsToolPlugin()){this._aEventIds=[this.getId()+"SetMeasurements",this.getId()+"SetActive",this.getId()+"Export",this.getId()+"Import",this.getId()+"SetQueryString"];var p=function(i,w){return("000"+String(i)).slice(-w);};this._fnFormatTime=function(n){var N=new Date(n),m=Math.floor((n-Math.floor(n))*1000);return p(N.getHours(),2)+":"+p(N.getMinutes(),2)+":"+p(N.getSeconds(),2)+"."+p(N.getMilliseconds(),3)+p(m,3);};this._oInteractionSlider=new I();this._oInteractionTree=new a({});this._oTimelineOverview=new T();}else{this._aEventIds=[this.getId()+"Refresh",this.getId()+"Clear",this.getId()+"Start",this.getId()+"Stop",this.getId()+"Activate",this.getId()+"Export",this.getId()+"Import",this.getId()+"SetQueryString"];}}});d.prototype.init=function(s){P.prototype.init.apply(this,arguments);if(this.runsAsToolPlugin()){g.call(this,s);}else{h.call(this,s);}};d.prototype.exit=function(s){P.prototype.exit.apply(this,arguments);};function g(s){var r=sap.ui.getCore().createRenderManager();r.write("<div class=\"sapUiSupportToolbar\">");r.write("<button id=\""+this.getId()+"-record\" class=\"sapUiSupportIntToggleRecordingBtn\"></button>");r.write("<label class='sapUiSupportIntODataLbl'><input type='checkbox' id=\""+this.getId()+"-odata\" > Enable OData Statistics</label>");r.write("<div class='sapUiSupportIntFupInputMask'>");r.write("<input id=\""+this.getId()+"-fileImport\" tabindex='-1' size='1' accept='application/zip' type='file'>");r.write("</div>");r.write("<button id=\""+this.getId()+"-import\" class=\"sapUiSupportIntImportExportBtn sapUiSupportIntImportBtn sapUiSupportRoundedButton \">Import</button>");r.write("<button id=\""+this.getId()+"-export\" class=\"sapUiSupportIntImportExportBtn sapUiSupportIntExportBtn sapUiSupportRoundedButton sapUiSupportIntHidden \">Export</button>");r.write("<span id=\""+this.getId()+"-info\" class=\"sapUiSupportIntRecordingInfo\"></span>");r.write("</div><div class=\"sapUiSupportInteractionCntnt\">");r.write("</div>");r.write('<div class="sapUiPerformanceStatsDiv sapUiSupportIntHidden">');r.write('<div class="sapUiPerformanceTimeline" style="height: 50px;"></div>');r.write('<div class="sapUiPerformanceTop">');r.write('</div>');r.write('<div class="sapUiPerformanceBottom">');r.write('</div>');r.write('</div>');r.flush(this.$().get(0));r.destroy();r=sap.ui.getCore().createRenderManager();this._oTimelineOverview.render(r);r.flush(this.$().find('.sapUiPerformanceStatsDiv .sapUiPerformanceTimeline').get(0));r.destroy();r=sap.ui.getCore().createRenderManager();this._oInteractionSlider.render(r);r.flush(this.$().find('.sapUiPerformanceStatsDiv .sapUiPerformanceTop').get(0));r.destroy();this._oInteractionSlider._registerEventListeners();var t=this;q(".sapUiPerformanceTop").on("InteractionSliderChange",{},function(e,f,i){t._oInteractionTree.setRange(f,i);});this.$("refresh").on("click",q.proxy(function(e){this._oStub.sendEvent(this.getId()+"Refresh");},this));this.$("clear").on("click",q.proxy(function(e){this._oStub.sendEvent(this.getId()+"Clear");},this));this.$("export").on("click",q.proxy(function(e){this.onsapUiSupportInteractionExport();},this));this.$("fileImport").on("change",q.proxy(function(e){this.onsapUiSupportInteractionImport();},this));this.$("active").on("click",q.proxy(function(e){var A=false;if(this.$("active").prop("checked")){A=true;}this._oStub.sendEvent(this.getId()+"Activate",{"active":A});},this));this.$("odata").attr('checked',this._bODATA_Stats_On).on("click",q.proxy(function(e){q.sap.statistics(!q.sap.statistics());},this));this.$('record').attr('data-state',(!this._bFesrActive)?'Start recording':'Stop recording');this.$('record').on("click",q.proxy(function(e){if(this.$('record').attr('data-state')==='Stop recording'){this._oStub.sendEvent(this.getId()+"Refresh");this._oStub.sendEvent(this.getId()+"Activate",{"active":false});this.$('record').attr('data-state','Start recording');q(".sapUiPerformanceStatsDiv.sapUiSupportIntHidden").removeClass("sapUiSupportIntHidden");q(".sapUiSupportIntExportBtn.sapUiSupportIntHidden").removeClass("sapUiSupportIntHidden");}else if(this.$('record').attr('data-state')==='Start recording'){q(".sapUiPerformanceStatsDiv").addClass("sapUiSupportIntHidden");q(".sapUiSupportIntExportBtn").addClass("sapUiSupportIntHidden");this._oStub.sendEvent(this.getId()+"Clear");this._oStub.sendEvent(this.getId()+"Activate",{"active":true});this.$('record').attr('data-state','Stop recording');}},this));}function h(s){var _=/sap-ui-xx-fesr=(true|x|X)/.test(window.location.search);var e=q.sap.statistics()||/sap-statistics=(true|x|X)/.test(window.location.search);this._oStub.sendEvent(this.getId()+"SetQueryString",{"queryString":{bFesrActive:_,bODATA_Stats_On:e}});k.call(this);}function k(s,e){var A=b.getActive()||this._bFesrActive;var m=[];if(A||e){m=e||b.getAll(true);var f=window.performance.timing.fetchStart;for(var i=0;i<m.length;i++){var l=m[i];for(var j=0;j<l.requests.length;j++){var r=l.requests[j];l.requests[j]={connectEnd:r.connectEnd,connectStart:r.connectStart,domainLookupEnd:r.domainLookupEnd,domainLookupStart:r.domainLookupStart,duration:r.duration,entryType:r.entryType,fetchStart:r.fetchStart,initiatorType:r.initiatorType,name:r.name,redirectEnd:r.redirectEnd,redirectStart:r.redirectStart,requestStart:r.requestStart,responseEnd:r.responseEnd,responseStart:r.responseStart,secureConnectionStart:r.secureConnectionStart,startTime:r.startTime,workerStart:r.workerStart,fetchStartOffset:f};}}}this._oStub.sendEvent(this.getId()+"SetMeasurements",{"measurements":m});this._oStub.sendEvent(this.getId()+"SetActive",{"active":A});}d.prototype.onsapUiSupportInteractionSetQueryString=function(e){var p=e.getParameter("queryString");this._bFesrActive=p.bFesrActive;this._bODATA_Stats_On=p.bODATA_Stats_On;this.$("odata").attr('checked',this._bODATA_Stats_On);this.$('record').attr('data-state',(!this._bFesrActive)?'Start recording':'Stop recording');};d.prototype.onsapUiSupportInteractionSetMeasurements=function(e){this._setMeasurementsData(e.getParameter("measurements"));};d.prototype.onsapUiSupportInteractionSetActive=function(e){var A=e.getParameter("active");var C=this.$("active");if(A){C.attr("checked","checked");}else{C.removeAttr("checked");}};d.prototype.onsapUiSupportInteractionRefresh=function(e){k.call(this);};d.prototype.onsapUiSupportInteractionClear=function(e){b.clear();this._oStub.sendEvent(this.getId()+"SetMeasurements",{"measurements":[]});};d.prototype.onsapUiSupportInteractionStart=function(e){c.start(this.getId()+"-perf","Measurement by support tool");};d.prototype.onsapUiSupportInteractionEnd=function(e){d.end(true);};d.prototype.onsapUiSupportInteractionActivate=function(e){var A=e.getParameter("active");if(b.getActive()!=A){b.setActive(A);}};d.prototype.onsapUiSupportInteractionExport=function(e){var m=this.measurements||[];if(m.length>0){var z=new J();z.file("InteractionsSteps.json",JSON.stringify(m).replace(/,"isExpanded":true/g,''));var C=z.generate({type:"blob"});this._openGeneratedFile(C);}};d.prototype.onsapUiSupportInteractionImport=function(E){var i=this.$().find('#'+this.getId()+"-fileImport").get(0).files;if(i.length===0){M.show('Select a file for import first!',{autoClose:true,duration:3000});return;}if(!window.FileReader){M.show('Use a modern browser which supports FileReader!',{autoClose:true,duration:3000});return;}var r=new window.FileReader(),f=i[0],t=this;r.onload=(function(j){return function(e){var z=new J(e.target.result);var l=z.files["InteractionsSteps.json"]&&z.files["InteractionsSteps.json"].asText();if(l){t._setMeasurementsData(JSON.parse(l.replace(/,"isExpanded":true/g,'')));}else{M.show('Imported data does not contain interaction measures',{autoClose:true,duration:3000});}};})(f);r.readAsArrayBuffer(f);};d.prototype._openGeneratedFile=function(C){F.save(C,"InteractionSteps","zip","application/zip");};d.prototype._setMeasurementsData=function(m){var r=0,e=100,f=function(D){var l=function(R,u){var v=0;if(R.length===0){return v;}for(var i=R.length-1;i>=0;i--){if(R[i].startTime<u.startTime){v=i+1;break;}}return v;},n=function(O,u){return O.filter(function(v){return v.timing.startTime===u;});},o=function(u,v){var w=0;if(u.length===0){return w;}for(var i=u.length-1;i>=0;i--){if(u[i].start<(v.fetchStartOffset+v.startTime)){w=i;break;}}return w;},p=0;D.forEach(function(u,v,w){var x=u.requests;for(var i=x.length-1;i>=0;i--){var y=x[i];if(v>0&&u.start-e>(y.fetchStartOffset+y.startTime)){var z=o(w,y);var A=w[z].requests;p=l(A,y);A.splice(p,0,y);x.splice(i,1);var O=n(u.sapStatistics,y.startTime);if(O.length>0){w[z].sapStatistics=w[z].sapStatistics.concat(O);}}}});};f(m);this.measurements=m;for(var i=0;i<m.length;i++){r+=m[i].requests.length;}if(m.length>0){q(".sapUiPerformanceStatsDiv.sapUiSupportIntHidden").removeClass("sapUiSupportIntHidden");q(".sapUiSupportIntExportBtn.sapUiSupportIntHidden").removeClass("sapUiSupportIntHidden");this.$('info').text("Total "+r+" Requests in "+m.length+" Interactions");}else{q(".sapUiPerformanceStatsDiv").addClass("sapUiSupportIntHidden");q(".sapUiSupportIntExportBtn").addClass("sapUiSupportIntHidden");this.$('info').text("");}var t=this.$().find('.sapUiPerformanceStatsDiv .sapUiPerformanceTimeline').get(0);var j=sap.ui.getCore().createRenderManager();this._oTimelineOverview.setInteractions(m);this._oTimelineOverview.render(j);j.flush(t);j.destroy();this._oInteractionSlider._initSlider();this._oInteractionSlider.setDuration(m);var s=this.$().find('.sapUiPerformanceStatsDiv .sapUiPerformanceBottom').get(0);this._oInteractionTree.setInteractions(m);this._oInteractionTree.renderAt(s);};return d;});
