/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./LabelEnablement','sap/ui/base/Object','sap/ui/performance/trace/Interaction','sap/base/util/uid',"sap/ui/util/ActivityDetection","sap/ui/thirdparty/jquery","sap/base/security/encodeXML","sap/base/security/encodeCSS","sap/base/assert","sap/ui/performance/Measurement","sap/base/Log","sap/base/util/extend","./InvisibleRenderer","./Patcher"],function(L,B,I,u,A,q,a,b,c,M,d,f,g,P){"use strict";var C=["renderControl","cleanupControlWithoutRendering","accessibilityState","icon"];var s=["write","writeEscaped","writeAcceleratorKey","writeControlData","writeElementData","writeAttribute","writeAttributeEscaped","addClass","writeClasses","addStyle","writeStyles","writeAccessibilityState","writeIcon","translate","getConfiguration","getHTML"];var D=["openStart","voidStart","attr","class","style","openEnd","voidEnd","text","unsafeHtml","close"];var n=["render","flush","destroy"];function R(){var p=this,F,v,x,S,E,G,O="",V=false,H,J="",K={},N={};this._setFocusHandler=function(e){c(e&&B.isA(e,'sap.ui.core.FocusHandler'),"oFocusHandler must be an sap.ui.core.FocusHandler");F=e;};function Q(){v=p.aBuffer=[];x=p.aRenderedControls=[];S=p.aStyleStack=[{}];H=undefined;V=false;O="";}function T(e,i){c(e&&typeof e=="string"&&/^[a-z_][a-zA-Z0-9_\-]*$/.test(e),"The "+i+" name provided '"+e+"' is not valid; it must contain alphanumeric characters, hyphens or underscores");}function U(e){c(O,"There is no open tag; '"+e+"' must not be called without an open tag");}function W(e){var i=(e===undefined)?!O:e;c(i,"There is an open tag; '"+O+"' tag has not yet ended with '"+(V?"voidEnd":"openEnd")+"'");}function X(e){T(e,"attr");c(e!="class"&&e!="style","Attributes 'class' and 'style' must not be written, instead use dedicated 'class' or 'style' method");}function Y(e){c(typeof e=="string"&&!/\s/.test(e)&&arguments.length===1,"Method 'class' must be called with exactly one class name");}function Z(e){c(e&&typeof e=="string"&&!/\s/.test(e),"Method 'style' must be called with a non-empty string name");}this.write=function(e){c((typeof e==="string")||(typeof e==="number"),"sText must be a string or number");v.push.apply(v,arguments);return this;};this.writeEscaped=function(e,i){if(e!=null){e=a(String(e));if(i){e=e.replace(/&#xa;/g,"<br>");}v.push(e);}return this;};this.writeAttribute=function(e,i){c(typeof e==="string","sName must be a string");c(typeof i==="string"||typeof i==="number"||typeof i==="boolean","value must be a string, number or boolean");v.push(" ",e,"=\"",i,"\"");return this;};this.writeAttributeEscaped=function(e,i){c(typeof e==="string","sName must be a string");v.push(" ",e,"=\"",a(String(i)),"\"");return this;};this.addStyle=function(e,i){c(typeof e==="string","sName must be a string");if(i!=null&&i!=""){c((typeof i==="string"||typeof i==="number"),"value must be a string or number");var j=S[S.length-1];if(!j.aStyle){j.aStyle=[];}j.aStyle.push(e+": "+i+";");}return this;};this.writeStyles=function(){var e=S[S.length-1];if(e.aStyle&&e.aStyle.length){this.writeAttribute("style",e.aStyle.join(" "));}e.aStyle=null;return this;};this.addClass=function(e){if(e){c(typeof e==="string","sName must be a string");var i=S[S.length-1];if(!i.aClasses){i.aClasses=[];}i.aClasses.push(e);}return this;};this.writeClasses=function(e){c(!e||typeof e==="boolean"||B.isA(e,'sap.ui.core.Element'),"oElement must be empty, a boolean, or an sap.ui.core.Element");var i=S[S.length-1];var j;if(e){j=e.aCustomStyleClasses;}else if(e===false){j=[];}else{j=i.aCustomStyleClasses;}if(i.aClasses||j){var c1=[].concat(i.aClasses||[],j||[]);if(c1.length){this.writeAttribute("class",c1.join(" "));}}if(!e){i.aCustomStyleClasses=null;}i.aClasses=null;return this;};this.openStart=function(e,i){T(e,"tag");W();O=e;this.write("<"+e);if(i){if(typeof i=="string"){this.attr("id",i);}else{this.writeElementData(i);}}return this;};this.openEnd=function(e){U("openEnd");W(!V);c(e===undefined||e===true,"The private parameter bExludeStyleClasses must be true or omitted!");O="";this.writeClasses(e===true?false:undefined);this.writeStyles();this.write(">");return this;};this.close=function(e){T(e,"tag");W();this.write("</"+e+">");return this;};this.voidStart=function(e,i){this.openStart(e,i);V=true;return this;};this.voidEnd=function(e){U("voidEnd");W(V||!O);V=false;O="";this.writeClasses(e?false:undefined);this.writeStyles();this.write(">");return this;};this.unsafeHtml=function(e){W();this.write(e);return this;};this.text=function(e){W();this.writeEscaped(e);return this;};this.attr=function(e,i){X(e);this.writeAttributeEscaped(e,i);return this;};this.class=function(e){if(e){Y.apply(this,arguments);this.addClass(a(e));}return this;};this.style=function(e,i){Z(e);this.addStyle(e,i);return this;};this.accessibilityState=this.writeAccessibilityState;this.icon=this.writeIcon;N.openStart=function(e,i){T(e,"tag");W();O=e;if(!i){P.openStart(e);}else if(typeof i=="string"){P.openStart(e,i);}else{P.openStart(e,i.getId());z(this,i);}return this;};N.voidStart=function(e,i){this.openStart(e,i);V=true;return this;};N.attr=function(e,i){X(e);U("attr");P.attr(e,i);return this;};N.class=function(e){if(e){Y.apply(this,arguments);U("class");P.class(e);}return this;};N.style=function(e,i){Z(e);U("style");P.style(e,i);return this;};N.openEnd=function(e){if(e!==true){var i=S[S.length-1];var j=i.aCustomStyleClasses;if(j){j.forEach(P.class,P);i.aCustomStyleClasses=null;}}U("openEnd");W(!V);c(e===undefined||e===true,"The private parameter bExludeStyleClasses must be true or omitted!");O="";P.openEnd();return this;};N.voidEnd=function(e){if(!e){var i=S[S.length-1];var j=i.aCustomStyleClasses;if(j){j.forEach(P.class,P);i.aCustomStyleClasses=null;}}U("voidEnd");W(V||!O);V=false;O="";P.voidEnd();return this;};N.text=function(e){W();if(e!=null){P.text(e);}return this;};N.unsafeHtml=function(e){W();P.unsafeHtml(e);return this;};N.close=function(e){T(e,"tag");W();P.close(e);return this;};function $(e){G=true;try{var i=new q.Event("BeforeRendering");i.srcControl=e;e._handleEvent(i);}finally{G=false;}}this.cleanupControlWithoutRendering=function(e){c(!e||B.isA(e,'sap.ui.core.Control'),"oControl must be an sap.ui.core.Control or empty");if(!e){return;}var i=e.getDomRef();if(i){$(e);R.preserveContent(i,false,false);if(!i.hasAttribute(m)){e.bOutput=false;}}};this.renderControl=function(e){c(!e||B.isA(e,'sap.ui.core.Control'),"oControl must be an sap.ui.core.Control or empty");if(!e){return this;}if(!E){E=[];}if(E&&E.length>0){M.pause(E[0]+"---renderControl");}else if(e.getParent()&&e.getParent().getMetadata().getName()=="sap.ui.core.UIArea"){M.pause(e.getParent().getId()+"---rerender");}E.unshift(e.getId());M.start(e.getId()+"---renderControl","Rendering of "+e.getMetadata().getName(),["rendering","control"]);$(e);M.pause(e.getId()+"---renderControl");var j;var c1=e.getMetadata();var d1=e.getVisible();if(d1){j=c1.getRenderer();}else{var e1=c1.getProperty("visible");var f1=e1&&e1._oParent&&e1._oParent.getName()=="sap.ui.core.Control";j=f1?g:c1.getRenderer();}M.resume(e.getId()+"---renderControl");var g1=e.aBindParameters,h1;if(g1&&g1.length>0&&(h1=e.getDomRef())){var i1=q(h1);for(var i=0;i<g1.length;i++){var j1=g1[i];i1.off(j1.sEventType,j1.fnProxy);}}if(j&&typeof j.render==="function"){if(v.length){H=false;}else if(H===undefined){h1=e.getDomRef();if(!h1&&!d1){h1=document.getElementById(g.createInvisiblePlaceholderId(e));}if(h1&&R.getApiVersion(j)==2&&!R.isPreservedContent(h1)){F&&F.storePatchingControlFocusInfo(h1);P.setRootNode(h1);H=true;}else{H=false;}}else if(!J&&H){if(R.getApiVersion(j)!=2){J=e.getId();H=false;}}var k1={};if(e.aCustomStyleClasses&&e.aCustomStyleClasses.length>0){k1.aCustomStyleClasses=e.aCustomStyleClasses;}S.push(k1);if(H){var l1=P.getCurrentNode();j.render(N,e);if(P.getCurrentNode()==l1){P.unsafeHtml("",e.getId());e.bOutput=false;}else{e.bOutput=true;}}else{var m1=v.length;j.render(K,e);e.bOutput=(v.length!==m1);}S.pop();if(J&&J===e.getId()){P.unsafeHtml(v.join(""),J);J="";H=true;v=[];}}else{d.error("The renderer for class "+c1.getName()+" is not defined or does not define a render function! Rendering of "+e.getId()+" will be skipped!");}x.push(e);if(e.getUIArea&&e.getUIArea()){e.getUIArea()._onControlRendered(e);}if(j===g){e.bOutput="invisible";}M.end(e.getId()+"---renderControl");E.shift();if(E&&E.length>0){M.resume(E[0]+"---renderControl");}else if(e.getParent()&&e.getParent().getMetadata().getName()=="sap.ui.core.UIArea"){M.resume(e.getParent().getId()+"---rerender");}return this;};this.getHTML=function(e){c(e&&B.isA(e,'sap.ui.core.Control'),"oControl must be an sap.ui.core.Control");var i=v;var j=v=this.aBuffer=[];this.renderControl(e);v=this.aBuffer=i;return j.join("");};function _(c1){var i,d1=x.length;for(i=0;i<d1;i++){x[i]._sapui_bInAfterRenderingPhase=true;}G=true;try{for(i=0;i<d1;i++){var e1=x[i];if(e1.bOutput&&e1.bOutput!=="invisible"){var f1=new q.Event("AfterRendering");f1.srcControl=e1;M.start(e1.getId()+"---AfterRendering","AfterRendering of "+e1.getMetadata().getName(),["rendering","after"]);e1._handleEvent(f1);M.end(e1.getId()+"---AfterRendering");}}}finally{for(i=0;i<d1;i++){delete x[i]._sapui_bInAfterRenderingPhase;}G=false;}try{F.restoreFocus(c1);}catch(e){d.warning("Problems while restoring the focus after rendering: "+e,null);}for(i=0;i<d1;i++){var e1=x[i],g1=e1.aBindParameters,h1;if(g1&&g1.length>0&&(h1=e1.getDomRef())){var i1=q(h1);for(var j=0;j<g1.length;j++){var j1=g1[j];i1.on(j1.sEventType,j1.fnProxy);}}}}function a1(e,i){var j;if(!H){j=F&&F.getControlFocusInfo();e(v.join(""));}else{j=F&&F.getPatchingControlFocusInfo();P.reset();}_(j);Q();A.refresh();if(i){i();}}this.flush=function(e,j,c1){c((typeof e==="object")&&(e.ownerDocument==document),"oTargetDomNode must be a DOM element");var d1=I.notifyAsyncStep();if(!j&&(typeof c1!=="number")&&!c1){R.preserveContent(e);}a1(function(e1){for(var i=0;i<x.length;i++){var f1=x[i].getDomRef();if(f1&&!R.isPreservedContent(f1)){if(R.isInlineTemplate(f1)){q(f1).empty();}else{q(f1).remove();}}}if(typeof c1==="number"){if(c1<=0){q(e).prepend(e1);}else{var g1=q(e).children().eq(c1-1);if(g1.length===1){g1.after(e1);}else{q(e).append(e1);}}}else if(!c1){q(e).html(e1);}else{q(e).append(e1);}},d1);};this.render=function(e,i){c(e&&B.isA(e,'sap.ui.core.Control'),"oControl must be a control");c(typeof i==="object"&&i.ownerDocument==document,"oTargetDomNode must be a DOM element");if(G){d.error("Render must not be called within Before or After Rendering Phase. Call ignored.",null,this);return;}var j=I.notifyAsyncStep();Q();this.renderControl(e);a1(function(c1){if(e&&i){var d1=e.getDomRef();if(!d1||R.isPreservedContent(d1)){d1=document.getElementById(g.createInvisiblePlaceholderId(e))||document.getElementById(h.Dummy+e.getId());}var e1=d1&&d1.parentNode!=i;var f1=function(){var g1=q(i);if(i.innerHTML==""){g1.html(c1);}else{g1.append(c1);}};if(e1){if(!R.isPreservedContent(d1)){if(R.isInlineTemplate(d1)){q(d1).empty();}else{q(d1).remove();}}if(c1){f1();}}else{if(c1){if(d1){if(R.isInlineTemplate(d1)){q(d1).html(c1);}else{q(d1).replaceWith(c1);}}else{f1();}}else{if(R.isInlineTemplate(d1)){q(d1).empty();}else{if(!e.getParent()||!e.getParent()._onChildRerenderedEmpty||!e.getParent()._onChildRerenderedEmpty(e,d1)){q(d1).remove();}}}}}},j);};this.destroy=function(){Q();};var b1={};C.forEach(function(e){K[e]=N[e]=b1[e]=this[e];},this);D.forEach(function(e){K[e]=b1[e]=this[e];},this);s.forEach(function(e){K[e]=b1[e]=this[e];},this);n.forEach(function(e){b1[e]=this[e];},this);this.getRendererInterface=function(){return K;};this.getInterface=function(){return b1;};Q();}R.prototype.getConfiguration=function(){return sap.ui.getCore().getConfiguration();};R.prototype.translate=function(K){};R.prototype.writeAcceleratorKey=function(){return this;};R.prototype.writeControlData=function(e){c(e&&B.isA(e,'sap.ui.core.Control'),"oControl must be an sap.ui.core.Control");this.writeElementData(e);return this;};R.prototype.writeElementData=function(e){c(e&&B.isA(e,'sap.ui.core.Element'),"oElement must be an sap.ui.core.Element");this.attr("id",e.getId());z(this,e);return this;};R.prototype.writeAccessibilityState=function(e,j){if(!sap.ui.getCore().getConfiguration().getAccessibility()){return this;}if(arguments.length==1&&!(B.isA(e,'sap.ui.core.Element'))){j=e;e=null;}var E={};if(e!=null){var F=e.getMetadata();var G=function(i,v,V){var Q=F.getProperty(i);if(Q&&e[Q._sGetter]()===V){E[v]="true";}};var H=function(v,Q){var S=F.getAssociation(v);if(S&&S.multiple){var T=e[S._sGetter]();if(v=="ariaLabelledBy"){var U=L.getReferencingLabels(e);var V=U.length;if(V){var W=[];for(var i=0;i<V;i++){if(T.indexOf(U[i])<0){W.push(U[i]);}}T=W.concat(T);}}if(T.length>0){E[Q]=T.join(" ");}}};G("editable","readonly",false);G("enabled","disabled",false);G("visible","hidden",false);if(L.isRequired(e)){E["required"]="true";}G("selected","selected",true);G("checked","checked",true);H("ariaDescribedBy","describedby");H("ariaLabelledBy","labelledby");}if(j){var J=function(v){var i=typeof(v);return v===null||i==="number"||i==="string"||i==="boolean";};var K={};var x,N,O;for(x in j){N=j[x];if(J(N)){K[x]=N;}else if(typeof(N)==="object"&&J(N.value)){O="";if(N.append&&(x==="describedby"||x==="labelledby")){O=E[x]?E[x]+" ":"";}K[x]=O+N.value;}}Object.assign(E,K);}if(B.isA(e,'sap.ui.core.Element')&&e.getParent()&&e.getParent().enhanceAccessibilityState){e.getParent().enhanceAccessibilityState(e,E);}for(var p in E){if(E[p]!=null&&E[p]!==""){this.attr(p==="role"?p:"aria-"+p,E[p]);}}return this;};R.prototype.writeIcon=function(U,e,i){var j=sap.ui.requireSync("sap/ui/core/IconPool"),p=j.isIconURI(U),v=false,x,E,F,G,H;if(typeof e==="string"){e=[e];}if(p){E=j.getIconInfo(U);if(!E){d.error("An unregistered icon: "+U+" is used in sap.ui.core.RenderManager's writeIcon method.");return this;}if(!e){e=[];}e.push("sapUiIcon");if(!E.suppressMirroring){e.push("sapUiIconMirrorInRTL");}}if(p){this.openStart("span");}else{this.voidStart("img");}if(Array.isArray(e)){e.forEach(function(J){this.class(J);},this);}if(p){F={"data-sap-ui-icon-content":E.content,"role":"presentation","title":E.text||null};this.style("font-family","'"+b(E.fontFamily)+"'");}else{F={role:"presentation",alt:"",src:U};}i=f(F,i);if(!i.id){i.id=u();}if(p){G=i.alt||i.title||E.text||E.name;H=i.id+"-label";if(i["aria-labelledby"]){v=true;i["aria-labelledby"]+=(" "+H);}else if(!i.hasOwnProperty("aria-label")){i["aria-label"]=G;}}if(typeof i==="object"){for(x in i){if(i.hasOwnProperty(x)&&i[x]!==null){this.attr(x,i[x]);}}}if(p){this.openEnd();if(v){this.openStart("span");this.style("display","none");this.attr("id",H);this.openEnd();this.text(G);this.close("span");}this.close("span");}else{this.voidEnd();}return this;};R.prototype.getRenderer=function(e){c(e&&B.isA(e,'sap.ui.core.Control'),"oControl must be an sap.ui.core.Control");return R.getRenderer(e);};var h=R.RenderPrefixes={Invisible:g.PlaceholderPrefix,Dummy:"sap-ui-dummy-",Temporary:"sap-ui-tmp-"};R.getRenderer=function(e){c(e&&B.isA(e,'sap.ui.core.Control'),"oControl must be an sap.ui.core.Control");return e.getMetadata().getRenderer();};R.forceRepaint=function(v){var e=v?window.document.getElementById(v):null;var i=typeof v=="string"?e:v;if(i){d.debug("forcing a repaint for "+(i.id||String(i)));var O=i.style.display;var j=document.activeElement;i.style.display="none";i.offsetHeight;i.style.display=O;if(document.activeElement!==j&&j){j.focus();}}};R.createInvisiblePlaceholderId=function(e){return g.createInvisiblePlaceholderId(e);};var k="sap-ui-preserve",l="sap-ui-static",m="data-sap-ui-preserve",o="data-sap-ui-area";function r(){var $=q(document.getElementById(k));if($.length===0){$=q("<div></div>",{"aria-hidden":"true",id:k}).addClass("sapUiHidden").addClass("sapUiForcedHidden").css("width","0").css("height","0").css("overflow","hidden").appendTo(document.body);}return $;}function t(e){q("<div></div>",{id:h.Dummy+e.id}).addClass("sapUiHidden").insertBefore(e);}var w=[];R.attachPreserveContent=function(e,i){R.detachPreserveContent(e);w.push({fn:e,context:i});};R.detachPreserveContent=function(e){w=w.filter(function(i){return i.fn!==e;});};R.preserveContent=function(e,p,j,v){c(typeof e==="object"&&e.ownerDocument==document,"oRootNode must be a DOM element");w.forEach(function(i){i.fn.call(i.context||R,{domNode:e});});var $=r();function x(i){while(i&&i!=e&&i.parentNode){i=i.parentNode;if(i.hasAttribute(m)){return true;}if(i.hasAttribute("data-sap-ui")){break;}}}function E(i,G,H){if(i===G){return true;}for(var J=G.getParent();J;J=J.isA("sap.ui.core.UIComponent")?J.oContainer:J.getParent()){if(J.isA("sap.ui.core.Control")){if(!J.getVisible()){return false;}var K=J.getDomRef();if(K&&!K.contains(H)){return false;}}if(J===i){return true;}}}function F(i){if(i.id===k||i.id===l){return;}var G=i.getAttribute(m);if(G){if(v){var H=sap.ui.getCore().byId(G);if(H&&E(v,H,i)){return;}}if(i===e||x(i)){t(i);}$.append(i);}else if(j&&i.id){R.markPreservableContent(q(i),i.id);$.append(i);return;}if(!i.hasAttribute(o)){var J=i.firstChild;while(J){i=J;J=J.nextSibling;if(i.nodeType===1){F(i);}}}}M.start(e.id+"---preserveContent","preserveContent for "+e.id,["rendering","preserve"]);if(p){F(e);}else{q(e).children().each(function(i,N){F(N);});}M.end(e.id+"---preserveContent");};R.findPreservedContent=function(i){c(typeof i==="string","sId must be a string");var $=r(),e=$.children("["+m+"='"+i.replace(/(:|\.)/g,'\\$1')+"']");return e;};R.markPreservableContent=function($,i){$.attr(m,i);};R.isPreservedContent=function(e){return(e&&e.getAttribute(m)&&e.parentNode&&e.parentNode.id==k);};R.getPreserveAreaRef=function(){return r()[0];};var y="data-sap-ui-template";R.markInlineTemplate=function($){$.attr(y,"");};R.isInlineTemplate=function(e){return(e&&e.hasAttribute(y));};R.getApiVersion=function(e){if(e.hasOwnProperty("apiVersion")){return e.apiVersion;}return 1;};function z(e,E){var i=E.getId();e.attr("data-sap-ui",i);E.getCustomData().forEach(function(v){var x=v._checkWriteToDom(E);if(x){e.attr(x.key.toLowerCase(),x.value);}});var j=E.getDragDropConfig().some(function(v){return v.isDraggable(E);});if(!j){var p=E.getParent();if(p&&p.getDragDropConfig){j=p.getDragDropConfig().some(function(v){return v.isDraggable(E);});}}if(j){e.attr("draggable","true");e.attr("data-sap-ui-draggable","true");}return this;}return R;},true);
