/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Fragment","sap/ui/Device","./Base","sap/ui/core/MessageType"],function(F,D,B,M){"use strict";var A=B.extend("sap.ui.rta.toolbar.Adaptation",{renderer:"sap.ui.rta.toolbar.AdaptationRenderer",animation:true,metadata:{events:{undo:{},redo:{},exit:{},restore:{},transport:{},modeChange:{},manageApps:{},appVariantOverview:{},saveAs:{},activateDraft:{},discardDraft:{},switchVersion:{}},properties:{modeSwitcher:{type:"string",defaultValue:"adaptation"}}}});A.modes={MOBILE:"sapUiRtaToolbarMobile",TABLET:"sapUiRtaToolbarTablet",DESKTOP:"sapUiRtaToolbarDesktop"};var a="sapUiRtaToolbar";var b="sapUiRtaDraftVersionAccent";var c="sapUiRtaActiveVersionAccent";A.prototype.init=function(){D.media.attachHandler(this._onSizeChanged,this,a);B.prototype.init.apply(this,arguments);};A.prototype.onBeforeRendering=function(){if(!D.media.hasRangeSet(a)){D.media.initRangeSet(a,[900,1200],"px",[A.modes.MOBILE,A.modes.TABLET,A.modes.DESKTOP]);}this._onSizeChanged(D.media.getCurrentRange(a));B.prototype.onBeforeRendering.apply(this,arguments);};A.prototype.exit=function(){D.media.detachHandler(this._onSizeChanged,this,a);B.prototype.exit.apply(this,arguments);};function _(s,i,t,T){var o=this.getControl(s);var g=t?this.getTextResources().getText(t):"";var h=T?this.getTextResources().getText(T):"";o.setText(g||"");o.setTooltip(h||"");o.setIcon(i||"");}A.prototype.formatVersionButtonText=function(g,v){var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var T="";var s="Active";if(v.length>0){s=v[0].type;if(g){T=t.getText("TIT_DRAFT");}else{T=v[0].title||t.getText("TIT_VERSION_1");}}else{T=t.getText("TIT_ORIGINAL_APP");}this.setVersionButtonAccentColor(s);return T;};A.prototype.formatVersionTableVisibility=function(n){return n>0;};A.prototype.formatVersionTitle=function(t,T){var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");if(T==="draft"){return o.getText("TIT_DRAFT");}return t||o.getText("TIT_VERSION_1");};A.prototype.formatHighlight=function(t){switch(t){case"draft":return M.Warning;case"active":return M.Success;default:return M.None;}};A.prototype.formatHighlightText=function(t){var T=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");switch(t){case"draft":return T.getText("TIT_DRAFT");case"active":return T.getText("LBL_ACTIVE");default:return T.getText("LBL_INACTIVE");}};function d(v){return v.some(function(V){return V.type==="active";});}A.prototype.formatOriginalAppHighlight=function(v){return d(v)?M.None:M.Success;};A.prototype.formatVersionListItemType=function(s){return s?"Active":"Inactive";};A.prototype.formatOriginalAppHighlightText=function(v){var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");return d(v)?t.getText("LBL_INACTIVE"):t.getText("LBL_ACTIVE");};A.prototype.versionSelected=function(E){var v=E.getSource().getBindingContext("versions");var n=sap.ui.fl.Versions.Original;if(v){n=v.getProperty("versionNumber");}this.fireEvent("switchVersion",{versionNumber:n});};A.prototype.showVersionHistory=function(E){var v=E.getSource();if(!this.oVersionDialogPromise){this.oVersionDialogPromise=F.load({name:"sap.ui.rta.toolbar.VersionHistory",id:this.getId()+"_versionHistoryDialog",controller:{formatVersionTitle:this.formatVersionTitle.bind(this),formatVersionTableVisibility:this.formatVersionTableVisibility.bind(this),formatHighlight:this.formatHighlight.bind(this),formatHighlightText:this.formatHighlightText.bind(this),formatOriginalAppHighlight:this.formatOriginalAppHighlight.bind(this),formatOriginalAppHighlightText:this.formatOriginalAppHighlightText.bind(this),formatVersionListItemType:this.formatVersionListItemType.bind(this),versionSelected:this.versionSelected.bind(this)}}).then(function(V){v.addDependent(V);return V;});}return this.oVersionDialogPromise.then(function(V){if(!V.isOpen()){V.openBy(v);}else{V.close();}});};A.prototype._showButtonIcon=function(s,i,t){_.call(this,s,i,"",t);};A.prototype._showButtonText=function(s,t){_.call(this,s,"",t,"");};A.prototype._switchToIcons=function(){this.getControl("iconBox").setVisible(false);this.getControl("iconSpacer").setVisible(false);this._showButtonIcon("adaptationSwitcherButton","sap-icon://wrench","BTN_ADAPTATION");this._showButtonIcon("navigationSwitcherButton","sap-icon://explorer","BTN_NAVIGATION");this._showButtonIcon("exit","sap-icon://decline","BTN_EXIT");};A.prototype._switchToTexts=function(){this.getControl("iconBox").setVisible(true);this.getControl("iconSpacer").setVisible(true);this._showButtonText("adaptationSwitcherButton","BTN_ADAPTATION");this._showButtonText("navigationSwitcherButton","BTN_NAVIGATION");this._showButtonText("exit","BTN_EXIT");};A.prototype._onSizeChanged=function(p){var m=p.name;this.sMode=m;switch(m){case A.modes.MOBILE:this._switchToIcons();break;case A.modes.TABLET:this._switchToTexts();break;case A.modes.DESKTOP:this._switchToTexts();break;default:}};A.prototype.buildControls=function(){return F.load({name:"sap.ui.rta.toolbar.Adaptation",id:this.getId()+"_fragment",controller:{activateDraft:this._openVersionTitleDialog.bind(this),discardDraft:this.eventHandler.bind(this,"DiscardDraft"),modeChange:this.eventHandler.bind(this,"ModeChange"),undo:this.eventHandler.bind(this,"Undo"),redo:this.eventHandler.bind(this,"Redo"),manageApps:this.eventHandler.bind(this,"ManageApps"),appVariantOverview:this.eventHandler.bind(this,"AppVariantOverview"),restore:this.eventHandler.bind(this,"Restore"),publish:this.eventHandler.bind(this,"Transport"),saveAs:this.eventHandler.bind(this,"SaveAs"),exit:this.eventHandler.bind(this,"Exit"),formatVersionButtonText:this.formatVersionButtonText.bind(this),showVersionHistory:this.showVersionHistory.bind(this)}}).then(function(C){this.getControl("modeSwitcher").setSelectedKey(this.getModeSwitcher());return C;}.bind(this));};function e(){this.getControl("versionTitleInput").setValue("");this.getControl("confirmVersionTitleButton").setEnabled(false);return Promise.resolve(this._oDialog);}function f(){return F.load({name:"sap.ui.rta.toolbar.VersionTitleDialog",id:this.getId()+"_fragment",controller:{onConfirmVersioningDialog:function(){var v=this.getControl("versionTitleInput").getValue();this.fireEvent("activateDraft",{versionTitle:v});this._oDialog.close();}.bind(this),onCancelVersioningDialog:function(){this._oDialog.close();}.bind(this),onVersionTitleLiveChange:function(E){var v=E.getParameter("value");this.getControl("confirmVersionTitleButton").setEnabled(!!v);}.bind(this)}}).then(function(o){this._oDialog=o;this.addDependent(this._oDialog);}.bind(this));}A.prototype.getControl=function(n){return sap.ui.getCore().byId(this.getId()+"_fragment--sapUiRta_"+n);};A.prototype._openVersionTitleDialog=function(){var o;if(this._oDialog){o=e.call(this);}else{o=f.call(this);}return o.then(function(){return this._oDialog.open();}.bind(this));};A.prototype.setVersionButtonAccentColor=function(t){var v=this.getControl("versionButton");if(t==="draft"){v.addStyleClass(b);v.removeStyleClass(c);}else{v.addStyleClass(c);v.removeStyleClass(b);}};A.prototype.show=function(){return B.prototype.show.apply(this,arguments);};A.prototype.hide=function(){return B.prototype.hide.apply(this,arguments);};return A;},true);
