/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Interface","sap/ui/thirdparty/jquery","sap/ui/core/Core","sap/ui/core/Control","sap/ui/integration/util/Manifest","sap/ui/integration/util/ServiceManager","sap/base/Log","sap/ui/integration/util/DataProviderFactory","sap/ui/integration/cards/BaseContent","sap/m/HBox","sap/ui/core/Icon","sap/m/Text","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/base/util/LoaderExtensions","sap/f/CardRenderer","sap/f/library","sap/m/library","sap/ui/integration/library","sap/ui/core/InvisibleText","sap/ui/integration/util/Destinations","sap/ui/integration/util/LoadingProvider","sap/ui/integration/util/HeaderFactory","sap/ui/integration/util/ContentFactory","sap/ui/integration/util/BindingHelper","sap/ui/integration/formatters/IconFormatter","sap/ui/integration/util/FilterBarFactory","sap/m/BadgeEnabler"],function(I,q,C,a,b,S,L,D,B,H,c,T,J,R,d,F,l,m,e,f,g,h,i,j,k,n,o,p){"use strict";var M={TYPE:"/sap.card/type",DATA:"/sap.card/data",HEADER:"/sap.card/header",HEADER_POSITION:"/sap.card/headerPosition",CONTENT:"/sap.card/content",SERVICES:"/sap.ui5/services",APP_TYPE:"/sap.app/type",PARAMS:"/sap.card/configuration/parameters",DESTINATIONS:"/sap.card/configuration/destinations"};var r=l.cards.HeaderPosition;var s=e.CardDataMode;var t=m.BadgeState;var u=3000;var v=a.extend("sap.ui.integration.widgets.Card",{metadata:{library:"sap.ui.integration",interfaces:["sap.f.ICard","sap.m.IBadge"],properties:{manifest:{type:"any",defaultValue:""},parameters:{type:"object",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"auto"},dataMode:{type:"sap.ui.integration.CardDataMode",group:"Behavior",defaultValue:s.Active},baseUrl:{type:"sap.ui.core.URI",defaultValue:null},manifestChanges:{type:"object[]"}},aggregations:{_header:{type:"sap.f.cards.IHeader",multiple:false,visibility:"hidden"},_filterBar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{action:{allowPreventDefault:true,parameters:{actionSource:{type:"sap.ui.core.Control"},manifestParameters:{type:"object"},parameters:{type:"object"},type:{type:"sap.ui.integration.CardActionType"}}},manifestReady:{parameters:{}}},associations:{hostConfigurationId:{},host:{}}},renderer:F});p.call(v.prototype);v.prototype.init=function(){this._oRb=C.getLibraryResourceBundle("sap.f");this.setModel(new J(),"parameters");this._busyStates=new Map();this._oExtension=null;this._oContentFactory=new j(this);this._mFilters=new Map();this._ariaText=new f({id:this.getId()+"-ariaText"});this._ariaContentText=new f({id:this.getId()+"-ariaContentText"});this._ariaContentText.setText(this._oRb.getText("ARIA_LABEL_CARD_CONTENT"));this._oLimitedInterface=new I(this,["getParameters","getCombinedParameters","getManifestEntry","resolveDestination","request","showMessage","getBaseUrl","getResourceBundle"]);this.initBadgeEnablement({accentColor:"AccentColor6"});};v.prototype._initReadyState=function(){this._aReadyPromises=[];this._awaitEvent("_headerReady");this._awaitEvent("_contentReady");this._awaitEvent("_cardReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready");}.bind(this));};v.prototype._clearReadyState=function(){this._bReady=false;this._aReadyPromises=[];};v.prototype.onBeforeRendering=function(){var w=this.getHostConfigurationId();if(this.getDataMode()!==s.Active){return;}if(w){this.addStyleClass(w.replace(/-/g,"_"));}if(this._bApplyManifest||this._bApplyParameters||this._bApplyFilters){this._clearReadyState();this._initReadyState();}if(this._bApplyManifest){var x=this.getManifest();if(!x){this.destroyManifest();}else{this.createManifest(x,this.getBaseUrl());}}if(!this._bApplyManifest&&this._bApplyParameters){this._oCardManifest.processParameters(this.getParameters());this._applyManifestSettings();}if(!this._bApplyManifest&&this._bApplyFilters){this._oCardManifest.processFilters(this._mFilters);this._applyManifestSettings();}this._bApplyManifest=false;this._bApplyParameters=false;this._bApplyFilters=false;};v.prototype.setManifest=function(V){this.setProperty("manifest",V);this._bApplyManifest=true;return this;};v.prototype.setManifestChanges=function(V){this.setProperty("manifestChanges",V);this._bApplyManifest=true;return this;};v.prototype.setParameters=function(V){this.setProperty("parameters",V);this._bApplyParameters=true;return this;};v.prototype.setParameter=function(K,V){var P=this.getParameters()||{};P[K]=V;this.setParameters(P);return this;};v.prototype.setHost=function(w){this.setAssociation("host",w);if(this._oDestinations){this._oDestinations.setHost(this.getHostInstance());}return this;};v.prototype._setFilterValue=function(K,V){this._mFilters.set(K,V);this._bApplyFilters=true;this.invalidate();return this;};v.prototype.createManifest=function(w,x){var O={};this._isManifestReady=false;if(typeof w==="string"){O.manifestUrl=w;w=null;}if(this._oCardManifest){this._oCardManifest.destroy();}this._oCardManifest=new b("sap.card",w,x,this.getManifestChanges());this._oCardManifest.load(O).then(function(){this._registerManifestModulePath();this._isManifestReady=true;this.fireManifestReady();return this._loadExtension();}.bind(this)).then(function(){this._applyManifest();}.bind(this)).catch(this._applyManifest.bind(this));};v.prototype._loadExtension=function(){var E=this._oCardManifest.get("/sap.card/extension");if(!E){return null;}var w=this._oCardManifest.get("/sap.app/id").replace(/\./g,"/")+"/"+E;return new Promise(function(x,y){sap.ui.require([w],function(z){this._oExtension=z;k.addNamespace("extension",{formatters:z.getFormatters()});x();}.bind(this),function(z){L.error("Failed to load "+E+". Check if the path is correct.");y(z);});}.bind(this));};v.prototype._applyManifest=function(){var P=this.getParameters(),w=this._mFilters,x=this._oCardManifest;if(x&&x.getResourceBundle()){this._enhanceI18nModel(x.getResourceBundle());}x.processParameters(P);x.processFilters(w);this._prepareToApplyManifestSettings();this._applyManifestSettings();};v.prototype._loadDefaultTranslations=function(){if(this._defaultTranslationsLoaded){return;}var w=C.getLibraryResourceBundle("sap.ui.integration");this._enhanceI18nModel(w);this._defaultTranslationsLoaded=true;};v.prototype._enhanceI18nModel=function(w){var x=this.getModel("i18n");if(x){x.enhance(w);return;}x=new R({bundle:w});this.setModel(x,"i18n");};v.prototype._awaitEvent=function(E){this._aReadyPromises.push(new Promise(function(w){this.attachEventOnce(E,function(){w();});}.bind(this)));};v.prototype.isReady=function(){return this._bReady;};v.prototype.refresh=function(){if(this.getDataMode()===s.Active){this._clearReadyState();this._initReadyState();this.destroyManifest();this._bApplyManifest=true;this.invalidate();}};v.prototype.exit=function(){this.destroyManifest();this._busyStates=null;this._oRb=null;this._oExtension=null;this._oContentFactory=null;if(this._ariaText){this._ariaText.destroy();this._ariaText=null;}if(this._ariaContentText){this._ariaContentText.destroy();this._ariaContentText=null;}};v.prototype.destroyManifest=function(){if(this._oCardManifest){this._oCardManifest.destroy();this._oCardManifest=null;}if(this._oServiceManager){this._oServiceManager.destroy();this._oServiceManager=null;}if(this._oDataProviderFactory){this._oDataProviderFactory.destroy();this._oDataProviderFactory=null;this._oDataProvider=null;}if(this._oLoadingProvider){this._oLoadingProvider.destroy();this._oLoadingProvider=null;}if(this._oTemporaryContent){this._oTemporaryContent.destroy();this._oTemporaryContent=null;}if(this._oDestinations){this._oDestinations.destroy();this._oDestinations=null;}if(this._oIconFormatter){this._oIconFormatter.destroy();this._oIconFormatter=null;}this.destroyAggregation("_header");this.destroyAggregation("_filterBar");this.destroyAggregation("_content");this._aReadyPromises=null;this._busyStates.clear();this._mFilters.clear();};v.prototype._registerManifestModulePath=function(){if(!this._oCardManifest){return;}this._sAppId=this._oCardManifest.get("/sap.app/id");if(this._sAppId){d.registerResourcePath(this._sAppId.replace(/\./g,"/"),this._oCardManifest.getUrl());}else{L.error("Card sap.app/id entry in the manifest is mandatory");}};v.prototype.getManifest=function(){var V=this.getProperty("manifest");if(V&&typeof V==="object"){return q.extend(true,{},V);}return V;};v.prototype.getParameters=function(){var V=this.getProperty("parameters");if(V&&typeof V==="object"){return q.extend(true,{},V);}return V;};v.prototype.getCombinedParameters=function(){if(!this._isManifestReady){L.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null;}var P=this._oCardManifest.getProcessedParameters(this.getProperty("parameters")),w={},K;for(K in P){w[K]=P[K].value;}return w;};v.prototype.getManifestEntry=function(P){if(!this._isManifestReady){L.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null;}return this._oCardManifest.get(P);};v.prototype.getManifestWithMergedChanges=function(){if(!this._oCardManifest||!this._oCardManifest._oManifest){L.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return{};}return q.extend(true,{},this._oCardManifest._oManifest.getRawJson());};v.prototype.resolveDestination=function(K){return this._oDestinations.getUrl(K);};v.prototype.showMessage=function(w,x){var y=this.getCardContent();if(!y||!y.showMessage){L.error("The experimental feature 'showMessage' is currently available only for an Adaptive Card.");return;}y.showMessage(w,x);};v.prototype.getResourceBundle=function(){var w=this.getModel("i18n");if(!w){L.warning("There are no translations available. Either the i18n configuration is missing or the method is called too early.");return null;}return w.getResourceBundle();};v.prototype._prepareToApplyManifestSettings=function(){var A=this._oCardManifest.get(M.APP_TYPE);if(A&&A!=="card"){L.error("sap.app/type entry in manifest is not 'card'");}if(this._oDataProviderFactory){this._oDataProviderFactory.destroy();}this._oDestinations=new g(this.getHostInstance(),this._oCardManifest.get(M.DESTINATIONS));this._oIconFormatter=new n(this._oDestinations);this._oDataProviderFactory=new D(this._oDestinations,this._oExtension);this._oLoadingProvider=new h();if(this._oExtension){this._oExtension.onCardReady(this._oLimitedInterface);}};v.prototype._applyManifestSettings=function(){this._applyServiceManifestSettings();this._applyDataManifestSettings();this._applyHeaderManifestSettings();this._applyFilterBarManifestSettings();this._applyContentManifestSettings();};v.prototype._applyDataManifestSettings=function(){var w=k.createBindingInfos(this._oCardManifest.get(M.DATA));if(!w){this.fireEvent("_cardReady");return;}this.bindObject(w.path||"/");if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=this._oDataProviderFactory.create(w,this._oServiceManager);if(this._oDataProvider){this.setModel(new J());this._oDataProvider.attachDataRequested(function(){this.onDataRequested();}.bind(this));this._oDataProvider.attachDataChanged(function(E){this.getModel().setData(E.getParameter("data"));if(this._createContentPromise){this._createContentPromise.then(function(x){x.onDataChanged();});}this.onDataRequestComplete();}.bind(this));this._oDataProvider.attachError(function(E){this._handleError("Data service unavailable. "+E.getParameter("message"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.triggerDataUpdate();}};v.prototype._handleCardLoading=function(){var w=this.getCardContent();if(w&&!w.hasStyleClass("sapFCardErrorContent")&&w._oLoadingPlaceholder){var x=w.getAggregation("_content");if(x){x.removeStyleClass("sapFCardContentHidden");}w._oLoadingPlaceholder.destroy();}if(this._oLoadingProvider){this._oLoadingProvider.removeHeaderPlaceholder(this.getCardHeader());}this._oLoadingProvider.setLoading(false);};v.prototype._applyServiceManifestSettings=function(){var w=this._oCardManifest.get(M.SERVICES);if(!w){return;}if(!this._oServiceManager){this._oServiceManager=new S(w,this);}};v.prototype.getCardHeader=function(){return this.getAggregation("_header");};v.prototype.getCardHeaderPosition=function(){if(!this._oCardManifest){return"Top";}return this._oCardManifest.get(M.HEADER_POSITION)||r.Top;};v.prototype.getCardContent=function(){return this.getAggregation("_content");};v.prototype._applyHeaderManifestSettings=function(){var w=this.createHeader();if(!w){this.fireEvent("_headerReady");return;}this.destroyAggregation("_header");this.setAggregation("_header",w);if(w.isReady()){this.fireEvent("_headerReady");}else{w.attachEvent("_ready",function(){this.fireEvent("_headerReady");}.bind(this));}};v.prototype._applyFilterBarManifestSettings=function(){var w=this.createFilterBar();this.destroyAggregation("_filterBar");if(!w){return;}this.setAggregation("_filterBar",w);};v.prototype.getHostInstance=function(){var w=this.getHost();if(!w){return null;}return C.byId(w);};v.prototype._applyContentManifestSettings=function(){var w=this._oCardManifest.get(M.TYPE),x=this.getContentManifest(),A=w+" "+this._oRb.getText("ARIA_ROLEDESCRIPTION_CARD");this._ariaText.setText(A);if(!x){this.fireEvent("_contentReady");return;}this._setTemporaryContent(w,x);this._createContentPromise=this.createContent({cardType:w,contentManifest:x,serviceManager:this._oServiceManager,dataProviderFactory:this._oDataProviderFactory,iconFormatter:this._oIconFormatter,appId:this._sAppId}).then(function(y){this._setCardContent(y);return y;}.bind(this));this._createContentPromise.catch(function(E){if(E){this._handleError(E);}}.bind(this));};v.prototype.createHeader=function(){var w=this._oCardManifest.get(M.HEADER),x=new i(this);return x.create(w);};v.prototype.createFilterBar=function(){var w=this.getManifestEntry("/sap.card/configuration/filters"),V=this._mFilters,x=new o(this);return x.create(w,V);};v.prototype.getContentManifest=function(){var w=this._oCardManifest.get(M.TYPE),x=w&&w.toLowerCase()==="component",y=this._oCardManifest.get(M.CONTENT),z=!!y;if(z&&!w){L.error("Card type property is mandatory!");return null;}if(!z&&!x){return null;}if(!y&&x){y=this._oCardManifest.getJson();}return y;};v.prototype.createContent=function(w){w.cardManifest=this._oCardManifest;return this._oContentFactory.create(w);};v.prototype.onAfterRendering=function(){var w;if(this._oCardManifest&&this._oCardManifest.get(M.TYPE)){w=this._oCardManifest.get(M.TYPE).toLowerCase();}this.toggleStyleClass("sapFCardAnalytical",w==="analytical");};v.prototype._setCardContent=function(w){w.attachEvent("_error",function(E){this._handleError(E.getParameter("logMessage"),E.getParameter("displayMessage"));}.bind(this));var P=this.getAggregation("_content");if(P&&P!==this._oTemporaryContent){P.destroy();}this.setAggregation("_content",w);if(w.isReady()){this.fireEvent("_contentReady");}else{w.attachEvent("_ready",function(){this.fireEvent("_contentReady");}.bind(this));}};v.prototype._setTemporaryContent=function(w,x){var y=this._getTemporaryContent(w,x),P=this.getAggregation("_content");if(P&&P!==y){P.destroy();}this.setAggregation("_content",y);};v.prototype._handleError=function(w,x){L.error(w);this.fireEvent("_error",{message:w});var y="Unable to load the data.",E=x||y,P=this.getAggregation("_content");var z=new H({justifyContent:"Center",alignItems:"Center",items:[new c({src:"sap-icon://message-error",size:"1rem"}).addStyleClass("sapUiTinyMargin"),new T({text:E})]}).addStyleClass("sapFCardErrorContent");if(P&&!P.hasStyleClass("sapFCardErrorContent")){P.destroy();this.fireEvent("_contentReady");}z.addEventDelegate({onAfterRendering:function(){if(!this._oCardManifest){return;}var A=this._oCardManifest.get(M.TYPE),G=this._oCardManifest.get(M.CONTENT),K=this._oContentFactory.getClass(A).getMetadata().getRenderer().getMinHeight(G,z);if(this.getHeight()==="auto"){z.$().css({"min-height":K});}}},this);this.setAggregation("_content",z);};v.prototype._getTemporaryContent=function(w,x){if(!this._oTemporaryContent&&this._oLoadingProvider){this._oTemporaryContent=this._oLoadingProvider.createContentPlaceholder(x,w);this._oTemporaryContent.addEventDelegate({onAfterRendering:function(){if(!this._oCardManifest){return;}var y=this._oContentFactory.getClass(w).getMetadata().getRenderer().getMinHeight(x,this._oTemporaryContent);if(this.getHeight()==="auto"){this._oTemporaryContent.$().css({"min-height":y});}}},this);}return this._oTemporaryContent;};v.prototype.setDataMode=function(w){if(this._oDataProviderFactory&&w===s.Inactive){this._oDataProviderFactory.destroy();this._oDataProviderFactory=null;}this.setProperty("dataMode",w,true);if(this.getProperty("dataMode")===s.Active){this.refresh();}return this;};v.prototype.loadDesigntime=function(){if(this._oDesigntime){return Promise.resolve(this._oDesigntime);}if(!this._oCardManifest){return new Promise(function(w,x){this.attachManifestReady(function(){this.loadDesigntime().then(w,x);}.bind(this));}.bind(this));}var A=this._oCardManifest.get("/sap.app/id");if(!A){return Promise.reject("App id not maintained");}return new Promise(function(w,x){var y=this._oCardManifest.get("/sap.card/designtime"),z=this._oCardManifest.get("/sap.app/id").replace(/\./g,"/")+"/"+y;if(z){sap.ui.require([z],function(E){E._readyPromise(this._oLimitedInterface,this).then(function(){this._oDesigntime=E;w(E);}.bind(this));}.bind(this),function(){x({error:z+" not found"});});}else{x();}}.bind(this));};v.prototype.isLoading=function(){return this._oLoadingProvider?this._oLoadingProvider.getLoadingState():false;};v.prototype.getFocusDomRef=function(){return this.getCardHeader()?this.getCardHeader().getDomRef():this.getDomRef();};v.prototype.onDataRequested=function(){this._oLoadingProvider.createLoadingState(this._oDataProvider);};v.prototype.onDataRequestComplete=function(){this.fireEvent("_cardReady");this._handleCardLoading();this._oLoadingProvider.setLoading(false);};v.prototype.request=function(w){return this._oDataProviderFactory.create({request:w}).setAllowCustomDataType(true).getData();};v.prototype.onfocusin=function(){this._startBadgeHiding();};v.prototype._startBadgeHiding=function(){if(this._iHideBadgeTimeout){return;}this._iHideBadgeTimeout=setTimeout(this._hideBadge.bind(this),u);};v.prototype._hideBadge=function(){var w=this.getBadgeCustomData();if(w){w.setVisible(false);}this._iHideBadgeTimeout=null;};v.prototype.onBadgeUpdate=function(V,w,x){var y=this.getCardHeader(),z,A;if(y){z=y.getDomRef();}else{z=this.getDomRef("contentSection");}if(!z){return;}A=z.getAttribute("aria-labelledby")||"";switch(w){case t.Appear:A=x+" "+A;z.setAttribute("aria-labelledby",A);break;case t.Disappear:A=A.replace(x,"").trim();z.setAttribute("aria-labelledby",A);break;}};v.prototype.getAriaLabelBadgeText=function(){return this.getBadgeCustomData().getValue();};return v;});
