//@ui5-bundle sap/ui/integration/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/integration/Designtime',["sap/ui/base/ManagedObject"],function(M){"use strict";
var D=M.extend("sap.ui.integration.Designtime",{
metadata:{library:"sap.ui.integration"},
constructor:function(s){M.apply(this,[]);this.settings=s;}
});
D.prototype.init=function(){this._oCard=null;};
D.prototype.exit=function(){this._oCard=null;};
D.prototype.onCardReady=function(c,i){this._oCard=c;this._oInternalCardInstance=i;};
D.prototype._readyPromise=function(c,i){this.onCardReady(c,i);return Promise.resolve();};
D.prototype.getCard=function(){return this._oCard;};
return D;});
sap.ui.predefine('sap/ui/integration/Extension',["sap/ui/base/ManagedObject"],function(M){"use strict";
var E=M.extend("sap.ui.integration.Extension",{metadata:{library:"sap.ui.integration",properties:{actions:{type:"sap.ui.integration.CardMenuAction[]"},formatters:{type:"object"}},events:{action:{allowPreventDefault:true,parameters:{card:{type:"sap.ui.core.Control"},actionConfig:{type:'object'},actionSource:{type:"sap.ui.core.Control"},parameters:{type:"object"},type:{type:"sap.ui.integration.CardActionType"}}}}}});
E.prototype.init=function(){this._oCard=null;};
E.prototype.exit=function(){this._oCard=null;};
E.prototype.onCardReady=function(c){this._oCard=c;};
E.prototype.getCard=function(){return this._oCard;};
return E;});
sap.ui.predefine('sap/ui/integration/Host',['sap/ui/thirdparty/jquery','sap/ui/core/Element'],function(q,E){"use strict";
var H=E.extend("sap.ui.integration.Host",{metadata:{library:"sap.ui.integration",properties:{actions:{type:"sap.ui.integration.CardMenuAction[]"},resolveDestination:{type:"function",invalidate:false,parameters:{destinationName:{type:"string"}}}},events:{action:{allowPreventDefault:true,parameters:{card:{type:"sap.ui.core.Control"},actionConfig:{type:'object'},actionSource:{type:"sap.ui.core.Control"},parameters:{type:"object"},type:{type:"sap.ui.integration.CardActionType"}}}}}});
H.prototype.getDestination=function(d){var r=this.getResolveDestination(),R;if(!r||!q.isFunction(r)){return Promise.reject("Could not resolve destination '"+d+"'. There is no 'resolveDestination' callback function configured in the host.");}R=r(d);if(!R){return Promise.reject("Destination '"+d+"' could not be resolved by the host.");}if(R instanceof Promise){return R;}return Promise.resolve(R);};
return H;});
sap.ui.predefine('sap/ui/integration/bindingFeatures/DateRange',["sap/ui/core/date/UniversalDateUtils","sap/base/Log"],function(U,L){"use strict";var D={start:function(t,v){var r=this._getRange(t,v);if(!r){return null;}return r[0];},end:function(t,v){var r=this._getRange(t,v);if(!r){return null;}return r[1];},_getRange:function(t,v){var g=U.ranges[t];if(!g){L.error("The requested date range type '"+t+"' is not found","sap.ui.integration.widgets.Card");return null;}return g(v);}};return D;});
sap.ui.predefine('sap/ui/integration/cards/AdaptiveContent',["sap/ui/integration/library","sap/ui/core/library","sap/ui/dom/includeScript","sap/ui/integration/cards/BaseContent","sap/ui/integration/thirdparty/adaptivecards","sap/ui/integration/thirdparty/adaptivecards-templating","sap/ui/integration/thirdparty/markdown-it","sap/ui/integration/cards/adaptivecards/elements/UI5InputText","sap/ui/integration/cards/adaptivecards/elements/UI5InputNumber","sap/ui/integration/cards/adaptivecards/elements/UI5InputChoiceSet","sap/ui/integration/cards/adaptivecards/elements/UI5InputTime","sap/ui/integration/cards/adaptivecards/elements/UI5InputDate","sap/ui/integration/cards/adaptivecards/elements/UI5InputToggle","sap/ui/integration/cards/adaptivecards/overwrites/ActionRender","sap/ui/integration/cards/adaptivecards/elements/hostConfig","sap/m/VBox","sap/m/MessageStrip","sap/ui/core/HTML","sap/ui/core/Core","sap/ui/model/json/JSONModel","sap/base/Log","sap/ui/integration/util/LoadingProvider"],function(l,c,i,B,A,a,M,U,b,d,e,f,g,h,H,V,j,k,C,J,L,m){"use strict";var n=c.MessageType;
var o=B.extend("sap.ui.integration.cards.AdaptiveContent",{renderer:{apiVersion:2,render:function(r,p){var P=B.getMetadata().getRenderer();return P.render.apply(this,arguments);}}});
o.prototype.init=function(){this.setComponentsReady(false);this._bAdaptiveCardElementsReady=false;this._setupCardContent();this._setupAdaptiveCardDependency();this._loadDependencies();this._oLoadingProvider=new m();};
o.prototype.onAfterRendering=function(){this._renderMSCardContent(this._oCardTemplate||this._oCardConfig);};
o.prototype._setupCardContent=function(){var p=new j(this.getId()+"-message",{showCloseButton:true,visible:false}),q=new k(this.getId()+"content",{preferDOM:false,content:"<div>&nbsp;</div>"});p.addStyleClass("sapUiTinyMargin");this.setAggregation("_content",new V({items:[p,q]}));};
o.prototype.setConfiguration=function(p){this._oCardConfig=p;if(p&&p.request&&p.request.url){this._loadManifestFromUrl(p.request.url);return;}this._handleMarkDown();this._setupMSCardContent();};
o.prototype.getConfiguration=function(){return this._oCardConfig;};
o.prototype._handleMarkDown=function(){var t=this;A.AdaptiveCard.onProcessMarkdown=function(T,r){var p=t.getParent(),E=p&&p.getManifestEntry("/sap.card/configuration/enableMarkdown");if(E){r.outputHtml=new M().render(T);r.didProcess=true;return r;}};};
o.prototype._loadManifestFromUrl=function(u){var D=new J(),t=this;D.loadData(u).then(function(){t._oCardConfig=Object.assign(t._oCardConfig,D.getData());}).then(function(){t._handleMarkDown();t._setupMSCardContent();}).then(function(){D.destroy();D=null;}).catch(function(){L.error("No JSON file found on this URL. Please provide a correct path to the JSON-serialized card object model file.");});};
o.prototype._setupAdaptiveCardDependency=function(){this.adaptiveCardInstance=new A.AdaptiveCard();this._doMSCardsOverwrites();this._adjustHostConfig();this._handleActions();this._replaceElements();this._isRtl();};
o.prototype._doMSCardsOverwrites=function(){A.Action.prototype.render=h;};
o.prototype._adjustHostConfig=function(){this.adaptiveCardInstance.hostConfig=new A.HostConfig(H);};
o.prototype._isRtl=function(){this.adaptiveCardInstance.isRtl=function(){return C.getConfiguration().getRTL();};};
o.prototype._handleActions=function(){this.adaptiveCardInstance.onExecuteAction=function(p){var t,P,q;if(p instanceof A.OpenUrlAction){P={url:p.url};t=l.CardActionType.Navigation;}else if(p instanceof A.SubmitAction){P={data:p.data};t=l.CardActionType.Submit;}else{return;}q=this.getActions();if(q){q.fireAction(this,t,P);}}.bind(this);};
o.prototype.onActionSubmitStart=function(F){this.getParent().setBusy(true);};
o.prototype.onActionSubmitEnd=function(r,E){var R=C.getLibraryResourceBundle("sap.ui.integration"),s=E?R.getText("CARDS_ADAPTIVE_ACTION_SUBMIT_ERROR"):R.getText("CARDS_ADAPTIVE_ACTION_SUBMIT_SUCCESS"),p=E?n.Error:n.Success;this.showMessage(s,p);this.getParent().setBusy(false);};
o.prototype.showMessage=function(s,t){var p=this.getAggregation("_content").getItems()[0];p.applySettings({"type":t,"text":s,"visible":true});};
o.prototype._replaceElements=function(){A.AdaptiveCard.elementTypeRegistry.unregisterType("Input.Text");A.AdaptiveCard.elementTypeRegistry.registerType("Input.Text",function(){return new U();});A.AdaptiveCard.elementTypeRegistry.unregisterType("Input.Number");A.AdaptiveCard.elementTypeRegistry.registerType("Input.Number",function(){return new b();});A.AdaptiveCard.elementTypeRegistry.unregisterType("Input.ChoiceSet");A.AdaptiveCard.elementTypeRegistry.registerType("Input.ChoiceSet",function(){return new d();});A.AdaptiveCard.elementTypeRegistry.unregisterType("Input.Time");A.AdaptiveCard.elementTypeRegistry.registerType("Input.Time",function(){return new e();});A.AdaptiveCard.elementTypeRegistry.unregisterType("Input.Date");A.AdaptiveCard.elementTypeRegistry.registerType("Input.Date",function(){return new f();});A.AdaptiveCard.elementTypeRegistry.unregisterType("Input.Toggle");A.AdaptiveCard.elementTypeRegistry.registerType("Input.Toggle",function(){return new g();});};
o.prototype.setCardDataProvider=function(D){this._oCardDataProvider=D;};
o.prototype._setupMSCardContent=function(){var p=this._oCardConfig,q,r=this._oCardDataProvider;if(!this.adaptiveCardInstance||!p){return;}q=p.$data||p.data;if(!q&&!r){this._oCardTemplate=null;this._renderMSCardContent(p);return;}if(p.$data){q={"json":q};}this._setDataConfiguration(q);};
o.prototype.onDataChanged=function(){var p=this.getBindingContext().getPath(),D=this.getModel().getProperty(p);this._oCardTemplate=this._setTemplating(this._oCardConfig,D);this._oLoadingProvider.setLoading(false);this.invalidate();};
o.prototype._renderMSCardContent=function(p){var D=this.getAggregation("_content").getItems()[1].$(),I=!!this.isLoading();this.setBusy(I);this.getAggregation("_content").toggleStyleClass("sapFCardContentHidden",I);if(this.adaptiveCardInstance&&p&&D.length){this.adaptiveCardInstance.parse(p);D.html(this.adaptiveCardInstance.render());this._bAdaptiveCardElementsReady=true;this._fireCardReadyEvent();if(this.adaptiveCardInstance.renderedElement){this.adaptiveCardInstance.renderedElement.tabIndex=-1;}}};
o.prototype._fireCardReadyEvent=function(){if(this._bAdaptiveCardElementsReady&&this.getComponentsReady()){this._bReady=true;this.fireEvent("_ready");}};
o.prototype._setTemplating=function(t,D){var p=new a.Template(t),q=new a.EvaluationContext();q.$root=D;return p.expand(q);};
o.prototype._loadDependencies=function(){if(this.getComponentsReady()){L.debug("WebComponents were already loaded");this._fireCardReadyEvent();return;}if(window.customElements){window.customElements.whenDefined("ui5-button").then(function(){if(!this.getComponentsReady()){this.setComponentsReady(true);this._fireCardReadyEvent();}}.bind(this));}setTimeout(function(){if(this.getComponentsReady()){L.debug("WebComponents were already loaded");return;}i({id:"webcomponents-loader",url:sap.ui.require.toUrl("sap/ui/integration/thirdparty/webcomponents/webcomponentsjs/webcomponents-loader.js")});}.bind(this));document.addEventListener("WebComponentsReady",function(){if(this.getComponentsReady()){L.debug("WebComponents were already loaded");return;}i({id:"webcomponents-bundle",attributes:{type:"module"},url:sap.ui.require.toUrl("sap/ui/integration/thirdparty/webcomponents/bundle.esm.js")});i({id:"webcomponents-bundle-es5",attributes:{nomodule:"nomodule"},url:sap.ui.require.toUrl("sap/ui/integration/thirdparty/webcomponents/bundle.es5.js")});this.setComponentsReady(true);this._fireCardReadyEvent();}.bind(this));};
o.prototype.setComponentsReady=function(v){this._bComponentsReady=v;return this;};
o.prototype.getComponentsReady=function(){return!!this._bComponentsReady;};
return o;});
sap.ui.predefine('sap/ui/integration/cards/AnalyticalContent',["./AnalyticalContentRenderer","./BaseContent","sap/ui/integration/library","sap/ui/integration/util/BindingResolver","sap/base/Log","sap/ui/core/Core","sap/ui/thirdparty/jquery"],function(A,B,l,a,L,C,q){"use strict";var V,F,b;var c={"Top":"top","Bottom":"bottom","Left":"left","Right":"right"};var d={"TopLeft":"topLeft","Center":"center"};var T={"Left":"left","Center":"center","Right":"right"};var e={"Line":"line","StackedColumn":"stacked_column","StackedBar":"stacked_bar","Donut":"donut"};var f=l.AreaType;
var g=B.extend("sap.ui.integration.cards.AnalyticalContent",{renderer:A});
g.prototype.loadDependencies=function(o){return new Promise(function(r,h){C.loadLibrary("sap.viz",{async:true}).then(function(){sap.ui.require(["sap/viz/ui5/controls/VizFrame","sap/viz/ui5/controls/common/feeds/FeedItem","sap/viz/ui5/data/FlattenedDataset"],function(_,i,j){V=_;F=i;b=j;r();},function(E){h(E);});}).catch(function(){h("Analytical content type is not available with this distribution.");});});};
g.prototype._getVizPropertiesObject=function(o){var t=o.title,h=o.legend,p=o.plotArea;if(!o){return this;}var v={"title":{"style":{"fontWeight":"normal"},"layout":{"respectPlotPosition":false}},"legend":{},"legendGroup":{"layout":{}},"plotArea":{"window":{"start":"firstDataPoint","end":"lastDataPoint"}},"categoryAxis":{"title":{}},"valueAxis":{"title":{}},"interaction":{"noninteractiveMode":true}};if(t){v.title.text=t.text;v.title.visible=t.visible;v.title.alignment=T[t.alignment];}if(h){v.legend.visible=h.visible;v.legendGroup.layout.position=c[h.position];v.legendGroup.layout.alignment=d[h.alignment];}if(p){if(p.dataLabel){v.plotArea.dataLabel=p.dataLabel;}if(p.categoryAxisText){v.categoryAxis.title.visible=p.categoryAxisText.visible;}if(p.valueAxisText){v.valueAxis.title.visible=p.valueAxisText.visible;}}return v;};
g.prototype.onDataChanged=function(){this._createChart();};
g.prototype._createChart=function(){var o=this.getConfiguration();if(!o.chartType){L.error("ChartType is a mandatory property");return;}var r=a.resolveValue(o,this.getModel(),"/");var D=[];if(o.dimensions){var h=[];for(var i=0;i<o.dimensions.length;i++){var j=o.dimensions[i];var n=r.dimensions[i].label;D.push(n);var k={name:n,value:j.value};h.push(k);}}var m=[];if(o.measures){var M=[];for(var i=0;i<o.measures.length;i++){var p=o.measures[i];var n=r.measures[i].label;m.push(n);var s={name:n,value:p.value};M.push(s);}}var t=new b({measures:M,dimensions:h,data:{path:this.getBindingContext().getPath()}});var u=new V({uiConfig:{applicationSet:'fiori'},height:"100%",width:"100%",vizType:e[o.chartType],dataset:t,legendVisible:o.legend,feeds:[new F({uid:o.measureAxis,type:'Measure',values:m}),new F({uid:o.dimensionAxis,type:'Dimension',values:D})]});var v=this._getVizPropertiesObject(r);u.setVizProperties(v);this._oActions.setAreaType(f.Content);this._oActions.attach(o,this);this.setAggregation("_content",u);};
g.prototype.onBeforeRendering=function(){if(this._handleHostConfiguration){this._handleHostConfiguration();}};
g.prototype._handleHostConfiguration=function(){var p=this.getParent(),o=this.getAggregation("_content");if(p&&p.getHostConfigurationId&&o){var h=C.byId(p.getHostConfigurationId());if(h){var s=h.generateJSONSettings("vizProperties"),v=o.getVizProperties();v=q.extend(true,v,s);o.setVizProperties(v);}}};
return g;});
sap.ui.predefine('sap/ui/integration/cards/AnalyticalContentRenderer',["./BaseContentRenderer"],function(B){"use strict";
var A=B.extend("sap.ui.integration.cards.AnalyticalContentRenderer");
A.getMinHeight=function(c,C){var M="14rem";return M;};
return A;});
sap.ui.predefine('sap/ui/integration/cards/AnalyticsCloudContent',["./AnalyticsCloudContentRenderer","./BaseContent","sap/ui/integration/library","sap/ui/core/HTML","sap/ui/integration/util/BindingResolver","sap/base/Log","sap/ui/dom/includeScript"],function(A,B,l,H,a,L,i){"use strict";var b=l.AreaType;
var c=B.extend("sap.ui.integration.cards.AnalyticsCloudContent",{renderer:A});
c.prototype.init=function(){B.prototype.init.apply(this,arguments);var I=this.getId()+"-highchartContainer";this._oHighchartContainer=new H(I,{content:"<div id="+I+" style='height:100%; width:100%'></div>"});this.setAggregation("_content",this._oHighchartContainer);this.fireEvent("_actionContentReady");};
c.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oHighchart){this._oHighchart.destroy();this._oHighchart=null;}if(this._oHighchartContainer){this._oHighchartContainer.destroy();this._oHighchartContainer=null;}};
c.prototype.loadDependencies=function(){return this._loadHighcharts();};
c.prototype.setConfiguration=function(C){B.prototype.setConfiguration.apply(this,arguments);this._oActions.setAreaType(b.Content);this._oActions.attach(C,this);};
c.prototype.onAfterRendering=function(){this._createHighchart();};
c.prototype._loadHighcharts=function(){var C=this.getCardInstance(),d=c.SAC_DESTINATION_KEY,p=C.resolveDestination(d);return p.then(function(u){return c.loadHighcharts(u);},function(r){return Promise.reject("Destination with key '"+d+"' is required for AnalyticsCloud card. It could not be resolved. Reason: '"+r+"'");});};
c.prototype._createHighchart=function(){var C=this.getCardInstance(),o=this.getConfiguration(),d=this.getBindingContext(),p,e;if(!C.isReady()){C.attachEventOnce("_ready",this._createHighchart,this);return;}if(!window.Highcharts){this._handleError("There was a problem with loading Highcharts library. Could not initialize AnalyticsCloud card content.");return;}if(d){p=d.getPath();}e=a.resolveValue(o.options,this.getModel(),p);this._oHighchart=new window.Highcharts.Chart(this._oHighchartContainer.getId(),e);};
c.SAC_DESTINATION_KEY="sac";c.SAC_FIREFLY_SERVICE_PATH="/firefly-service";c.HIGHCHART_MODULES={"highcharts/highstock":{amd:true,exports:'Highcharts'},"highcharts/highcharts-more":{deps:["highcharts/highstock"]},"highcharts/solid-gauge":{deps:["highcharts/highstock"]},"highcharts/histogram-bellcurve":{deps:["highcharts/highstock"]},"highcharts/no-data-to-display":{deps:["highcharts/highstock"]},"highcharts/wordcloud":{deps:["highcharts/highstock"]},"highcharts/variable-pie":{deps:["highcharts/highstock"]},"highcharts/heatmap":{deps:["highcharts/highstock"]},"highcharts/treemap":{deps:["highcharts/highstock"]},"highcharts/variwide":{deps:["highcharts/highstock"]},"highcharts/pattern-fill":{deps:["highcharts/highstock"]},"highcharts/highcharts-3d":{deps:["highcharts/highstock"]},"highcharts/grouped-categories":{deps:["highcharts/highstock"]}};
c.loadHighcharts=function(s){var S=s.trim().replace(/\/$/,""),f=S+this.SAC_FIREFLY_SERVICE_PATH,I=this._isHighchartsIncluded(f),d=this._isHighchartsIncludedByThirdParty();if(I){return this._pLoadModules;}if(d){return Promise.resolve();}this._sIncludedFrom=f;this._pLoadModules=this._loadModules(f);return this._pLoadModules;};
c._isHighchartsIncluded=function(s){var I=this._sIncludedFrom;if(I&&I===s){return true;}if(I&&I!==s){L.warning("Highcharts library is already included from '"+I+"'. The included version will be used and will not load from '"+s+"'","sap.ui.integration.widgets.Card#AnalyticsCloud");return true;}return false;};
c._isHighchartsIncludedByThirdParty=function(){if(window.Highcharts){L.warning("Highcharts library is already included on the page. The included version will be used and will not load another one.","sap.ui.integration.widgets.Card#AnalyticsCloud");return true;}return false;};
c._loadModules=function(s){var S=this.HIGHCHART_MODULES,m=Object.getOwnPropertyNames(S);sap.ui.loader.config({paths:{"highcharts":s+"/highcharts"},async:true,shim:S});return this._require(m).catch(function(){return Promise.reject("There was a problem with loading of the Highcharts library files.");});};
c._require=function(m){return new Promise(function(r,R){sap.ui.require(m,function(){r(arguments);},function(e){R(e);});});};
return c;});
sap.ui.predefine('sap/ui/integration/cards/AnalyticsCloudContentRenderer',["./BaseContentRenderer"],function(B){"use strict";
var A=B.extend("sap.ui.integration.cards.AnalyticsCloudContentRenderer");
A.getMinHeight=function(c,C){var M="14rem";return M;};
return A;});
sap.ui.predefine('sap/ui/integration/cards/BaseContent',["./BaseContentRenderer","sap/ui/core/Core","sap/ui/core/Control","sap/ui/model/json/JSONModel","sap/ui/base/ManagedObjectObserver","sap/ui/integration/util/LoadingProvider"],function(B,C,a,J,M,L){"use strict";
var b=a.extend("sap.ui.integration.cards.BaseContent",{
metadata:{aggregations:{_content:{multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}},events:{press:{}}},
renderer:B
});
b.prototype.init=function(){this._iWaitingEventsCount=0;this._bReady=false;this._mObservers={};this._awaitEvent("_dataReady");this._awaitEvent("_actionContentReady");this._oLoadingProvider=new L();};
b.prototype.ontap=function(e){if(!e.isMarked()){this.firePress({});}};
b.prototype.exit=function(){this._oServiceManager=null;this._oDataProviderFactory=null;this._oIconFormatter=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null;}if(this._oActions){this._oActions.destroy();this._oActions=null;}if(this._oLoadingProvider){this._oLoadingProvider.destroy();this._oLoadingProvider=null;}if(this._oLoadingPlaceholder){this._oLoadingPlaceholder.destroy();this._oLoadingPlaceholder=null;}};
b.prototype.loadDependencies=function(c){return Promise.resolve();};
b.prototype.getActions=function(){return this._oActions;};
b.prototype.setActions=function(A){this._oActions=A;};
b.prototype._awaitEvent=function(e){this._iWaitingEventsCount++;this.attachEventOnce(e,function(){this._iWaitingEventsCount--;if(this._iWaitingEventsCount===0){this._bReady=true;this.fireEvent("_ready");}});};
b.prototype.destroy=function(){this.setAggregation("_content",null);this.setModel(null);this._iWaitingEventsCount=0;if(this._mObservers){Object.keys(this._mObservers).forEach(function(k){this._mObservers[k].disconnect();delete this._mObservers[k];},this);}return a.prototype.destroy.apply(this,arguments);};
b.prototype.setConfiguration=function(c,t){this._oConfiguration=c;if(!c){return this;}this._oLoadingPlaceholder=this._oLoadingProvider.createContentPlaceholder(c,t);this._setDataConfiguration(c.data);return this;};
b.prototype.getConfiguration=function(){return this._oConfiguration;};
b.prototype._setDataConfiguration=function(d){if(!d){this.fireEvent("_dataReady");return;}this.bindObject(d.path||"/");if(this._oDataProvider){this._oDataProvider.destroy();}if(this._oDataProviderFactory){this._oDataProvider=this._oDataProviderFactory.create(d,this._oServiceManager);}if(this._oDataProvider){this.setModel(new J());this._oDataProvider.attachDataRequested(function(){this.onDataRequested();}.bind(this));this._oDataProvider.attachDataChanged(function(e){this._updateModel(e.getParameter("data"));this.onDataChanged();this.onDataRequestComplete();}.bind(this));this._oDataProvider.attachError(function(e){this._handleError(e.getParameter("message"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.triggerDataUpdate();}else{this.fireEvent("_dataReady");}};
b.prototype.destroyPlaceholder=function(){var c=this.getAggregation("_content");if(c){c.removeStyleClass("sapFCardContentHidden");}if(this._oLoadingPlaceholder){this._oLoadingPlaceholder.destroy();this._oLoadingPlaceholder=null;}};
b.prototype.onDataChanged=function(){};
function _(A,c,o){var d=this.getBindingContext(),e=c.getAggregation(A);if(d){o.path=o.path||d.getPath();c.bindAggregation(A,o);if(this.getModel("parameters")&&e){this.getModel("parameters").setProperty("/visibleItems",e.length);}if(!this._mObservers[A]){this._mObservers[A]=new M(function(f){if(f.name===A&&(f.mutation==="insert"||f.mutation==="remove")){var e=c.getAggregation(A);var l=e?e.length:0;if(this.getModel("parameters")){this.getModel("parameters").setProperty("/visibleItems",l);}}}.bind(this));this._mObservers[A].observe(c,{aggregations:[A]});}}}
b.prototype._bindAggregation=function(A,c,o){var d=A&&typeof A==="string";var e=o&&typeof o==="object";if(!d||!c||!e){return;}if(this.getBindingContext()){_.apply(this,arguments);}else{c.attachModelContextChange(_.bind(this,A,c,o));}};
b.prototype.isReady=function(){return this._bReady;};
b.prototype._updateModel=function(d){this.getModel().setData(d);};
b.prototype._handleError=function(l){this.fireEvent("_error",{logMessage:l});};
b.prototype.setServiceManager=function(s){this._oServiceManager=s;return this;};
b.prototype.setDataProviderFactory=function(d){this._oDataProviderFactory=d;return this;};
b.prototype.setIconFormatter=function(i){this._oIconFormatter=i;return this;};
b.prototype.isLoading=function(){var l=this._oLoadingProvider,c=this.getCardInstance();return!l.getDataProviderJSON()&&(l.getLoadingState()||(c&&c.isLoading()));};
b.prototype.attachPress=function(){var m=Array.prototype.slice.apply(arguments);m.unshift("press");a.prototype.attachEvent.apply(this,m);this.invalidate();return this;};
b.prototype.detachPress=function(){var m=Array.prototype.slice.apply(arguments);m.unshift("press");a.prototype.detachEvent.apply(this,m);this.invalidate();return this;};
b.prototype.onActionSubmitStart=function(f){};
b.prototype.onActionSubmitEnd=function(r,e){};
b.prototype.onDataRequested=function(){if(this._oLoadingProvider){this._oLoadingProvider.createLoadingState(this._oDataProvider);}};
b.prototype.onDataRequestComplete=function(){this.fireEvent("_dataReady");this.destroyPlaceholder();this._oLoadingProvider.setLoading(false);};
b.prototype.getCardInstance=function(){return C.byId(this.getCard());};
return b;});
sap.ui.predefine('sap/ui/integration/cards/BaseContentRenderer',["sap/ui/core/Renderer"],function(R){"use strict";
var B=R.extend("sap.ui.integration.cards.BaseContentRenderer",{apiVersion:2});
B.DEFAULT_MIN_HEIGHT="5rem";
B.render=function(r,c){var C="sapFCard",l=c.getMetadata().getLibraryName(),n=c.getMetadata().getName(),t=n.slice(l.length+1,n.length),o=c.getParent(),i=o&&o.isA("sap.f.ICard");C+=t;r.openStart("div",c).class(C).class("sapFCardBaseContent");if(c.hasListeners("press")){r.class("sapFCardClickable");}if(i&&o.getHeight()==="auto"){var h=this.getMinHeight(c.getConfiguration(),c);r.style("min-height",h);}r.openEnd();if(t!=="AdaptiveContent"&&i&&c.isLoading()){r.renderControl(c._oLoadingPlaceholder);if(t!=="AnalyticalContent"&&t!=="TimelineContent"){this.hideContent(c);}}this.renderContent(r,c);r.close("div");};
B.renderContent=function(r,c){r.renderControl(c.getAggregation("_content"));};
B.hideContent=function(c){if(c.isLoading()){c.getAggregation("_content").addStyleClass("sapFCardContentHidden");}};
B.getMinHeight=function(c,C){return this.DEFAULT_MIN_HEIGHT;};
B.isCompact=function(c){var r=c,p=c.getParent();if(!c.getDomRef()&&p&&p.isA("sap.f.ICard")){r=p;}return r.$().closest(".sapUiSizeCompact").hasClass("sapUiSizeCompact");};
return B;});
sap.ui.predefine('sap/ui/integration/cards/BaseListContent',["sap/ui/integration/cards/BaseContent","sap/ui/integration/util/BindingResolver","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/base/Log"],function(B,a,F,b,L){"use strict";
var c=B.extend("sap.ui.integration.cards.BaseListContent",{renderer:{}});
c.prototype.setConfiguration=function(C,t){if(!C){return this;}var l=this.getInnerList(),m=C.maxItems;if(l&&m){l.setGrowing(true);l.setGrowingThreshold(parseInt(m));l.addStyleClass("sapFCardMaxItems");}return B.prototype.setConfiguration.apply(this,arguments);};
c.prototype.getInnerList=function(){return null;};
c.prototype._filterHiddenNavigationItems=function(i,o){if(!i.actions){return;}var A=i.actions[0];if(!(A&&A.service&&A.type==="Navigation")){return;}var f=new F("_card_item_hidden",b.EQ,false);this._awaitEvent("_filterNavItemsReady");o.filters=[f];};
c.prototype._checkHiddenNavigationItems=function(i){if(!i.actions){return;}var m=this.getModel(),p=this.getBindingContext().getPath(),I=m.getProperty(p),A=i.actions[0],s=p.trim().replace(/\/$/,""),P=[],d;if(!(A&&A.service&&A.type==="Navigation")){return;}if(A.service==="object"){d=A.service.name;}else{d=A.service;}I.forEach(function(o,e){var f=a.resolveValue(A.parameters,this.getModel(),s+"/"+e);if(o._card_item_hidden!==undefined){return;}o._card_item_hidden=false;P.push(this._oServiceManager.getService(d).then(function(n){var m=this.getModel();if(!n.hidden){return Promise.resolve();}return n.hidden({parameters:f}).then(function(h){o._card_item_hidden=h;m.checkUpdate(true);});}.bind(this)).catch(function(M){L.error(M);}));}.bind(this));m.checkUpdate(true);Promise.all(P).then(function(){this.fireEvent("_filterNavItemsReady");}.bind(this));};
return c;});
sap.ui.predefine('sap/ui/integration/cards/CalendarContent',["sap/ui/integration/library","sap/ui/integration/cards/BaseContent","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/f/PlanningCalendarInCard","sap/f/PlanningCalendarInCardRow","sap/f/PlanningCalendarInCardLegend","sap/m/library","sap/m/PlanningCalendar",'sap/ui/core/format/DateFormat',"sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/unified/CalendarAppointment","sap/ui/unified/DateTypeRange","sap/ui/unified/CalendarLegendItem"],function(l,B,a,b,P,c,d,L,e,D,F,f,C,g,h){"use strict";var A=l.AreaType,i=L.PlanningCalendarBuiltInView;
var j=B.extend("sap.ui.integration.cards.CalendarContent",{renderer:{}});
j.prototype._createCalendar=function(){this._oCalendar=new P(this.getId()+"-PC",{showWeekNumbers:true,builtInViews:[i.OneMonth],rows:[new c(this.getId()+"-Row",{})],intervalSelect:function(E){this._setParameters(E,E.getParameter("startDate"));}.bind(this)});this.setAggregation("_content",this._oCalendar);this._oCalendar.attachEvent("_todayPressed",new Date(),this._setParameters);};
j.prototype.init=function(){B.prototype.init.apply(this,arguments);this._createCalendar();this.fireEvent("_actionContentReady");};
j.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oAppointmentTemplate){this._oAppointmentTemplate.destroy();this._oAppointmentTemplate=null;}if(this._oHeaderTemplate){this._oHeaderTemplate.destroy();this._oHeaderTemplate=null;}if(this._oSpecialDateTemplate){this._oSpecialDateTemplate.destroy();this._oSpecialDateTemplate=null;}if(this._oCalendarLegendItemTemplate){this._oCalendarLegendItemTemplate.destroy();this._oCalendarLegendItemTemplate=null;}if(this._oAppointmentLegendItemTemplate){this._oAppointmentLegendItemTemplate.destroy();this._oAppointmentLegendItemTemplate=null;}if(this._oActions){this._oActions.destroy();this._oActions=null;}};
j.prototype.onDataChanged=function(){this._setParameters();};
j.prototype.onBeforeRendering=function(){this.getModel("parameters").setProperty("/visibleItems",this._iVisibleItems);this.getModel("parameters").setProperty("/allItems",this._iAllItems);};
j.prototype.setConfiguration=function(o){B.prototype.setConfiguration.apply(this,arguments);if(!o){return this;}if(o.item){this._addItem(o.item);}if(o.specialDate){this._addSpecialDate(o.specialDate);}if(o.legendItem){this._addLegendItem(o.legendItem);}if(o.date){this._addDate(o.date);}if(o.maxItems){this._addMaxItems(o.maxItems);}if(o.maxLegendItems){this._addMaxLegendItems(o.maxLegendItems);}if(o.noItemsText){this._addNoItemsText(o.noItemsText);}if(o.moreItems&&o.moreItems.actions){this._oActions.setAreaType(A.Content);this._oActions.attach(o.moreItems,this._oCalendar.getRows()[0]._getMoreButton());}return this;};
j.prototype._setParameters=function(E,o){var k=o?o:this._oCalendar.getStartDate(),s=new Date(k.getFullYear(),k.getMonth(),k.getDate()),m=new Date(k.getFullYear(),k.getMonth(),k.getDate()),n=this.getConfiguration&&this.getConfiguration(),I=n&&n.item&&n.item.path,M,p,q,v,t;m.setDate(m.getDate()+1);q=I?this.getModel().getProperty(I).filter(function(r){var S=new Date(r.start).getTime(),u=new Date(r.end).getTime();if((S>=s.getTime()&&S<m.getTime())||(u>=s.getTime()&&u<m.getTime())||(S<=s.getTime()&&u>m.getTime())){return r;}}):[];if(n&&typeof n.maxItems==="object"){M=n&&this.getConfiguration().maxItems&&"/"+this.getConfiguration().maxItems.binding.getPath();p=this.getModel().getProperty(M);}else{p=n&&this.getConfiguration().maxItems;}t=q.length;if(t<p){v=t;}else{v=p;}this._iVisibleItems=v;this._iAllItems=t;if(this.getModel("parameters")){this.getModel("parameters").setProperty("/visibleItems",this._iVisibleItems);this.getModel("parameters").setProperty("/allItems",this._iAllItems);}};
j.prototype.formatDate=function(t){var o=D.getDateTimeInstance({pattern:"yyyy-MM-dd'T'HH:mm:ss.SSSXXX"}).parse(t);if(!o){o=D.getInstance({pattern:"yyyy-MM-dd"}).parse(t);}return o;};
j.prototype._addItem=function(I){var m={title:I.template.title,text:I.template.text,type:I.template.type},o,k={title:I.template.title,text:I.template.text,type:I.template.type},n;if(I.template.startDate){m.startDate=a.formattedProperty(I.template.startDate,this.formatDate);}if(I.template.endDate){m.endDate=a.formattedProperty(I.template.endDate,this.formatDate);}if(I.template.icon&&I.template.icon.src){m.icon=a.formattedProperty(I.template.icon.src,function(v){return this._oIconFormatter.formatSrc(v,this._sAppId);}.bind(this));}this._oAppointmentTemplate=new C(m);o={path:I.path,template:this._oAppointmentTemplate,filters:new F({path:"visualization",operator:f.Contains,value1:"appointment"})};this._bindAggregation("appointments",this._oCalendar.getRows()[0],o);if(I.template.startDate){k.startDate=a.formattedProperty(I.template.startDate,this.formatDate);}if(I.template.endDate){k.endDate=a.formattedProperty(I.template.endDate,this.formatDate);}if(I.template.icon&&I.template.icon.src){k.icon=a.formattedProperty(I.template.icon.src,function(v){return this._oIconFormatter.formatSrc(v,this._sAppId);}.bind(this));}this._oHeaderTemplate=new C(k);n={path:I.path,template:this._oHeaderTemplate,filters:new F({path:"visualization",operator:f.Contains,value1:"blocker"})};this._bindAggregation("intervalHeaders",this._oCalendar.getRows()[0],n);};
j.prototype._addSpecialDate=function(s){var S=s.template,o;if(S.startDate){S.startDate=a.formattedProperty(S.startDate,this.formatDate);}if(S.endDate){S.endDate=a.formattedProperty(S.endDate,this.formatDate);}this._oSpecialDateTemplate=new g(S);o={path:s.path,template:this._oSpecialDateTemplate};this._bindAggregation("specialDates",this._oCalendar,o);};
j.prototype._addLegendItem=function(m){var k={text:m.template.text,type:m.template.type},n={text:m.template.text,type:m.template.type},o,p;this._oCalendarLegendItemTemplate=new h(k);o={path:m.path,template:this._oCalendarLegendItemTemplate,filters:new F({path:"category",operator:f.Contains,value1:"calendar"})};this._bindAggregation("items",this._oCalendar._getLegend(),o);this._oAppointmentLegendItemTemplate=new h(n);p={path:m.path,template:this._oAppointmentLegendItemTemplate,filters:new F({path:"category",operator:f.Contains,value1:"appointment"})};this._bindAggregation("appointmentItems",this._oCalendar._getLegend(),p);};
j.prototype._addDate=function(t){if(b.isBindingInfo(t)){t&&this._oCalendar.bindProperty("startDate",a.formattedProperty(t,this.formatDate));}else{this._oCalendar.setStartDate(this.formatDate(t));}};
j.prototype._addMaxItems=function(m){if(b.isBindingInfo(m)){m&&this._oCalendar.getRows()[0].bindProperty("visibleAppointmentsCount",m);}else{this._oCalendar.getRows()[0].setVisibleAppointmentsCount(m);}};
j.prototype._addMaxLegendItems=function(m){if(b.isBindingInfo(m)){m&&this._oCalendar._getLegend().bindProperty("visibleLegendItemsCount",m);}else{this._oCalendar._getLegend().setVisibleLegendItemsCount(m);}};
j.prototype._addNoItemsText=function(n){if(b.isBindingInfo(n)){n&&this._oCalendar.getRows()[0].bindProperty("noAppointmentsText",n);}else{this._oCalendar.getRows()[0].setNoAppointmentsText(n);}};
return j;});
sap.ui.predefine('sap/ui/integration/cards/ComponentContent',["sap/ui/integration/cards/BaseContent","sap/ui/core/ComponentContainer"],function(B,C){"use strict";
var a=B.extend("sap.ui.integration.cards.ComponentContent",{renderer:{}});
a.prototype.setConfiguration=function(c){B.prototype.setConfiguration.apply(this,arguments);if(!c){return;}var o=new C({manifest:c,async:true,componentCreated:function(e){var b=e.getParameter("component"),d=this.getParent();if(b.onCardReady){b.onCardReady(d);}this.fireEvent("_actionContentReady");this.fireEvent("_updated");}.bind(this),componentFailed:function(){this.fireEvent("_actionContentReady");this._handleError("Card content failed to create component");}.bind(this)});this.setAggregation("_content",o);};
return a;});
sap.ui.predefine('sap/ui/integration/cards/Header',["sap/f/cards/Header","sap/f/cards/HeaderRenderer","sap/ui/integration/util/BindingHelper",'sap/ui/model/json/JSONModel',"sap/ui/integration/util/LoadingProvider"],function(F,a,B,J,L){"use strict";
var H=F.extend("sap.ui.integration.cards.Header",{
constructor:function(c,A,s,i){c=c||{};this._sAppId=s;var S={title:c.title,subtitle:c.subTitle};if(c.status&&typeof c.status.text==="string"){S.statusText=c.status.text;}if(c.icon){S.iconSrc=c.icon.src;S.iconDisplayShape=c.icon.shape;S.iconInitials=c.icon.text;S.iconAlt=c.icon.alt;}S=B.createBindingInfos(S);if(S.iconSrc){S.iconSrc=B.formattedProperty(S.iconSrc,function(v){return i.formatSrc(v,s);});}S.toolbar=A;F.call(this,S);},
metadata:{library:"sap.ui.integration",properties:{}},
renderer:a
});
H.prototype.init=function(){F.prototype.init.call(this);this._bReady=false;this._oLoadingProvider=new L();this._aReadyPromises=[];this._awaitEvent("_dataReady");this._awaitEvent("_actionHeaderReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready");}.bind(this));};
H.prototype.exit=function(){F.prototype.exit.call(this);this._oServiceManager=null;this._oDataProviderFactory=null;if(this._oLoadingProvider){this._oLoadingProvider.destroy();this._oLoadingProvider=null;}if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null;}if(this._oActions){this._oActions.destroy();this._oActions=null;}};
H.prototype.isReady=function(){return this._bReady;};
H.prototype.isLoading=function(){var l=this._oLoadingProvider,c=this.getParent(),b=c.getMetadata()._sClassName==='sap.ui.integration.widgets.Card'?c.isLoading():false;return!l.getDataProviderJSON()&&(l.getLoadingState()||b);};
H.prototype._updateModel=function(d){this.getModel().setData(d);};
H.prototype._handleError=function(l){this.fireEvent("_error",{logMessage:l});};
H.prototype._awaitEvent=function(e){this._aReadyPromises.push(new Promise(function(r){this.attachEventOnce(e,function(){r();});}.bind(this)));};
H.prototype.setServiceManager=function(s){this._oServiceManager=s;return this;};
H.prototype.setDataProviderFactory=function(d){this._oDataProviderFactory=d;return this;};
H.prototype._setDataConfiguration=function(d){var p="/";if(d&&d.path){p=d.path;}this.bindObject(p);if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=this._oDataProviderFactory.create(d,this._oServiceManager);if(this._oDataProvider){this.setModel(new J());this._oDataProvider.attachDataRequested(function(){this.onDataRequested();}.bind(this));this._oDataProvider.attachDataChanged(function(e){this._updateModel(e.getParameter("data"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.attachError(function(e){this._handleError(e.getParameter("message"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.triggerDataUpdate();}else{this.fireEvent("_dataReady");}};
H.prototype.onDataRequested=function(){this._oLoadingProvider.createLoadingState(this._oDataProvider);};
H.prototype.onDataRequestComplete=function(){this.fireEvent("_dataReady");this._oLoadingProvider.setLoading(false);this._oLoadingProvider.removeHeaderPlaceholder(this);};
return H;});
sap.ui.predefine('sap/ui/integration/cards/ListContent',["./BaseListContent","./ListContentRenderer","sap/m/library","sap/m/List","sap/ui/integration/library","sap/ui/integration/util/BindingHelper","sap/ui/integration/controls/Microchart","sap/ui/integration/controls/MicrochartLegend","sap/ui/integration/controls/ListContentItem"],function(B,L,l,a,b,c,M,d,e){"use strict";var A=b.AreaType;var f=l.AvatarSize;
var g=B.extend("sap.ui.integration.cards.ListContent",{
metadata:{aggregations:{_legend:{multiple:false,visibility:"hidden"}}},
renderer:L
});
g.prototype.init=function(){B.prototype.init.apply(this,arguments);var o=this._getList();var t=this;this.setAggregation("_content",o);o.attachUpdateFinished(function(){if(t._iVisibleItems){var I=o.getItems();for(var i=t._iVisibleItems+1;i<I.length;i++){I[i].setVisible(false);}}});this._oItemTemplate=new e({iconDensityAware:false});};
g.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oItemTemplate){this._oItemTemplate.destroy();this._oItemTemplate=null;}};
g.prototype.loadDependencies=function(C){if(!C||!C.item||!C.item.chart){return Promise.resolve();}return M.loadDependencies();};
g.prototype.destroyPlaceholder=function(){var o=this.getAggregation("_legend");if(o){o.removeStyleClass("sapFCardContentHidden");}B.prototype.destroyPlaceholder.apply(this,arguments);};
g.prototype.setConfiguration=function(C){B.prototype.setConfiguration.apply(this,arguments);if(!C){return this;}if(C.items){this._setStaticItems(C.items);return this;}if(C.item){this._setItem(C.item);}return this;};
g.prototype.onDataChanged=function(){this._checkHiddenNavigationItems(this.getConfiguration().item);};
g.prototype._getList=function(){if(this._bIsBeingDestroyed){return null;}if(!this._oList){this._oList=new a({id:this.getId()+"-list",growing:false,showNoData:false,showSeparators:"None"});}return this._oList;};
g.prototype._setItem=function(i){var s={iconDensityAware:false,title:i.title&&(i.title.value||i.title),description:i.description&&(i.description.value||i.description),highlight:i.highlight,info:i.info&&i.info.value,infoState:i.info&&i.info.state};if(i.icon){s.icon=c.formattedProperty(i.icon.src,function(v){return this._oIconFormatter.formatSrc(v,this._sAppId);}.bind(this));s.iconAlt=i.icon.alt;s.iconDisplayShape=i.icon.shape;s.iconInitials=i.icon.text;if(s.title&&s.description){s.iconSize=f.S;}else{s.iconSize=f.XS;}s.iconSize=i.icon.size||s.iconSize;}if(i.chart){s.microchart=this._createChartAndAddLegend(i.chart);}this._oItemTemplate=new e(s);this._oActions.setAreaType(A.ContentItem);this._oActions.attach(i,this);var o={template:this._oItemTemplate};this._filterHiddenNavigationItems(i,o);this._bindAggregation("items",this._getList(),o);};
g.prototype._createChartAndAddLegend=function(C){var o=M.create(C);this.destroyAggregation("_legend");if(C.type==="StackedBar"){var h=new d({chart:o.getChart()});h.initItemsTitles(C.bars,this.getBindingContext().getPath());this.setAggregation("_legend",h);}return o;};
g.prototype._setStaticItems=function(i){var o=this._getList();i.forEach(function(I){var h=new e({iconDensityAware:false,title:I.title?I.title:"",description:I.description?I.description:"",icon:I.icon?I.icon:"",infoState:I.infoState?I.infoState:"None",info:I.info?I.info:"",highlight:I.highlight?I.highlight:"None"});if(I.action){h.setType("Navigation");if(I.action.url){h.attachPress(function(){window.open(I.action.url,I.target||"_blank");});}}o.addItem(h);});this.fireEvent("_actionContentReady");};
g.prototype.getInnerList=function(){return this._getList();};
return g;});
sap.ui.predefine('sap/ui/integration/cards/ListContentRenderer',["./BaseContentRenderer"],function(B){"use strict";
var L=B.extend("sap.ui.integration.cards.ListContentRenderer");
L.renderContent=function(r,l){r.renderControl(l.getAggregation("_content"));if(l.getAggregation("_legend")){r.renderControl(l.getAggregation("_legend"));}};
L.hideContent=function(l){B.hideContent(l);if(l.getAggregation("_legend")){l.getAggregation("_legend").addStyleClass("sapFCardContentHidden");}};
L.getMinHeight=function(c,C){if(!c){return this.DEFAULT_MIN_HEIGHT;}if(!c.maxItems||!c.item){return this.DEFAULT_MIN_HEIGHT;}var i=this.isCompact(C),a=parseInt(c.maxItems)||0,t=c.item,I=i?2:2.75;if(t.description||t.chart){I=5;}if(t.description&&t.chart){I=6;}return(a*I)+"rem";};
return L;});
sap.ui.predefine('sap/ui/integration/cards/NumericHeader',['sap/base/util/extend',"sap/f/cards/NumericHeader","sap/f/cards/NumericHeaderRenderer","sap/ui/integration/util/BindingHelper","sap/f/cards/NumericSideIndicator",'sap/ui/model/json/JSONModel',"sap/ui/integration/util/LoadingProvider"],function(e,F,a,B,N,J,L){"use strict";
var b=F.extend("sap.ui.integration.cards.NumericHeader",{
constructor:function(c,A,s){c=c||{};this._sAppId=s;var S={title:c.title,subtitle:c.subTitle};if(c.status&&typeof c.status.text==="string"){S.statusText=c.status.text;}e(S,{unitOfMeasurement:c.unitOfMeasurement,details:c.details});if(c.mainIndicator){S.number=c.mainIndicator.number;S.scale=c.mainIndicator.unit;S.trend=c.mainIndicator.trend;S.state=c.mainIndicator.state;}S=B.createBindingInfos(S);if(c.sideIndicators){S.sideIndicators=c.sideIndicators.map(function(i){return new N(i);});}S.toolbar=A;F.call(this,S);},
metadata:{library:"sap.ui.integration",properties:{}},
renderer:a
});
b.prototype.init=function(){F.prototype.init.call(this);this._bReady=false;this._oLoadingProvider=new L();this._aReadyPromises=[];this._awaitEvent("_dataReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready");}.bind(this));};
b.prototype.exit=function(){F.prototype.exit.call(this);this._oServiceManager=null;this._oDataProviderFactory=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null;}if(this._oActions){this._oActions.destroy();this._oActions=null;}if(this._oLoadingProvider){this._oLoadingProvider.destroy();this._oLoadingProvider=null;}};
b.prototype.isReady=function(){return this._bReady;};
b.prototype.isLoading=function(){var l=this._oLoadingProvider,c=this.getParent(),d=c.getMetadata()._sClassName==='sap.ui.integration.widgets.Card'?c.isLoading():false;return!l.getDataProviderJSON()&&(l.getLoadingState()||d);};
b.prototype._awaitEvent=function(E){this._aReadyPromises.push(new Promise(function(r){this.attachEventOnce(E,function(){r();});}.bind(this)));};
b.prototype.setServiceManager=function(s){this._oServiceManager=s;return this;};
b.prototype.setDataProviderFactory=function(d){this._oDataProviderFactory=d;return this;};
b.prototype._setDataConfiguration=function(d){var p="/";if(d&&d.path){p=d.path;}this.bindObject(p);if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=this._oDataProviderFactory.create(d,this._oServiceManager);if(this._oDataProvider){this.setModel(new J());this._oDataProvider.attachDataRequested(function(){this.onDataRequested();}.bind(this));this._oDataProvider.attachDataChanged(function(E){this._updateModel(E.getParameter("data"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.attachError(function(E){this._handleError(E.getParameter("message"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.triggerDataUpdate();}else{this.fireEvent("_dataReady");}};
b.prototype._updateModel=function(d){this.getModel().setData(d);};
b.prototype._handleError=function(l){this.fireEvent("_error",{logMessage:l});};
b.prototype.onDataRequested=function(){this._oLoadingProvider.createLoadingState(this._oDataProvider);};
b.prototype.onDataRequestComplete=function(){this.fireEvent("_dataReady");this._oLoadingProvider.setLoading(false);this._oLoadingProvider.removeHeaderPlaceholder(this);};
return b;});
sap.ui.predefine('sap/ui/integration/cards/ObjectContent',["sap/ui/integration/library","sap/ui/integration/cards/BaseContent","sap/m/library","sap/m/HBox","sap/m/VBox","sap/m/Text","sap/m/Title","sap/f/Avatar","sap/m/Link","sap/m/Label","sap/ui/core/ResizeHandler","sap/ui/layout/AlignedFlowLayout","sap/ui/dom/units/Rem","sap/ui/integration/util/BindingHelper"],function(l,B,L,H,V,T,a,A,b,c,R,d,e,f){"use strict";var g=l.AreaType;var h=L.AvatarSize;
var O=B.extend("sap.ui.integration.cards.ObjectContent",{renderer:{}});
O.prototype._getRootContainer=function(){if(this._bIsBeingDestroyed){return null;}var o=this.getAggregation("_content");if(!o){o=new d();this.setAggregation("_content",o);}this._sResizeListenerId=R.register(o,this.onAlignedFlowLayoutResize.bind(this));o.addEventDelegate({"onAfterRendering":function(){this.getContent().forEach(function(E){if(!E.getVisible()){document.getElementById("sap-ui-invisible-"+E.getId()).parentElement.classList.add("sapFCardInvisibleContent");}});}},o);return o;};
O.prototype.onAlignedFlowLayoutResize=function(E){if(E&&(E.size.width===E.oldSize.width)&&!E.control){return;}var C=E.control,m=C.getMinItemWidth(),n=C.getContent().length,M;if(m.lastIndexOf("rem")!==-1){M=e.toPx(m);}else if(m.lastIndexOf("px")!==-1){M=parseFloat(m);}var i=Math.floor(E.size.width/M);if(i>n){i=n;}if(this._iColsOld===i){return;}this._iColsOld=i;var j=i-1,r=Math.ceil(n/i);C.getContent().forEach(function(I,k){I.addStyleClass("sapFCardObjectSpaceBetweenGroup");if(j===k&&j<n){I.removeStyleClass("sapFCardObjectSpaceBetweenGroup");j+=i;}if(k+1>(r-1)*i){I.addStyleClass("sapFCardObjectGroupLastInColumn");}else{I.removeStyleClass("sapFCardObjectGroupLastInColumn");}});};
O.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId="";}};
O.prototype.setConfiguration=function(C){B.prototype.setConfiguration.apply(this,arguments);if(!C){return this;}if(C.groups){this._addGroups(C);}return this;};
O.prototype._addGroups=function(C){var o=this._getRootContainer();var G=C.groups||[];G.forEach(function(i){var j=new V({visible:i.visible}).addStyleClass("sapFCardObjectGroup");var t=new a({text:i.title}).addStyleClass("sapFCardObjectItemTitle");j.addItem(t);i.items.forEach(function(I){var k,v=I.label,m=I.value,n,p,q=[];if(v){v=f.formattedProperty(v,function(x){return x&&x[x.length-1]===":"?x:x+=":";});n=new c({text:v,visible:I.visible}).addStyleClass("sapFCardObjectItemLabel");}if(m){switch(I.type){case'link':k=new b({href:I.url||m,text:m,target:I.target||'_blank',visible:I.visible});break;case'email':if(I.value){q.push(I.value);}if(I.emailSubject){q.push(I.emailSubject);}p=f.formattedProperty(q,function(x,E){if(E){return"mailto:"+x+"?subject="+E;}else{return"mailto:"+x;}});k=new b({href:p,text:m,visible:I.visible});break;case'phone':p=f.formattedProperty(m,function(x){return"tel:"+x;});k=new b({href:p,text:m,visible:I.visible});break;default:k=new T({text:m,visible:I.visible});break;}}if(k){k.addStyleClass("sapFCardObjectItemText");}if(I.icon){var s=f.formattedProperty(I.icon.src,function(x){return this._oIconFormatter.formatSrc(x,this._sAppId);}.bind(this));var r=new A({displaySize:I.icon.size||h.XS,src:s,initials:I.icon.text,displayShape:I.icon.shape,tooltip:I.icon.alt}).addStyleClass("sapFCardObjectItemAvatar sapFCardObjectItemLabel sapFCardIcon");var u=new V({items:[n,k]});var w=new H({visible:I.visible,items:[r,u]});j.addItem(w);}else{j.addItem(n);j.addItem(k);}},this);o.addContent(j);},this);this._oActions.setAreaType(g.Content);this._oActions.attach(C,this);};
return O;});
sap.ui.predefine('sap/ui/integration/cards/TableContent',["./BaseListContent","./TableContentRenderer","sap/ui/integration/library","sap/m/Table","sap/m/Column","sap/m/ColumnListItem","sap/m/Text","sap/m/Link","sap/m/ProgressIndicator","sap/m/ObjectIdentifier","sap/m/ObjectStatus","sap/m/Avatar","sap/ui/core/library","sap/m/library","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/BindingHelper"],function(B,T,l,R,C,a,b,L,P,O,c,A,d,m,e,f){"use strict";var g=m.AvatarSize;var V=d.VerticalAlign;var h=m.ListSeparators;var i=m.ListType;var k=l.AreaType;
var n=B.extend("sap.ui.integration.cards.TableContent",{renderer:T});
n.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oItemTemplate){this._oItemTemplate.destroy();this._oItemTemplate=null;}};
n.prototype._getTable=function(){if(this._bIsBeingDestroyed){return null;}var t=this.getAggregation("_content");if(!t){t=new R({id:this.getId()+"-Table",showSeparators:h.None});this.setAggregation("_content",t);}return t;};
n.prototype.setConfiguration=function(o){B.prototype.setConfiguration.apply(this,arguments);if(!o){return this;}if(o.rows&&o.columns){this._setStaticColumns(o.rows,o.columns);return this;}if(o.row&&o.row.columns){this._setColumns(o.row);}return this;};
n.prototype.onDataChanged=function(){this._checkHiddenNavigationItems(this.getConfiguration().row);};
n.prototype._setColumns=function(r){var j=[],t=this._getTable(),o=r.columns;o.forEach(function(q){t.addColumn(new C({header:new b({text:q.title}),width:q.width,hAlign:q.hAlign,visible:q.visible}));j.push(this._createCell(q));}.bind(this));this._oItemTemplate=new a({cells:j,vAlign:V.Middle});this._oActions.setAreaType(k.ContentItem);this._oActions.attach(r,this);var p={template:this._oItemTemplate};this._filterHiddenNavigationItems(r,p);this._bindAggregation("items",t,p);};
n.prototype._setStaticColumns=function(r,o){var t=this._getTable();o.forEach(function(j){t.addColumn(new C({header:new b({text:j.title}),width:j.width,hAlign:j.hAlign}));});r.forEach(function(p){var I=new a({vAlign:V.Middle});if(p.cells&&Array.isArray(p.cells)){for(var j=0;j<p.cells.length;j++){I.addCell(this._createCell(p.cells[j]));}}if(p.actions&&Array.isArray(p.actions)){var q=p.actions[0];if(q.type===i.Navigation){I.setType(i.Navigation);}if(q.url){I.attachPress(function(){window.open(q.url,q.target||"_blank");});}}t.addItem(I);}.bind(this));this.fireEvent("_actionContentReady");};
n.prototype._createCell=function(o){if(o.url){return new L({text:o.value,href:o.url,target:o.target||"_blank"});}if(o.identifier){var t;if(o.identifier.url){t=f.formattedProperty(o.identifier.url,function(v){if(typeof v==="string"){return true;}return false;});}var I=new O({title:o.value,titleActive:t});if(o.identifier.url){I.attachTitlePress(function(E){var S=E.getSource(),j=S.getBindingContext(),M=S.getModel(),p,u,q;if(j){p=j.getPath();}u=e.resolveValue(o.identifier.url,M,p);q=e.resolveValue(o.identifier.target,M,p);if(u){window.open(u,q||"_blank");}});}return I;}if(o.state){return new c({text:o.value,state:o.state});}if(o.value){return new b({text:o.value});}if(o.icon){var s=f.formattedProperty(o.icon.src,function(v){return this._oIconFormatter.formatSrc(v,this._sAppId);}.bind(this));return new A({src:s,displayShape:o.icon.shape,displaySize:o.icon.size||g.XS,tooltip:o.icon.alt,initials:o.icon.text}).addStyleClass("sapFCardIcon");}if(o.progressIndicator){return new P({percentValue:o.progressIndicator.percent,displayValue:o.progressIndicator.text,state:o.progressIndicator.state});}};
n.prototype.getInnerList=function(){return this._getTable();};
return n;});
sap.ui.predefine('sap/ui/integration/cards/TableContentRenderer',["./BaseContentRenderer"],function(B){"use strict";
var T=B.extend("sap.ui.integration.cards.TableContentRenderer");
T.getMinHeight=function(c,C){if(!c){return this.DEFAULT_MIN_HEIGHT;}var i=this.isCompact(C),a=parseInt(c.maxItems)||0,r=i?2:2.75,t=i?2:2.75;return(a*r+t)+"rem";};
return T;});
sap.ui.predefine('sap/ui/integration/cards/TimelineContent',["./BaseListContent","./TimelineContentRenderer","sap/ui/core/Core","sap/ui/integration/util/BindingHelper"],function(B,T,C,a){"use strict";var b,c;
var d=B.extend("sap.ui.integration.cards.TimelineContent",{renderer:T});
d.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oTimeLineItemTemplate){this._oTimeLineItemTemplate.destroy();this._oTimeLineItemTemplate=null;}};
d.prototype.loadDependencies=function(o){return new Promise(function(r,e){C.loadLibrary("sap.suite.ui.commons",{async:true}).then(function(){sap.ui.require(["sap/suite/ui/commons/Timeline","sap/suite/ui/commons/TimelineItem"],function(_,f){b=_;c=f;r();},function(E){e(E);});}).catch(function(){e("Timeline content type is not available with this distribution.");});});};
d.prototype._getTimeline=function(){var t=this.getAggregation("_content");if(this._bIsBeingDestroyed){return null;}if(!t){t=new b({id:this.getId()+"-Timeline",showHeaderBar:false,enableScroll:false});this.setAggregation("_content",t);}return t;};
d.prototype.setConfiguration=function(o){B.prototype.setConfiguration.apply(this,arguments);if(!o){return this;}if(o.items){this._setStaticItems(o.items);return this;}if(o.item){this._setItem(o.item);}return this;};
d.prototype.onDataChanged=function(){this._checkHiddenNavigationItems(this.getConfiguration().item);};
d.prototype._setItem=function(i){var s={userNameClickable:false,title:i.title&&i.title.value,text:i.description&&i.description.value,dateTime:i.dateTime&&i.dateTime.value,userName:i.owner&&i.owner.value,icon:i.icon&&i.icon.src};if(i.ownerImage&&i.ownerImage.value){s.userPicture=a.formattedProperty(i.ownerImage.value,function(v){return this._oIconFormatter.formatSrc(v,this._sAppId);}.bind(this));}this._oTimeLineItemTemplate=new c(s);this._oActions.attach(i,this);var o={template:this._oTimeLineItemTemplate};this._filterHiddenNavigationItems(i,o);this._bindAggregation("content",this._getTimeline(),o);return this;};
d.prototype._setStaticItems=function(i){var t=this._getTimeline(),o;i.forEach(function(I){o=new c({title:I.title,text:I.description,userPicture:I.ownerImage,dateTime:I.dateTime,userName:I.owner,icon:I.icon});t.addContent(o);});};
d.prototype.getInnerList=function(){return this._getTimeline();};
return d;});
sap.ui.predefine('sap/ui/integration/cards/TimelineContentRenderer',["./BaseContentRenderer"],function(B){"use strict";
var T=B.extend("sap.ui.integration.cards.TimelineContentRenderer");
T.getMinHeight=function(c,C){if(!c){return this.DEFAULT_MIN_HEIGHT;}if(!c.maxItems){return this.DEFAULT_MIN_HEIGHT;}var i=this.isCompact(C),a=parseInt(c.maxItems),I=i?4:5;return(a*I)+"rem";};
return T;});
sap.ui.predefine('sap/ui/integration/cards/adaptivecards/elements/UI5InputChoiceSet',["sap/ui/integration/thirdparty/adaptivecards"],function(A){"use strict";
function U(){A.ChoiceSetInput.apply(this,arguments);}
U.prototype=Object.create(A.ChoiceSetInput.prototype);
U.prototype.internalRender=function(){if(!this.isMultiSelect){if(this.isCompact){this._selectElement=document.createElement("ui5-select");this._selectElement.id=this.id;this._selectElement.addEventListener("change",function(){this.valueChanged();}.bind(this));for(var i=0;i<this.choices.length;i++){var o=document.createElement("ui5-option");o.value=this.choices[i].value;o.innerHTML=this.choices[i].title;if(this.choices[i].value===this.defaultValue){o.selected=true;}this._selectElement.appendChild(o);}return this._selectElement;}var r=document.createElement("div");r.classList.add("sapFCardAdaptiveContentChoiceSetWrapper");r.id=this.id;r.addEventListener("select",function(){this.valueChanged();}.bind(this));this._toggleInputs=[];for(var j=0;j<this.choices.length;j++){var R=document.createElement("ui5-radiobutton");R.value=this.choices[j].value;R.text=this.choices[j].title;R.name=this.id;R.wrap=this.wrap;if(this.choices[j].value===this.defaultValue){R.selected=true;}this._toggleInputs.push(R);r.appendChild(R);}return r;}var d=this.defaultValue?this.defaultValue.split(","):null;var c=document.createElement("div");c.classList.add("sapFCardAdaptiveContentChoiceSetWrapper");c.id=this.id;c.addEventListener("change",function(){this.valueChanged();}.bind(this));this._toggleInputs=[];for(var k=0;k<this.choices.length;k++){var C=document.createElement("ui5-checkbox");C.value=this.choices[k].value;C.text=this.choices[k].title;C.name=this.id;C.wrap=this.wrap;if(d&&d.indexOf(this.choices[k].value)>=0){C.checked=true;}this._toggleInputs.push(C);c.appendChild(C);}return c;};
Object.defineProperty(U.prototype,"value",{get:function value(){var i;if(!this.isMultiSelect){if(this.isCompact){return this._selectElement.selectedOption?this._selectElement.selectedOption.value:null;}else{if(!this._toggleInputs||this._toggleInputs.length===0){return null;}for(i=0;i<this._toggleInputs.length;i++){if(this._toggleInputs[i].selected){return this._toggleInputs[i].value;}}return null;}}else{if(!this._toggleInputs||this._toggleInputs.length===0){return null;}var r="";for(i=0;i<this._toggleInputs.length;i++){if(this._toggleInputs[i].checked){if(r!==""){r+=this.hostConfig.choiceSetInputValueSeparator;}r+=this._toggleInputs[i].value;}}return r===""?null:r;}}});return U;});
sap.ui.predefine('sap/ui/integration/cards/adaptivecards/elements/UI5InputDate',["sap/ui/integration/thirdparty/adaptivecards"],function(A){"use strict";
function U(){A.DateInput.apply(this,arguments);}
U.prototype=Object.create(A.DateInput.prototype);
U.prototype.internalRender=function(){this._dateInputElement=document.createElement("ui5-datepicker");this._dateInputElement.id=this.id;this._dateInputElement.placeholder=this.placeholder;this._dateInputElement.formatPattern="yyyy-MM-dd";this._dateInputElement.value=this.defaultValue||"";this._dateInputElement.minDate=this.min||"";this._dateInputElement.maxDate=this.max||"";this._dateInputElement.addEventListener("change",function(){this.valueChanged();}.bind(this));return this._dateInputElement;};
return U;});
sap.ui.predefine('sap/ui/integration/cards/adaptivecards/elements/UI5InputNumber',["sap/ui/integration/thirdparty/adaptivecards"],function(A){"use strict";
function U(){A.NumberInput.apply(this,arguments);}
U.prototype=Object.create(A.NumberInput.prototype);
U.prototype.internalRender=function(){this._numberInputElement=document.createElement("ui5-input");this._numberInputElement.type="Number";this._numberInputElement.id=this.id;this._numberInputElement.placeholder=this.placeholder||"";this._numberInputElement.value=this.defaultValue||"";this._numberInputElement.addEventListener("change",function(e){if(e.target.value>this._max){e.target.value=this._max;}if(e.target.value<this._min){e.target.value=this._min;}this.valueChanged();}.bind(this));return this._numberInputElement;};
return U;});
sap.ui.predefine('sap/ui/integration/cards/adaptivecards/elements/UI5InputText',["sap/ui/integration/thirdparty/adaptivecards"],function(A){"use strict";
function U(){A.TextInput.apply(this,arguments);}
U.prototype=Object.create(A.TextInput.prototype);
U.prototype.internalRender=function(){if(this.isMultiline){var t=document.createElement("ui5-textarea");t.id=this.id;t.placeholder=this.placeholder||"";t.value=this.defaultValue||"";t.maxlength=this.maxLength||null;t.addEventListener("change",function(){this.valueChanged();}.bind(this));return t;}var i=document.createElement("ui5-input");switch(this.style){case 1:i.type="Tel";break;case 2:i.type="URL";break;case 3:i.type="Email";break;default:i.type="Text";}i.id=this.id;i.placeholder=this.placeholder||"";i.value=this.defaultValue||"";i.maxlength=this.maxLength||null;i.addEventListener("change",function(){this.valueChanged();}.bind(this));return i;};
return U;});
sap.ui.predefine('sap/ui/integration/cards/adaptivecards/elements/UI5InputTime',["sap/ui/integration/thirdparty/adaptivecards","sap/ui/core/format/DateFormat"],function(A,D){"use strict";
function U(){A.TimeInput.apply(this,arguments);}
var V={None:"None",Error:"Error"};var t="HH:mm";U.prototype=Object.create(A.TimeInput.prototype);
U.prototype.internalRender=function(){var w="ui5-timepicker";this._timeInputElement=document.createElement(w);this._timeInputElement.id=this.id;this._timeInputElement.value=this.defaultValue||"";this._timeInputElement.formatPattern=t;this._handleMinMaxProps();this._validateInput(this.value);this._timeInputElement.addEventListener("change",function(e){this._validateInput(e.target.value);this.valueChanged();}.bind(this));return this._timeInputElement;};
U.prototype._validateInputRange=function(v){var a,i,b;if(!this._isMinValid&&!this._isMaxValid){this._setValueState(V.None);return;}a=v.split(":");i=a[0];b=a[1];if(this._isMinValid&&i<this._iMinHour||(i===this._iMinHour&&b<this._iMinMinute)){this._setValueState(V.Error);return;}if(this._isMaxValid&&i>this._iMaxHour||(i===this._iMaxHour&&b>this._iMaxMinute)){this._setValueState(V.Error);return;}this._setValueState(V.None);};
U.prototype._validateInput=function(v){if(v===""){this._setValueState(V.None);return;}this._isValidTime(v)?this._validateInputRange(v):this._setValueState(V.Error);};
U.prototype._handleMinMaxProps=function(){this._isMinValid=this._min&&this._isValidTime(this._min);this._isMaxValid=this._max&&this._isValidTime(this._max);if(this._isMinValid){this._aMinValue=this._min.split(":");this._iMinHour=Number(this._aMinValue[0]);this._iMinMinute=Number(this._aMinValue[1]);}if(this._isMaxValid){this._aMaxValue=this._max.split(":");this._iMaxHour=Number(this._aMaxValue[0]);this._iMaxMinute=Number(this._aMaxValue[1]);}if(!this._isMinValid||!this._isMaxValid){return;}if(this._iMinHour>this._iMaxHour||(this._iMinHour===this._iMaxHour&&this._iMinMinute>this._iMaxMinute||this._iMinMinute===this._iMaxMinute)){this._setValueState(V.Error);}else{this._setValueState(V.None);}};
U.prototype._setValueState=function(T){this._timeInputElement.valueState=T;};
U.prototype._setValueStateMessage=function(m){this._timeInputElement.valueStateMessage=m;};
U.prototype._isValidTime=function(v){var T=D.getTimeInstance({pattern:t});return v&&T.parse(v);};
return U;});
sap.ui.predefine('sap/ui/integration/cards/adaptivecards/elements/UI5InputToggle',["sap/ui/integration/thirdparty/adaptivecards"],function(A){"use strict";
function U(){A.ToggleInput.apply(this,arguments);}
U.prototype=Object.create(A.ToggleInput.prototype);
U.prototype.internalRender=function(){this._checkboxInputElement=document.createElement("ui5-checkbox");this._checkboxInputElement.id=this.id;this._checkboxInputElement.text=this.title||"";this._checkboxInputElement.wrap=this.wrap;this._checkboxInputElement.checked=false;if(this.defaultValue===this.valueOn){this._checkboxInputElement.checked=true;}this._checkboxInputElement.addEventListener("change",function(){this.valueChanged();}.bind(this));return this._checkboxInputElement;};
return U;});
sap.ui.predefine('sap/ui/integration/cards/adaptivecards/elements/hostConfig',["sap/ui/core/theming/Parameters"],function(P){"use strict";return{"spacing":{"small":8,"default":16,"medium":32,"large":48,"extraLarge":48,"padding":16},"separator":{"lineThickness":1,"lineColor":P.get("sapUiToolbarSeparatorColor")},"supportsInteractivity":true,"fontTypes":{"default":{"fontFamily":P.get("sapUiFontFamily"),"fontSizes":{"small":12,"default":14,"medium":14,"large":16,"extraLarge":20}},"monospace":{}},"containerStyles":{"default":{"backgroundColor":"transparent","foregroundColors":{"default":{"default":P.get("sapUiBaseText"),"subtle":P.get("sapUiContentLabelColor")},"accent":{"default":P.get("sapUiInformativeText")},"attention":{"default":P.get("sapUiNegativeText")},"good":{"default":P.get("sapUiPositiveText")},"warning":{"default":P.get("sapUiCriticalText")}}},"emphasis":{"backgroundColor":P.get("sapUiNeutralBG"),"foregroundColors":{"default":{"default":P.get("sapUiBaseText")},"accent":{"default":P.get("sapUiInformativeText")},"attention":{"default":P.get("sapUiNegativeText")},"good":{"default":P.get("sapUiPositiveText")},"warning":{"default":P.get("sapUiCriticalText")}}},"accent":{"backgroundColor":P.get("sapUiInformationBG"),"foregroundColors":{"default":{"default":P.get("sapUiBaseText")},"accent":{"default":P.get("sapUiInformativeText")},"attention":{"default":P.get("sapUiNegativeText")},"good":{"default":P.get("sapUiPositiveText")},"warning":{"default":P.get("sapUiCriticalText")}}},"good":{"backgroundColor":P.get("sapUiSuccessBG"),"foregroundColors":{"default":{"default":P.get("sapUiBaseText")},"accent":{"default":P.get("sapUiInformativeText")},"attention":{"default":P.get("sapUiNegativeText")},"good":{"default":P.get("sapUiPositiveText")},"warning":{"default":P.get("sapUiCriticalText")}}},"attention":{"backgroundColor":P.get("sapUiErrorBG"),"foregroundColors":{"default":{"default":P.get("sapUiBaseText")},"accent":{"default":P.get("sapUiInformativeText")},"attention":{"default":P.get("sapUiNegativeText")},"good":{"default":P.get("sapUiPositiveText")},"warning":{"default":P.get("sapUiCriticalText")}}},"warning":{"backgroundColor":P.get("sapUiWarningBG"),"foregroundColors":{"default":{"default":P.get("sapUiBaseText")},"accent":{"default":P.get("sapUiInformativeText")},"attention":{"default":P.get("sapUiNegativeText")},"good":{"default":P.get("sapUiPositiveText")},"warning":{"default":P.get("sapUiCriticalText")}}}}};});
sap.ui.predefine('sap/ui/integration/cards/adaptivecards/overwrites/ActionRender',["sap/ui/integration/thirdparty/adaptivecards"],function(A){"use strict";return function(b){if(b===0){b="ac-pushButton";}var h=this.parent.hostConfig;var a=document.createElement("ui5-button");this.addCssClasses(a);a.setAttribute("aria-label",this.title);a.type="button";a.style.display="flex";a.style.alignItems="center";a.style.justifyContent="center";var c=!A.isNullOrEmpty(this.title);var t=document.createElement("div");t.style.overflow="hidden";t.style.textOverflow="ellipsis";if(!(h.actions.iconPlacement===A.ActionIconPlacement.AboveTitle||h.actions.allowTitleToWrap)){t.style.whiteSpace="nowrap";}if(c){t.innerText=this.title;}if(A.isNullOrEmpty(this.iconUrl)){a.classList.add("noIcon");a.appendChild(t);}else{var i=document.createElement("img");i.src=this.iconUrl;i.style.width=h.actions.iconSize+"px";i.style.height=h.actions.iconSize+"px";i.style.flex="0 0 auto";if(h.actions.iconPlacement===A.ActionIconPlacement.AboveTitle){a.classList.add("iconAbove");a.style.flexDirection="column";if(c){i.style.marginBottom="4px";}}else{a.classList.add("iconLeft");if(c){i.style.marginRight="4px";}}a.appendChild(i);a.appendChild(t);}this._renderedElement=a;};});
sap.ui.predefine('sap/ui/integration/controls/ActionsToolbar',["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/m/library","sap/m/Button","sap/m/ActionSheet","sap/ui/integration/util/CardActions","./ActionsToolbarRenderer"],function(q,C,l,B,A,a,b){"use strict";var c=l.ButtonType;
function s(o,p,v,e){return new Promise(function(r){var R;if(q.isFunction(v)){R=v(e);if(R instanceof Promise){R.then(function(f){o.setProperty(p,f);r();});return;}}else{R=v;}o.setProperty(p,R);r();});}
var d=C.extend("sap.ui.integration.controls.ActionsToolbar",{
metadata:{library:"sap.ui.integration",properties:{},aggregations:{_toolbar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}},
renderer:b
});
d.prototype._open=function(){this._refreshButtons().then(function(){this._oActionSheet.openBy(this._getToolbar());}.bind(this));};
d.prototype._createActionButton=function(h,o,m){return new B({icon:m.icon,text:m.text,tooltip:m.tooltip,type:m.buttonType,press:function(e){a.fireAction({card:o,host:h,action:m,parameters:m.parameters,source:e.getSource(),url:m.url});}});};
d.prototype._getToolbar=function(){var t=this.getAggregation('_toolbar');if(!t){t=new B({id:this.getId()+"-overflowButton",icon:'sap-icon://overflow',type:c.Transparent,press:function(e){this._open();}.bind(this)});this.setAggregation('_toolbar',t);}return t;};
d.prototype.initializeContent=function(h,o,e){var t=this,f,g=[],i=[];this._oCard=o;if(h){i=i.concat(h.getActions()||[]);}if(e){i=i.concat(e.getActions()||[]);}if(!i.length){return false;}this._aActions=i;i.forEach(function(j){f=t._createActionButton(h,o,j);g.push(f);});if(this._oActionSheet){this._oActionSheet.destroy();}this._oActionSheet=new A({buttons:g});this._refreshButtons().then(function(){var g=this._oActionSheet.getButtons(),v=g.filter(function(j){return j.getVisible();});this._getToolbar().setVisible(!!v.length);}.bind(this));return true;};
d.prototype._refreshButtons=function(){var e=this._aActions,o=this._oCard,f=this._oActionSheet.getButtons(),m,g,i,p=[];for(i=0;i<e.length;i++){m=e[i];g=f[i];p.push(s(g,'enabled',m.enabled,o));p.push(s(g,'visible',m.visible,o));}return Promise.all(p);};
d.prototype.exit=function(){this._oCard=null;this._aActions=null;if(this._oActionSheet){this._oActionSheet.destroy();this._oActionSheet=null;}};
return d;});
sap.ui.predefine('sap/ui/integration/controls/ActionsToolbarRenderer',[],function(){"use strict";var A={apiVersion:2};
A.render=function(r,a){r.openStart("div",a).class("sapUIActionsToolbar").openEnd();r.renderControl(a._getToolbar());r.close("div");};
return A;},true);
sap.ui.predefine('sap/ui/integration/controls/ListContentItem',["./ListContentItemRenderer","sap/m/Avatar","sap/m/AvatarShape","sap/m/AvatarSize","sap/m/StandardListItem"],function(L,A,a,b,S){"use strict";
var c=S.extend("sap.ui.integration.controls.ListContentItem",{
metadata:{library:"sap.ui.integration",properties:{iconAlt:{type:"string",defaultValue:""},iconDisplayShape:{type:"sap.m.AvatarShape",defaultValue:a.Square},iconInitials:{type:"string",defaultValue:""},iconSize:{type:"sap.m.AvatarSize",defaultValue:b.XS}},aggregations:{microchart:{type:"sap.ui.integration.controls.Microchart",multiple:false},_avatar:{type:"sap.m.Avatar",multiple:false,visibility:"hidden"}}},
renderer:L
});
c.prototype._getAvatar=function(){var o=this.getAggregation("_avatar");if(!o){o=new A().addStyleClass("sapFCardIcon");this.setAggregation("_avatar",o);}o.setSrc(this.getIcon());o.setDisplayShape(this.getIconDisplayShape());o.setTooltip(this.getIconAlt());o.setInitials(this.getIconInitials());o.setDisplaySize(this.getIconSize());return o;};
return c;});
sap.ui.predefine('sap/ui/integration/controls/ListContentItemRenderer',["sap/ui/core/Renderer","sap/m/StandardListItemRenderer"],function(R,S){"use strict";var L=R.extend(S);L.apiVersion=2;
L.renderLIAttributes=function(r,l){S.renderLIAttributes.apply(this,arguments);r.class("sapUiIntegrationListContentItem");if(l.getMicrochart()){r.class("sapUiIntegrationListContentItemWithChart");}};
L.renderLIContent=function(r,l){var i=l.getInfo(),t=l.getTitle(),d=l.getDescription(),a=l.getAdaptTitleSize(),s=!t&&i;if(l.getIcon()||l.getIconInitials()){r.renderControl(l._getAvatar());}r.openStart("div").class("sapMSLIDiv");if((!d&&a&&i)||s){r.class("sapMSLIInfoMiddle");}r.openEnd();this.renderTitleWrapper(r,l);if(t&&d){this.renderDescription(r,l);}if(s&&!l.getWrapping()){this.renderInfo(r,l);}if(l.getMicrochart()){r.renderControl(l.getMicrochart());}r.close("div");};
return L;},true);
sap.ui.predefine('sap/ui/integration/controls/Microchart',["sap/m/library","sap/ui/core/Control","sap/ui/core/Core"],function(l,C,a){"use strict";var B,b,S,c;var V=l.ValueColor;
var M=C.extend("sap.ui.integration.controls.Microchart",{
metadata:{library:"sap.ui.integration",properties:{displayValue:{type:"string"},valueColor:{type:"sap.m.ValueColor",defaultValue:V.Neutral}},aggregations:{chart:{type:"sap.ui.core.Control",multiple:false}}},
renderer:{apiVersion:2,render:function(r,m){var v="sapUiIntegrationMicrochartValue"+m.getValueColor();r.openStart("div",m).class("sapUiIntegrationMicrochartChartWrapper").openEnd();r.openStart("div").class("sapUiIntegrationMicrochartChart").openEnd().renderControl(m.getChart()).close("div");r.openStart("div").class("sapMSLIInfo").class(v).openEnd().text(m.getDisplayValue()).close("div");r.close("div");}}
});
M.loadDependencies=function(){return new Promise(function(r,d){a.loadLibrary("sap.suite.ui.microchart",{async:true}).then(function(){sap.ui.require(["sap/suite/ui/microchart/BulletMicroChart","sap/suite/ui/microchart/BulletMicroChartData","sap/suite/ui/microchart/StackedBarMicroChart","sap/suite/ui/microchart/StackedBarMicroChartBar"],function(_,e,f,g){B=_;b=e;S=f;c=g;r();},function(e){d(e);});}).catch(function(){d("The usage of Microcharts is not available with this distribution.");});});};
M.create=function(o){var m,d;if(o.type==="Bullet"){var t=[];if(o.thresholds){t=o.thresholds.map(function(T){return new b({value:T.value,color:T.color});});}d=new B({size:"Responsive",minValue:o.minValue,maxValue:o.maxValue,targetValue:o.target,showTargetValue:!!o.target,scaleColor:"Light",scale:o.scale,actual:new b({value:o.value,color:o.color}),thresholds:t});m=new M({valueColor:o.color,displayValue:o.displayValue,chart:d});}if(o.type==="StackedBar"){var e=o.bars.map(function(f){return new c({value:f.value,displayValue:f.displayValue,valueColor:f.color});});d=new S({size:"Responsive",bars:e,maxValue:o.maxValue});m=new M({displayValue:o.displayValue,chart:d});}return m;};
return M;});
sap.ui.predefine('sap/ui/integration/controls/MicrochartLegend',["./MicrochartLegendRenderer","sap/m/Text","sap/ui/core/Control","sap/ui/integration/util/BindingHelper"],function(M,T,C,B){"use strict";
var a=C.extend("sap.ui.integration.controls.MicrochartLegend",{
metadata:{library:"sap.ui.integration",aggregations:{_titles:{type:"sap.m.Text",multiple:true,visibility:"hidden"}},associations:{chart:{type:"sap.ui.core.Control",multiple:false}}},
renderer:M
});
a.prototype.onAfterRendering=function(){this._equalizeWidths();};
a.prototype._equalizeWidths=function(){var $=this.$().children(".sapUiIntegrationMicrochartLegendItem"),m=0;$.css("width","");$.each(function(){var c=this.getBoundingClientRect().width;if(c>m){m=c;}});$.css("min-width",m+"px");};
a.prototype.initItemsTitles=function(b,p){this.destroyAggregation("_titles");b.forEach(function(c,i){var o=B.prependRelativePaths(c.legendTitle,p+"/"+i);var t=new T({text:o});t.addEventDelegate({onAfterRendering:this._equalizeWidths},this);this.addAggregation("_titles",t);}.bind(this));};
return a;});
sap.ui.predefine('sap/ui/integration/controls/MicrochartLegendRenderer',["sap/m/library","sap/ui/core/Core","sap/ui/core/theming/Parameters"],function(l,C,P){"use strict";var V=l.ValueColor;var M={apiVersion:2};
M.render=function(r,m){var c=C.byId(m.getChart()),L=[],t=m.getAggregation("_titles");if(c){L=c._calculateChartData().map(function(d){return d.color;});}r.openStart("div",m).class("sapUiIntegrationMicrochartLegend").openEnd();L.forEach(function(s,i){r.openStart("div").class("sapUiIntegrationMicrochartLegendItem").openEnd();r.openStart("div");M.addColor(r,s);r.openEnd().close("div");r.renderControl(t[i]);r.close("div");});r.close("div");};
M.addColor=function(r,c){if(V[c]){r.class("sapUiIntegrationMicrochartLegendItem"+c);}else{var s=P.get(c)||c;r.style("background",s);}};
return M;},true);
sap.ui.predefine('sap/ui/integration/customElements/CustomElementBase',["sap/base/Log","sap/ui/integration/util/Utils","sap/base/strings/hyphenate","sap/base/strings/camelize","sap/ui/integration/thirdparty/customElements","sap/ui/integration/thirdparty/customEvent"],function(L,U,h,c,a,b){"use strict";
function C(){if(this.constructor===C){throw new TypeError('Abstract class "CustomElementBase" cannot be instantiated directly.');}return Reflect.construct(HTMLElement,[],this.constructor);}
C.prototype=Object.create(HTMLElement.prototype);C.prototype.constructor=C;
C.prototype.connectedCallback=function(){this._init();this._upgradeAllProperties();this._oControlInstance.placeAt(this.firstElementChild);this._attachEventListeners();};
C.prototype.disconnectedCallback=function(){if(this._oControlInstance){this._oControlInstance.destroy();delete this._oControlInstance;}if(this.firstElementChild){this.removeChild(this.firstElementChild);}};
C.prototype.attributeChangedCallback=function(A,o,n){this._init();var s=c(A);if(U.isJson(n)){n=JSON.parse(n);}if(this._mAllProperties[s]){this._mAllProperties[s].set(this._oControlInstance,n);}else if(this._mAllAssociations[s]){var e=document.getElementById(n);if(e instanceof C){n=document.getElementById(n)._getControl();}this._mAllAssociations[s].set(this._oControlInstance,n);}};
C.prototype._init=function(){if(!this._oControlInstance){this._oControlInstance=new this._ControlClass();}if(!this.firstElementChild){var u=document.createElement("div");this.appendChild(u);}};
C.prototype._getControl=function(){this._init();return this._oControlInstance;};
C.prototype._attachEventListeners=function(){Object.keys(this._oMetadata.getEvents()).map(function(e){this._oControlInstance.attachEvent(e,function(E){this.dispatchEvent(new CustomEvent(e,{detail:E,bubbles:true}));},this);}.bind(this));};
C.prototype._upgradeAllProperties=function(){this._aAllProperties.forEach(this._upgradeProperty.bind(this));};
C.prototype._upgradeProperty=function(p){if(this[p]){var v=this[p];delete this[p];this[p]=v;}};
C.generateAccessors=function(p,P){P.forEach(function(s){Object.defineProperty(p,s,{get:function(){return this.getAttribute(h(s));},set:function(v){if(typeof v==="object"){v=JSON.stringify(v);}return this.setAttribute(h(s),v);}});});};
C.define=function(s,d,D){C.awaitDependencies(D).then(function(){window.customElements.define(s,d);});};
C.awaitDependencies=function(d){var p=d.map(function(s){return window.customElements.whenDefined(s);});return Promise.all(p);};
C.extend=function(d,s){function e(){return C.apply(this,arguments);}e.prototype=Object.create(C.prototype);e.prototype.constructor=e;var p=e.prototype,k="";p._ControlClass=d;p._oMetadata=d.getMetadata();p._mAllAssociations=p._oMetadata.getAllAssociations();p._mAllProperties=p._oMetadata.getAllProperties();p._aAllProperties=[];if(s&&s.customProperties){p._mAllProperties=Object.assign(p._mAllProperties,s.customProperties);}for(k in p._mAllProperties){if(s&&s.privateProperties&&s.privateProperties.indexOf(k)!==-1){continue;}p._aAllProperties.push(k);}for(k in p._mAllAssociations){p._aAllProperties.push(k);}Object.defineProperty(e,"observedAttributes",{get:function(){var A=p._aAllProperties.map(h);return A;}});C.generateAccessors(p,p._aAllProperties);return e;};
return C;});
sap.ui.predefine('sap/ui/integration/formatters/DateTimeFormatter',["sap/ui/core/format/DateFormat","sap/ui/core/date/UniversalDate","sap/ui/integration/util/Utils"],function(D,U,a){"use strict";var d={dateTime:function(v,f,l){var A=a.processFormatArguments(f,l),o=D.getDateTimeInstance(A.formatOptions,A.locale),p=a.parseJsonDateTime(v);var u=new U(p);var F=o.format(u);return F;},date:function(v,f,l){return d.dateTime.apply(this,arguments);}};return d;});
sap.ui.predefine('sap/ui/integration/formatters/IconFormatter',["sap/ui/base/Object","sap/ui/core/IconPool"],function(B,I){"use strict";
var a=B.extend("sap.ui.integration.util.Destinations",{constructor:function(d){B.call(this);this._oDestinations=d;}});
a.prototype.formatSrc=function(u,A){var i=0;if(!u||!A){return u;}if(u.startsWith("data:")){return u;}if(this._oDestinations.hasDestination(u)){return this._oDestinations.processString(u);}if(I.isIconURI(u)||u.startsWith("http://")||u.startsWith("https://")||u.startsWith("//")){return u;}if(u.startsWith("..")){i=2;}else if(u.startsWith(".")){i=1;}return sap.ui.require.toUrl(A.replace(/\./g,"/")+u.slice(i,u.length));};
return a;});
sap.ui.predefine('sap/ui/integration/formatters/NumberFormatter',["sap/ui/core/format/NumberFormat","sap/ui/integration/util/Utils"],function(N,U){"use strict";var n={currency:function(c,C,f,l){var s=U.processFormatArguments(f,l),o=N.getCurrencyInstance(s.formatOptions,s.locale);return o.format(c,C);},"float":function(f,F,l){var s=U.processFormatArguments(F,l),o=N.getFloatInstance(s.formatOptions,s.locale);return o.format(f);},integer:function(i,f,l){var s=U.processFormatArguments(f,l),I=N.getIntegerInstance(s.formatOptions,s.locale);return I.format(i);},percent:function(p,f,l){var s=U.processFormatArguments(f,l),P=N.getPercentInstance(s.formatOptions,s.locale);return P.format(p);},unit:function(u,s,f,l){var S=U.processFormatArguments(f,l),o=N.getUnitInstance(S.formatOptions,S.locale);return o.format(u,s);}};return n;});
sap.ui.predefine('sap/ui/integration/host/HostConfiguration',['sap/ui/core/Control',"sap/ui/integration/host/HostConfigurationCompiler"],function(C,H){"use strict";
var a=C.extend("sap.ui.integration.host.HostConfiguration",{
metadata:{library:"sap.ui.integration",properties:{config:{type:"any"},css:{type:"string"}},events:{cssChanged:{}}},
renderer:function(r,c){r.write("<style ");r.writeElementData(c);r.write(">");r.write(c._getCssText()||"");r.write("</style>");}
});
a.prototype.setConfig=function(v,s){this._sCssText=null;return this.setProperty("config",v,s);};
a.prototype.setCss=function(v,s){this._sCssText=null;return this.setProperty("css",v,s);};
a.prototype.onBeforeRendering=function(){if(!this._sCssText){if(this.getCss()){this._applyCss();}else{this._applyConfig();}}};
a.prototype._applyCss=function(){var c=this.getCss();H.loadResource(c,"text").then(function(s){this._sCssText=s;this.invalidate();}.bind(this)).catch(function(){});};
a.prototype._applyConfig=function(){var v=this.getConfig();if(typeof v==="string"){H.loadResource(v,"json").then(function(v){this._oConfig=v;this.invalidate();}.bind(this)).catch(function(){});}else if(typeof v==="object"&&!Array.isArray(v)){this._oConfig=v;this.invalidate();}};
a.prototype._getCssText=function(){var c=this._oConfig;if(!c&&!this.getCss()){return"";}if(this._sCssText){return this._sCssText;}var s=this.getId().replace(/-/g,"_").replace(/\./g,"_").replace(/\,/g,"_");this._sCssText=H.generateCssText(this._oConfig,s);this.fireCssChanged({cssText:this._sCssText});return this._sCssText;};
a.prototype.generateJSONSettings=function(t){return H.generateJSONSettings(this._oConfig,t);};
return a;});
sap.ui.predefine('sap/ui/integration/host/HostConfigurationCompiler',["sap/ui/thirdparty/less","sap/base/Log","jquery.sap.global"],function(L,a,q){"use strict";var p=q.sap.loadResource("sap/ui/integration/host/HostConfigurationMap.json",{dataType:"json"}),l=q.sap.loadResource("sap/ui/integration/host/HostConfiguration.less",{dataType:"text"});
function b(u,t){return new Promise(function(r,e){q.ajax({url:u,async:true,dataType:t,success:function(j){r(j);},error:function(){e();}});});}
function _(n,P){if(!P){return n;}var e=P.split("/"),i=0;if(!e[0]){n=n;i++;}while(n&&e[i]){n=n[e[i]];i++;}return n;}
function g(C,s){var m=p.less,P=[];for(var n in m){var M=m[n],v=_(C,M.path),u=M.unit;if(v){P.push(n+":"+v+(u?u:""));}else{P.push(n+": /*null*/");}}var r=l.replace(/\#hostConfigName/g,"."+s);r=r.replace(/\/\* HOSTCONFIG PARAMETERS \*\//,P.join(";\n")+";");var o=new L.Parser(),S="";o.parse(r,function(e,R){try{S=R.toCSS();}catch(f){S=" ";}});return S;}
function c(C,N){function e(C,v){var r=null;if(v.path){r=_(C,v.path);if(v.unit){v.unit=r+v.unit;}}else if(v.value){r=v.value;}else if(Array.isArray(v)){r=[];for(var i=0;i<v.length;i++){r.push(e(C,v[i]));}}return r;}var m=p[N],s={};for(var n in m){var M=m[n],o=n.split("/"),f=s;if(M){for(var i=0;i<o.length-1;i++){if(f[o[i]]===undefined){f[o[i]]={};}f=f[o[i]];}f[o[o.length-1]]=e(C,M);}}return s;}
function d(C,o){return b(C,"json").then(function(o){return g(o,o);});}
return{loadResource:b,generateCssText:g,generateCssTextAsync:d,generateJSONSettings:c};});
sap.ui.predefine('sap/ui/integration/library',["sap/ui/base/DataType","sap/ui/Global","sap/ui/core/library","sap/m/library","sap/f/library"],function(D){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.integration",version:"1.82.2",dependencies:["sap.ui.core","sap.f","sap.m"],types:["sap.ui.integration.CardActionType","sap.ui.integration.CardDataMode","sap.ui.integration.CardMenuAction"],controls:["sap.ui.integration.widgets.Card","sap.ui.integration.cards.Header","sap.ui.integration.cards.NumericHeader","sap.ui.integration.controls.ListContentItem","sap.ui.integration.host.HostConfiguration"],elements:["sap.ui.integration.Host"],customElements:{"card":"sap/ui/integration/customElements/CustomElementCard","host-configuration":"sap/ui/integration/customElements/CustomElementHostConfiguration"}});var t=sap.ui.integration;t.CardActionType={Navigation:"Navigation",Submit:"Submit",Custom:'Custom'};t.CardDataMode={Active:"Active",Inactive:"Inactive"};t.AreaType={None:'None',ContentItem:'ContentItem',Content:'Content',Header:'Header'};t.CardMenuAction=D.createType("sap.ui.integration.CardMenuAction",{isValid:function(v){var p=["type","text","icon","tooltip","buttonType","enabled","visible","action","parameters","target","url"];return Object.keys(v).every(function(k){return p.indexOf(k)!==-1;});}},"object");return t;});
sap.ui.predefine('sap/ui/integration/services/Data',['./Service'],function(S){"use strict";var D=S.extend();
D.prototype.attachDataChanged=function(d,p){};
D.prototype.detachDataChanged=function(d){};
D.prototype.getData=function(i){return Promise.resolve(false);};
return D;});
sap.ui.predefine('sap/ui/integration/services/Navigation',['./Service'],function(S){"use strict";var N=S.extend();
N.prototype.navigate=function(c){};
S.prototype.enabled=function(c){return Promise.resolve(false);};
return N;});
sap.ui.predefine('sap/ui/integration/services/Service',[],function(){"use strict";var S=function(){};
S.extend=function(C){if(!C){var t=this;C=function(){t.apply(this,arguments);};}C.prototype=Object.create(this.prototype);C.prototype.constructor=C;C.extend=this.extend.bind(C);return C;};
S.prototype.getInterface=function(){return this;};
return S;});
sap.ui.predefine('sap/ui/integration/util/BindingHelper',["sap/ui/base/BindingParser","sap/base/util/extend","sap/ui/integration/formatters/DateTimeFormatter","sap/ui/integration/formatters/NumberFormatter","sap/ui/integration/bindingFeatures/DateRange"],function(B,e,D,N,a){"use strict";var r=/\{\{([^}]+)\}\}/g,b=/\{\{(parameters\.[^}]+)\}\}/g,c=/\{\{(dataSources\.[^}]+)\}\}/g;var d={};var f={date:D.date,dateTime:D.dateTime,currency:N.currency,"float":N.float,integer:N.integer,percent:N.percent,unit:N.unit};d.mLocals={"format":f,"dateRange":a};
d.extractBindingInfo=function(v){v=d.escapeCardPlaceholders(v);return B.complexParser(v,undefined,true,undefined,undefined,undefined,d.mLocals);};
d.createBindingInfos=function(i){if(!i){return i;}if(Array.isArray(i)){return i.map(d.createBindingInfos);}if(typeof i==="object"){var I={};for(var k in i){I[k]=d.createBindingInfos(i[k]);}return I;}return d.escapeParametersAndDataSources(d.extractBindingInfo(i)||i);};
d.formattedProperty=function(v,F){var g={};if(Array.isArray(v)){g.parts=v.map(function(I){return typeof I==="object"?e({},I):{value:I};});g.formatter=F;}else if(typeof v==="object"){g=e({},v);if(v.formatter){var i=g.formatter;g.formatter=function(){var I=i.apply(this,arguments);return F(I);};}else{g.formatter=F;}}else{g=F(v);}return g;};
d.escapeCardPlaceholders=function(v){if(typeof v!=="string"){return v;}return v.replace(r,"\\{\\{$1\\}\\}");};
d.escapeParametersAndDataSources=function(v){if(typeof v!=="string"){return v;}return v.replace(b,"\\{\\{$1\\}\\}").replace(c,"\\{\\{$1\\}\\}");};
d.addNamespace=function(n,v){d.mLocals[n]=v;};
d.isAbsolutePath=function(p){return p.startsWith("/");};
d.prependRelativePaths=function(v,p){if(typeof v!=="object"){return v;}var o=e({},v);if(o.path&&!this.isAbsolutePath(o.path)){o.path=p+"/"+o.path;}if(o.parts){o.parts=o.parts.map(function(g){return d.prependRelativePaths(g,p);});}return o;};
return d;});
sap.ui.predefine('sap/ui/integration/util/BindingResolver',["sap/ui/base/ManagedObject","sap/base/Log","sap/base/util/extend"],function(M,L,e){"use strict";
var S=M.extend("sap.ui.integration.util.SimpleControl",{metadata:{properties:{resolved:{type:"any"}}}});
var s=new S();var B={};
function p(v,m,P,c,i){if(c===i){L.warning("BindingResolver maximum level processing reached. Please check for circular dependencies.");return v;}if(Array.isArray(v)){return v.map(function(I){return p(I,m,P,c+1,i);});}if(v&&typeof v==="object"&&!B.isBindingInfo(v)){var n={};for(var a in v){n[a]=p(v[a],m,P,c+1,i);}return n;}if(typeof v==="string"||(typeof v==="object"&&B.isBindingInfo(v))){return r(v,m,P);}return v;}
function r(b,m,P){if(!b){return b;}var o=typeof b==="string"?M.bindingParser(b):e({},b);if(!o){return b;}if(!P){P="/";}s.setModel(m);s.bindObject(P);s.bindProperty("resolved",o);var v=s.getResolved();s.unbindProperty("resolved");s.unbindObject();s.setModel(null);return v;}
B.resolveValue=function(v,m,P){var c=0,i=30;if(m){return p(v,m,P,c,i);}else{return v;}};
B.isBindingInfo=function(o){if(!o){return false;}return o.hasOwnProperty("path")||(o.hasOwnProperty("parts")&&o.hasOwnProperty("formatter"));};
return B;});
sap.ui.predefine('sap/ui/integration/util/CardActions',["sap/m/library","sap/ui/integration/library","sap/ui/base/ManagedObject","sap/base/Log","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/DataProviderFactory"],function(l,a,M,L,B,D){"use strict";
function _(s){if(s&&typeof s==="object"){return s.name;}return s;}
var A=a.AreaType,C=a.CardActionType,b=l.ListType;
var c=M.extend("sap.ui.integration.util.CardActions",{metadata:{library:"sap.ui.integration",properties:{card:{type:"object"},areaType:{type:"sap.ui.integration.AreaType",defaultValue:A.None}}}});
c.prototype.exit=function(){this._oAreaControl=null;};
c.prototype.attach=function(i,o){this._oAreaControl=o;if(!i.actions){this._fireActionReady();return;}var d=i.actions[0];if(d&&d.type){this._attachAction(i,d);}else{this._fireActionReady();}};
c.prototype._setItemTemplateTypeFormatter=function(o){var t=this,d=t._oAreaControl,i=d._oItemTemplate;var e=M.bindingParser("{path:''}");e.formatter=function(v){var f=this.getBindingContext(),m=this.getModel(),p,P;if(f){p=f.getPath();}P=B.resolveValue(o.parameters,m,p);if(v.__resolved){if(!v.__enabled||v.__enabled==="false"){return b.Inactive;}return b.Navigation;}if(!v.__promise){v.__promise=true;d._oServiceManager.getService(_(o.service)).then(function(n){if(n){n.enabled({parameters:P}).then(function(E){v.__resolved=true;v.__enabled=E;d.getModel().checkUpdate(true);}).catch(function(){v.__resolved=true;v.__enabled=false;});}else{v.__resolved=true;v.__enabled=false;}});}return b.Inactive;};i.bindProperty("type",e);};
c.prototype._setSingleActionEnabledState=function(i,o){var d=this._oAreaControl,e=d.getBindingContext(),p,m=d.getModel(),P;if(e){P=e.getPath();}p=B.resolveValue(o.parameters,m,P);return new Promise(function(r){d._oServiceManager.getService(_(o.service)).then(function(n){if(n){n.enabled({parameters:p}).then(function(E){r(E);}).catch(function(){r(false);});}else{r(false);}}).catch(function(){r(false);});});};
c.prototype._setItemTemplateEnabledState=function(o){var d,t,i=this._oAreaControl._oItemTemplate;if(typeof o.enabled==="object"){d=o.enabled;d.formatter=function(v){if(!v||v==="false"){return b.Inactive;}return b.Navigation;};}if(d){i.bindProperty("type",d);}else{t=(o.enabled===false||o.enabled==="false")?b.Inactive:b.Navigation;i.setProperty("type",t);}};
c.prototype._fireActionReady=function(){var h=this.getAreaType()===A.Header;var e=h?"_actionHeaderReady":"_actionContentReady";this._oAreaControl.fireEvent(e);};
c.prototype._handleServiceAction=function(s,o){var d=s.getBindingContext(),m=s.getModel(),p;if(d){p=d.getPath();}this._oAreaControl._oServiceManager.getService(_(o.service)).then(function(S){if(S){S.navigate({parameters:B.resolveValue(o.parameters,m,p)});}}).catch(function(e){L.error("Navigation service unavailable",e);}).finally(function(){this._processAction(s,o,m,p);}.bind(this));};
c.prototype._handleAction=function(s,o){var d=s.getBindingContext(),m=s.getModel(),p;if(d){p=d.getPath();}this._processAction(s,o,m,p);};
c.prototype._attachPressEvent=function(o,d,s){o.attachPress(function(e){var S=e.getSource();if(d.service){this._handleServiceAction(S,d);}else{this._handleAction(S,d);}}.bind(this));};
c.prototype._attachAction=function(i,o){var d=this.getAreaType()===A.ContentItem?this._oAreaControl._oItemTemplate:this._oAreaControl,e=true,s=this.getAreaType(),S=s===A.Header||s===A.Content,f=s===A.ContentItem,g=true;if(o.service){if(this.getAreaType()===A.ContentItem){this._setItemTemplateTypeFormatter(o);}e=false;}else if(f){this._setItemTemplateEnabledState(o);e=false;}if(S&&o.service){this._setSingleActionEnabledState(i,o).then(function(E){if(E){this._attachPressEvent(d,o,S);}this._fireActionReady();}.bind(this));}else{if(e){g=o.enabled!==false&&o.enabled!=="false";}if(g){this._attachPressEvent(d,o,S);}this._fireActionReady();}};
c.prototype._processAction=function(s,o,m,p){var h=this._getHostInstance(),d=this.getCard(),u=o.url;if(u){u=B.resolveValue(u,m,p);}c.fireAction({card:d,host:h,action:o,parameters:B.resolveValue(o.parameters,m,p),source:s,url:u});};
c.prototype._getHostInstance=function(){var o=this.getCard();if(o){return o.getHostInstance();}return null;};
c.prototype.fireAction=function(s,t,p){var h=this._getHostInstance(),o=this.getCard(),d=this._extractActionConfigurations(o,p),e={card:o,host:h,action:{type:t},parameters:d,source:s};c.fireAction(e);};
c.fireAction=function(m){var h=m.host,o=m.card,e=o._oExtension,d=m.action,p=m.parameters||{},f={type:d.type,card:o,actionSource:m.source,manifestParameters:p,parameters:p},g=o.fireAction(f);if(!g){return false;}if(h){g=h.fireAction(f);}if(!g){return false;}if(e){g=e.fireAction(f);}if(g){c._doPredefinedAction(m);}return g;};
c._doPredefinedAction=function(m){var o=m.action,p=m.parameters,f,u,t;if(p){var P=p.url,s=p.target;}switch(o.type){case C.Navigation:if(o.service){break;}u=m.url||P;t=o.target||s||"_blank";if(u){c.openUrl(u,t);}break;case C.Custom:f=o.action;if(f&&jQuery.isFunction(f)){f(m.card,m.source);}break;case C.Submit:if(m.source&&m.source.isA("sap.ui.integration.cards.BaseContent")){c.handleSubmitAction(m);}break;}};
c.openUrl=function(u,t){window.open(u,t);};
c.handleSubmitAction=function(m){var d,o=m.card,e=o._oDataProviderFactory,f=m.source,g=m.parameters;if(!g.configuration){return;}f.onActionSubmitStart(g);d=e.create({request:g.configuration});d.getData().then(function(r){f.onActionSubmitEnd(r,null);},function(E){L.error(E);f.onActionSubmitEnd(null,{error:E});}).finally(function(){e.remove(d);});};
c.prototype._extractActionConfigurations=function(o,p){var r=o&&o.getManifestEntry("/sap.card/configuration/actionHandlers/submit"),d=p.data||{};if(!r){return p;}return{data:d,configuration:{"mode":r.mode||"cors","url":r.url,"method":r.method||"POST","parameters":Object.assign({},d,r.parameters),"headers":r.headers,"xhrFields":{"withCredentials":!!r.withCredentials}}};};
return c;});
sap.ui.predefine('sap/ui/integration/util/CardMerger',["sap/base/util/merge"],function(m){"use strict";var C={mergeCardDelta:function(M,c){var i=m({},M),s="sap.card";c.forEach(function(o){m(i[s],o.content);});return i;},mergeCardDesigntimeMetadata:function(d,c){var i=m({},d);c.forEach(function(o){var I=o.content.entityPropertyChange||[];I.forEach(function(a){var p=a.propertyPath;switch(a.operation){case"UPDATE":if(i.hasOwnProperty(p)){i[p]=a.propertyValue;}break;case"DELETE":delete i[p];break;case"INSERT":if(!i.hasOwnProperty(p)){i[p]=a.propertyValue;}break;default:break;}});});return i;}};return C;});
sap.ui.predefine('sap/ui/integration/util/ContentFactory',["./BindingHelper","./CardActions","sap/ui/base/Object","sap/ui/integration/cards/AdaptiveContent","sap/ui/integration/cards/AnalyticalContent","sap/ui/integration/cards/AnalyticsCloudContent","sap/ui/integration/cards/CalendarContent","sap/ui/integration/cards/ComponentContent","sap/ui/integration/cards/ListContent","sap/ui/integration/cards/ObjectContent","sap/ui/integration/cards/TableContent","sap/ui/integration/cards/TimelineContent"],function(B,C,a,A,b,c,d,e,L,O,T,f){"use strict";
var g=a.extend("sap.ui.integration.util.ContentFactory",{
metadata:{library:"sap.ui.integration"},
constructor:function(o){a.call(this);this._oCard=o;}
});
g.prototype.create=function(m){var o=this._oCard,t=m.cardType;return new Promise(function(r,h){var i=this.getClass(t);if(!i){h(t.toUpperCase()+" content type is not supported.");return;}var j=new i();j.setCard(o);if(j instanceof A){j.setCardDataProvider(o._oDataProvider);}j.loadDependencies(m.contentManifest).then(function(){if((m.cardManifest&&m.cardManifest.isDestroyed())||(m.dataProviderFactory&&m.dataProviderFactory.isDestroyed())){h();return;}var k=new C({card:o});j._sAppId=m.appId;j.setServiceManager(m.serviceManager);j.setDataProviderFactory(m.dataProviderFactory);j.setIconFormatter(m.iconFormatter);j.setActions(k);if(t.toLowerCase()!=="adaptivecard"){j.setConfiguration(B.createBindingInfos(m.contentManifest),t);}else{j.setConfiguration(m.contentManifest);}r(j);}).catch(function(E){h(E);});}.bind(this));};
g.prototype.getClass=function(t){switch(t.toLowerCase()){case"adaptivecard":return A;case"analytical":return b;case"analyticscloud":return c;case"calendar":return d;case"component":return e;case"list":return L;case"object":return O;case"table":return T;case"timeline":return f;default:return null;}};
return g;});
sap.ui.predefine('sap/ui/integration/util/DataProvider',["sap/ui/base/ManagedObject"],function(M){"use strict";
var D=M.extend("sap.ui.integration.util.DataProvider",{metadata:{events:{dataRequested:{parameters:{}},dataChanged:{parameters:{data:{type:"object"}}},error:{parameters:{message:{type:"string"}}}}}});
D.prototype.setDestinations=function(d){this._oDestinations=d;};
D.prototype.setSettings=function(s){this._oSettings=s;};
D.prototype.getSettings=function(){return this._oSettings;};
D.prototype.triggerDataUpdate=function(){this.fireDataRequested();return this.getData().then(function(d){this.fireDataChanged({data:d});this.onDataRequestComplete();}.bind(this)).catch(function(e){this.fireError({message:e});this.onDataRequestComplete();}.bind(this));};
D.prototype.getData=function(){var d=this.getSettings();return new Promise(function(r,a){if(d.json){r(d.json);}else{a("Could not get card data.");}});};
D.prototype.destroy=function(){if(this._iIntervalId){clearInterval(this._iIntervalId);this._iIntervalId=null;}this._oSettings=null;M.prototype.destroy.apply(this,arguments);};
D.prototype.onDataRequestComplete=function(){var i;if(!this._oSettings||!this._oSettings.updateInterval){return;}i=parseInt(this._oSettings.updateInterval);if(isNaN(i)){return;}setTimeout(function(){this.triggerDataUpdate();}.bind(this),i*1000);};
return D;});
sap.ui.predefine('sap/ui/integration/util/DataProviderFactory',["sap/ui/base/Object","sap/ui/integration/util/ServiceDataProvider","sap/ui/integration/util/RequestDataProvider","sap/ui/integration/util/DataProvider","sap/ui/integration/util/ExtensionDataProvider"],function(B,S,R,D,E){"use strict";
var a=B.extend("sap.ui.integration.util.DataProviderFactory",{constructor:function(d,e){B.call(this);this._oDestinations=d;this._oExtension=e;this._aDataProviders=[];}});
a.prototype.destroy=function(){B.prototype.destroy.apply(this,arguments);if(this._aDataProviders){this._aDataProviders.forEach(function(d){if(!d.bIsDestroyed){d.destroy();}});this._aDataProviders=null;}this._oExtension=null;this._bIsDestroyed=true;};
a.prototype.isDestroyed=function(){return this._bIsDestroyed;};
a.prototype.create=function(d,s){var o;if(!d){return null;}if(d.request){o=new R();}else if(d.service){o=new S();}else if(d.json){o=new D();}else if(d.extension){o=new E(this._oExtension);}else{return null;}o.setDestinations(this._oDestinations);o.setSettings(d);if(o.isA("sap.ui.integration.util.IServiceDataProvider")){o.createServiceInstances(s);}this._aDataProviders.push(o);return o;};
a.prototype.remove=function(d){var p=this._aDataProviders.indexOf(d);if(p>-1){this._aDataProviders.splice(p,1);}if(d&&!d.bDestroyed&&d._bIsDestroyed){d.destroy();}};
return a;});
sap.ui.predefine('sap/ui/integration/util/Destinations',["sap/ui/base/Object","sap/base/Log"],function(B,L){"use strict";var r=/\{\{destinations.([^\}]+)/;
var D=B.extend("sap.ui.integration.util.Destinations",{
metadata:{library:"sap.ui.integration"},
constructor:function(h,c){B.call(this);this._oHost=h;this._oConfiguration=c;this._mResolved=new Map();}
});
D.prototype.setHost=function(h){this._oHost=h;this._mResolved.clear();};
D.prototype.process=function(c){var u=c.url,C;if(!u||typeof u!=="string"){return Promise.resolve(c);}if(!this.hasDestination(u)){return Promise.resolve(c);}C=jQuery.extend(true,{},c);return this.processString(u).then(function(p){C.url=p;return C;});};
D.prototype.getUrl=function(k){var R;if(this._mResolved.has(k)){return this._mResolved.get(k);}R=this._resolveUrl(k);this._mResolved.set(k,R);return R;};
D.prototype._resolveUrl=function(k){var c=this._oConfiguration?this._oConfiguration[k]:null,n,d,p;if(!c){return Promise.reject("Configuration for destination '"+k+"' was not found in the manifest.");}n=c.name;d=c.defaultUrl;if(!n&&!d){return Promise.reject("Can not resolve destination '"+k+"'. Neither 'name' nor 'defaultUrl' is configured.");}if(!n&&d){return Promise.resolve(d);}if(!this._oHost&&!d){return Promise.reject("Can not resolve destination '"+k+"'. There is no 'host' and no defaultUrl specified.");}if(!this._oHost&&d){return Promise.resolve(d);}p=this._oHost.getDestination(n);if(d){return p.catch(function(m){L.error(m+" Fallback to default url.");return d;});}return p;};
D.prototype.hasDestination=function(s){return!!s.match(r);};
D.prototype.processString=function(s){var m=s.match(r),k;if(!m){return Promise.resolve(s);}k=m[1];return this.getUrl(k).then(function(u){return this._replaceUrl(s,k,u);}.bind(this));};
D.prototype._replaceUrl=function(s,k,u){var S=u.trim().replace(/\/$/,"");return s.replace("{{destinations."+k+"}}",S);};
return D;});
sap.ui.predefine('sap/ui/integration/util/ExtensionDataProvider',["sap/ui/integration/util/DataProvider"],function(D){"use strict";
var E=D.extend("sap.ui.integration.util.ExtensionDataProvider",{constructor:function(e){D.call(this);this._oExtension=e;}});
E.prototype.destroy=function(){D.prototype.destroy.apply(this,arguments);this._oExtension=null;};
E.prototype.getData=function(){var e=this.getSettings().extension;if(!this._oExtension){return Promise.reject("The extension module is not loaded properly or doesn't export a correct value.");}if(!this._oExtension[e.method]){return Promise.reject("Extension doesn't implement "+e.method+" method.");}return this._oExtension[e.method].apply(this._oExtension,e.args);};
return E;});
sap.ui.predefine('sap/ui/integration/util/FilterBarFactory',["sap/ui/base/Object","sap/m/library","sap/m/HBox","sap/m/Select","sap/ui/core/ListItem"],function(B,l,H,S,L){"use strict";var F=l.FlexWrap;
var a=B.extend("sap.ui.integration.util.FilterBarFactory",{
metadata:{library:"sap.ui.integration"},
constructor:function(c){B.call(this);this._oCard=c;}
});
a.prototype.create=function(f,m){var o,s=[],k,c,v;for(k in f){c=f[k];v=m.get(k)||c.value;s.push(this._createSelect(k,c,v));}if(!s.length){return null;}o=new H({wrap:F.Wrap,items:s});return o;};
a.prototype._createSelect=function(k,c,v){var i=c.items||[],s;s=new S();i.forEach(function(I){s.addItem(new L({key:I.key,text:I.title}));});s.setSelectedKey(v);s.attachChange(function(){this._oCard._setFilterValue(k,s.getSelectedKey());}.bind(this));return s;};
return a;});
sap.ui.predefine('sap/ui/integration/util/HeaderFactory',["sap/ui/integration/library","sap/ui/base/Object","sap/ui/integration/cards/NumericHeader","sap/ui/integration/cards/Header","sap/base/strings/formatMessage","sap/ui/integration/controls/ActionsToolbar","sap/ui/integration/util/BindingHelper","./CardActions"],function(l,B,N,H,f,A,a,C){"use strict";var b=l.AreaType;
function c(F,h){if(F.parts&&F.translationKey&&F.parts.length===2){var o={parts:[F.translationKey,F.parts[0].toString(),F.parts[1].toString()],formatter:function(t,p,P){var s=p||F.parts[0];var e=P||F.parts[1];if(Array.isArray(p)){s=p.length;}if(Array.isArray(P)){e=P.length;}var i=parseFloat(s)||0;var g=parseFloat(e)||0;return f(t,[i,g]);}};h.bindProperty("statusText",o);}}
var d=B.extend("sap.ui.integration.util.HeaderFactory",{
metadata:{library:"sap.ui.integration"},
constructor:function(o){B.call(this);this._oCard=o;}
});
d.prototype.create=function(m){var h,o=this._oCard,e,g=this._createActionsToolbar();if(!m&&!g){return null;}if(!m){m={};}e=new C({card:o,areaType:b.Header});switch(m.type){case"Numeric":h=new N(m,g,o._sAppId);break;default:h=new H(m,g,o._sAppId,o._oIconFormatter);break;}if(m.status&&m.status.text&&m.status.text.format){if(m.status.text.format.translationKey){o._loadDefaultTranslations();}c(m.status.text.format,h);}h.setServiceManager(o._oServiceManager);h.setDataProviderFactory(o._oDataProviderFactory);h._setDataConfiguration(a.createBindingInfos(m.data));e.attach(m,h);h._oActions=e;return h;};
d.prototype._createActionsToolbar=function(){var o=this._oCard,h=o.getHostInstance(),e=o._oExtension,g,i;if(!h&&!e){return null;}g=new A();i=g.initializeContent(h,o,e);if(i){return g;}return null;};
return d;});
sap.ui.predefine('sap/ui/integration/util/LoadingProvider',["sap/ui/base/ManagedObject","sap/ui/core/Core","sap/f/cards/loading/GenericPlaceholder","sap/f/cards/loading/ListPlaceholder"],function(M,C,G,L){"use strict";
var a=M.extend("sap.ui.integration.util.LoadingProvider",{});
a.prototype.createLoadingState=function(d){this._bLoading=true;this._bJSON=false;if(d){if(d.getSettings()['json']){this._bJSON=true;}}else{this._bLoading=false;}};
a.prototype.getDataProviderJSON=function(){return this._bJSON;};
a.prototype.setLoading=function(l){this._bLoading=l;return this._bLoading;};
a.prototype.getLoadingState=function(){return this._bLoading;};
a.prototype.removeHeaderPlaceholder=function(c){if(c&&c.getDomRef()){c.removeStyleClass("sapFCardHeaderLoading");c.getDomRef().classList.remove("sapFCardHeaderLoading");}};
a.prototype.destroy=function(){this._bLoading=null;this._bJSON=null;if(this._oContentPlaceholder){this._oContentPlaceholder.destroy();this._oContentPlaceholder=null;}M.prototype.destroy.apply(this,arguments);};
a.prototype.createContentPlaceholder=function(c,t){switch(t){case"List":this._oContentPlaceholder=new L({maxItems:c.maxItems?parseInt(c.maxItems):2,item:c.item});break;default:this._oContentPlaceholder=new G();}return this._oContentPlaceholder;};
return a;});
sap.ui.predefine('sap/ui/integration/util/Manifest',["sap/ui/base/Object","sap/ui/core/Manifest","sap/base/util/deepClone","sap/base/util/isPlainObject","sap/base/Log","./ParameterMap","sap/ui/integration/util/CardMerger"],function(B,C,d,a,L,P,b){"use strict";var M="/{SECTION}/configuration/parameters",c="/{SECTION}/configuration/filters",e="/{SECTION}",A="/sap.app/dataSources",R=/\{\{(?!parameters.)(?!destinations.)([^\}\}]+)\}\}|\{i18n>([^\}]+)\}/g;
var f=B.extend("sap.ui.integration.util.Manifest",{constructor:function(s,o,i,j){B.call(this);this._aChanges=j;this.PARAMETERS=M.replace("{SECTION}",s);this.FILTERS=c.replace("{SECTION}",s);this.CONFIGURATION=e.replace("{SECTION}",s);if(o){var O={},l;O.process=false;if(i){O.baseUrl=i;this._sBaseUrl=i;}else{L.warning("If no base URL is provided when the manifest is an object static resources cannot be loaded.");}if(this._aChanges){l=b.mergeCardDelta(o,this._aChanges);}else{l=o;}this._oManifest=new C(l,O);this.oJson=this._oManifest.getRawJson();}}});
f.prototype.getJson=function(){return this._unfreeze(this.oJson);};
f.prototype.get=function(s){return this._unfreeze(m(this.oJson,s));};
f.prototype.getUrl=function(){return this._oManifest.resolveUri("./","manifest");};
f.prototype.getResourceBundle=function(){return this.oResourceBundle;};
f.prototype._unfreeze=function(v){if(typeof v==="object"){return JSON.parse(JSON.stringify(v));}return v;};
f.prototype.destroy=function(){this.oJson=null;this.oResourceBundle=null;if(this._oManifest){this._oManifest.destroy();}this._bIsDestroyed=true;};
f.prototype.isDestroyed=function(){return this._bIsDestroyed;};
f.prototype.load=function(s){if(!s||!s.manifestUrl){if(this._sBaseUrl&&this._oManifest){return this.loadI18n().then(function(){this.processManifest();}.bind(this));}else{if(this._oManifest){this.processManifest();}return new Promise(function(i){i();});}}return C.load({manifestUrl:s.manifestUrl,async:true,processJson:function(o){if(this._aChanges){return b.mergeCardDelta(o,this._aChanges);}return o;}.bind(this)}).then(function(o){this._oManifest=o;this.oJson=this._oManifest.getRawJson();return this.loadI18n().then(function(){this.processManifest();}.bind(this));}.bind(this));};
f.prototype.loadI18n=function(){var H=false;C.processObject(this._oManifest.getJson(),function(o,K,v){if(!H&&v.match(R)){H=true;}});if(this.get("/sap.app/i18n")){H=true;}if(!H){return Promise.resolve();}return this._oManifest._loadI18n(true).then(function(o){this.oResourceBundle=o;}.bind(this));};
f.prototype.processManifest=function(){var i=0,j=15,u=jQuery.extend(true,{},this._oManifest.getRawJson()),D=this.get(A);p(u,this.oResourceBundle,i,j,this._oCombinedParams,D,this._oCombinedFilters);g(u);this.oJson=u;};
function g(o){if(o&&typeof o==='object'&&!Object.isFrozen(o)){Object.freeze(o);for(var K in o){if(o.hasOwnProperty(K)){g(o[K]);}}}}
function h(v){return(typeof v==="string")&&v.indexOf("{{")===0&&v.indexOf("}}")===v.length-2;}
function k(v){return(typeof v==="string")&&(v.indexOf("{{parameters.")>-1||v.indexOf("{{dataSources")>-1||v.indexOf("{{filters.")>-1);}
f._processPlaceholder=function(s,o,D,F){var i=P.processPredefinedParameter(s),v,j;if(o){for(var l in o){v=o[l].value;j="{{parameters."+l;i=r(i,v,j);}}if(D){i=r(i,D,"{{dataSources");}if(F){i=r(i,F,"{{filters");}return i;};
function r(s,v,i){if(a(v)){for(var j in v){s=r(s,v[j],i+"."+j);}}else if(s.includes(i+"}}")){s=s.replace(new RegExp(i+"}}",'g'),v);}return s;}
function p(o,i,j,l,n,D,F){if(j===l){return;}if(Array.isArray(o)){o.forEach(function(I,q,t){if(typeof I==="object"){p(I,i,j+1,l,n,D,F);}else if(k(I)){t[q]=f._processPlaceholder(I,n,D,F);}else if(h(I)&&i){t[q]=i.getText(I.substring(2,I.length-2));}},this);}else{for(var s in o){if(typeof o[s]==="object"){p(o[s],i,j+1,l,n,D,F);}else if(k(o[s])){o[s]=f._processPlaceholder(o[s],n,D,F);}else if(h(o[s])&&i){o[s]=i.getText(o[s].substring(2,o[s].length-2));}}}}
function m(o,s){if(s==="/"){return o;}if(o&&s&&typeof s==="string"&&s[0]==="/"){var j=s.substring(1).split("/"),n;for(var i=0,l=j.length;i<l;i++){n=j[i];o=o.hasOwnProperty(n)?o[n]:undefined;if(o===null||typeof o!=="object"){if(i+1<l&&o!==undefined){o=undefined;}break;}}return o;}return o&&o[s];}
f.prototype.processFilters=function(i){if(!this._oManifest){return;}var o=this.get(this.FILTERS),j={};if(i.size&&!o){L.error("If runtime filters are set, they have to be defined in the manifest configuration as well.");return;}jQuery.each(o,function(K,l){var v=i.get(K)||l.value;j[K]=v;});this._oCombinedFilters=j;this.processManifest();};
f.prototype.processParameters=function(o){if(!this._oManifest){return;}var i=this.get(this.PARAMETERS);if(o&&!i){L.error("If parameters property is set, parameters should be described in the manifest");return;}this._oCombinedParams=this._syncParameters(o,i);this.processManifest();};
f.prototype.getProcessedParameters=function(o){var i=this.get(this.PARAMETERS),j=this._syncParameters(o,i);p(j,this.oResourceBundle,0,15,o);return j;};
f.prototype._syncParameters=function(o,l){if(!o){return l;}var n=d(l,20,20),q=Object.getOwnPropertyNames(o),s=Object.getOwnPropertyNames(n);for(var i=0;i<s.length;i++){for(var j=0;j<q.length;j++){if(s[i]===q[j]){n[s[i]].value=o[q[j]];}}}return n;};
return f;},true);
sap.ui.predefine('sap/ui/integration/util/ParameterMap',['sap/ui/core/Core'],function(C){"use strict";var P={};var p={"{{parameters.NOW_ISO}}":g,"{{parameters.TODAY_ISO}}":a,"{{parameters.LOCALE}}":b};
function g(){return new Date().toISOString();}
function a(){return new Date().toISOString().slice(0,10);}
function b(){return C.getConfiguration().getLocale().toString();}
P.processPredefinedParameter=function(s){var r;Object.keys(p).forEach(function(e){r=new RegExp(e,'g');if(s.indexOf(e)>-1){s=s.replace(r,p[e]());}});return s;};
return P;});
sap.ui.predefine('sap/ui/integration/util/RequestDataProvider',["sap/ui/integration/util/DataProvider","jquery.sap.global","sap/base/Log"],function(D,q,L){"use strict";var m=["no-cors","same-origin","cors"];var M=["GET","POST"];
var R=D.extend("sap.ui.integration.util.RequestDataProvider",{metadata:{properties:{allowCustomDataType:{type:"boolean",defaultValue:false}}}});
R.prototype.getData=function(){var r=this.getSettings().request;if(this._oDestinations){return this._oDestinations.process(r).then(this._fetch.bind(this));}return this._fetch(r);};
R.prototype._isValidRequest=function(r){if(!r){return false;}if(m.indexOf(r.mode)===-1){return false;}if(M.indexOf(r.method)===-1){return false;}if(typeof r.url!=="string"){return false;}return true;};
R.prototype._fetch=function(r){var s="Invalid request";return new Promise(function(a,b){if(!r||!r.url){L.error(s);b(s);return;}if(!this.getAllowCustomDataType()&&r.dataType){L.error("To specify dataType property in the Request Configuration, first set allowCustomDataType to 'true'.");}var o={"mode":r.mode||"cors","url":r.url,"method":(r.method&&r.method.toUpperCase())||"GET","dataType":(this.getAllowCustomDataType()&&r.dataType)||"json","data":r.parameters,"headers":r.headers,"timeout":15000,"xhrFields":{"withCredentials":!!r.withCredentials}};if(this._isValidRequest(o)){q.ajax(o).done(function(d){a(d);}).fail(function(j,t,e){b(e);});}else{L.error(s);b(s);}}.bind(this));};
return R;});
sap.ui.predefine('sap/ui/integration/util/ServiceDataProvider',["sap/ui/integration/util/DataProvider"],function(D){"use strict";
var S=D.extend("sap.ui.integration.util.ServiceDataProvider",{metadata:{interfaces:["sap.ui.integration.util.IServiceDataProvider"]}});
S.prototype.destroy=function(){this._oDataServicePromise=null;if(this._oServiceManager){this._oServiceManager=null;}D.prototype.destroy.apply(this,arguments);};
S.prototype.createServiceInstances=function(s){this._oServiceManager=s;if(!this._oSettings||!this._oSettings.service){return;}var v=this._oSettings.service;if(v&&typeof v==="object"){v=v.name;}this._createServiceInstance(v);};
S.prototype._createServiceInstance=function(s){var d=this._oSettings;this._oDataServicePromise=this._oServiceManager.getService(s).then(function(o){o.attachDataChanged(function(e){this.fireDataChanged({data:e.data});}.bind(this),d.service.parameters);return o;}.bind(this));};
S.prototype.getData=function(){var d=this.getSettings();var s=d.service;return new Promise(function(r,a){if(s&&this._oDataServicePromise){this._oDataServicePromise.then(function(o){o.getData().then(function(b){r(b);}).catch(function(){a("Card data service failed to get data.");});}).catch(function(){a("Card data service unavailable.");});}else{a("Could not get card data.");}}.bind(this));};
return S;});
sap.ui.predefine('sap/ui/integration/util/ServiceManager',["sap/ui/base/EventProvider","sap/base/Log"],function(E,L){"use strict";
var S=E.extend("sap.ui.integration.util.ServiceManager",{
metadata:{library:"sap.ui.integration"},
constructor:function(s,o){if(!s){throw new Error("Missing manifest services reference!");}if(!o){throw new Error("Missing context object");}this._mServiceFactoryReferences=s;this._mServices={};this._oServiceContext=o;this._initAllServices();}
});
S.prototype._initAllServices=function(){for(var s in this._mServiceFactoryReferences){this._initService(s);}};
S.prototype._initService=function(n){var s=this._mServices[n]||{};s.promise=S._getService(this._oServiceContext,n,this._mServiceFactoryReferences).then(function(o){s.instance=o;}).catch(function(e){L.error(e.message);});this._mServices[n]=s;};
S.prototype.getService=function(s){var e="Invalid service";return new Promise(function(r,R){if(!s||!this._mServices[s]||!Object.keys(this._mServices[s])){R(e);return;}this._mServices[s].promise.then(function(){if(this._mServices[s].instance){r(this._mServices[s].instance);}else{R(e);}}.bind(this)).catch(R);}.bind(this));};
S.prototype.destroy=function(){this._mServices=null;};
S._getService=function(i,n,s){return new Promise(function(r,R){var o,f;if(i.bIsDestroyed){R(new Error("Service "+n+" could not be loaded as the requestor "+i.getMetadata().getName()+" was destroyed."));return;}if(!s){R(new Error("No Services declared"));return;}else{o=s[n];}if(!o||!o.factoryName){R(new Error("No Service '"+n+"' declared or factoryName missing"));return;}else{f=o.factoryName;}sap.ui.require(["sap/ui/core/service/ServiceFactoryRegistry"],function(a){var b=a.get(f);if(b){b.createInstance({scopeObject:i,scopeType:"component",settings:o.settings||{}}).then(function(c){if(c.getInterface){r(c.getInterface());}else{r(c);}}).catch(R);}else{var e=new Error("ServiceFactory '"+f+"' for Service '"+n+"' not found in ServiceFactoryRegistry");e._optional=o.optional;R(e);}});});};
return S;});
sap.ui.predefine('sap/ui/integration/util/Utils',["sap/ui/core/Locale",'sap/base/util/isPlainObject',"sap/base/Log"],function(L,i,a){"use strict";var U={};
U.isJson=function(t){if(typeof t!=="string"){return false;}try{JSON.parse(t);return true;}catch(e){return false;}};
U.processFormatArguments=function(f,l){var F=i(f)?f:{},o=typeof f==="string"?new L(f):(l&&new L(l));return{formatOptions:F,locale:o};};
var J=1,b=2,c=3;
U.parseJsonDateTime=function(d){var r=/^\/Date\((-?\d+)(\+|-)?(\d+)?\)\/$/,j;if(typeof d==="string"){j=r.exec(d);}if(j){var R=new Date(parseInt(j[J]));if(j[b]){var m=parseInt(j[c]);if(j[b]==="-"){m=-m;}var C=R.getUTCMinutes();R.setUTCMinutes(C-m);}if(isNaN(R.valueOf())){a.error("Invalid JSON Date format - "+d);}else{d=R;}}return d;};
return U;});
sap.ui.predefine('sap/ui/integration/util/loadCardEditor',function(){"use strict";return function(){return sap.ui.loader._.loadJSResourceAsync("sap-ui-integration-cardEditor.js").then(function(){return new Promise(function(r,R){sap.ui.require(["sap/ui/integration/designtime/cardEditor/CardEditor"],r,R);});});};});
sap.ui.predefine('sap/ui/integration/widgets/Card',["sap/ui/base/Interface","sap/ui/thirdparty/jquery","sap/ui/core/Core","sap/ui/core/Control","sap/ui/integration/util/Manifest","sap/ui/integration/util/ServiceManager","sap/base/Log","sap/ui/integration/util/DataProviderFactory","sap/ui/integration/cards/BaseContent","sap/m/HBox","sap/ui/core/Icon","sap/m/Text","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/base/util/LoaderExtensions","sap/f/CardRenderer","sap/f/library","sap/m/library","sap/ui/integration/library","sap/ui/core/InvisibleText","sap/ui/integration/util/Destinations","sap/ui/integration/util/LoadingProvider","sap/ui/integration/util/HeaderFactory","sap/ui/integration/util/ContentFactory","sap/ui/integration/util/BindingHelper","sap/ui/integration/formatters/IconFormatter","sap/ui/integration/util/FilterBarFactory","sap/m/BadgeEnabler"],function(I,q,C,a,b,S,L,D,B,H,c,T,J,R,d,F,l,m,e,f,g,h,i,j,k,n,o,p){"use strict";var M={TYPE:"/sap.card/type",DATA:"/sap.card/data",HEADER:"/sap.card/header",HEADER_POSITION:"/sap.card/headerPosition",CONTENT:"/sap.card/content",SERVICES:"/sap.ui5/services",APP_TYPE:"/sap.app/type",PARAMS:"/sap.card/configuration/parameters",DESTINATIONS:"/sap.card/configuration/destinations"};var r=l.cards.HeaderPosition;var s=e.CardDataMode;var t=m.BadgeState;var u=3000;
var v=a.extend("sap.ui.integration.widgets.Card",{
metadata:{library:"sap.ui.integration",interfaces:["sap.f.ICard","sap.m.IBadge"],properties:{manifest:{type:"any",defaultValue:""},parameters:{type:"object",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"auto"},dataMode:{type:"sap.ui.integration.CardDataMode",group:"Behavior",defaultValue:s.Active},baseUrl:{type:"sap.ui.core.URI",defaultValue:null},manifestChanges:{type:"object[]"}},aggregations:{_header:{type:"sap.f.cards.IHeader",multiple:false,visibility:"hidden"},_filterBar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{action:{allowPreventDefault:true,parameters:{actionSource:{type:"sap.ui.core.Control"},manifestParameters:{type:"object"},parameters:{type:"object"},type:{type:"sap.ui.integration.CardActionType"}}},manifestReady:{parameters:{}}},associations:{hostConfigurationId:{},host:{}}},
renderer:F
});
p.call(v.prototype);
v.prototype.init=function(){this._oRb=C.getLibraryResourceBundle("sap.f");this.setModel(new J(),"parameters");this._busyStates=new Map();this._oExtension=null;this._oContentFactory=new j(this);this._mFilters=new Map();this._ariaText=new f({id:this.getId()+"-ariaText"});this._ariaContentText=new f({id:this.getId()+"-ariaContentText"});this._ariaContentText.setText(this._oRb.getText("ARIA_LABEL_CARD_CONTENT"));this._oLimitedInterface=new I(this,["getParameters","getCombinedParameters","getManifestEntry","resolveDestination","request","showMessage","getBaseUrl","getResourceBundle"]);this.initBadgeEnablement({accentColor:"AccentColor6"});};
v.prototype._initReadyState=function(){this._aReadyPromises=[];this._awaitEvent("_headerReady");this._awaitEvent("_contentReady");this._awaitEvent("_cardReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready");}.bind(this));};
v.prototype._clearReadyState=function(){this._bReady=false;this._aReadyPromises=[];};
v.prototype.onBeforeRendering=function(){var w=this.getHostConfigurationId();if(this.getDataMode()!==s.Active){return;}if(w){this.addStyleClass(w.replace(/-/g,"_"));}if(this._bApplyManifest||this._bApplyParameters||this._bApplyFilters){this._clearReadyState();this._initReadyState();}if(this._bApplyManifest){var x=this.getManifest();if(!x){this.destroyManifest();}else{this.createManifest(x,this.getBaseUrl());}}if(!this._bApplyManifest&&this._bApplyParameters){this._oCardManifest.processParameters(this.getParameters());this._applyManifestSettings();}if(!this._bApplyManifest&&this._bApplyFilters){this._oCardManifest.processFilters(this._mFilters);this._applyManifestSettings();}this._bApplyManifest=false;this._bApplyParameters=false;this._bApplyFilters=false;};
v.prototype.setManifest=function(V){this.setProperty("manifest",V);this._bApplyManifest=true;return this;};
v.prototype.setManifestChanges=function(V){this.setProperty("manifestChanges",V);this._bApplyManifest=true;return this;};
v.prototype.setParameters=function(V){this.setProperty("parameters",V);this._bApplyParameters=true;return this;};
v.prototype.setParameter=function(K,V){var P=this.getParameters()||{};P[K]=V;this.setParameters(P);return this;};
v.prototype.setHost=function(w){this.setAssociation("host",w);if(this._oDestinations){this._oDestinations.setHost(this.getHostInstance());}return this;};
v.prototype._setFilterValue=function(K,V){this._mFilters.set(K,V);this._bApplyFilters=true;this.invalidate();return this;};
v.prototype.createManifest=function(w,x){var O={};this._isManifestReady=false;if(typeof w==="string"){O.manifestUrl=w;w=null;}if(this._oCardManifest){this._oCardManifest.destroy();}this._oCardManifest=new b("sap.card",w,x,this.getManifestChanges());this._oCardManifest.load(O).then(function(){this._registerManifestModulePath();this._isManifestReady=true;this.fireManifestReady();return this._loadExtension();}.bind(this)).then(function(){this._applyManifest();}.bind(this)).catch(this._applyManifest.bind(this));};
v.prototype._loadExtension=function(){var E=this._oCardManifest.get("/sap.card/extension");if(!E){return null;}var w=this._oCardManifest.get("/sap.app/id").replace(/\./g,"/")+"/"+E;return new Promise(function(x,y){sap.ui.require([w],function(z){this._oExtension=z;k.addNamespace("extension",{formatters:z.getFormatters()});x();}.bind(this),function(z){L.error("Failed to load "+E+". Check if the path is correct.");y(z);});}.bind(this));};
v.prototype._applyManifest=function(){var P=this.getParameters(),w=this._mFilters,x=this._oCardManifest;if(x&&x.getResourceBundle()){this._enhanceI18nModel(x.getResourceBundle());}x.processParameters(P);x.processFilters(w);this._prepareToApplyManifestSettings();this._applyManifestSettings();};
v.prototype._loadDefaultTranslations=function(){if(this._defaultTranslationsLoaded){return;}var w=C.getLibraryResourceBundle("sap.ui.integration");this._enhanceI18nModel(w);this._defaultTranslationsLoaded=true;};
v.prototype._enhanceI18nModel=function(w){var x=this.getModel("i18n");if(x){x.enhance(w);return;}x=new R({bundle:w});this.setModel(x,"i18n");};
v.prototype._awaitEvent=function(E){this._aReadyPromises.push(new Promise(function(w){this.attachEventOnce(E,function(){w();});}.bind(this)));};
v.prototype.isReady=function(){return this._bReady;};
v.prototype.refresh=function(){if(this.getDataMode()===s.Active){this._clearReadyState();this._initReadyState();this.destroyManifest();this._bApplyManifest=true;this.invalidate();}};
v.prototype.exit=function(){this.destroyManifest();this._busyStates=null;this._oRb=null;this._oExtension=null;this._oContentFactory=null;if(this._ariaText){this._ariaText.destroy();this._ariaText=null;}if(this._ariaContentText){this._ariaContentText.destroy();this._ariaContentText=null;}};
v.prototype.destroyManifest=function(){if(this._oCardManifest){this._oCardManifest.destroy();this._oCardManifest=null;}if(this._oServiceManager){this._oServiceManager.destroy();this._oServiceManager=null;}if(this._oDataProviderFactory){this._oDataProviderFactory.destroy();this._oDataProviderFactory=null;this._oDataProvider=null;}if(this._oLoadingProvider){this._oLoadingProvider.destroy();this._oLoadingProvider=null;}if(this._oTemporaryContent){this._oTemporaryContent.destroy();this._oTemporaryContent=null;}if(this._oDestinations){this._oDestinations.destroy();this._oDestinations=null;}if(this._oIconFormatter){this._oIconFormatter.destroy();this._oIconFormatter=null;}this.destroyAggregation("_header");this.destroyAggregation("_filterBar");this.destroyAggregation("_content");this._aReadyPromises=null;this._busyStates.clear();this._mFilters.clear();};
v.prototype._registerManifestModulePath=function(){if(!this._oCardManifest){return;}this._sAppId=this._oCardManifest.get("/sap.app/id");if(this._sAppId){d.registerResourcePath(this._sAppId.replace(/\./g,"/"),this._oCardManifest.getUrl());}else{L.error("Card sap.app/id entry in the manifest is mandatory");}};
v.prototype.getManifest=function(){var V=this.getProperty("manifest");if(V&&typeof V==="object"){return q.extend(true,{},V);}return V;};
v.prototype.getParameters=function(){var V=this.getProperty("parameters");if(V&&typeof V==="object"){return q.extend(true,{},V);}return V;};
v.prototype.getCombinedParameters=function(){if(!this._isManifestReady){L.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null;}var P=this._oCardManifest.getProcessedParameters(this.getProperty("parameters")),w={},K;for(K in P){w[K]=P[K].value;}return w;};
v.prototype.getManifestEntry=function(P){if(!this._isManifestReady){L.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null;}return this._oCardManifest.get(P);};
v.prototype.getManifestWithMergedChanges=function(){if(!this._oCardManifest||!this._oCardManifest._oManifest){L.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return{};}return q.extend(true,{},this._oCardManifest._oManifest.getRawJson());};
v.prototype.resolveDestination=function(K){return this._oDestinations.getUrl(K);};
v.prototype.showMessage=function(w,x){var y=this.getCardContent();if(!y||!y.showMessage){L.error("The experimental feature 'showMessage' is currently available only for an Adaptive Card.");return;}y.showMessage(w,x);};
v.prototype.getResourceBundle=function(){var w=this.getModel("i18n");if(!w){L.warning("There are no translations available. Either the i18n configuration is missing or the method is called too early.");return null;}return w.getResourceBundle();};
v.prototype._prepareToApplyManifestSettings=function(){var A=this._oCardManifest.get(M.APP_TYPE);if(A&&A!=="card"){L.error("sap.app/type entry in manifest is not 'card'");}if(this._oDataProviderFactory){this._oDataProviderFactory.destroy();}this._oDestinations=new g(this.getHostInstance(),this._oCardManifest.get(M.DESTINATIONS));this._oIconFormatter=new n(this._oDestinations);this._oDataProviderFactory=new D(this._oDestinations,this._oExtension);this._oLoadingProvider=new h();if(this._oExtension){this._oExtension.onCardReady(this._oLimitedInterface);}};
v.prototype._applyManifestSettings=function(){this._applyServiceManifestSettings();this._applyDataManifestSettings();this._applyHeaderManifestSettings();this._applyFilterBarManifestSettings();this._applyContentManifestSettings();};
v.prototype._applyDataManifestSettings=function(){var w=k.createBindingInfos(this._oCardManifest.get(M.DATA));if(!w){this.fireEvent("_cardReady");return;}this.bindObject(w.path||"/");if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=this._oDataProviderFactory.create(w,this._oServiceManager);if(this._oDataProvider){this.setModel(new J());this._oDataProvider.attachDataRequested(function(){this.onDataRequested();}.bind(this));this._oDataProvider.attachDataChanged(function(E){this.getModel().setData(E.getParameter("data"));if(this._createContentPromise){this._createContentPromise.then(function(x){x.onDataChanged();});}this.onDataRequestComplete();}.bind(this));this._oDataProvider.attachError(function(E){this._handleError("Data service unavailable. "+E.getParameter("message"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.triggerDataUpdate();}};
v.prototype._handleCardLoading=function(){var w=this.getCardContent();if(w&&!w.hasStyleClass("sapFCardErrorContent")&&w._oLoadingPlaceholder){var x=w.getAggregation("_content");if(x){x.removeStyleClass("sapFCardContentHidden");}w._oLoadingPlaceholder.destroy();}if(this._oLoadingProvider){this._oLoadingProvider.removeHeaderPlaceholder(this.getCardHeader());}this._oLoadingProvider.setLoading(false);};
v.prototype._applyServiceManifestSettings=function(){var w=this._oCardManifest.get(M.SERVICES);if(!w){return;}if(!this._oServiceManager){this._oServiceManager=new S(w,this);}};
v.prototype.getCardHeader=function(){return this.getAggregation("_header");};
v.prototype.getCardHeaderPosition=function(){if(!this._oCardManifest){return"Top";}return this._oCardManifest.get(M.HEADER_POSITION)||r.Top;};
v.prototype.getCardContent=function(){return this.getAggregation("_content");};
v.prototype._applyHeaderManifestSettings=function(){var w=this.createHeader();if(!w){this.fireEvent("_headerReady");return;}this.destroyAggregation("_header");this.setAggregation("_header",w);if(w.isReady()){this.fireEvent("_headerReady");}else{w.attachEvent("_ready",function(){this.fireEvent("_headerReady");}.bind(this));}};
v.prototype._applyFilterBarManifestSettings=function(){var w=this.createFilterBar();this.destroyAggregation("_filterBar");if(!w){return;}this.setAggregation("_filterBar",w);};
v.prototype.getHostInstance=function(){var w=this.getHost();if(!w){return null;}return C.byId(w);};
v.prototype._applyContentManifestSettings=function(){var w=this._oCardManifest.get(M.TYPE),x=this.getContentManifest(),A=w+" "+this._oRb.getText("ARIA_ROLEDESCRIPTION_CARD");this._ariaText.setText(A);if(!x){this.fireEvent("_contentReady");return;}this._setTemporaryContent(w,x);this._createContentPromise=this.createContent({cardType:w,contentManifest:x,serviceManager:this._oServiceManager,dataProviderFactory:this._oDataProviderFactory,iconFormatter:this._oIconFormatter,appId:this._sAppId}).then(function(y){this._setCardContent(y);return y;}.bind(this));this._createContentPromise.catch(function(E){if(E){this._handleError(E);}}.bind(this));};
v.prototype.createHeader=function(){var w=this._oCardManifest.get(M.HEADER),x=new i(this);return x.create(w);};
v.prototype.createFilterBar=function(){var w=this.getManifestEntry("/sap.card/configuration/filters"),V=this._mFilters,x=new o(this);return x.create(w,V);};
v.prototype.getContentManifest=function(){var w=this._oCardManifest.get(M.TYPE),x=w&&w.toLowerCase()==="component",y=this._oCardManifest.get(M.CONTENT),z=!!y;if(z&&!w){L.error("Card type property is mandatory!");return null;}if(!z&&!x){return null;}if(!y&&x){y=this._oCardManifest.getJson();}return y;};
v.prototype.createContent=function(w){w.cardManifest=this._oCardManifest;return this._oContentFactory.create(w);};
v.prototype.onAfterRendering=function(){var w;if(this._oCardManifest&&this._oCardManifest.get(M.TYPE)){w=this._oCardManifest.get(M.TYPE).toLowerCase();}this.toggleStyleClass("sapFCardAnalytical",w==="analytical");};
v.prototype._setCardContent=function(w){w.attachEvent("_error",function(E){this._handleError(E.getParameter("logMessage"),E.getParameter("displayMessage"));}.bind(this));var P=this.getAggregation("_content");if(P&&P!==this._oTemporaryContent){P.destroy();}this.setAggregation("_content",w);if(w.isReady()){this.fireEvent("_contentReady");}else{w.attachEvent("_ready",function(){this.fireEvent("_contentReady");}.bind(this));}};
v.prototype._setTemporaryContent=function(w,x){var y=this._getTemporaryContent(w,x),P=this.getAggregation("_content");if(P&&P!==y){P.destroy();}this.setAggregation("_content",y);};
v.prototype._handleError=function(w,x){L.error(w);this.fireEvent("_error",{message:w});var y="Unable to load the data.",E=x||y,P=this.getAggregation("_content");var z=new H({justifyContent:"Center",alignItems:"Center",items:[new c({src:"sap-icon://message-error",size:"1rem"}).addStyleClass("sapUiTinyMargin"),new T({text:E})]}).addStyleClass("sapFCardErrorContent");if(P&&!P.hasStyleClass("sapFCardErrorContent")){P.destroy();this.fireEvent("_contentReady");}z.addEventDelegate({onAfterRendering:function(){if(!this._oCardManifest){return;}var A=this._oCardManifest.get(M.TYPE),G=this._oCardManifest.get(M.CONTENT),K=this._oContentFactory.getClass(A).getMetadata().getRenderer().getMinHeight(G,z);if(this.getHeight()==="auto"){z.$().css({"min-height":K});}}},this);this.setAggregation("_content",z);};
v.prototype._getTemporaryContent=function(w,x){if(!this._oTemporaryContent&&this._oLoadingProvider){this._oTemporaryContent=this._oLoadingProvider.createContentPlaceholder(x,w);this._oTemporaryContent.addEventDelegate({onAfterRendering:function(){if(!this._oCardManifest){return;}var y=this._oContentFactory.getClass(w).getMetadata().getRenderer().getMinHeight(x,this._oTemporaryContent);if(this.getHeight()==="auto"){this._oTemporaryContent.$().css({"min-height":y});}}},this);}return this._oTemporaryContent;};
v.prototype.setDataMode=function(w){if(this._oDataProviderFactory&&w===s.Inactive){this._oDataProviderFactory.destroy();this._oDataProviderFactory=null;}this.setProperty("dataMode",w,true);if(this.getProperty("dataMode")===s.Active){this.refresh();}return this;};
v.prototype.loadDesigntime=function(){if(this._oDesigntime){return Promise.resolve(this._oDesigntime);}if(!this._oCardManifest){return new Promise(function(w,x){this.attachManifestReady(function(){this.loadDesigntime().then(w,x);}.bind(this));}.bind(this));}var A=this._oCardManifest.get("/sap.app/id");if(!A){return Promise.reject("App id not maintained");}return new Promise(function(w,x){var y=this._oCardManifest.get("/sap.card/designtime"),z=this._oCardManifest.get("/sap.app/id").replace(/\./g,"/")+"/"+y;if(z){sap.ui.require([z],function(E){E._readyPromise(this._oLimitedInterface,this).then(function(){this._oDesigntime=E;w(E);}.bind(this));}.bind(this),function(){x({error:z+" not found"});});}else{x();}}.bind(this));};
v.prototype.isLoading=function(){return this._oLoadingProvider?this._oLoadingProvider.getLoadingState():false;};
v.prototype.getFocusDomRef=function(){return this.getCardHeader()?this.getCardHeader().getDomRef():this.getDomRef();};
v.prototype.onDataRequested=function(){this._oLoadingProvider.createLoadingState(this._oDataProvider);};
v.prototype.onDataRequestComplete=function(){this.fireEvent("_cardReady");this._handleCardLoading();this._oLoadingProvider.setLoading(false);};
v.prototype.request=function(w){return this._oDataProviderFactory.create({request:w}).setAllowCustomDataType(true).getData();};
v.prototype.onfocusin=function(){this._startBadgeHiding();};
v.prototype._startBadgeHiding=function(){if(this._iHideBadgeTimeout){return;}this._iHideBadgeTimeout=setTimeout(this._hideBadge.bind(this),u);};
v.prototype._hideBadge=function(){var w=this.getBadgeCustomData();if(w){w.setVisible(false);}this._iHideBadgeTimeout=null;};
v.prototype.onBadgeUpdate=function(V,w,x){var y=this.getCardHeader(),z,A;if(y){z=y.getDomRef();}else{z=this.getDomRef("contentSection");}if(!z){return;}A=z.getAttribute("aria-labelledby")||"";switch(w){case t.Appear:A=x+" "+A;z.setAttribute("aria-labelledby",A);break;case t.Disappear:A=A.replace(x,"").trim();z.setAttribute("aria-labelledby",A);break;}};
v.prototype.getAriaLabelBadgeText=function(){return this.getBadgeCustomData().getValue();};
return v;});
sap.ui.require.preload({
	"sap/ui/integration/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.integration","type":"library","embeds":[],"applicationVersion":{"version":"1.82.2"},"title":"SAPUI5 library with integration-related controls.","description":"SAPUI5 library with integration-related controls.","ach":"CA-UI5-CTR","resources":"resources.json","offline":true,"openSourceComponents":[{"name":"webcomponentsjs","packagedWithMySelf":true,"version":"0.0.0"},{"name":"custom-event-polyfill","packagedWithMySelf":true,"version":"0.0.0"},{"name":"adaptive-cards","packagedWithMySelf":true,"version":"0.0.0"},{"name":"markdown-it","packagedWithMySelf":true,"version":"0.0.0"},{"name":"ui5-web-components","packagedWithMySelf":true,"version":"0.0.0"},{"name":"ajv","packagedWithMySelf":true,"version":"0.0.0"}]},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.82","libs":{"sap.ui.core":{"minVersion":"1.82.2"},"sap.f":{"minVersion":"1.82.2"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cs","da","de","el","en","en-US-sappsd","en-US-saptrc","es","et","fi","fr","hi","hr","hu","it","iw","ja","kk","ko","lt","lv","ms","nl","no","pl","pt","rigi","ro","ru","sh","sk","sl","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.ui.integration.widgets.Card","sap.ui.integration.cards.Header","sap.ui.integration.cards.NumericHeader","sap.ui.integration.controls.ListContentItem","sap.ui.integration.host.HostConfiguration"],"elements":["sap.ui.integration.Host"],"types":["sap.ui.integration.CardActionType","sap.ui.integration.CardDataMode","sap.ui.integration.CardMenuAction"]}}}}',
	"sap/ui/integration/customElements/CustomElementCard.js":function(){sap.ui.require(["sap/ui/integration/widgets/Card","sap/ui/integration/customElements/CustomElementBase","sap/ui/integration/customElements/CustomElementHostConfiguration","sap/m/BadgeCustomData"],function(C,a,b,B){"use strict";var c=a.extend(C,{privateProperties:["width","height"],customProperties:{"badge":{set:function(o,v){o.addCustomData(new B({value:v}));}}}});c.prototype.refresh=function(){this._getControl().refresh();};c.prototype.loadDesigntime=function(){return this._getControl().loadDesigntime();};var d=["ui-integration-host-configuration"];a.define("ui-integration-card",c,d);});
},
	"sap/ui/integration/customElements/CustomElementHostConfiguration.js":function(){sap.ui.require(["sap/ui/integration/customElements/CustomElementBase","sap/ui/integration/host/HostConfiguration"],function(C,H){"use strict";var a=C.extend(H);C.define("ui-integration-host-configuration",a,[]);});
},
	"sap/ui/integration/library-bootstrap.js":function(){(function(w){"use strict";var c;var s=document.currentScript||document.querySelector("script[src*='/sap-ui-integration.js']");
function b(){if(w.sap&&w.sap.ui&&w.sap.ui.getCore){c=w.sap.ui.getCore();return a();}w.sap.ui.require(['sap/ui/core/Core'],function(C){C.boot();c=C;C.attachInit(function(){a();});});}
function r(l){var L=c.getLoadedLibraries()[l];var t=Object.keys(L.customElements),T=s.getAttribute("tags");if(T){t=T.split(",");}w.sap.ui.require(t.map(function(o,i){return L.customElements[t[i]];}));}
function a(){c.loadLibraries(["sap/ui/integration"],{async:true}).then(function(){r("sap.ui.integration");});}
b();})(window);
},
	"sap/ui/integration/sap-ui-integration-config.js":function(){window["sap-ui-config"]=window["sap-ui-config"]||{};window["sap-ui-config"].bindingSyntax="complex";window["sap-ui-config"].compatVersion="edge";window["sap-ui-config"].async=true;window["sap-ui-config"]["xx-waitForTheme"]=true;
},
	"sap/ui/integration/sap-ui-integration-define-nojQuery.js":function(){(function(){"use strict";sap["ui"].define("sap/ui/thirdparty/jquery",function(){return jQuery;});sap["ui"].define("sap/ui/thirdparty/jqueryui/jquery-ui-position",function(){return jQuery;});})();
}
},"sap/ui/integration/library-preload"
);
//# sourceMappingURL=library-preload.js.map