/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler","sap/ui/fl/initial/_internal/StorageUtils","sap/ui/fl/Change","sap/ui/fl/Layer","sap/ui/fl/Variant","sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/Cache","sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/write/_internal/Storage","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Component","sap/ui/model/json/JSONModel","sap/ui/performance/Measurement","sap/ui/thirdparty/jquery","sap/base/util/includes","sap/base/util/merge","sap/base/util/UriParameters","sap/base/Log","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/write/_internal/condenser/Condenser"],function(D,S,C,L,V,U,a,b,A,c,J,d,e,M,q,i,m,f,g,h,j){"use strict";var k=function(n){this._mComponent=n;this._mChanges=D.createEmptyDependencyMap();this._bChangesMapCreated=false;this._mChangesInitial=m({},this._mChanges);this._mVariantsChanges={};if(!this._mComponent||!this._mComponent.name){g.error("The Control does not belong to an SAPUI5 component. Personalization and changes for this control might not work as expected.");throw new Error("Missing component name.");}this._aDirtyChanges=[];this._oMessagebundle=undefined;this._mChangesEntries={};this._bHasChangesOverMaxLayer=false;this.HIGHER_LAYER_CHANGES_EXIST="higher_layer_changes_exist";};function r(v,o){return v.controlChanges.some(function(n,p){if(n.fileName===o.getDefinition().fileName){v.controlChanges.splice(p,1,o);return true;}});}function l(F,o){var n;if(o instanceof C){n=o;this._mChangesEntries[n.getFileName()]=n;}else{if(!this._mChangesEntries[o.fileName]){this._mChangesEntries[o.fileName]=new C(o);}n=this._mChangesEntries[o.fileName];n.setState(C.states.PERSISTED);var v=n.getVariantReference();if(v){var p=h.getVariant({vReference:v,reference:this._mComponent.name});if(p){r(p,n);}}}return n;}k.prototype.getComponentName=function(){return this._mComponent.name;};k.prototype.getCacheKey=function(o){return b.getCacheKey(this._mComponent,o);};k.prototype._preconditionsFulfilled=function(I,o){var n=o instanceof C?o.getDefinition():o;if(!n.fileName){g.warning("A change without fileName is detected and excluded from component: "+this._mComponent.name);return false;}function _(){if(I){return(n.fileType==="change")||(n.fileType==="variant");}return(n.fileType==="change")&&(n.changeType!=="defaultVariant");}function p(){if(I){if((n.fileType==="variant")||(n.changeType==="defaultVariant")){return n.selector&&n.selector.persistencyKey;}}return true;}function t(){if((n.fileType==="ctrl_variant")||(n.fileType==="ctrl_variant_change")||(n.fileType==="ctrl_variant_management_change")){return n.variantManagementReference||n.variantReference||(n.selector&&n.selector.id);}}if(_()&&p()||t()){return true;}return false;};k.prototype.getChangesForComponent=function(p,I){return b.getChangesFillingCache(this._mComponent,p,I).then(function(p,w){var o=m({},w);var n=p&&p.component&&U.getAppComponentForControl(p.component);var H=S.isStorageResponseFilled(o.changes);if(!H){return[];}var t=o.changes.changes;if(!this._oMessagebundle&&o.messagebundle&&n){if(!n.getModel("i18nFlexVendor")){if(t.some(function(E){return E.layer===L.VENDOR;})){this._oMessagebundle=o.messagebundle;var u=new e(this._oMessagebundle);n.setModel(u,"i18nFlexVendor");}}}var v=p&&p.currentLayer;var F=!(p&&p.ignoreMaxLayerParameter);var x=function(){return true;};if(v){x=this._filterChangeForCurrentLayer.bind(this,v);t=t.filter(x);}else if(a.isLayerFilteringRequired()&&F){x=this._filterChangeForMaxLayer.bind(this);t=t.filter(x);}else if(this._bHasChangesOverMaxLayer&&!F){this._bHasChangesOverMaxLayer=false;return this.HIGHER_LAYER_CHANGES_EXIST;}var y=o.changes&&p&&p.includeCtrlVariants;var z=this._getAllCtrlVariantChanges(o,y,x);t=t.concat(z);var B=p&&p.includeVariants;return this._checkAndGetChangeInstances(t,B,o);}.bind(this,p));};k.prototype._checkAndGetChangeInstances=function(n,I,o){return n.filter(this._preconditionsFulfilled.bind(this,I)).map(l.bind(this,o));};k.prototype._filterChangeForMaxLayer=function(o){if(a.isOverMaxLayer(this._getLayerFromChangeOrChangeContent(o))){if(!this._bHasChangesOverMaxLayer){this._bHasChangesOverMaxLayer=true;}return false;}return true;};k.prototype._filterChangeForCurrentLayer=function(n,o){return n===this._getLayerFromChangeOrChangeContent(o);};k.prototype._getLayerFromChangeOrChangeContent=function(o){var n;if(o instanceof V||o instanceof C){n=o.getLayer();}else{n=o.layer;}return n;};k.prototype._getAllCtrlVariantChanges=function(o,I,F){if(!I){return h.getInitialChanges({reference:this._mComponent.name});}return["variants","variantChanges","variantDependentControlChanges","variantManagementChanges"].reduce(function(R,v){if(o.changes[v]){return R.concat(o.changes[v]);}return R;},[]).filter(F);};k.prototype.getSmartVariantManagementChangeMap=function(){return this._mVariantsChanges;};k.prototype.getControlChangesForVariant=function(n,o,p){if(this._mVariantsChanges[o]){return Promise.resolve(this._mVariantsChanges[o]);}var t=function(v){var w=false;var x=v._oDefinition.selector;q.each(x,function(y,z){if(y===n&&z===o){w=true;}});return w;};var u=function(v,w){g.error("key : "+v+" and text : "+w.value);};return this.getChangesForComponent(p).then(function(v){return v.filter(t);}).then(function(v){if(!this._mVariantsChanges[o]){this._mVariantsChanges[o]={};}var I;v.forEach(function(w){I=w.getId();if(w.isValid()){if(this._mVariantsChanges[o][I]&&w.isVariant()){g.error("Id collision - two or more variant files having the same id detected: "+I);q.each(w.getDefinition().texts,u);g.error("already exists in variant : ");q.each(this._mVariantsChanges[o][I].getDefinition().texts,u);}this._mVariantsChanges[o][I]=w;}}.bind(this));return this._mVariantsChanges[o];}.bind(this));};k.prototype.addChangeForVariant=function(n,o,p){var F;var I;var t;var u;var v;if(!p){return undefined;}if(!p.type){g.error("sap.ui.fl.Persistence.addChange : type is not defined");}var w=typeof p.content;if(!p.content||(w!=='object'&&!Array.isArray(p.content))){g.error("mParameters.content is not of expected type object or array, but is: "+w,"sap.ui.fl.Persistence#addChange");}t={};if(typeof(p.texts)==="object"){q.each(p.texts,function(y,z){t[y]={value:z,type:"XFLD"};});}var x={creation:this._mComponent.appVersion,from:this._mComponent.appVersion};if(this._mComponent.appVersion&&p.developerMode){x.to=this._mComponent.appVersion;}I={changeType:p.type,service:p.ODataService,texts:t,content:p.content,reference:this._mComponent.name,isVariant:p.isVariant,packageName:p.packageName,isUserDependent:p.isUserDependent,validAppVersions:x};I.selector={};I.selector[n]=o;F=C.createInitialFileContent(I);if(p.id){F.fileName=p.id;}u=new C(F);v=u.getId();if(!this._mVariantsChanges[o]){this._mVariantsChanges[o]={};}this._mVariantsChanges[o][v]=u;return u.getId();};k.prototype.saveAllChangesForVariant=function(n){var p=[];q.each(this._mVariantsChanges[n],function(o,t){var u=t.getId();switch(t.getPendingAction()){case"NEW":var v=c.write({flexObjects:[t.getDefinition()],layer:t.getLayer(),transport:t.getRequest(),isLegacyVariant:t.isVariant()}).then(function(y){if(y&&y.response&&y.response[0]){t.setResponse(y.response[0]);}else{t.setState(C.states.PERSISTED);}b.addChange({name:this._mComponent.name,appVersion:this._mComponent.appVersion},t.getDefinition());return y;}.bind(this));p.push(v);break;case"UPDATE":var w=c.update({flexObject:t.getDefinition(),layer:t.getLayer(),transport:t.getRequest()}).then(function(y){if(y&&y.response){t.setResponse(y.response);}else{t.setState(C.states.PERSISTED);}b.updateChange({name:this._mComponent.name,appVersion:this._mComponent.appVersion},t.getDefinition());return y;}.bind(this));p.push(w);break;case"DELETE":var x=c.remove({flexObject:t.getDefinition(),layer:t.getLayer(),transport:t.getRequest()}).then(function(y){var t=this._mVariantsChanges[n][u];if(t.getPendingAction()==="DELETE"){delete this._mVariantsChanges[n][u];}b.deleteChange({name:this._mComponent.name,appVersion:this._mComponent.appVersion},t.getDefinition());return y;}.bind(this));p.push(x);break;default:break;}}.bind(this));return Promise.all(p);};k.prototype.loadChangesMapForComponent=function(o){return this.getChangesForComponent({component:o}).then(n.bind(this));function n(p){M.start("fl.createDependencyMap","Measurement of creating initial dependency map");this._mChanges=D.createEmptyDependencyMap();p.forEach(this._addChangeAndUpdateDependencies.bind(this,o));this._mChangesInitial=m({},this._mChanges);M.end("fl.createDependencyMap","Measurement of creating initial dependency map");this._bChangesMapCreated=true;return this.getChangesMapForComponent.bind(this);}};k.prototype.checkForOpenDependenciesForControl=function(o,n){return D.checkForOpenDependenciesForControl(this._mChanges,J.getControlIdBySelector(o,n),n);};k.prototype.copyDependenciesFromInitialChangesMap=function(o,n,p){var I=m({},this._mChangesInitial.mDependencies);var t=I[o.getId()];if(t){var N=[];t.dependencies.forEach(function(w){if(n(w)){this._mChanges.mDependentChangesOnMe[w]=this._mChanges.mDependentChangesOnMe[w]||[];this._mChanges.mDependentChangesOnMe[w].push(o.getId());N.push(w);}}.bind(this));var u;var v=[];t.controlsDependencies.forEach(function(w){if(!J.bySelector(w,p)){u=J.getControlIdBySelector(w,p);v.push(w);this._mChanges.mControlsWithDependencies[u]=this._mChanges.mControlsWithDependencies[u]||[];if(!i(this._mChanges.mControlsWithDependencies[u],o.getId())){this._mChanges.mControlsWithDependencies[u].push(o.getId());}}}.bind(this));t.dependencies=N;t.controlsDependencies=v;if(N.length||v.length){this._mChanges.mDependencies[o.getId()]=t;}}return this._mChanges;};k.prototype._addChangeAndUpdateDependencies=function(o,n){n.setInitialApplyState();D.addChangeAndUpdateDependencies(n,o,this._mChanges);};k.prototype._addRunTimeCreatedChangeAndUpdateDependencies=function(o,n){D.addRuntimeChangeAndUpdateDependencies(n,o,this._mChanges,this._mChangesInitial);};k.prototype.getChangesMapForComponent=function(){return this._mChanges;};k.prototype.isChangeMapCreated=function(){return this._bChangesMapCreated;};k.prototype.changesHavingCorrectViewPrefix=function(p,o){var n=p.modifier;var t=p.appComponent;var u=o.getSelector();if(!u||!p){return false;}if(u.viewSelector){var v=n.getControlIdBySelector(u.viewSelector,t);return v===p.viewId;}var w=u.id;if(w){var x;if(o.getSelector().idIsLocal){if(t){x=t.getLocalId(p.viewId);}}else{x=p.viewId;}var I=0;var y;do{I=w.indexOf("--",I);y=w.slice(0,I);I++;}while(y!==x&&I>0);return y===x;}return false;};k.prototype.getChangesForView=function(p){return this.getChangesForComponent(p).then(function(n){return n.filter(this.changesHavingCorrectViewPrefix.bind(this,p));}.bind(this));};k.prototype.addChange=function(v,o){var n=this.addDirtyChange(v);this._addRunTimeCreatedChangeAndUpdateDependencies(o,n);this._addPropagationListener(o);return n;};k.prototype.addDirtyChange=function(v){var n;if(v instanceof C||v instanceof V){n=v;}else{n=new C(v);}if(this._aDirtyChanges.indexOf(n)===-1){this._aDirtyChanges.push(n);}return n;};k.prototype._addPropagationListener=function(o){var n=U.getAppComponentForControl(o);if(n instanceof d){var p=function(P){return!P._bIsSapUiFlFlexControllerApplyChangesOnControl;};var N=n.getPropagationListeners().every(p);if(N){var t=n.getManifestObject();var v=U.getAppVersionFromManifest(t);var F=sap.ui.require("sap/ui/fl/FlexControllerFactory");var u=F.create(this.getComponentName(),v);var P=A.applyAllChangesForControl.bind(A,this.getChangesMapForComponent.bind(this),n,u);P._bIsSapUiFlFlexControllerApplyChangesOnControl=true;n.addPropagationListener(P);}}};k.prototype._deleteNotSavedChanges=function(n,o){n.filter(function(p){return!o.some(function(t){return p.getId()===t.getId();});}).forEach(function(p){this.deleteChange(p,true);}.bind(this));};function s(o,n){var p=false;if(!o||n.length<2){return false;}var t=n.map(function(w){return w.getLayer();});var u=t.filter(function(w,I,t){return t.indexOf(w)===I;});if(u.length>1){return false;}if(u[0]==="CUSTOMER"||u[0]==="USER"){p=true;}var v=f.fromURL(window.location.href);if(v.has("sap-ui-xx-condense-changes")){p=v.get("sap-ui-xx-condense-changes")==="true";}return p;}k.prototype.saveDirtyChanges=function(o,n,p,t){p=p||this._aDirtyChanges;var u=p.slice(0);var R=this._getRequests(p);var P=this._getPendingActions(p);if(P.length===1&&R.length===1&&P[0]==="NEW"){var v=Promise.resolve(u);if(s(o,u)){v=j.condense(o,u);}return v.then(function(w){if(w.length){var x=R[0];var y=this._prepareDirtyChanges(w);return c.write({layer:y[0].layer,flexObjects:y,transport:x,isLegacyVariant:false,draft:t}).then(function(z){this._massUpdateCacheAndDirtyState(w,n);this._deleteNotSavedChanges(p,w);return z;}.bind(this));}this._deleteNotSavedChanges(p,w);}.bind(this));}return this.saveSequenceOfDirtyChanges(u,n,t);};k.prototype.saveSequenceOfDirtyChanges=function(n,o,p){return n.reduce(function(P,t){return P.then(this._performSingleSaveAction(t,p)).then(this._updateCacheAndDirtyState.bind(this,t,o));}.bind(this),Promise.resolve());};k.prototype._performSingleSaveAction=function(o,n){return function(){if(o.getPendingAction()==="NEW"){return c.write({layer:o.getLayer(),flexObjects:[o.getDefinition()],transport:o.getRequest(),isLegacyVariant:o.isVariant(),draft:n});}if(o.getPendingAction()==="DELETE"){return c.remove({flexObject:o.getDefinition(),layer:o.getLayer(),transport:o.getRequest()});}};};k.prototype._updateCacheAndDirtyState=function(o,n){if(!n){if(U.isChangeRelatedToVariants(o)){h.updateVariantsState({reference:this._mComponent.name,changeToBeAddedOrDeleted:o});}else if(o.getPendingAction()==="NEW"){b.addChange(this._mComponent,o.getDefinition());}else if(o.getPendingAction()==="DELETE"){b.deleteChange(this._mComponent,o.getDefinition());}}this._aDirtyChanges=this._aDirtyChanges.filter(function(E){return o.getId()!==E.getId();});};k.prototype._massUpdateCacheAndDirtyState=function(n,o){n.forEach(function(p){this._updateCacheAndDirtyState(p,o);},this);};k.prototype._getRequests=function(n){var R=[];n.forEach(function(o){var p=o.getRequest();if(R.indexOf(p)===-1){R.push(p);}});return R;};k.prototype._getPendingActions=function(n){var p=[];n.forEach(function(o){var P=o.getPendingAction();if(p.indexOf(P)===-1){p.push(P);}});return p;};k.prototype._prepareDirtyChanges=function(n){var o=[];n.forEach(function(p){o.push(p.getDefinition());});return o;};k.prototype.getDirtyChanges=function(){return this._aDirtyChanges;};k.prototype.deleteChange=function(o,R){var n=this._aDirtyChanges.indexOf(o);if(n>-1){if(o.getPendingAction()==="DELETE"){return;}this._aDirtyChanges.splice(n,1);this._deleteChangeInMap(o,R);return;}o.markForDeletion();this.addDirtyChange(o);this._deleteChangeInMap(o,R);};k.prototype._deleteChangeInMap=function(o,R){var n=o.getId();D.removeChangeFromMap(this._mChanges,n);D.removeChangeFromDependencies(R?this._mChangesInitial:this._mChanges,n);};k.prototype.transportAllUIChanges=function(R,n,o,p){return this.getChangesForComponent({currentLayer:o,includeCtrlVariants:true}).then(function(t){return c.publish({transportDialogSettings:{rootControl:R,styleClass:n},layer:o,reference:this.getComponentName(),appVersion:this._mComponent.appVersion,localChanges:t,appVariantDescriptors:p});}.bind(this));};k.prototype._getChangesFromMapByNames=function(n){return this._mChanges.aChanges.filter(function(o){return n.indexOf(o.getFileName())!==-1;});};k.prototype.resetChanges=function(n,G,o,p){var t=o&&o.length>0;var u=p&&p.length>0;if(!G&&!t&&!u){g.error("Of the generator, selector IDs and change types parameters at least one has to filled");return Promise.reject("Of the generator, selector IDs and change types parameters at least one has to filled");}return this.getChangesForComponent({currentLayer:n,includeCtrlVariants:true}).then(function(v){var P={reference:this.getComponentName(),appVersion:this._mComponent.appVersion,layer:n,changes:v};if(G){P.generator=G;}if(t){P.selectorIds=o;}if(u){P.changeTypes=p;}return c.reset(P);}.bind(this)).then(function(R){var v=[];if(o||p){var N=[];if(R&&R.response&&R.response.length>0){R.response.forEach(function(w){N.push(w.fileName);});}b.removeChanges(this._mComponent,N);v=this._getChangesFromMapByNames(N);}return v;}.bind(this));};k.prototype.getResetAndPublishInfo=function(p){return c.getFlexInfo(p);};return k;},true);
