/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./ListBase','./library','sap/ui/model/ClientTreeBindingAdapter','sap/ui/model/TreeBindingCompatibilityAdapter','./TreeRenderer',"sap/base/Log","sap/base/assert"],function(L,l,C,T,a,b,c){"use strict";var d=L.extend("sap.m.Tree",{metadata:{library:"sap.m",events:{toggleOpenState:{parameters:{itemIndex:{type:"int"},itemContext:{type:"object"},expanded:{type:"boolean"}}}}}});d.prototype.isTreeBinding=function(n){return(n=="items");};d.prototype.getBinding=function(n){n=n||"items";var B=L.prototype.getBinding.call(this,n);if(B&&n==="items"&&!B.getLength){if(B.isA("sap.ui.model.odata.v2.ODataTreeBinding")){B.applyAdapterInterface();}else if(B.isA("sap.ui.model.ClientTreeBinding")){C.apply(B);}else if(B.isA("sap.ui.model.odata.ODataTreeBinding")){T(B,this);}else{b.error("TreeBinding is not supported for the "+this);}}return B;};d.prototype.updateAggregation=function(n){if(n!="items"){return L.prototype.updateAggregation.apply(this,arguments);}var B=this.getBindingInfo("items"),o=this.getBinding("items"),f=B.factory,e;function u(g,e){var h=g.getItems()||[],j,k;if(h.length>e.length){for(var i=e.length;i<h.length;i++){g.removeItem(h[i]);h[i].destroy("KeepDom");}}for(var i=0;i<e.length;i++){j=e[i];k=h[i];if(k){k.setBindingContext(j,B.model);}else{k=f(g.getId()+"-"+i,j);k.setBindingContext(j,B.model);g.addItem(k);}}}e=o.getContexts(0);if(!B.template){this.destroyItems();}u(this,e);};d.prototype.validateAggregation=function(A,o,m){var r=L.prototype.validateAggregation.apply(this,arguments);if(A==="items"&&!o.isA("sap.m.TreeItemBase")){throw new Error(o+" is not a valid items aggregation of "+this+". Items aggregation in Tree control only supports TreeItemBase-based objects, e.g. StandardTreeItem.");}return r;};d.prototype.invalidate=function(){L.prototype.invalidate.apply(this,arguments);this._bInvalidated=true;};d.prototype.onAfterRendering=function(){L.prototype.onAfterRendering.apply(this,arguments);this._bInvalidated=false;};d.prototype._updateDeepestLevel=function(i){if(i.getLevel()+1>this.getDeepestLevel()){this._iDeepestLevel=i.getLevel()+1;}};d.prototype.onItemExpanderPressed=function(i,e){var I=this.indexOfItem(i);var B=this.getBindingInfo("items");var o=i&&i.getBindingContext(B.model);if(B&&o){var E=i.getExpanded();var f;this._updateDeepestLevel(i);var g=this.getBinding("items");if(e==undefined){g.toggleIndex(I);}else if(e){g.expand(I);}else{g.collapse(I);}f=g.isExpanded(I);if(E!==f&&!i.isLeaf()){this.fireToggleOpenState({itemIndex:I,itemContext:o,expanded:f});}}};d.prototype.setGrowing=function(v){b.error("Growing feature of "+this+" is not supported!");return this;};d.prototype.setGrowingThreshold=function(v){b.error("GrowingThreshold of "+this+" is not supported!");return this;};d.prototype.setGrowingTriggerText=function(v){b.error("GrowingTriggerText of "+this+" is not supported!");return this;};d.prototype.setGrowingScrollToLoad=function(v){b.error("GrowingScrollToLoad of "+this+" is not supported!");return this;};d.prototype.setGrowingDirection=function(v){b.error("GrowingDirection of "+this+" is not supported!");return this;};d.prototype.expandToLevel=function(i){var B=this.getBinding("items");c(B&&B.expandToLevel,"Tree.expandToLevel is not supported with your current Binding. Please check if you are running on an ODataModel V2.");if(B&&B.expandToLevel&&B.getNumberOfExpandedLevels){if(B.getNumberOfExpandedLevels()>i){B.collapseToLevel(0);}B.expandToLevel(i);}return this;};d.prototype.getNumberOfExpandedLevel=function(){return this.getBinding("items").getNumberOfExpandedLevels();};d.prototype.getDeepestLevel=function(){if(this._iDeepestLevel===undefined){this._iDeepestLevel=this.getNumberOfExpandedLevel();}return this._iDeepestLevel;};d.prototype.collapseAll=function(){var B=this.getBinding("items");c(B&&B.expandToLevel,"Tree.collapseAll is not supported with your current Binding. Please check if you are running on an ODataModel V2.");if(B){B.collapseToLevel(0);}return this;};d.prototype._sortHelper=function(p){var i=[];if(typeof p==="number"){i.push(p);}else if(Array.isArray(p)){i=p.sort().reverse();}return i;};d.prototype._removeLeaf=function(s){var I=null,e,f=[];for(var i=0;i<s.length;i++){e=s[i];I=this.getItems()[e];if(I&&!I.isLeaf()){f.push(e);}}return f;};d.prototype._preExpand=function(p){var i=this._sortHelper(p);i=this._removeLeaf(i);return i;};d.prototype.expand=function(p){var B=this.getBinding("items");if(B&&B.expand){var I=this._preExpand(p),o;if(I.length>0){for(var i=0;i<I.length-1;i++){o=this.getItems()[I[i]];this._updateDeepestLevel(o);B.expand(I[i],true);}o=this.getItems()[I[I.length-1]];this._updateDeepestLevel(o);B.expand(I[I.length-1],false);}}return this;};d.prototype.collapse=function(p){var B=this.getBinding("items");if(B&&B.collapse){var I=this._preExpand(p);for(var i=0;i<I.length-1;i++){B.collapse(I[i],true);}B.collapse(I[I.length-1],false);}return this;};d.prototype.getAccessibilityType=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_TREE");};d.prototype.getAccessbilityPosition=function(i){var s,p,n=i.getItemNodeContext();if(n.parent){s=n.parent.children.length;}if(n.positionInParent!=undefined){p=n.positionInParent+1;}return{setSize:s,posInset:p};};d.prototype.onItemLongDragOver=function(i){var I=this.indexOfItem(i),B=this.getBinding("items"),o=this.getBindingInfo("items"),e=i&&i.getBindingContext(o.model);if(i){this._updateDeepestLevel(i);if(!i.isLeaf()){B.expand(I);this.fireToggleOpenState({itemIndex:I,itemContext:e,expanded:B.isExpanded(I)});}}};d.prototype.isGrouped=function(){return false;};return d;});
