/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./ComboBoxTextField','./ComboBoxBase','./List','./library','sap/ui/Device','sap/ui/core/Item','./StandardListItem','./ComboBoxRenderer','sap/ui/base/ManagedObjectObserver',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","./Toolbar","sap/base/assert","sap/base/security/encodeXML","sap/ui/core/Core","sap/base/Log","sap/ui/dom/jquery/control"],function(C,a,L,l,D,I,S,b,M,c,K,T,d,f,g,h,q){"use strict";var j=l.ListType;var k=l.ListMode;var m=a.extend("sap.m.ComboBox",{metadata:{library:"sap.m",designtime:"sap/m/designtime/ComboBox.designtime",properties:{selectedKey:{type:"string",group:"Data",defaultValue:""},selectedItemId:{type:"string",group:"Misc",defaultValue:""},filterSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false}},events:{change:{parameters:{value:{type:"string"},itemPressed:{type:"boolean"}}},selectionChange:{parameters:{selectedItem:{type:"sap.ui.core.Item"}}}},dnd:{draggable:false,droppable:true}}});function H(o,i){if(!i){return;}var e=o.getFocusDomRef(),p=o._getSelectionRange().start,t=e.value.substring(0,e.selectionStart),r=o._shouldResetSelectionStart(i),u=o.getSelectedItem(),G=i.isA("sap.ui.core.SeparatorItem"),v=this.getListItem(i);o.handleListItemsVisualFocus(v);o.setSelection(i);if(i!==u&&!G){o.updateDomValue(i.getText());o.fireSelectionChange({selectedItem:i});i=o.getSelectedItem();if(r){p=0;}o.selectText(p,e.value.length);o._bIsLastFocusedItemHeader=false;}if(G){o.setSelectedItem(null);o.fireSelectionChange({selectedItem:null});o.updateDomValue(t);o._bIsLastFocusedItemHeader=true;o._getGroupHeaderInvisibleText().setText(o._oRb.getText("LIST_ITEM_GROUP_HEADER")+" "+i.getText());}if(o.isOpen()){o.removeStyleClass("sapMFocus");o._getList().addStyleClass("sapMListFocus");}else{o.addStyleClass("sapMFocus");}o.scrollToItem(i);}m.prototype.scrollToItem=function(i){var p=this.getPicker(),P=p.getDomRef("cont"),o=this.getListItem(i),e=i&&o&&o.getDomRef();if(!p||!P||!e){return;}var r=P.scrollTop,t=e.offsetTop,u=P.clientHeight,v=e.offsetHeight;if(r>t){P.scrollTop=t;}else if((t+v)>(r+u)){P.scrollTop=Math.ceil(t+v-u);}};function s(i,e){if(document.activeElement===this.getFocusDomRef()){this.selectText(i,e);}}function n(i){var o=this.getSelectedItem(),e=this.getListItem(o),p=o&&e&&e.getDomRef(),r=p&&p.offsetTop,t=p&&p.offsetHeight,P=this.getPicker(),u=P.getDomRef("cont"),v=u.clientHeight;if(o&&((r+t)>(v))){if(!i){this._getList().$().css("visibility","hidden");}else{u.scrollTop=r-t/2;this._getList().$().css("visibility","visible");}}}m.prototype._getSelectedItemText=function(i){i=i||this.getSelectedItem();if(!i){i=this.getDefaultSelectedItem();}if(i){return i.getText();}return"";};m.prototype._setItemVisibility=function(i,v){var o=i&&this.getListItem(i).$(),e="sapMSelectListItemBaseInvisible";if(v){i.bVisible=true;o.length&&o.removeClass(e);}else{i.bVisible=false;o.length&&o.addClass(e);}};m.prototype.setSelectedIndex=function(i,_){var o;_=_||this.getItems();i=(i>_.length-1)?_.length-1:Math.max(0,i);o=_[i];if(o){this.setSelection(o);}};m.prototype.revertSelection=function(){var p,P=this.getPickerTextField();this.setSelectedItem(this._oSelectedItemBeforeOpen);this.setValue(this._sValueBeforeOpen);if(this.getSelectedItem()===null){p=this._sValueBeforeOpen;}else{p=this._oSelectedItemBeforeOpen.getText();}P&&P.setValue(p);};m.prototype.filterItems=function(o){var i=this.getItems(),F=[],e=[],p=o.properties.indexOf("additionalText")>-1,r=this.fnFilter||a.DEFAULT_TEXT_FILTER,G=[],t=false;this._oFirstItemTextMatched=null;i.forEach(function(u){if(u.isA("sap.ui.core.SeparatorItem")){if(!u.getText()){this.getListItem(u).setVisible(false);return;}G.push({separator:u,show:false});t=true;this.getListItem(u).setVisible(false);return;}var v=r.call(this,o.value,u,"getText");var w=r.call(this,o.value,u,"getAdditionalText");if((v||w)&&t){G[G.length-1].show=true;t=false;}if(v){e.push(u);F.push(u);}else if(w&&p){F.push(u);}}.bind(this));i.forEach(function(u){if(u.isA("sap.ui.core.SeparatorItem")){return;}var v=F.indexOf(u)>-1;var w=e.indexOf(u)>-1;if(!this._oFirstItemTextMatched&&w){this._oFirstItemTextMatched=u;}this.getListItem(u).setVisible(v);},this);G.forEach(function(u){if(u.show){this.getListItem(u.separator).setVisible(true);}}.bind(this));return F;};m.prototype._filterStartsWithItems=function(i,e){var o=i.toLowerCase();var p=this.getItems(),F=p.filter(function(r){return r[e]&&r[e]().toLowerCase().startsWith(o);});return F;};m.prototype._getFilters=function(){return this.getFilterSecondaryValues()?["text","additionalText"]:["text"];};m.prototype.getNextFocusableItem=function(e){var A=this.getSelectableItems(),i=this.getNonSeparatorSelectableItems(A),F=this.hasStyleClass("sapMFocus"),o=this.getSelectedItem()||this._getItemByListItem(this._oLastFocusedListItem),p=this.getFormattedTextFocused(),N;if((F&&this.isOpen())||p){N=A[0];}else if(F&&!this.getValueStateLinks().length){N=i[i.indexOf(o)+(e?1:-1)];}else{N=A[A.indexOf(o)+(e?1:-1)];}if(p||(!p&&o===A[0]&&!e&&this.getValueStateLinks().length)){this.setProperty("formattedTextFocused",!p);}return N;};m.prototype.getNonSeparatorSelectableItems=function(i){return i.filter(function(o){return!o.isA("sap.ui.core.SeparatorItem");});};m.prototype._itemsTextStartsWithTypedValue=function(i,t){if(!i||typeof t!="string"||t==""){return false;}return i.getText().toLowerCase().startsWith(t.toLowerCase());};m.prototype._shouldResetSelectionStart=function(i){var o=this.getFocusDomRef(),e=this._getSelectionRange(),p=e.start!==e.end,t=o.value.substring(0,e.start),r=this._itemsTextStartsWithTypedValue(i,t);return!(r&&(p||this._bIsLastFocusedItemHeader));};m.prototype._getSelectionRange=function(){var o=this.getFocusDomRef(),v=this.getValue(),i=o.selectionStart,e=o.selectionEnd,r={start:i,end:e};if(!(D.browser.msie||D.browser.edge)){return r;}if(this._bIsLastFocusedItemHeader){r.start=v.length;r.end=v.length;}return r;};m.prototype.handleListItemsVisualFocus=function(o){if(this._oLastFocusedListItem){this._oLastFocusedListItem.removeStyleClass("sapMLIBFocused");this._oLastFocusedListItem=null;}else if(this.isOpen()&&this.getFocusDomRef()){this.getFocusDomRef().setAttribute("aria-activedescendant",o.getId());}if(o){this._oLastFocusedListItem=o;o.addStyleClass("sapMLIBFocused");}};m.prototype.setSelection=function(i){var o=this._getList(),e=this._getSuggestionsPopover(),p,r;this.setAssociation("selectedItem",i);this._setPropertyProtected("selectedItemId",(i instanceof I)?i.getId():i,true);if(typeof i==="string"){i=g.byId(i);}if(o){p=this.getListItem(i);if(p){o.setSelectedItem(p,true);}else{o.removeSelections(true);}}r=i?i.getKey():"";this._setPropertyProtected("selectedKey",r);if(e){e._iPopupListSelectedIndex=this.getItems().indexOf(i);}};m.prototype.isSelectionSynchronized=function(){var i=this.getSelectedItem();return this.getSelectedKey()===(i&&i.getKey());};m.prototype.isFiltered=function(){var o=this._getList();return o&&(o.getVisibleItems().length!==this.getItems().length);};m.prototype.isItemVisible=function(i){return i&&(i.bVisible===undefined||i.bVisible);};m.prototype._mapItemToListItem=function(i){var o,e,p,A;var r=this.getRenderer();if(!i){return null;}A=(i.getAdditionalText&&this.getShowSecondaryValues())?i.getAdditionalText():"";e=r.CSS_CLASS_COMBOBOXBASE+"Item";p=(this.isItemSelected(i))?e+"Selected":"";if(i.isA("sap.ui.core.SeparatorItem")){o=this._mapSeparatorItemToGroupHeader(i,r);}else{o=new S({type:j.Active,info:A,visible:i.getEnabled()}).addStyleClass(e+" "+p);}o.setTitle(i.getText());this.setSelectable(i,i.getEnabled());o.setTooltip(i.getTooltip());i.data(r.CSS_CLASS_COMBOBOXBASE+"ListItem",o);i.getCustomData().forEach(function(t){o.addCustomData(t.clone());});this._oItemObserver.observe(i,{properties:["text","additionalText","enabled","tooltip"]});return o;};m.prototype._forwardItemProperties=function(p){var i=p.object,o=i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"ListItem"),e={text:"title",enabled:"visible",tooltip:"tooltip"},A,P,r;if(Object.keys(e).indexOf(p.name)>-1){P=e[p.name];r="set"+P.charAt(0).toUpperCase()+P.slice(1);o[r](p.current);}if(p.name==="additionalText"){A=this.getShowSecondaryValues()?p.current:"";o.setInfo(A);}};m.prototype.isItemSelected=function(i){return i&&(i.getId()===this.getAssociation("selectedItem"));};m.prototype.setAssociation=function(A,i,e){var o=this._getList();if(o&&(A==="selectedItem")){if(!(i instanceof I)){i=this.findItem("id",i);}o.setSelectedItem(this.getListItem(i),true);}return a.prototype.setAssociation.apply(this,arguments);};m.prototype.removeAllAssociation=function(A,e){var o=this._getList();if(o&&(A==="selectedItem")){L.prototype.removeAllAssociation.apply(o,arguments);}return a.prototype.removeAllAssociation.apply(this,arguments);};m.prototype.init=function(){this._oRb=g.getLibraryResourceBundle("sap.m");a.prototype.init.apply(this,arguments);this.bOpenValueStateMessage=true;this._sValueBeforeOpen="";this._sInputValueBeforeOpen="";this._oSelectedItemBeforeOpen=null;this._oFirstItemTextMatched=null;this.bIsFocused=false;if(D.system.phone){this.attachEvent("_change",this.onPropertyChange,this);}this._oLastFocusedListItem=null;this._bIsLastFocusedItemHeader=null;this._oItemObserver=new M(this._forwardItemProperties.bind(this));};m.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);var o=this.getSelectedItem(),e=this._getList(),i=o&&this.getListItem(o),F=this.getProperty("formattedTextFocused"),p=this.getPicker()&&this.getPicker().getCustomHeader(),P=(D.browser.msie&&p&&p.getFormattedText)?p.getFormattedText():p;this.synchronizeSelection();if(!this.getOpen()&&document.activeElement===this.getFocusDomRef()){this.addStyleClass("sapMFocus");}if(F){P.addStyleClass("sapMPseudoFocus");e.removeStyleClass("sapMListFocus");i.removeStyleClass("sapMLIBFocused");this.removeStyleClass("sapMFocus");}else if(P){P.removeStyleClass("sapMPseudoFocus");}};m.prototype._fillList=function(){var o=this._getList(),e,p,r,i,t;if(!o){return;}if(this._oLastFocusedListItem){t=this._getItemByListItem(this._oLastFocusedListItem);}o.destroyItems();e=this.getItems();if(this._sInputValueBeforeOpen){e=this.filterItems({properties:this._getFilters(),value:this._sInputValueBeforeOpen});}for(i=0,r=e.length;i<r;i++){p=this._mapItemToListItem(e[i]);o.addAggregation("items",p,true);}if(t){this._oLastFocusedListItem=this.getListItem(t);}};m.prototype.exit=function(){a.prototype.exit.apply(this,arguments);this._oRb=null;this._oSelectedItemBeforeOpen=null;this._oFirstItemTextMatched=null;this._oLastFocusedListItem=null;if(this._oSuggestionPopover){if(this._oPickerCustomHeader){this._oPickerCustomHeader.destroy();this._oPickerCustomHeader=null;}this._oSuggestionPopover.destroy();this._oSuggestionPopover=null;}if(this._oItemObserver){this._oItemObserver.disconnect();this._oItemObserver=null;}};m.prototype.onBeforeRenderingPicker=function(){var o=this["onBeforeRendering"+this.getPickerType()];o&&o.call(this);};m.prototype.onBeforeRenderingDropdown=function(){var p=this.getPicker(),w=(this.$().outerWidth()/parseFloat(l.BaseFontSize))+"rem";if(p){p.setContentMinWidth(w);}};m.prototype.onBeforeRenderingList=function(){if(this.bProcessingLoadItemsEvent){var o=this._getList(),F=this.getFocusDomRef();if(o){o.setBusy(true);}if(F){F.setAttribute("aria-busy","true");}}};m.prototype.onAfterRenderingPicker=function(){var o=this["onAfterRendering"+this.getPickerType()];o&&o.call(this);n.call(this,false);};m.prototype.onAfterRenderingList=function(){var o=this.getSelectedItem(),e=this.getListItem(o);if(this.bProcessingLoadItemsEvent&&(this.getItems().length===0)){return;}var i=this._getList(),F=this.getFocusDomRef();this._highlightList(this._sInputValueBeforeOpen);if(o){i.setSelectedItem(e);this.handleListItemsVisualFocus(e);}if(i){i.setBusy(false);}if(F){F.removeAttribute("aria-busy");}};m.prototype.oninput=function(e){a.prototype.oninput.apply(this,arguments);this.syncPickerContent();if(e.isMarked("invalid")){return;}this.loadItems(function(){this.handleInputValidation(e,this.isComposingCharacter());},{name:"input",busyIndicator:false});if(this.bProcessingLoadItemsEvent&&(this.getPickerType()==="Dropdown")){this.open();}if(this._oLastFocusedListItem){this._oLastFocusedListItem.removeStyleClass("sapMLIBFocused");this._oLastFocusedListItem=null;}this.setFormattedTextFocused(false);this.addStyleClass("sapMFocus");this._getList().removeStyleClass("sapMListFocus");if(this._getItemsShownWithFilter()){this.toggleIconPressedStyle(true);}};m.prototype.handleInputValidation=function(e,i){var v,o,F,p,r,t=this.getSelectedItem(),V=e.target.value,E=V==="",u=e.srcControl,w=(this.getPickerType()==="Dropdown");if(E&&!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){v=this.getItems();}else{v=this.filterItems({properties:this._getFilters(),value:V});}F=v[0];p=v.some(function(x){return x.getKey()===this.getSelectedKey();},this);o=this.intersectItems(this._filterStartsWithItems(V,'getText'),v);r=!E&&F&&F.getEnabled();if(F&&this.getSelectedKey()&&!p){this.setSelection(null);}if(r&&u&&u._bDoTypeAhead){this.handleTypeAhead(u,v,V,i);}else if(r&&V===o[0].getText()){this.setSelection(o[0]);}else{this.setSelection(null);}if(t!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()});}this._sInputValueBeforeOpen=V;if(this.isOpen()){setTimeout(function(){this._highlightList(V);}.bind(this));}if(F){if(E&&!this.bOpenedByKeyboardOrButton){this.close();}else if(w){this.open();this.scrollToItem(this.getSelectedItem());}}else if(this.isOpen()){if(w&&!this.bOpenedByKeyboardOrButton){this.close();}}else{this.clearFilter();}};m.prototype.handleTypeAhead=function(i,e,v,o){var p=this.intersectItems(this._filterStartsWithItems(v,'getText'),e);var r=this.getFilterSecondaryValues();var t=D.system.desktop;var u=this.intersectItems(this._filterStartsWithItems(v,'getAdditionalText'),e);if(r&&!p[0]&&u[0]){!o&&i.updateDomValue(u[0].getAdditionalText());this.setSelection(u[0]);}else if(p[0]){!o&&i.updateDomValue(p[0].getText());this.setSelection(p[0]);}if(t){s.call(i,v.length,i.getValue().length);}else{setTimeout(s.bind(i,v.length,i.getValue().length),0);}this.addStyleClass("sapMFocus");this._getList().removeStyleClass("sapMListFocus");};m.prototype.onSelectionChange=function(o){var i=this._getItemByListItem(o.getParameter("listItem")),p=this.getChangeEventParams(),e=(i!==this.getSelectedItem());this.updateDomValue(i.getText());this.setSelection(i);this.fireSelectionChange({selectedItem:this.getSelectedItem()});if(e){p.itemPressed=true;this.onChange(null,p);}};m.prototype.onItemPress=function(o){var e=o.getParameter("listItem"),t=e.getTitle(),p=this.getChangeEventParams(),i=(e!==this.getListItem(this.getSelectedItem()));if(e.isA("sap.m.GroupHeaderListItem")){return;}this.handleListItemsVisualFocus(e);this.updateDomValue(t);if(!i){p.itemPressed=true;this.onChange(null,p);}this._setPropertyProtected("value",t,true);if(this.getPickerType()==="Dropdown"&&!this.isPlatformTablet()){this.selectText.bind(this,this.getValue().length,this.getValue().length);}this.close();};m.prototype.onBeforeOpen=function(){a.prototype.onBeforeOpen.apply(this,arguments);var p=this["onBeforeOpen"+this.getPickerType()],o=this.getFocusDomRef();this.setProperty("open",true);if(this.hasLoadItemsEventListeners()&&!this.bProcessingLoadItemsEvent){this.loadItems();}if(o){o.setAttribute("aria-controls",this.getPicker().getId());}this.addContent();p&&p.call(this);};m.prototype.onBeforeOpenDialog=function(){var p=this.getPickerTextField();this._oSelectedItemBeforeOpen=this.getSelectedItem();this._sValueBeforeOpen=this.getValue();if(this.getSelectedItem()){this.filterItems({properties:this._getFilters(),value:""});}p.setValue(this._sValueBeforeOpen);};m.prototype.onAfterOpen=function(){var i=this.getSelectedItem(),o=this._getSelectionRange(),t=this.isPlatformTablet();this.closeValueStateMessage();n.call(this,true);if(!t&&i&&o.start===o.end&&o.start>1){setTimeout(function(){this.selectText(0,o.end);}.bind(this),0);}};m.prototype.onBeforeClose=function(){a.prototype.onBeforeClose.apply(this,arguments);var o=this.getFocusDomRef();this.setProperty("open",false);this.setProperty("formattedTextFocused",false);if(o){o.removeAttribute("aria-controls");}this.toggleIconPressedStyle(false);};m.prototype.onAfterClose=function(){this.clearFilter();this._sInputValueBeforeOpen="";if(this.isPickerDialog()){a.prototype.closeValueStateMessage.apply(this,arguments);}};m.prototype.onItemChange=function(o){var e=this.getAssociation("selectedItem"),N=o.getParameter("newValue"),p=o.getParameter("name");if(e===o.getParameter("id")){switch(p){case"text":if(!this.isBound("value")){this.setValue(N);}break;case"key":if(!this.isBound("selectedKey")){this.setSelectedKey(N);}break;}}};m.prototype.onkeydown=function(e){var o=e.srcControl;a.prototype.onkeydown.apply(o,arguments);if(!o.getEnabled()||!o.getEditable()){return;}var i=K;o._bDoTypeAhead=!D.os.android&&(e.which!==i.BACKSPACE)&&(e.which!==i.DELETE);};m.prototype.oncut=function(e){var o=e.srcControl;a.prototype.oncut.apply(o,arguments);o._bDoTypeAhead=false;};m.prototype.onsapenter=function(e){var o=e.srcControl,i=o.getSelectedItem();if(i&&this.getFilterSecondaryValues()){o.updateDomValue(i.getText());}a.prototype.onsapenter.apply(o,arguments);if(!o.getEnabled()||!o.getEditable()){return;}if(o.isOpen()&&!this.isComposingCharacter()){o.close();}};m.prototype.onsapdown=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}this.syncPickerContent();e.setMarked();e.preventDefault();this.loadItems(function navigateToNextSelectableItem(){H.call(this,o,this.getNextFocusableItem(true));});};m.prototype.onsapup=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}this.syncPickerContent();e.setMarked();e.preventDefault();this.loadItems(function navigateToPrevSelectableItem(){H.call(this,o,this.getNextFocusableItem(false));});};m.prototype.onsaphome=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}this.syncPickerContent();e.setMarked();if(this.getValueStateLinks().length){this.setProperty("formattedTextFocused",true);}e.preventDefault();this.loadItems(function navigateToFirstSelectableItem(){var F=this.getSelectableItems()[0];H.call(this,o,F);});};m.prototype.onsapend=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}this.syncPickerContent();e.setMarked();e.preventDefault();if(this.getValueStateLinks().length&&this.getFormattedTextFocused()){this.setProperty("formattedTextFocused",false);}this.loadItems(function navigateToLastSelectableItem(){var i=this.findLastEnabledItem(this.getSelectableItems());H.call(this,o,i);});};m.prototype.onsappagedown=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}this.syncPickerContent();e.setMarked();e.preventDefault();if(this.getValueStateLinks().length&&this.getFormattedTextFocused()){this.setProperty("formattedTextFocused",false);}this.loadItems(function(){var i=this.getNonSeparatorSelectableItems(this.getSelectableItems()),p=i.indexOf(this.getSelectedItem())+10,r;p=(p>i.length-1)?i.length-1:Math.max(0,p);r=i[p];H.call(this,o,r);});};m.prototype.onsappageup=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}this.syncPickerContent();e.setMarked();e.preventDefault();this.loadItems(function(){var i=this.getNonSeparatorSelectableItems(this.getSelectableItems()),p=i.indexOf(this.getSelectedItem())-10,r;p=(p>i.length-1)?i.length-1:Math.max(0,p);r=i[p];H.call(this,o,r);});};m.prototype.onsapshow=function(e){var i,o,E=this.getEditable(),p;a.prototype.onsapshow.apply(this,arguments);this.syncPickerContent();if(!this.getValue()&&E){i=this.getSelectableItems();o=this.getNonSeparatorSelectableItems(i)[0];if(o){p=this.getListItem(o);if(this.isOpen()){this.removeStyleClass("sapMFocus");this._getList().addStyleClass("sapMListFocus");this.handleListItemsVisualFocus(p);}else{this.addStyleClass("sapMFocus");}this.setSelection(o);this.updateDomValue(o.getText());this.fireSelectionChange({selectedItem:o});setTimeout(function(){this.selectText(0,o.getText().length);}.bind(this),0);}}};m.prototype.onsaphide=m.prototype.onsapshow;m.prototype.ontap=function(e){var o=this.getFocusDomRef(),A="aria-activedescendant";this.addStyleClass("sapMFocus");if(this.getFormattedTextFocused()){this.setFormattedTextFocused(false);}else if((this.getOpen()&&this._getList().hasStyleClass("sapMListFocus"))||this._oLastFocusedListItem){this._getList().removeStyleClass("sapMListFocus");this._oLastFocusedListItem.removeStyleClass("sapMLIBFocused");this._oLastFocusedListItem=null;o.removeAttribute(A);}};m.prototype.onfocusin=function(e){var i=this.getPickerType()==="Dropdown";if(this._bIsBeingDestroyed){return;}if(e.target===this.getOpenArea()){this.bOpenValueStateMessage=false;if(i&&!this.isPlatformTablet()){this.focus();}}else{if(i){setTimeout(function(){if(document.activeElement===this.getFocusDomRef()&&!this.bIsFocused&&!this.bFocusoutDueRendering&&!this.getSelectedText()){this.selectText(0,this.getValue().length);}this.bIsFocused=true;}.bind(this),0);}if(!this.isOpen()&&this.bOpenValueStateMessage&&this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}this.bOpenValueStateMessage=true;}if(this.getEnabled()&&(!this.isOpen()||!this.getSelectedItem()||!this._getList().hasStyleClass("sapMListFocus"))){this.addStyleClass("sapMFocus");}};m.prototype.onsapfocusleave=function(e){this.bIsFocused=false;var t,p,r,F,i=this.getSelectedItem();if(i&&this.getFilterSecondaryValues()){this.updateDomValue(i.getText());}a.prototype.onsapfocusleave.apply(this,arguments);if(this.isPickerDialog()){return;}p=this.getPicker();if(!e.relatedControlId||!p){return;}t=this.isPlatformTablet();r=g.byId(e.relatedControlId);F=r&&r.getFocusDomRef();if(c(p.getFocusDomRef(),F)&&!t&&!this.getFormattedTextFocused()){this.focus();}};m.prototype.synchronizeSelection=function(){if(this.isSelectionSynchronized()){return;}var e=this.getSelectedKey(),i=this.getItemByKey(""+e);if(i&&(e!=="")){this.setAssociation("selectedItem",i,true);this._setPropertyProtected("selectedItemId",i.getId(),true);if(this._sValue===this.getValue()){this.setValue(i.getText());this._sValue=this.getValue();}}};m.prototype.configPicker=function(p){var r=this.getRenderer(),e=r.CSS_CLASS_COMBOBOXBASE;p.setHorizontalScrolling(false).addStyleClass(e+"Picker").addStyleClass(e+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this);};m.prototype._configureList=function(o){var r=this.getRenderer();if(!o){return;}o.setMode(k.SingleSelectMaster).addStyleClass(r.CSS_CLASS_COMBOBOXBASE+"List").addStyleClass(r.CSS_CLASS_COMBOBOX+"List");o.attachSelectionChange(this.onSelectionChange,this).attachItemPress(this.onItemPress,this);o.addEventDelegate({onBeforeRendering:this.onBeforeRenderingList,onAfterRendering:this.onAfterRenderingList},this);};m.prototype.destroyItems=function(){this.destroyAggregation("items");if(this._getList()){this._getList().destroyItems();}return this;};m.prototype.getDefaultSelectedItem=function(){return null;};m.prototype.getChangeEventParams=function(){return{itemPressed:false};};m.prototype.clearSelection=function(){this.setSelection(null);};m.prototype.selectText=function(i,e){a.prototype.selectText.apply(this,arguments);this.textSelectionStart=i;this.textSelectionEnd=e;return this;};m.prototype.removeAllItems=function(){var i=a.prototype.removeAllItems.apply(this,arguments);this._fillList();return i;};m.prototype.clone=function(i){var o=a.prototype.clone.apply(this,arguments),e=this._getList();if(!this.isBound("items")&&e){o.syncPickerContent();o.setSelectedIndex(this.indexOfItem(this.getSelectedItem()));}return o;};m.prototype.open=function(){this.syncPickerContent();var o=this._getList();a.prototype.open.call(this);if(this.getSelectedItem()){o.addStyleClass("sapMListFocus");this.removeStyleClass("sapMFocus");}return this;};m.prototype.syncPickerContent=function(){var p,P=this.getPicker(),e=this.getInputForwardableProperties();if(!P){var i,G;P=this.createPicker(this.getPickerType());p=this.getPickerTextField();this._fillList();if(p){e.forEach(function(o){o=o.charAt(0).toUpperCase()+o.slice(1);i="set"+o;G="get"+o;if(p[i]){p[i](this[G]());}},this);}this._getSuggestionsPopover().updateValueState(this.getValueState(),this.getValueStateText(),this.getShowValueStateMessage());}this.synchronizeSelection();return P;};m.prototype.findAggregatedObjects=function(){var o=this._getList();if(o){return L.prototype.findAggregatedObjects.apply(o,arguments);}return[];};m.prototype.setSelectedItem=function(i){if(typeof i==="string"){this.setAssociation("selectedItem",i,true);i=g.byId(i);}if(!(i instanceof I)&&i!==null){return this;}if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);this.setValue(this._getSelectedItemText(i));return this;};m.prototype.setSelectedItemId=function(i){i=this.validateProperty("selectedItemId",i);if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);i=this.getSelectedItem();this.setValue(this._getSelectedItemText(i));return this;};m.prototype.setSelectedKey=function(e){e=this.validateProperty("selectedKey",e);var i=(e===""),o=this.isBound("selectedKey")&&this.isBound("value")&&this.getBindingInfo("selectedKey").skipModelUpdate;if(i){this.setSelection(null);if(!o){this.setValue("");}return this;}var p=this.getItemByKey(e);if(p){this.setSelection(p);if(!o){this.setValue(this._getSelectedItemText(p));}return this;}this._sValue=this.getValue();return this._setPropertyProtected("selectedKey",e);};m.prototype._setPropertyProtected=function(p,v,i){try{return this.setProperty(p,v,i);}catch(e){h.warning("setSelectedKey update failed due to exception. Loggable in support mode log",null,null,function(){return{exception:e};});}};m.prototype.getSelectedItem=function(){var v=this.getAssociation("selectedItem");return(v===null)?null:g.byId(v)||null;};m.prototype.removeItem=function(i){i=a.prototype.removeItem.apply(this,arguments);var o;if(this._getList()){this._getList().removeItem(i&&this.getListItem(i));}if(this.isBound("items")&&!this.bItemsUpdated){return i;}var v=this.getValue();if(this.getItems().length===0){this.clearSelection();}else if(this.isItemSelected(i)){o=this.getDefaultSelectedItem();this.setSelection(o);this.setValue(v);}return i;};m.prototype._modifyPopupInput=function(i){a.prototype._modifyPopupInput.apply(this,arguments);i.addEventDelegate({onsapenter:function(){var t=i.getValue();this.updateDomValue(t);this.onChange();if(t){this.updateDomValue(t);this.onChange();this.close();}}},this);return i;};m.prototype.applyShowItemsFilters=function(){var p,P;this.syncPickerContent();p=this.getPicker();P=function(){p.detachBeforeOpen(P,this);p=null;this.filterItems({value:this.getValue()||"_",properties:this._getFilters()});};p.attachBeforeOpen(P,this);};m.prototype._getFormattedValueStateText=function(){if(this.isOpen()){return this._getSuggestionsPopover()._getValueStateHeader().getFormattedText();}else{return C.prototype.getFormattedValueStateText.call(this);}};return m;});
